/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.search.service.impl;

import com.ptteng.common.search.service.SearchService;
import com.qding.common.util.HttpClientUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QingSearchServiceImpl
implements SearchService {
    private static final Log log = LogFactory.getLog(QingSearchServiceImpl.class);
    private String url;
    private String params;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    @Override
    public String getDocumentById(String index, String type, Long id) {
        if (index.isEmpty() || type.isEmpty() || id == null) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            String requrestUrl = "http://" + this.url + "/" + index + "/" + type + "/" + id;
            String result = HttpClientUtil.sendGetRequest((String)requrestUrl, null);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String addDocument(String index, String type, Long id, String json) {
        if (index.isEmpty() || type.isEmpty() || id == null) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            String requrestUrl = "http://" + this.url + "/" + index + "/" + type + "/" + id;
            String result = HttpClientUtil.sendPutRequestByJava((String)requrestUrl, (String)json);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String updateDocument(String index, String type, Long id, String json) {
        if (index.isEmpty() || type.isEmpty() || id == null) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            String requrestUrl = "http://" + this.url + "/" + index + "/" + type + "/" + id;
            String result = HttpClientUtil.sendPutRequestByJava((String)requrestUrl, (String)json);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String deleteDocument(String index, String type, Long id) {
        if (index.isEmpty() || type.isEmpty() || id == null) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            String requrestUrl = "http://" + this.url + "/" + index + "/" + type + "/" + id;
            String result = HttpClientUtil.sendDeleteRequestByJava((String)requrestUrl);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String simpleSearch(String index, String type, String query) {
        if (index.isEmpty() || type.isEmpty()) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            this.params = query;
            log.info((Object)("params is : " + this.params));
            String requrestUrl = "http://" + this.url + "/" + index + "/" + type + "/_search";
            log.info((Object)("url is :" + requrestUrl));
            String result = HttpClientUtil.sendPostRequestByJava((String)requrestUrl, (String)this.params);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String indexSearch(String index, String query) {
        if (index.isEmpty()) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            this.params = query;
            log.info((Object)("params is : " + this.params));
            String requrestUrl = "http://" + this.url + "/" + index + "/_search";
            log.info((Object)("url is :" + requrestUrl));
            String result = HttpClientUtil.sendPostRequestByJava((String)requrestUrl, (String)this.params);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    @Override
    public String addIndex(String index) {
        if (index.isEmpty()) {
            log.info((Object)"params is null");
            return "params is null";
        }
        try {
            String requrestUrl = "http://" + this.url + "/" + index + "/";
            log.info((Object)("url is :" + requrestUrl));
            String result = HttpClientUtil.sendPutRequestByJava((String)requrestUrl, null);
            log.info((Object)result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            return "error";
        }
    }

    public static void main(String[] args) {
    }
}

