/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.live.service.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class BaijiayunUtil {
    public static final Integer RESPONSE_SUCCESS_CODE = 0;

    public static String getUrlParam(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = BaijiayunUtil.invertObjectValue2Map(object);
        ArrayList<String> keyList = new ArrayList<String>(map.keySet());
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            Object value = map.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        sb.append("sign=").append(BaijiayunUtil.getSign(object, partnerKey));
        return sb.toString();
    }

    public static String getSign(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = BaijiayunUtil.invertObjectValue2Map(object);
        ArrayList<String> keyList = new ArrayList<String>(map.keySet());
        Collections.sort(keyList);
        StringBuilder sb = new StringBuilder();
        for (String key : keyList) {
            Object value = map.get(key);
            sb.append(key).append("=").append(value).append("&");
        }
        String signStr = sb.append("partner_key=").append(partnerKey).toString();
        return DigestUtils.md5Hex((byte[])signStr.getBytes());
    }

    public static Map<String, Object> getRequestText(Object object, String partnerKey) throws IllegalAccessException {
        Map<String, Object> map = BaijiayunUtil.invertObjectValue2Map(object);
        String sign = BaijiayunUtil.getSign(object, partnerKey);
        map.put("sign", sign);
        return map;
    }

    public static Map<String, Object> invertObjectValue2Map(Object object) throws IllegalAccessException {
        Field[] fields;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            String name = field.getName();
            if (field.get(object) == null) continue;
            result.put(name, field.get(object));
        }
        return result;
    }

    public static Long getTimeSecond() {
        return System.currentTimeMillis() / 1000L;
    }

    public static Long getTimeSecond(Long time) {
        return time / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(File file, String urlPath) {
        try {
            URL url = new URL(urlPath);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            System.out.println("\u60a8\u8981\u4e0b\u8f7d\u7684\u6587\u4ef6\u5927\u5c0f\u4e3a:" + fileLength / 1024 + "KB");
            URLConnection con = url.openConnection();
            BufferedInputStream bin = new BufferedInputStream(httpURLConnection.getInputStream());
            FileOutputStream out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[2048];
            while ((size = bin.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, size);
                System.out.println("\u4e0b\u8f7d\u4e86-------> " + (len += size) * 100 / fileLength + "%\n");
            }
            bin.close();
            ((OutputStream)out).close();
            System.out.println("\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f\uff01");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        finally {
            return file;
        }
    }
}

