/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.common.live.service.impl;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.ptteng.common.live.service.BaijiayunLiveService;
import com.ptteng.common.live.service.util.BaijiayunUtil;
import com.ptteng.common.live.service.util.ConfigPropertiesUtil;
import com.ptteng.common.live.service.util.HttpRequestUtil;
import com.ptteng.common.live.service.vo.baijiayun.BJYDict;
import com.ptteng.common.live.service.vo.baijiayun.BJYQuery;
import com.ptteng.common.live.service.vo.baijiayun.Res;
import com.qding.common.util.DataUtils;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.formula.functions.T;

public class BaijiayunLiveServiceImpl
implements BaijiayunLiveService {
    protected Log log = LogFactory.getLog(this.getClass());
    private Integer partner_id;
    private String partner_key;
    private String secret_key;
    private String apiHost;

    @Override
    public Res<BJYDict> getRoomCode(String roomId, Integer userNumber, String userAvatar) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomGetCode"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            query.setUser_number(userNumber);
            query.setUser_avatar(userAvatar);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getRoomCodeInfo(String code) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomGetCodeInfo"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setCode(code);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<String> getRoomListCode(String roomId, Integer page, Integer limit) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomListCode"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            query.setPage(page);
            query.setLimit(limit);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<String>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getLiveRoomUserCount(String roomId) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("getUserCount"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getLiveRoomPushUrl(String roomId) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomPushUrl"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getLiveRoomPullUrl(String roomId) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomPullUrl"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public String sendChatMessage(T msg) {
        return null;
    }

    @Override
    public String sendChatMessage(List<T> msgList) {
        return null;
    }

    @Override
    public Res<String> startClass(String roomId) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("startClass"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<String> stopClass(String roomId, Integer isKickOutAll) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("stopClass"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setRoom_id(roomId);
            query.setIs_kick_out_all(isKickOutAll);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public String setClassCallbackUrl(String url) {
        try {
            String reqUrl = this.apiHost.concat(ConfigPropertiesUtil.getProperty("setClassCallbackUrl"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setUrl(url);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + reqUrl + ",param" + param));
            String result = HttpRequestUtil.sendPost(reqUrl, param);
            this.log.info((Object)("http request result = " + result));
            return result;
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getClassCallbackUrl() {
        try {
            String reqUrl = this.apiHost.concat(ConfigPropertiesUtil.getProperty("getClassCallbackUrl"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + reqUrl + ",param" + param));
            String result = HttpRequestUtil.sendPost(reqUrl, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public String partnerCreateKey(String secretKey, Integer regenerate) {
        try {
            String reqUrl = this.apiHost.concat(ConfigPropertiesUtil.getProperty("partnerCreateKey"));
            BJYQuery query = new BJYQuery();
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            if (DataUtils.isNullOrEmpty((Object)secretKey)) {
                query.setSecret_key(this.secret_key);
            }
            query.setRegenerate(regenerate);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + reqUrl + ",param" + param));
            String result = HttpRequestUtil.sendPost(reqUrl, param);
            this.log.info((Object)("http request result = " + result));
            return result;
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> createLiveRoom(BJYQuery query) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("createRoom"));
            String result = this.httpRequest(query, url);
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> updateLiveRoom(BJYQuery query) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("updateRoom"));
            String result = this.httpRequest(query, url);
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> deleteLiveRoom(BJYQuery query) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("deleteRoom"));
            String result = this.httpRequest(query, url);
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getLiveRoomInfo(BJYQuery query) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("getRoomInfo"));
            String result = this.httpRequest(query, url);
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<BJYDict> getLiveRoomStatus(BJYQuery query) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("liveStatus"));
            String result = this.httpRequest(query, url);
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<BJYDict>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    @Override
    public Res<String> getRoomList(BJYQuery query, Integer page, Integer limit) {
        try {
            String url = this.apiHost.concat(ConfigPropertiesUtil.getProperty("roomList"));
            query.setPartner_id(this.partner_id);
            query.setTimestamp(BaijiayunUtil.getTimeSecond());
            query.setPage(page);
            query.setLimit(limit);
            String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
            this.log.info((Object)("http request start: url" + url + ",param" + param));
            String result = HttpRequestUtil.sendPost(url, param);
            this.log.info((Object)("http request result = " + result));
            Gson gson = new Gson();
            return (Res)gson.fromJson(result, new TypeToken<Res<String>>(){}.getType());
        }
        catch (Throwable throwable) {
            this.log.error((Object)throwable.getMessage(), throwable);
            return null;
        }
    }

    private String httpRequest(BJYQuery query, String url) throws IllegalAccessException, IOException {
        query.setPartner_id(this.partner_id);
        query.setTimestamp(BaijiayunUtil.getTimeSecond());
        String param = BaijiayunUtil.getUrlParam(query, this.partner_key);
        this.log.info((Object)("http request start: url" + url + ",param" + param));
        String result = HttpRequestUtil.sendPost(url, param);
        this.log.info((Object)("http request result = " + result));
        return result;
    }

    public Integer getPartner_id() {
        return this.partner_id;
    }

    public void setPartner_id(Integer partner_id) {
        this.partner_id = partner_id;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public void setApiHost(String apiHost) {
        this.apiHost = apiHost;
    }

    public String getPartner_key() {
        return this.partner_key;
    }

    public void setPartner_key(String partner_key) {
        this.partner_key = partner_key;
    }

    public String getSecret_key() {
        return this.secret_key;
    }

    public void setSecret_key(String secret_key) {
        this.secret_key = secret_key;
    }
}

