package com.ptteng.common.esign.utils;





import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.ptteng.common.esign.exception.DefineException;

import java.util.HashMap;
import java.util.Map;

/**
 * http发送专用协助类
 * @author chenxi
 *
 */
public class HttpHelper {

	/**
	 * 
	 * @param
	 * @return
	 * HttpGet返回值
	 */
	public static String sendGet(String url) {
		String res  ="";
		res =HttpUtils.sendHttp(HttpRequestMethedEnum.HttpGet,url,null,null,1);
		return res ;
	}
	/**发送post请求
	 * 
	 * @param url 发送地址
	 * @param token 交易token
	 * @param params body入参
	 * @return httpPost返回值
	 */
	public static String sendPost(String appId,String url,String token,String params) {
		Map<String,String>  header =new HashMap();
		header.put("X-Tsign-Open-App-Id", appId);
		header.put("X-Tsign-Open-Token", token);
		header.put("Content-Type", "application/json");
		String res  ="";
		res  =HttpUtils.sendHttp(HttpRequestMethedEnum.HttpPost, url, header, params, 1);
		return res ;
	}
	/**发送get请求(带有header)
	 * 
	 * @param url 发送地址
	 * @param token 交易token
	 * @return httpGet返回值
	 */
	public static String sendGet2(String appId,String url,String token) {
		Map<String,String>  header =new HashMap();
		header.put("X-Tsign-Open-App-Id", appId);
		header.put("X-Tsign-Open-Token", token);
		header.put("Content-Type", "application/json");
		String res  ="";
		res  =HttpUtils.sendHttp(HttpRequestMethedEnum.HttpGet, url, header, null, 1);
		return res ;
	}
	/**发送put请求
	 * 
	 * @param url 发送地址
	 * @param token 交易token
	 * @param params body入参
	 * @return httpPut返回值
	 */
	public static String sendPut(String appId,String url,String token,String params) {
		Map<String,String>  header =new HashMap();
		header.put("X-Tsign-Open-App-Id", appId);
		header.put("X-Tsign-Open-Token", token);
		header.put("Content-Type", "application/json");
		String res  ="";
		res  =HttpUtils.sendHttp(HttpRequestMethedEnum.HttpPut, url, header, params, 1);
		return res ;
	}
	/**发送DELETE请求
	 *
	 * @param url 发送地址
	 * @param token 交易token
	 * @param params body入参
	 * @return httpPut返回值
	 */
	public static String sendDelete(String appId,String url,String token,String params) {
		Map<String,String>  header =new HashMap();
		header.put("X-Tsign-Open-App-Id", appId);
		header.put("X-Tsign-Open-Token", token);
		header.put("Content-Type", "application/json");
		String res  ="";
		res  =HttpUtils.sendHttp(HttpRequestMethedEnum.HttpDelete, url, header, params, 1);
		return res ;
	}

	/**
	 * @description 发送文件流上传 HTTP 请求
	 *
	 * @param reqType 请求方式
	 * @param url 请求路径
	 * @param param 请求参数
	 * @param contentMd5 文件contentMd5
	 * @param contentType 文件MIME类型
	 * @return
	 * @throws DefineException
	 * @author 宫清
	 * @date 2019年7月20日 下午8:21:28
	 */
	public static JSONObject doUploadHttp(HttpRequestMethedEnum reqType, String url, byte[] param, String contentMd5,
										  String contentType) throws DefineException {
		return HttpCfgHelper.sendHttp(reqType, url, buildUploadHeader(contentMd5, contentType), param);
	}
	/**
	 * @description 创建文件流上传 请求头
	 *
	 * @param contentMd5
	 * @param contentType
	 * @return
	 * @author 宫清
	 * @date 2019年7月20日 下午8:13:15
	 */
	private static Map<String, String> buildUploadHeader(String contentMd5, String contentType) {
		Map<String, String> header = Maps.newHashMap();
		header.put("Content-MD5", contentMd5);
		header.put("Content-Type", contentType);
		return header;
	}
}
