/**
 * 
 */
package com.ptteng.common.esign.service;

import com.ptteng.common.esign.bean.BillParams;
import com.ptteng.common.esign.bean.ContextInfo;
import com.ptteng.common.esign.bean.IndivInfo;
import com.alibaba.fastjson.JSONObject;
import com.ptteng.common.esign.utils.ConfigPropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.ptteng.common.esign.utils.HttpHelper;

import java.util.HashMap;
import java.util.Map;

/**
 * 实名认证v2.1
 * 
 * @author chenxi 个人实名认证
 */
public class PersonRealnameVerify{
	// 日志记录器
	private Logger logger = LoggerFactory.getLogger(getClass());
	public  String appId ="";
	public  String secret="";
	public  String grantType ="client_credentials";
	public String host="";
	public String token="";


	public PersonRealnameVerify() {

	}

	/**
	 * 个人2要素信息比对
	 * 
	 * @param name 姓名
	 * @param idno 身份证号码
	 * @return 包含接口响应码、接口响应结果描述和信息比对业务Id的map集合
	 */
	public Map<String, String> verifyPerson2keys(String name, String idno) {

		Map<String, String> map = new HashMap();
		int code = 0;
		String msg = "";
		String verifyId = "";
		JSONObject jspell = new JSONObject();
		jspell.put("idNo", idno);
		jspell.put("name", name);

		String s_url = host.concat(ConfigPropertiesUtil.getProperty("verifyPer2keys"));
		String res = "";
		logger.info("============个人2要素信息比对==========");
		res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
		JSONObject jparse = JSONObject.parseObject(res);
		code = jparse.getInteger("code");
		msg = jparse.getString("message");
		if (code != 0) {
			map.put("code", String.valueOf(code));
			map.put("msg", msg);
			map.put("verifyId", verifyId);
			return map;
		}
		JSONObject data = jparse.getJSONObject("data");
		verifyId = data.getString("verifyId");
		map.put("code", String.valueOf(code));
		map.put("msg", msg);
		map.put("verifyId", verifyId);
		logger.info("信息比对业务Id： " + verifyId);
		logger.info("====================================");
		return map;
	}

	/**
	 * 个人运营商3要素信息比对
	 * 
	 * @param name     姓名
	 * @param idno     身份证号码
	 * @param mobileNo 手机号码
	 * @return 包含接口响应码、接口响应结果描述和信息比对业务Id的map集合
	 */
	public Map<String, String> verifyPerson3keys_telecom(String name, String idno, String mobileNo) {

		Map<String, String> map = new HashMap();
		int code = 0;
		String msg = "";
		String verifyId = "";
		JSONObject jspell = new JSONObject();
		jspell.put("idNo", idno);
		jspell.put("name", name);
		jspell.put("mobileNo", mobileNo);

		String s_url = host.concat(ConfigPropertiesUtil.getProperty("verifyPer3keys_telecom"));;
		String res = "";
		logger.info("============个人运营商3要素信息比对==========");
		res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
		JSONObject jparse = JSONObject.parseObject(res);
		code = jparse.getInteger("code");
		msg = jparse.getString("message");
		if (code != 0) {
			map.put("code", String.valueOf(code));
			map.put("msg", msg);
			map.put("verifyId", verifyId);
			return map;
		}
		JSONObject data = jparse.getJSONObject("data");
		verifyId = data.getString("verifyId");
		map.put("code", String.valueOf(code));
		map.put("msg", msg);
		map.put("verifyId", verifyId);
		logger.info("信息比对业务Id： " + verifyId);
		logger.info("====================================");
		return map;
	}

	/**
	 * 个人银行卡3要素信息比对
	 * 
	 * @param name   姓名
	 * @param idno   身份证号码
	 * @param cardNo 银行卡号
	 * @return 包含接口响应码、接口响应结果描述和信息比对业务Id的map集合
	 */
	public Map<String, String> verifyPerson3keys_bank(String name, String idno, String cardNo) {

		Map<String, String> map = new HashMap();
		int code = 0;
		String msg = "";
		String verifyId = "";
		JSONObject jspell = new JSONObject();
		jspell.put("idNo", idno);
		jspell.put("name", name);
		jspell.put("cardNo", cardNo);

		String s_url =  host.concat(ConfigPropertiesUtil.getProperty("verifyPer3keys_bank"));
		String res = "";
		logger.info("============个人银行卡3要素信息比对==========");
		res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
		JSONObject jparse = JSONObject.parseObject(res);
		code = jparse.getInteger("code");
		msg = jparse.getString("message");
		if (code != 0) {
			map.put("code", String.valueOf(code));
			map.put("msg", msg);
			map.put("verifyId", verifyId);
			return map;
		}
		JSONObject data = jparse.getJSONObject("data");
		verifyId = data.getString("verifyId");
		map.put("code", String.valueOf(code));
		map.put("msg", msg);
		map.put("verifyId", verifyId);
		logger.info("信息比对业务Id： " + verifyId);
		logger.info("====================================");
		return map;
	}

	/**
	 * 个人银行卡4要素信息比对
	 * 
	 * @param name     姓名
	 * @param idno     身份证号码
	 * @param cardNo   银行卡号
	 * @param mobileNo 手机号码
	 * @return 包含接口响应码、接口响应结果描述和信息比对业务Id的map集合
	 */
	public Map<String, String> verifyPerson4keys_bank(String name, String idno, String cardNo, String mobileNo) {

		Map<String, String> map = new HashMap();
		int code = 0;
		String msg = "";
		String verifyId = "";
		JSONObject jspell = new JSONObject();
		jspell.put("idNo", idno);
		jspell.put("name", name);
		jspell.put("cardNo", cardNo);
		jspell.put("mobileNo", mobileNo);

		String s_url =  host.concat(ConfigPropertiesUtil.getProperty("verifyPer4keys_bank"));
		String res = "";
		logger.info("============个人银行卡4要素信息比对==========");
		res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
		JSONObject jparse = JSONObject.parseObject(res);
		code = jparse.getInteger("code");
		msg = jparse.getString("message");
		if (code != 0) {
			map.put("code", String.valueOf(code));
			map.put("msg", msg);
			map.put("verifyId", verifyId);
			return map;
		}
		JSONObject data = jparse.getJSONObject("data");
		verifyId = data.getString("verifyId");
		map.put("code", String.valueOf(code));
		map.put("msg", msg);
		map.put("verifyId", verifyId);
		logger.info("信息比对业务Id： " + verifyId);
		logger.info("====================================");
		return map;
	}

	// --------------个人实名认证网页版---------------
	/**
	 * 获取个人实名认证地址
	 * 
	 * @param authType    个人认证类型
	 * @param billParams  业务计费参数模型
	 * @param contextInfo 业务方交互上下文信息模型
	 * @param indivInfo   个人基本信息模型
	 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
	 */
	public Map<String, String> getPersonalRealnameUrl(String authType, BillParams billParams, ContextInfo contextInfo,
			IndivInfo indivInfo) {
		Map<String, String> map = new HashMap();
		int code = 0;
		String msg = "";
		String flowId = "";
		String shortLink = "";
		String url = "";
		JSONObject jspell = new JSONObject();
		jspell.put("authType", authType);
		jspell.put("billParams", billParams);
		jspell.put("contextInfo", contextInfo);
		jspell.put("indivInfo", indivInfo);
		String s_url =  host.concat(ConfigPropertiesUtil.getProperty("getPersonalRealnameUrl"));
		String res = "";
		logger.info("============个人认证服务网页版：获取个人实名认证地址==========");
		res = HttpHelper.sendPost(appId,s_url, token, jspell.toString());
		JSONObject jparse = JSONObject.parseObject(res);
		code = jparse.getInteger("code");
		msg = jparse.getString("message");
		if (code != 0) {
			map.put("code", String.valueOf(code));
			map.put("msg", msg);
			map.put("flowId", flowId);
			map.put("shortLink", shortLink);
			map.put("url", url);
			return map;
		}
		JSONObject data = jparse.getJSONObject("data");
		flowId = data.getString("flowId");
		shortLink = data.getString("shortLink");
		url = data.getString("url");
		map.put("code", String.valueOf(code));
		map.put("msg", msg);
		map.put("flowId", flowId);
		map.put("shortLink", shortLink);
		map.put("url", url);
		logger.info("认证流程Id： " + flowId);
		logger.info("实名认证地址短连接： " + shortLink);
		logger.info("实名认证地址原始链接： " + url);
		logger.info("====================================");
		return map;
	}

	public static final class PersonRealnameVerifyBuilder {
		public  String appId ="";
		public  String secret="";
		public  String grantType ="client_credentials";
		public String host="";
		public String token="";
		// 日志记录器
		private Logger logger = LoggerFactory.getLogger(getClass());

		private PersonRealnameVerifyBuilder() {
		}

		public static PersonRealnameVerifyBuilder aPersonRealnameVerify() {
			return new PersonRealnameVerifyBuilder();
		}


		public PersonRealnameVerifyBuilder withAppId(String appId) {
			this.appId = appId;
			return this;
		}

		public PersonRealnameVerifyBuilder withSecret(String secret) {
			this.secret = secret;
			return this;
		}

		public PersonRealnameVerifyBuilder withGrantType(String grantType) {
			this.grantType = grantType;
			return this;
		}

		public PersonRealnameVerifyBuilder withHost(String host) {
			this.host = host;
			return this;
		}

		public PersonRealnameVerifyBuilder withToken(String token) {
			this.token = token;
			return this;
		}

		public PersonRealnameVerify build() {
			PersonRealnameVerify personRealnameVerify = new PersonRealnameVerify();
			personRealnameVerify.appId = this.appId;
			personRealnameVerify.secret = this.secret;
			personRealnameVerify.host = this.host;
			personRealnameVerify.token = this.token;
			personRealnameVerify.grantType = this.grantType;
			return personRealnameVerify;
		}
	}
}
