/**
 *
 */
package com.ptteng.common.esign.service;

import com.ptteng.common.esign.bean.API_Enterprise4keys;
import com.ptteng.common.esign.bean.API_LegalSign;
import com.ptteng.common.esign.bean.API_Organ3keys;
import com.ptteng.common.esign.bean.API_PayRandomAmount;
import com.alibaba.fastjson.JSONObject;
import com.ptteng.common.esign.utils.ConfigPropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import com.ptteng.common.esign.utils.HttpHelper;

import java.util.HashMap;
import java.util.Map;

/**认证服务纯API接入方式:企业实名认证
 * @author chenxi
 *
 */
public class API_OrganRealnameVerify {
    public  String appId ="";
    public  String secret="";
    public  String grantType ="client_credentials";
    public String host="";
    public String token="";
	            // 日志记录器
				private Logger logger = LoggerFactory.getLogger(getClass());


				public API_OrganRealnameVerify() {

				}
				//------------纯API方式: 企业/组织认证-------------------------
				/**
				 * 纯API方式：【发起企业实名认证4要素校验】
				 * @param api_Enterprise4keys 纯API方式入参模型：【发起企业实名认证4要素校验】
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> applyForEnterprise4keys(API_Enterprise4keys  api_Enterprise4keys) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String flowId = "";
					String jspell = JSONObject.toJSONString(api_Enterprise4keys);
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("startEnterprise4keys"));

                    String res = "";
					logger.info("============纯API方式【发起企业实名认证4要素校验】==========");
					res = HttpHelper.sendPost(appId,s_url, this.token, jspell);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						map.put("flowId", flowId);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					flowId = data.getString("flowId");
					map.put("flowId", flowId);
					logger.info("实名流程Id： " + flowId);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【发起授权签署实名认证】
				 * @param api_LegalSign  纯API方式入参模型：【发起授权签署实名认证】
				 * @param flowid  实名流程Id
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> startLegalSignFlow(API_LegalSign  api_LegalSign,String flowid) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String jspell = JSONObject.toJSONString(api_LegalSign);
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("startLegalSignFlow").replace("{flowid}",flowid));

                    String res = "";
					logger.info("============纯API方式【发起授权签署实名认证】==========");
					res = HttpHelper.sendPost(appId,s_url, this.token, jspell);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【发起组织机构实名认证3要素检验】
				 * @param api_Organ3keys 纯API方式入参模型：【发起组织机构实名认证3要素检验】
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> applyForOrgan3keys(API_Organ3keys  api_Organ3keys) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String flowId = "";
					String jspell = JSONObject.toJSONString(api_Organ3keys);
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("startOrgan3keys"));
					String res = "";
					logger.info("============纯API方式【发起组织机构实名认证3要素检验】==========");
					res = HttpHelper.sendPost(appId,s_url, this.token, jspell);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						map.put("flowId", flowId);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					flowId = data.getString("flowId");
					map.put("flowId", flowId);
					logger.info("实名流程Id： " + flowId);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【发起随机金额打款认证】
				 * @param api_PayRandomAmount 纯API方式入参模型：【发起随机金额打款认证】
				 * @param flowid 实名流程Id
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> applyForRandomPay(API_PayRandomAmount  api_PayRandomAmount,String flowid) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String jspell = JSONObject.toJSONString(api_PayRandomAmount);
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("startRandomPay").replace("{flowid}",flowid));

					String res = "";
					logger.info("============纯API方式【发起随机金额打款认证】==========");
					res = HttpHelper.sendPut(appId,s_url, this.token, jspell);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					logger.info("====================================");
					return map;
				}

				/**
				 * 纯API方式：【查询打款进度】
				 * @param flowId 实名流程Id
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> queryRandomPayProcess(String flowId) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String process = "";
					String message = "";
					String foresee = "";
					String cardNo = "";
					String subbranch = "";
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("queryRandomPay").replace("{flowid}",flowId));

                    String res = "";
					logger.info("============纯API方式【查询打款进度】==========");
					res = HttpHelper.sendGet2(appId,s_url,token);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						map.put("process",process );
						map.put("message",message );
						map.put("foresee",foresee );
						map.put("cardNo", cardNo);
						map.put("subbranch",subbranch );
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					process = data.getString("process");
					message = data.getString("message");
					foresee = data.getString("foresee");
					cardNo = data.getString("cardNo");
					subbranch = data.getString("subbranch");
					map.put("process",process );
					map.put("message",message );
					map.put("foresee",foresee );
					map.put("cardNo", cardNo);
					map.put("subbranch",subbranch );
					logger.info("打款进度标识： " + process);
					logger.info("打款进度附件描述信息： " + message);
					logger.info("预计最晚到款日期： " + foresee);
					logger.info("发起时打款对公账号信息： " + cardNo);
					logger.info("对公账号所在银行名称： " + subbranch);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【查询打款银行信息】
				 * @param flowId 实名流程Id
				 * @param keyWord 银行名称搜索关键字，强烈建议输出完整的银行名称
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> queryBankInfoByKeywords(String flowId,String keyWord) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("queryBankInfoByKeywords").replace("{flowId}", flowId))
                            .replace("keyWord", keyWord);

					String res = "";
					logger.info("============纯API方式【查询打款银行信息】==========");
					res = HttpHelper.sendGet2(appId,s_url,token);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					map.put("data", data.toJSONString());
				    logger.info("返回data数组：>>>>>>>>>>");
				    logger.info(data.toJSONString());
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【查询授权书签署状态】
				 * @param flowId 实名流程Id
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> queryLegalSignResult(String flowId) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String status = "";
					String message = "";

                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("queryLegalSignResult").replace("{flowId}", flowId));

                    String res = "";
					logger.info("============纯API方式【查询授权书签署状态】==========");
					res = HttpHelper.sendGet2(appId,s_url,token);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						map.put("status",status );
						map.put("message",message );
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					status = data.getString("status");
					message = data.getString("message");
					map.put("status",status );
					map.put("message",message );
					logger.info("签署状态标识： " + status);
					logger.info("签署状态描述： " + message);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【获取授权签署链接】
				 * @param flowId 实名流程Id
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> getLegalSignUrl(String flowId) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";
					String signUrl = "";

                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("queryLegalSignUrl").replace("{flowId}", flowId));

                    String res = "";
					logger.info("============纯API方式【获取授权签署链接】==========");
					res = HttpHelper.sendGet2(appId,s_url,token);
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						map.put("signUrl",signUrl );
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					signUrl = data.getString("signUrl");
					map.put("signUrl",signUrl );
					logger.info("签署链接： " + signUrl);
					logger.info("====================================");
					return map;
				}
				/**
				 * 纯API方式：【随机打款金额校验】
				 * @param flowId 实名流程Id
				 * @param amount 对公账号收到的随机金额打款金额,0.01~0.99之间
				 * @return 包含接口响应码、接口响应结果描述和业务信息的map集合
				 */
				public Map<String, String> verifyRandomAmount(String flowId,double amount) {

					Map<String, String> map = new HashMap();
					int code = 0;
					String msg = "";

                    String s_url = host.concat(ConfigPropertiesUtil.getProperty("verifyRandomAmount").replace("{flowId}", flowId));

                    String res = "";
					logger.info("============纯API方式【随机打款金额校验】==========");
					JSONObject jspell =new JSONObject();
					jspell.put("amount", amount);
					res = HttpHelper.sendPut(appId,s_url, this.token,"");
					JSONObject jparse = JSONObject.parseObject(res);
					code = jparse.getInteger("code");
					msg = jparse.getString("message");
					if (code != 0) {
						map.put("code", String.valueOf(code));
						map.put("msg", msg);
						return map;
					}
					JSONObject data = jparse.getJSONObject("data");
					map.put("code", String.valueOf(code));
					map.put("msg", msg);
					logger.info("====================================");
					return map;
				}

    public static final class API_OrganRealnameVerifyBuilder {
        public  String appId ="";
        public  String secret="";
        public  String grantType ="client_credentials";
        public String host="";
        public String token="";

        private API_OrganRealnameVerifyBuilder() {
        }

        public static API_OrganRealnameVerifyBuilder anAPI_OrganRealnameVerify() {
            return new API_OrganRealnameVerifyBuilder();
        }

        public API_OrganRealnameVerifyBuilder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public API_OrganRealnameVerifyBuilder withSecret(String secret) {
            this.secret = secret;
            return this;
        }

        public API_OrganRealnameVerifyBuilder withGrantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public API_OrganRealnameVerifyBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public API_OrganRealnameVerifyBuilder withToken(String token) {
            this.token = token;
            return this;
        }

        public API_OrganRealnameVerify build() {
            API_OrganRealnameVerify aPI_OrganRealnameVerify = new API_OrganRealnameVerify();
            aPI_OrganRealnameVerify.secret = this.secret;
            aPI_OrganRealnameVerify.host = this.host;
            aPI_OrganRealnameVerify.appId = this.appId;
            aPI_OrganRealnameVerify.token = this.token;
            aPI_OrganRealnameVerify.grantType = this.grantType;
            return aPI_OrganRealnameVerify;
        }
    }
}
