/*
 * Decompiled with CFR 0.152.
 */
package com.dify.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.dify.client.IDifyDatasetClient;
import com.dify.client.impl.DifyBaseClientImpl;
import com.dify.client.params.PathVariables;
import com.dify.client.params.documents.AddDocumentRequest;
import com.dify.client.params.documents.Document;
import com.dify.client.params.documents.UpdateDocumentMetadata;
import com.dify.client.params.segments.Segment;
import com.dify.client.params.segments.SegmentAddRequest;
import com.dify.client.params.segments.SegmentUpdateRequest;
import com.dify.client.response.DatasetResponse;
import com.dify.client.response.DocumentCreateResponse;
import com.dify.routes.DifyRoutes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DifyDatasetClientImpl
extends DifyBaseClientImpl
implements IDifyDatasetClient {
    private static final Log log = LogFactory.getLog(DifyDatasetClientImpl.class);

    public DifyDatasetClientImpl(String server, String apiKey) {
        super(server, apiKey);
    }

    @Override
    public DatasetResponse<List<JSONObject>> getDatasets(Integer page, Integer limit, Boolean includeAll, String keyword, List<String> tagIds) throws IOException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("page", page);
        query.put("limit", limit);
        query.put("include_all", includeAll);
        query.put("keyword", keyword);
        query.put("tag_ids", tagIds);
        String result = this.requestJson(DifyRoutes.DATASET_LIST, query, null);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<List<JSONObject>>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public DocumentCreateResponse createDocumentByText(String datasetId, AddDocumentRequest addDocumentRequest) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        String result = this.requestJson(DifyRoutes.CREATE_DOCUMENT_BY_TEXT, pathVariables, null, (Object)addDocumentRequest);
        return (DocumentCreateResponse)JSON.parseObject((String)result, DocumentCreateResponse.class);
    }

    @Override
    public DocumentCreateResponse updateDocumentByText(String datasetId, String documentId, AddDocumentRequest addDocumentRequest) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        String result = this.requestJson(DifyRoutes.UPDATE_DOCUMENT_BY_TEXT, pathVariables, null, (Object)addDocumentRequest);
        return (DocumentCreateResponse)JSON.parseObject((String)result, DocumentCreateResponse.class);
    }

    @Override
    public DatasetResponse<List<Document>> getDocumentList(Integer page, Integer limit, String datasetId, String keyword) throws IOException, InterruptedException {
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("page", page);
        query.put("limit", limit);
        query.put("keyword", keyword);
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        String result = this.requestJson(DifyRoutes.GET_DOCUMENT_LIST, pathVariables, query);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<List<Document>>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public void deleteDocument(String datasetId, String documentId) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        String result = this.requestJson(DifyRoutes.DELETE_DOCUMENT, pathVariables);
    }

    @Override
    public Document getDocumentInfo(String datasetId, String documentId) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        String result = this.requestJson(DifyRoutes.GET_DOCUMENT_INFO, pathVariables);
        return (Document)JSON.parseObject((String)result, (TypeReference)new TypeReference<Document>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public DatasetResponse<List<Segment>> createSegment(String datasetId, String documentId, SegmentAddRequest segment) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        String result = this.requestJson(DifyRoutes.CREATE_SEGMENT, pathVariables, null, (Object)segment);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<List<Segment>>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public DatasetResponse<Segment> updateSegment(String datasetId, String documentId, String segmentId, SegmentUpdateRequest segment) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        pathVariables.add(PathVariables.builder().name("segment_id").value(segmentId).build());
        String result = this.requestJson(DifyRoutes.UPDATE_SEGMENT, pathVariables, null, (Object)segment);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<Segment>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public DatasetResponse<List<Segment>> getSegments(Integer page, Integer limit, String datasetId, String documentId, String keyword, String status) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("page", page);
        query.put("limit", limit);
        query.put("keyword", keyword);
        query.put("status", status);
        String result = this.requestJson(DifyRoutes.GET_SEGMENTS, pathVariables, query);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<List<Segment>>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public DatasetResponse<Segment> getSegmentInfo(String datasetId, String documentId, String segmentId) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        pathVariables.add(PathVariables.builder().name("segment_id").value(segmentId).build());
        String result = this.requestJson(DifyRoutes.GET_SEGMENT_INFO, pathVariables);
        return (DatasetResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<DatasetResponse<Segment>>(){}, (Feature[])new Feature[0]);
    }

    @Override
    public void deleteSegment(String datasetId, String documentId, String segmentId) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        pathVariables.add(PathVariables.builder().name("document_id").value(documentId).build());
        pathVariables.add(PathVariables.builder().name("segment_id").value(segmentId).build());
        String result = this.requestJson(DifyRoutes.DELETE_SEGMENT, pathVariables);
    }

    @Override
    public void updateDocumentMeta(String datasetId, UpdateDocumentMetadata updateDocumentMetadata) throws IOException, InterruptedException {
        ArrayList<PathVariables> pathVariables = new ArrayList<PathVariables>();
        pathVariables.add(PathVariables.builder().name("dataset_id").value(datasetId).build());
        String result = this.requestJson(DifyRoutes.UPDATE_DOCUMENT_META, pathVariables, null, (Object)updateDocumentMetadata);
    }
}

