/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Material;
import com.ptteng.common.carjn.service.MaterialService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class MaterialSCAClient implements MaterialService {

    private MaterialService materialService;

	public MaterialService getMaterialService() {
		return materialService;
	}
	
	
	public void setMaterialService(MaterialService materialService) {
		this.materialService =materialService;
	}
	
	
			   
		@Override
		public Long insert(Material material)throws ServiceException, ServiceDaoException{
		
		return materialService.insert(material);
		          
		
		}	
		  
    	   
		@Override
		public List<Material> insertList(List<Material> materialList)throws ServiceException, ServiceDaoException{
		
		return materialService.insertList(materialList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return materialService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Material material)throws ServiceException, ServiceDaoException{
		
		return materialService.update(material);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Material> materialList)throws ServiceException, ServiceDaoException{
		
		return materialService.updateList(materialList);
		          
		
		}	
		  
    	   
		@Override
		public Material getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return materialService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Material> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return materialService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			

	 @Override
	public List<Long>  getMaterialIdsByParentNameOrderByUpdateAt(String parentName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return materialService.getMaterialIdsByParentNameOrderByUpdateAt(parentName, start, limit);
	
	
	}

	@Override
	public List<Long>  getMaterialIdsByTypeAndStatusOrderByUpdateAt(String type,String status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return materialService.getMaterialIdsByTypeAndStatusOrderByUpdateAt(type, status, start, limit);


	}

	@Override
	public List<Long>  getMaterialIdsByMetarialNameOrderByUpdateAt(String metarialName,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return materialService.getMaterialIdsByMetarialNameOrderByUpdateAt(metarialName, start, limit);


	}




	 @Override
	public Integer  countMaterialIdsByParentNameOrderByUpdateAt(String parentName)throws ServiceException, ServiceDaoException{
		
		return materialService.countMaterialIdsByParentNameOrderByUpdateAt(parentName);
	
	
	}
	
		
	
		@Override
	public List<Long> getMaterialIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return materialService.getMaterialIds(start, limit);
	}

	@Override
	public Integer countMaterialIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return materialService.countMaterialIds();
	}


	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return materialService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return materialService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   materialService.deleteList(clz, ids);
		
	}

	public  Long getIdBymetNameAndValueName(Long metarialName,Long valueName) throws
			ServiceException, ServiceDaoException{
		return materialService.getIdBymetNameAndValueName(metarialName,valueName);
	}



}

