/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.CustomerMaterialRelation;
import com.ptteng.common.carjn.service.CustomerMaterialRelationService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerMaterialRelationSCAClient implements CustomerMaterialRelationService {

    private CustomerMaterialRelationService customerMaterialRelationService;

	public CustomerMaterialRelationService getCustomerMaterialRelationService() {
		return customerMaterialRelationService;
	}
	
	
	public void setCustomerMaterialRelationService(CustomerMaterialRelationService customerMaterialRelationService) {
		this.customerMaterialRelationService =customerMaterialRelationService;
	}
	
	
			   
		@Override
		public Long insert(CustomerMaterialRelation customerMaterialRelation)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.insert(customerMaterialRelation);
		          
		
		}	
		  
    	   
		@Override
		public List<CustomerMaterialRelation> insertList(List<CustomerMaterialRelation> customerMaterialRelationList)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.insertList(customerMaterialRelationList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(CustomerMaterialRelation customerMaterialRelation)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.update(customerMaterialRelation);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<CustomerMaterialRelation> customerMaterialRelationList)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.updateList(customerMaterialRelationList);
		          
		
		}	
		  
    	   
		@Override
		public CustomerMaterialRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<CustomerMaterialRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(String customerId,String personnelType,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(customerId, personnelType, start, limit);
	
	
	}

	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @param constantName
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public  Long  getIdsByCidAndPersonnelTypeAndConstantname(String customerId,String personnelType,String constantName)throws ServiceException, ServiceDaoException{

		return customerMaterialRelationService.getIdsByCidAndPersonnelTypeAndConstantname(customerId, personnelType,constantName);


	}


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public  Long  getCustomerMaterialRelationIdByCustomerIdAndPersonnelType(String customerId,String personnelType)throws ServiceException, ServiceDaoException{

		return customerMaterialRelationService.getCustomerMaterialRelationIdByCustomerIdAndPersonnelType(customerId,personnelType);


	}


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(String customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.getCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(customerId,start,limit);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @param personnelType
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(String customerId,String personnelType)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.countCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(customerId,personnelType);
	
	
	}


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(String customerId)throws ServiceException, ServiceDaoException{
		
		return customerMaterialRelationService.countCustomerMaterialRelationIdsByCustomerIdOrderByUpdateAt(customerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getCustomerMaterialRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerMaterialRelationService.getCustomerMaterialRelationIds(start, limit);
	}

	@Override
	public Integer countCustomerMaterialRelationIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerMaterialRelationService.countCustomerMaterialRelationIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerMaterialRelationService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return customerMaterialRelationService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   customerMaterialRelationService.deleteList(clz, ids);
		
	}


 
}

