/**
 * 
 */
package com.ptteng.sca.common.carjn.client;

import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.model.Article;
import com.ptteng.common.carjn.service.ArticleService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ArticleSCAClient implements ArticleService {

    private ArticleService articleService;

	public ArticleService getArticleService() {
		return articleService;
	}
	
	
	public void setArticleService(ArticleService articleService) {
		this.articleService =articleService;
	}
	
	
			   
		@Override
		public Long insert(Article article)throws ServiceException, ServiceDaoException{
		
		return articleService.insert(article);
		          
		
		}	
		  
    	   
		@Override
		public List<Article> insertList(List<Article> articleList)throws ServiceException, ServiceDaoException{
		
		return articleService.insertList(articleList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return articleService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Article article)throws ServiceException, ServiceDaoException{
		
		return articleService.update(article);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Article> articleList)throws ServiceException, ServiceDaoException{
		
		return articleService.updateList(articleList);
		          
		
		}	
		  
    	   
		@Override
		public Article getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return articleService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Article> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return articleService.getObjectsByIds(ids);
		          
		
		}


	/**
	 *
	 * @param status
	 * @param source
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleIdsByStatusAndSourceOrderByPublishat(Long status,String source,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return articleService.getArticleIdsByStatusAndSourceOrderByPublishat(status, source, start, limit);
	
	
	}

	/**
	 *
	 * @param type
	 * @param status
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getArticleIdsByTypeAndStatusOrderByPublishat(Integer type,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		return articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, status, start, limit);


	}

	/**
	 *
	 * @param type
	 * @param status
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countArticleIdsByTypeAndStatusOrderByPublishat(Integer type,Integer status)throws ServiceException, ServiceDaoException{

		return articleService.countArticleIdsByTypeAndStatusOrderByPublishat(type, status);


	}


	/**
	 *
	 * @param source
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleIdsBySourceAndTypeOrderByPublishat(String source,Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return articleService.getArticleIdsBySourceAndTypeOrderByPublishat(source,type,start,limit);
	
	
	}


	/**
	 *
	 * @param source
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleIdsBySourceOrderByPublishat(String source,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return articleService.getArticleIdsBySourceOrderByPublishat(source,start,limit);
	
	
	}


	/**
	 *
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getArticleIdsByTypeOrderByPublishat(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return articleService.getArticleIdsByTypeOrderByPublishat(type,start,limit);
	
	
	}


	/**
	 *
	 * @param status
	 * @param source
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleIdsByStatusAndSourceOrderByPublishat(Long status,String source)throws ServiceException, ServiceDaoException{
		
		return articleService.countArticleIdsByStatusAndSourceOrderByPublishat(status,source);
	
	
	}


	/**
	 *
	 * @param source
	 * @param type
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleIdsBySourceAndTypeOrderByPublishat(String source,Integer type)throws ServiceException, ServiceDaoException{
		
		return articleService.countArticleIdsBySourceAndTypeOrderByPublishat(source,type);
	
	
	}


	/**
	 *
	 * @param source
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleIdsBySourceOrderByPublishat(String source)throws ServiceException, ServiceDaoException{
		
		return articleService.countArticleIdsBySourceOrderByPublishat(source);
	
	
	}


	/**
	 *
	 * @param type
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countArticleIdsByTypeOrderByPublishat(Integer type)throws ServiceException, ServiceDaoException{
		
		return articleService.countArticleIdsByTypeOrderByPublishat(type);
	
	
	}
	
		
	
		@Override
	public List<Long> getArticleIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return articleService.getArticleIds(start, limit);
	}

	@Override
	public Integer countArticleIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return articleService.countArticleIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return articleService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return articleService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   articleService.deleteList(clz, ids);
		
	}


 
}

