package com.ptteng.common.carjn.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.carjn.model.Sms;
import com.ptteng.common.dao.BaseDaoService;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface SmsService extends BaseDaoService {

    public String ErrorCode_SMS_InvalidType = "invalideType";

    public String ErrorCode_SMS_smsMoreThan3 = "smsMoreThan3";


    public Long insert(Sms sms) throws ServiceException, ServiceDaoException;


    public List<Sms> insertList(List<Sms> smsList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Sms sms) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Sms> smsList) throws ServiceException, ServiceDaoException;


    public Sms getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Sms> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     *
     * @param mobile
     * @param type
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getSmsIdByMobileAndType(String mobile, String type) throws ServiceException, ServiceDaoException;


    /**
     *
     * @param start
     * @param limit
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSmsIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     *
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSmsIds() throws ServiceException, ServiceDaoException;


    /**
     *
     * @param phone
     * @param type
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public String sendMsg(String phone, String type) throws ServiceException, ServiceDaoException;
}

