package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Saler;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface SalerService extends BaseDaoService {

	



   		   
		
		public Long insert(Saler saler)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Saler> insertList(List<Saler> salerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Saler saler)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Saler> salerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Saler getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Saler> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getSalerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countSalerIds() throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param phone
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getSalerIdByPhone(String phone) throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param channelId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long getSalerIdByChannelId(String channelId) throws ServiceException, ServiceDaoException;

}

