package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Role;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface RoleService extends BaseDaoService {

	



   		   
		
		public Long insert(Role role)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Role> insertList(List<Role> roleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Role role)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Role> roleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Role getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Role> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param name
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countRoleIdsByNameOrderByUpdateAt(String name)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param name
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getRoleIdsByNameOrderByUpdateAt(String name, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getRoleIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countRoleIds() throws ServiceException, ServiceDaoException;
	

}

