package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Ploan;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface PloanService extends BaseDaoService {

	



   		   
		
		public Long insert(Ploan ploan)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Ploan> insertList(List<Ploan> ploanList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Ploan ploan)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Ploan> ploanList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Ploan getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Ploan> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param productId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countPloanIdsByProductIdOrderByUpdateAt(Long productId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param productId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getPloanIdsByProductIdOrderByUpdateAt(Long productId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getPloanIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countPloanIds() throws ServiceException, ServiceDaoException;
	

}

