package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Manager;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ManagerService extends BaseDaoService {

	



   		   
		
		public Long insert(Manager manager)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Manager> insertList(List<Manager> managerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Manager manager)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Manager> managerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Manager getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Manager> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param name
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countManagerIdsByName(String name)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param roleId
	 * @param status
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countManagerIdsByRoleIdAndStatusOrderByUpdateAt(Long roleId, String status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param roleId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countManagerIdsByRoleId(Long roleId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param name
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getManagerIdsByName(String name, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param roleId
	 * @param status
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getManagerIdsByRoleIdAndStatusOrderByUpdateAt(Long roleId, String status, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param roleId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getManagerIdsByRoleId(Long roleId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getManagerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getManagerIdsByType(String type,Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countManagerIds() throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param conditions
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getManagerIdsByCondition(Map<String, Object> conditions,
											   Integer start, Integer limit) throws ServiceException,
			ServiceDaoException;

}

