package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Iprocess;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface IprocessService extends BaseDaoService {

	



   		   
		
		public Long insert(Iprocess iprocess)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Iprocess> insertList(List<Iprocess> iprocessList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Iprocess iprocess)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Iprocess> iprocessList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Iprocess getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Iprocess> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param indentId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIprocessIdsByIndentId(String indentId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param indentId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countIprocessIdsByIndentIdOrderByUpdateAt(String indentId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param indentId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIprocessIdsByIndentId(String indentId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param indentId
	 * @param process
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getIprocessIdByIndentIdAndProcess(String indentId,String process)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getIprocessIdByCustomerId(Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIprocessIdsByCustomerIdOrderByUpdateAt(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getIprocessIdsByCustomerIdOrderByUpdateAtAsc(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getIprocessIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countIprocessIds() throws ServiceException, ServiceDaoException;
	

}

