package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Customer;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CustomerService extends BaseDaoService {

	



   		   
		
		public Long insert(Customer customer)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Customer> insertList(List<Customer> customerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Customer customer)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Customer> customerList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Customer getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Customer> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param name
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerIdsBySalerIdAndNameOrderByUpdateAt(Long salerId,String name)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param number
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getCustomerIdByNumber(String number)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param number
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsByNumberAndSalerId(String number,String salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsBySalerIdOrderByUpdateAtAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsBySalerIdOrderByProcessAsc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsBySalerIdOrderByProcessDesc(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param name
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerIdsBySalerIdAndNameOrderByUpdateAt(Long salerId,String name,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCustomerIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCustomerIds() throws ServiceException, ServiceDaoException;
	

}

