package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.CustomerSalerRelation;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CustomerSalerRelationService extends BaseDaoService {

	



   		   
		
		public Long insert(CustomerSalerRelation customerSalerRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<CustomerSalerRelation> insertList(List<CustomerSalerRelation> customerSalerRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(CustomerSalerRelation customerSalerRelation)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<CustomerSalerRelation> customerSalerRelationList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public CustomerSalerRelation getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<CustomerSalerRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(Long salerId)throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @param customerId
	 * @param salerId
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getCustomerSalerRelationIdByCustomerIdAndSalerId(Long customerId,Long salerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param customerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerSalerRelationIdsByCustomerIdOrderByUpdateAt(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param salerId
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getCustomerSalerRelationIdsBySalerIdOrderByUpdateAt(Long salerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getCustomerSalerRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countCustomerSalerRelationIds() throws ServiceException, ServiceDaoException;
	

}

