package com.ptteng.common.carjn.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.common.carjn.model.Article;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ArticleService extends BaseDaoService {

	



   		   
		
		public Long insert(Article article)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Article> insertList(List<Article> articleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Article article)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Article> articleList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Article getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Article> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;



	public Integer  countArticleIdsByStatusAndSourceOrderByPublishat(Long status, String source)throws ServiceException, ServiceDaoException;



	public Integer  countArticleIdsBySourceAndTypeOrderByPublishat(String source, Integer type)throws ServiceException, ServiceDaoException;



	public Integer  countArticleIdsBySourceOrderByPublishat(String source)throws ServiceException, ServiceDaoException;

	public Integer  countArticleIdsByTypeOrderByPublishat(Integer type)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param status
	 * @param source
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByStatusAndSourceOrderByPublishat(Long status, String source, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param source
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsBySourceAndTypeOrderByPublishat(String source, Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param source
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsBySourceOrderByPublishat(String source, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByTypeOrderByPublishat(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param status
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countArticleIdsByTypeAndStatusOrderByPublishat(Integer type,Integer status)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param type
	 * @param status
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getArticleIdsByTypeAndStatusOrderByPublishat(Integer type,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param start
	 * @param limit
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getArticleIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 *
	 * @return int
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countArticleIds() throws ServiceException, ServiceDaoException;
	

}

