package com.ptteng.util;

import com.gemantic.dal.config.helper.GroupHelper;
import com.ptteng.common.carjn.model.Product;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

import javax.sql.DataSource;
import javax.xml.crypto.Data;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by ruan on 2015/12/10.
 */
public class ProductUtil {
    private static final Log log = LogFactory.getLog(ProductUtil.class);

    public static Map<String, Object> getProductListParam(  Long startAt,Long endAt,String productType,String status,
                                                            Long channel,String firstUpperPercent,
                                                            String firstLowerPercent,String loanLowerLimit,String loanUpperLimit, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();



        if (DataUtils.isNotNullOrEmpty(productType)) {
            params.put("type", "'"+productType+"'");
        }
        if (DataUtils.isNotNullOrEmpty(status)) {
            params.put("status","'"+ status+"'");
        }
        if (DataUtils.isNotNullOrEmpty(channel)) {
            params.put("channel", " '"+channel+"' ");
        }


        if (DataUtils.isNotNullOrEmpty(firstUpperPercent)) {
            params.put("first_upper_percent", "'"+firstUpperPercent+"'");
        }
        if (DataUtils.isNotNullOrEmpty(firstLowerPercent)) {
            params.put("first_lower_percent","'"+ firstLowerPercent+"'");
        }

        if (DataUtils.isNotNullOrEmpty(loanLowerLimit)) {
            params.put(" loan_lower_limit ", "'"+loanLowerLimit+"'");
        }
        if (DataUtils.isNotNullOrEmpty(loanUpperLimit)) {
            params.put("loan_upper_limit","'"+ loanUpperLimit+"'");
        }


        if(DataUtils.isNotNullOrEmpty(startAt))
        {
            params.put(" create_at & >= ", "'"+startAt+"'");
        }
        if(DataUtils.isNotNullOrEmpty(endAt))
        {
            params.put(" create_at & <= ", "'"+endAt+"'");
        }



        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  product ");

        return params;
    }


    public static List<Product> getProductIdsByCondition(Integer start, Integer limit,
                                                      Long startAt,Long endAt,String productType,String status,
                                                      Long channel,String firstPercent,
                                                      String loanLimit){

        log.info(" getProductIdsByCondition  start  ");
        List<Product> ids = new ArrayList<Product>();
        DataSource dataSource = GroupHelper.getDataSource("common_carjn");
        log.info("Test 333 ");
        if (DataUtils.isNotNullOrEmpty(dataSource)) {
            log.info("  datasource = " + dataSource);
        } else {

        }
        SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        StringBuilder sql = new StringBuilder();
        sql.append("  select id ");
        sql.append("  from  product  ");
        sql.append("  where 1=1 ");
        if(DataUtils.isNotNullOrEmpty(startAt)){
            sql.append(" and   create_at >=  '" + startAt + "' ");
        }
        if(DataUtils.isNotNullOrEmpty(endAt)){
            sql.append(" and   a.create_at <= '" + endAt + "' ");
        }
        if(DataUtils.isNotNullOrEmpty(productType)){
            sql.append(" and type = "+"'"+productType+"'");
        }
        if(DataUtils.isNotNullOrEmpty(status)){
            sql.append(" and status = "+"'"+status+"'");
        }
        if(DataUtils.isNotNullOrEmpty(channel)){
            sql.append(" and channel = "+"'"+channel+"'");
        }
        if(DataUtils.isNotNullOrEmpty(firstPercent)){
            sql.append(" and  first_lower_percent <= "+firstPercent);
            sql.append(" and first_upper_percent >=  "+firstPercent);
        }

        if(DataUtils.isNotNullOrEmpty(loanLimit)){
            sql.append(" and loan_lower_limit <= "+loanLimit);
            sql.append(" and (loan_upper_limit >= "+loanLimit+" or loan_upper_limit  = '-1')");
        }

        sql.append("  order by update_at desc ");

        sql.append(" limit  "+start+","+limit);
        log.info("Sql " + sql.toString());
        ids =   simpleJdbcTemplate.query(sql.toString(),

                ParameterizedBeanPropertyRowMapper.newInstance(Product.class));
        return ids;
    }


}
