package com.ptteng.util;

import com.ptteng.common.carjn.model.Indent;
import com.ptteng.model.IndentParm;
import com.qding.common.util.DataUtils;
import com.gemantic.dal.config.helper.GroupHelper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.ParameterizedBeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/**
 * Created by liangxj on 2015/12/15.
 */
public class IndentUtil {
    private static final Log log = LogFactory.getLog(IndentUtil.class);


    public static Map<String, Object> getIndentList(String processes, Boolean count) {

        Map<String, Object> params = new HashMap<String, Object>();


        if (DataUtils.isNotNullOrEmpty(processes)) {
            params.put("process & in ", "(" + processes + ")");
        }


        if (count) {
            params.put("@query", " count(id) ");
        } else {
            params.put("@order", "  update_at desc ");
            params.put("@query", " id ");
        }
        params.put("@table", "  indent ");

        return params;
    }

    public static List<IndentParm> getIndentListByMore(Long startAt, Long endAt, String salerName, String cusName,
                                                       String productType, Long channelId, String productName, String

                                                               process, String status, String processes, Integer start, Integer
                                                               limit, String uid) {


        log.info("Test 111 ");
        List<IndentParm> indentParmList = new ArrayList<IndentParm>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_carjn");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append("select a.id,a.create_at as createAt ,a.number,c.`name` as salerName, ");
            sql.append(" c.phone as salerePhone, a.product_type as productType, ");
            sql.append(" b.`name` as customerName ,b.phone as customerPhone ,e.`name` as  channel  , ");
            sql.append(" d.`name` as productName,a.process as process, ");
            sql.append(" a.reply_result as result, a.operator as operator from  indent a  ");
            sql.append("  join  customer b  on a.customer_id=b.id ");
            sql.append(" JOIN  saler c on c.id = a.saler_id  ");
            sql.append(" JOIN  product d on a.product_id=d.id ");
            sql.append(" JOIN  constant e on d.channel=e.id  ");


            sql.append("  where 1=1 ");
            if (DataUtils.isNotNullOrEmpty(salerName)) {
                sql.append(" and c.name like  '%" + salerName + "%'  ");
            }
            if (DataUtils.isNotNullOrEmpty(cusName)) {
                sql.append(" and b.name like  '%" + cusName + "%' ");
            }
            sql.append("  and (a.operator is null or a.operator =  " + uid + ") ");

            if (DataUtils.isNotNullOrEmpty(uid)) {
                sql.append("  and a.product_id in ( ")
                        .append(" select c.product_id from manager a  ")
                        .append("  join  manager_product_relation c on c.manager_id = a.id ")
                        .append("  where a.id=  " + uid + ") ");
            }


            if (DataUtils.isNotNullOrEmpty(productType)) {
                sql.append(" and  a.product_type = '" + productType + "' ");
            }
            if (DataUtils.isNotNullOrEmpty(channelId)) {
                sql.append(" and e.id = '" + channelId + "'  ");
            }
            if (DataUtils.isNotNullOrEmpty(productName)) {
                sql.append(" and d.name = '" + productName + "'  ");
            }
            if (DataUtils.isNotNullOrEmpty(process)) {
                sql.append("  and a.process in (" + process + ") ");
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                sql.append("  and a.reply_result   = '" + status + "'  ");
            }

            if (DataUtils.isNotNullOrEmpty(startAt)) {
                sql.append("  and a.create_at >= '" + startAt + "' ");
            }
            if (DataUtils.isNotNullOrEmpty(endAt)) {
                sql.append(" and   a.create_at <= '" + endAt + "' ");
            }

            if (DataUtils.isNotNullOrEmpty(processes)) {
                sql.append(" and  a.process in (" + processes + ")");
            }


            sql.append("  order by a.update_at desc ");

            sql.append(" limit  " + start + "," + limit);
            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(IndentParm.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static List<IndentParm> getLoanListByMore(Long startAt, Long endAt, String salerName, String cusName,
                                                     String productType, Long channelId, String productName, String

                                                             process, String status, String processes, Integer start, Integer
                                                             limit, String uid, String operatorName) {


        log.info("Test 111 ");
        List<IndentParm> indentParmList = new ArrayList<IndentParm>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_carjn");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
            StringBuilder sql = new StringBuilder();
            sql.append("select a.id,a.create_at as createAt ,a.number,c.`name` as salerName, ");
            sql.append(" c.phone as salerePhone, a.product_type as productType, ");
            sql.append(" b.`name` as customerName ,b.phone as customerPhone ,e.`name` as  channel  , ");
            sql.append(" d.`name` as productName,a.process as process, ");
            sql.append(" a.reply_result as result,   ");
            sql.append("(select name from manager where id = a.operator or null ) as operator   ");
            sql.append(" from indent a    ");

            sql.append("  join  customer b  on a.customer_id=b.id ");
            sql.append(" JOIN  saler c on c.id = a.saler_id  ");
            sql.append(" JOIN  product d on a.product_id=d.id ");
            sql.append(" JOIN  constant e on d.channel=e.id  ");
            if (DataUtils.isNotNullOrEmpty(operatorName)) {
                sql.append(" JOIN manager f on f.id = a.operator   ");

            }


            sql.append("  where 1=1 ");
//          普通管理员可以看到所有产品，不需要对产品进行限制
//            if(DataUtils.isNotNullOrEmpty(uid)){
//                sql.append("  and a.product_id in ( ")
//                        .append(" select c.product_id from manager a  ")
//                        .append("  join  manager_product_relation c on c.manager_id = a.id ")
//                        .append("  where a.id=  " + uid + ") ");
//
//
//
//            }


            if (DataUtils.isNotNullOrEmpty(salerName)) {
                sql.append(" and c.name like  '%" + salerName + "%'  ");
            }
            if (DataUtils.isNotNullOrEmpty(cusName)) {
                sql.append(" and b.name like  '%" + cusName + "%' ");
            }
            if (DataUtils.isNotNullOrEmpty(productType)) {
                sql.append(" and  a.product_type = '" + productType + "' ");
            }
            if (DataUtils.isNotNullOrEmpty(channelId)) {
                sql.append(" and e.id = '" + channelId + "'  ");
            }
            if (DataUtils.isNotNullOrEmpty(productName)) {
                sql.append(" and d.name = '" + productName + "'  ");
            }
            if (DataUtils.isNotNullOrEmpty(operatorName)) {
                sql.append(" and f.name like  '%" + operatorName + "%' ");
            }
            if (DataUtils.isNotNullOrEmpty(process)) {
                sql.append("  and a.process  in (" + process + ")  ");
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                sql.append("  and a.reply_result   = '" + status + "'  ");
            }

            if (DataUtils.isNotNullOrEmpty(startAt)) {
                sql.append("  and a.create_at >= '" + startAt + "' ");
            }
            if (DataUtils.isNotNullOrEmpty(endAt)) {
                sql.append(" and   a.create_at <= '" + endAt + "' ");
            }

            if (DataUtils.isNotNullOrEmpty(processes)) {
                sql.append(" and  a.process in (" + processes + ")");
            }


            sql.append("  order by a.update_at desc ");

            sql.append(" limit  " + start + "," + limit);
            log.info("Sql " + sql.toString());
            indentParmList =
                    simpleJdbcTemplate.query(sql.toString(),
                            ParameterizedBeanPropertyRowMapper.newInstance(IndentParm.class));
        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }

        log.info("  size  = " + indentParmList.size());
        return indentParmList;
    }


    public static Map<String, Object> getIndentCount(Integer model,Integer type) {
        log.info("Test 111 ");
        Map<String, Object> map = new HashMap<>();
        log.info("Test 222 ");
        try {
            DataSource dataSource = GroupHelper.getDataSource("common_carjn");
            log.info("Test 333 ");
            if (DataUtils.isNotNullOrEmpty(dataSource)) {
                log.info("  datasource = " + dataSource);
            } else {

            }
            log.info("Test 44 ");
            SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);

            String sqlWhere = type != 0 ? " and product_type = " + type + " " : " ";

            StringBuilder sql = new StringBuilder();
            if (model == 1){
                // 申请数量
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (2,3,4,5) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("applyNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 批复数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (6) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("replyNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 出合同数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (7,8,9) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("contractNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 待请款数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (10,11) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("requestNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 放款数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (12,13,14) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("loanNum", simpleJdbcTemplate.queryForInt(sql.toString()));

            }
            if (model == 2){
                // 待请款
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (12) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("requestNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 上传贷后资料数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (13) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("uploadNum", simpleJdbcTemplate.queryForInt(sql.toString()));

                // 归档数量
                sql = new StringBuilder();
                sql.append("SELECT COUNT(id) FROM indent WHERE process IN (14) ");
                sql.append(sqlWhere);
                log.info("Sql: " + sql.toString());
                map.put("fileNum", simpleJdbcTemplate.queryForInt(sql.toString()));

            }

        } catch (Exception e) {
            e.printStackTrace(System.out);
            log.info(e.getMessage());
        }
        return map;
    }
}
