package com.ptteng.common.carjn.controller;


import atg.taglib.json.util.JSONArray;
import atg.taglib.json.util.JSONObject;
import com.gemantic.common.util.json.GsonUtil;
import com.gemantic.dal.dao.util.DalAssert;
import com.ptteng.common.storage.util.notice.NoticeUtil;
import com.ptteng.model.*;
import com.ptteng.util.NoticeMessageUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.ptteng.common.carjn.model.*;
import com.ptteng.common.carjn.service.*;
import com.ptteng.util.IndentUtil;
import com.ptteng.util.LoanUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.PathVariable;

import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.io.*;
import java.security.cert.Certificate;
import java.text.SimpleDateFormat;
import java.util.*;


/**
 * Created by liangxj on 2015/12/15.
 */
@Controller
public class loanControler {
    private static final Log log = LogFactory.getLog(loanControler.class);

    @Autowired
    private IndentService indentService;

    @Autowired
    private IprocessService iprocessService;

    @Autowired
    private SalerService salerService;

    @Autowired
    private CustomerService customerService;

    @Autowired
    private ProductService productService;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private CookieUtil  cookieUtil;

    @Autowired
    private IdocumentService idocumentService;

    @Autowired
    private CustomerMaterialRelationService cmrService;

    @Autowired
    private GuaranteeService guaranteeService;

    @Autowired
    private PcertificateService pcertificateService;
    @Autowired
    private GuaCertificateService guaCertificateService;

    @Autowired
    private StatisticsService statisticsService;

    @Autowired
    private CheckresultrecordService checkresultrecordService;

    @Autowired
    private CusemerconService cusemerconService;

    @Autowired
    private NoticeUtil noticeUtil;


    /**
     * 贷后订单列表查询
     * 进度是上传放款资料或补充放款资料且状态为通过
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/loan/indent/", method = RequestMethod.GET)
    public String getIndentList(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Integer page,
                                Integer size,Long startAt,Long endAt,String salerName,String cusName,
                                String productType,Long channelId,String productName,String

                                            process,String status) throws Exception {

        if(page==null){

            page=1;
        }

        if(size == null){
            size=10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Boolean next = false;
            size+=1;
            List<IndentParm> list = new ArrayList<>();

            String processes = "'"+ Iprocess.PROCESS12+"'"+",'"+Iprocess.PROCESS13+"'"+",'"+Iprocess.PROCESS14+"'";
            log.info(" processes  ="+processes);
 //           status  = Indent.WAITING;
//            Map<String,Object> indentMap =  LoanUtil.getIndentList(processes,Indent.RESULTT_1, false);
//            List<Long>   ids=  indentService.getIdsByDynamicCondition(Indent.class, indentMap, start, size);


         //   List<IndentParm> indentParmList = new ArrayList<>();
            if(DataUtils.isNotNullOrEmpty(process)){
                list =    IndentUtil.getLoanListByMore(startAt,
                        endAt, salerName, cusName, productType, channelId, productName, process, status, "", start, size, "","");

            }else {
                list =    IndentUtil.getLoanListByMore(startAt,
                        endAt, salerName, cusName, productType, channelId, productName, process, status, processes, start, size, "","");
            }

            log.info("  indentParamList   = "+list.size());




            if(list!=null && list.size()>0){

                if (size.equals(list.size())) {
                    next = true;
                    log.info("ss  "+list.subList(0,size-1));
                    model.addAttribute("list", list.subList(0,size-1));
                }else{
                    log.info("ss  "+list.subList(0,list.size()));
                    model.addAttribute("list", list.subList(0, list.size()));
                }
            }else{
                model.addAttribute("list", list);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);



        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get indent list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/indent/json/loanList";
    }


    /**
     * 归档列表查询
     * 进度是12、13、14
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/document/indent/", method = RequestMethod.GET)
    public String getCustomerDocument(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Integer page,
                                Integer size,Long startAt,Long endAt,String salerName,String cusName,
                                      String productType,Long channelId,String productName,String

                                                  process,String status) throws Exception {

        if(page==null){

            page=1;
        }

        if(size == null){
            size=10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Boolean next = false;
            size+=1;
            List<IndentParm> list = new ArrayList<>();

            String processes = Iprocess.PROCESS13+","+Iprocess.PROCESS14;
//            log.info(" processes  ="+processes);
//            Map<String,Object> indentMap =  LoanUtil.getIndentList(processes,Indent.RESULTT_1, false);
//            List<Long>   ids=  indentService.getIdsByDynamicCondition(Indent.class, indentMap, start, size);


    //        List<IndentParm> indentParmList = new ArrayList<>();
            if(DataUtils.isNotNullOrEmpty(process)){
                list =    IndentUtil.getLoanListByMore(startAt,
                        endAt, salerName, cusName, productType, channelId, productName, process, status, "", start, size, "","");

            }else {
                list =    IndentUtil.getLoanListByMore(startAt,
                        endAt, salerName, cusName, productType, channelId, productName, process, status,processes,start,size,"","");
            }

           log.info("get indent size is " + list.size());
            if(list!=null && list.size()>0){

                if (size.equals(list.size())) {
                    next = true;
                    log.info("ss  "+list.subList(0,size-1));
                    model.addAttribute("list", list.subList(0,size-1));
                }else{
                    log.info("ss  "+list.subList(0,list.size()));
                    model.addAttribute("list", list.subList(0, list.size()));
                }
            }else{
                model.addAttribute("list", list);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);



        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get indent list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/indent/json/loanList";
    }




    //根据ID查找单个订单
    @RequestMapping(value = "/a/u/loan/indent/{id}", method = RequestMethod.GET)
    public String getIndentById(HttpServletRequest request,
                   HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

        log.info("  getIndentById   id ="+id);
        try {


            Indent indent = indentService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(indent)){
                model.addAttribute("code",-40001);
                return "/common/success";
            }
            IndentParm indentParm = new IndentParm();


                        log.info(" indent get start");
                        indentParm.setId(indent.getId());
                        indentParm.setProcess(indent.getProcess());
                        indentParm.setResult(indent.getReplyResult());
                        indentParm.setCreateAt(indent.getCreateAt());
                        indentParm.setNumber(indent.getNumber());
                        indentParm.setProductType(indent.getProductType());
                        Saler saler = salerService.getObjectById(indent.getSalerId());
                        if(DataUtils.isNotNullOrEmpty(saler)){
                            indentParm.setSalerName(saler.getName());
                            indentParm.setSalerePhone(saler.getPhone());
                        }
                        Customer customer = customerService.getObjectById(indent.getCustomerId());
                        indentParm.setCustomerName(customer.getName());
                        indentParm.setCustomerPhone(customer.getPhone());
                        Product product = productService.getObjectById(indent.getProductId());
                        indentParm.setProductName(product.getName());
                        Constant constant = constantService.getObjectById( product.getChannel());
                        indentParm.setChannel(constant.getValue());

             List<Long> ids =   idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                        (indent.getCustomerId(),Iprocess.AFTER,0,Integer.MAX_VALUE);
                log.info(" loanurl  idocument id s ="+ids);
                if(ids.size()>0){
                  Idocument idocument =   idocumentService.getObjectById(ids.get(0));
                    log.info("  loanurl  =  "+idocument.getImg() );
                    indentParm.setLoanUrl( idocument.getImg());
                }




            List<Long> dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                    Customer.c_personnelType + "", Iprocess.FILE, Iprocess.FILE_NAME, 0, Integer.MAX_VALUE);

            if (dids.size() > 0) {
                Idocument idocument = idocumentService.getObjectById(dids.get(0));
                model.addAttribute("url", idocument.getImg());
            }

            model.addAttribute("code",0);
            model.addAttribute("indent", indentParm);


            return "/common-carjn-service/indent/json/loanDetail";


        }catch (Throwable t){
            t.printStackTrace();
            log.error("getIndentById  error  id =" + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }


    }

    //保存贷后资料
    @RequestMapping(value = "/a/u/loan/indent/{id}", method = RequestMethod.PUT)
    public String  updateIndentProcess(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id
                                       ,String urls)throws Exception{

        log.info("  url  =" + urls);
        try {
            String uid =  cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            if(DataUtils.isNullOrEmpty(urls)){
                model.addAttribute("code",-1000);
                return "/common/success";
            }
            Indent indent = indentService.getObjectById(id);
            List<Idocument> idocumentList = new ArrayList<>();
            String[]  urlList = urls.split(",");
            for(String url : urlList){
                Idocument idocument = new Idocument();
                idocument.setCustomerId(indent.getCustomerId());
                idocument.setDocumentName("贷后");
                idocument.setDocumentType(Iprocess.AFTER);
                idocument.setPersonnelType(Customer.c_personnelType + "");
                idocument.setImg(url);
                idocument.setCreateBy(Long.valueOf(uid));
                idocumentList.add(idocument);
            }
            idocumentService.insertList(idocumentList);

            Iprocess iprocess = new Iprocess();
            iprocess.setProcess(Iprocess.PROCESS13);
            iprocess.setResultFlag(Indent.RESULTT_1);
            iprocess.setCustomerId(indent.getCustomerId());
            iprocess.setCreateBy(Long.valueOf(uid));
            iprocess.setDescrition("");
            Long processId =  iprocessService.insert(iprocess);
            log.info("  update   indent process ");
            indent.setProcess(Iprocess.PROCESS13);
            indent.setReplyResult(Indent.RESULTT_1);
            indentService.update(indent);
            log.info("  update customer process = ");
            Customer customer = customerService.getObjectById(indent.getCustomerId());
            customer.setProcess(Iprocess.PROCESS13);
            customerService.update(customer);
            log.info("  indent process = " + indent.getProcess());
            log.info(" process id =" + processId);
            //归档
            getCustomerFile(indent.getId(), Long.valueOf(uid));
             model.addAttribute("code",0);


            //加入记录表
            Checkresultrecord checkresultrecord = new Checkresultrecord();
            checkresultrecord.setStage(Checkresultrecord.STAGE_4);
            checkresultrecord.setIndentId(indent.getId());
            checkresultrecord.setDescription("");
            checkresultrecord.setResult(Indent.RESULTT_1);
            checkresultrecord.setAction(Checkresultrecord.ACTION_1);
            checkresultrecord.setModify("");
            checkresultrecord.setNumber(1 + "");
            checkresultrecord.setCreateBy(Long.valueOf(uid));
            checkresultrecord.setUpdateBy(Long.valueOf(uid));
            Long checkId =  checkresultrecordService.insert(checkresultrecord);
            log.info("   insert   checkresultrecord  id ="+checkId);

            //发送推送内容

            Saler saler = salerService.getObjectById(customer.getSalerId());
            //获取channlId
            String channelId = saler.getNoticeChannelId();
            log.info(" saler id = "+saler.getId()+"   saler "+saler.getName()+"  channelId = "+channelId);
            if(DataUtils.isNotNullOrEmpty(channelId)){
                Map<String,String> messageMap =
                        new NoticeMessageUtil().setNotice(indent.getProcess(),indent.getReplyResult(),customer.getName());
                String customContent = "{\""+"cid"+"\":"+customer.getId()+",\"productType\":\""+indent.getProductType()+"\"}";

                this.noticeUtil.pushMessae(channelId,messageMap.get("title"),messageMap.get("description"),3,1,86400 * 7,customContent);

            }

        }catch (Throwable t){
        t.printStackTrace();
        log.error("updateIndentProcess  error  id =" + id);
        model.addAttribute("code", -1);
    }
        return "/common/success";

    }


    //放款归档接口
    @RequestMapping(value = "/a/u/indent/loan/{id}", method = RequestMethod.PUT)
    public String  updateIndentProcess13(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                         @PathVariable Long id )throws Exception{
        log.info("   updateIndentProcess13 id  ="+id);
        try {
            String uid = cookieUtil.getKeyIdentity(request,CookieUtil.USER_ID);
            Indent indent = indentService.getObjectById(id);
            String nowProcess = indent.getProcess();
            log.info(" nowProcess  =  " + nowProcess);


            //改变进度
            Iprocess iprocess = new Iprocess();
            iprocess.setCustomerId(indent.getCustomerId());
            if(Iprocess.PROCESS13.equals(nowProcess)){
                iprocess.setProcess(Iprocess.PROCESS14);
            }else{
                iprocess.setProcess(Iprocess.PROCESS12);
            }

            iprocess.setResultFlag(Indent.RESULTT_1);
            iprocess.setDescrition("");
            iprocess.setCreateBy(Long.valueOf(uid));
            iprocess.setUpdateBy(Long.valueOf(uid));
            iprocessService.insert(iprocess);

            log.info("  customer id = "+indent.getCustomerId());
            Customer customer = customerService.getObjectById(indent.getCustomerId());
            if(Iprocess.PROCESS13.equals(nowProcess)){
                customer.setProcess(Iprocess.PROCESS14);
            }else{
                customer.setProcess(Iprocess.PROCESS12);
            }
            customerService.update(customer);

            log.info("  history   process  = " + indent.getProcess() + "  result = " + indent.getReplyResult());
            if(Iprocess.PROCESS13.equals(nowProcess)){
                indent.setProcess(Iprocess.PROCESS14);
            }else{
                indent.setProcess(Iprocess.PROCESS12);
            }
            indent.setReplyResult(Indent.RESULTT_1);
            indentService.update(indent);
            log.info("  now process  = " + indent.getProcess());

            //改变销售统计
            if(Iprocess.PROCESS12.equals(indent.getProcess())){
                Long statisticsId = statisticsService.getStatisticsIdBySalerIdAndProductType
                        (indent.getSalerId(), indent.getProductType());
                Statistics statistics = statisticsService.getObjectById(statisticsId);
                Integer loanAmont = Integer.valueOf(indent.getLoanAmount());
                //减去审核通过的统计
                Integer passMoney = Integer.valueOf(statistics.getPassMoney()) ;
                log.info("   history  passMoney  ="+passMoney);
                Integer money = passMoney-loanAmont;
                statistics.setPassMoney(money.toString());
                log.info("   now  passMoney  =" + statistics.getPassMoney());
                Integer count = Integer.valueOf(Integer.valueOf(statistics.getPassCount()) - 1);
                statistics.setPassCount(count.toString());
                //加上放款的统计
                log.info("  history  loanAmount = "+statistics.getLoanMoney());
                money = Integer.valueOf(statistics.getLoanMoney())+loanAmont;
                statistics.setLoanMoney(money.toString());
                log.info("  now  loanAmount = "+statistics.getLoanMoney());

                count = Integer.valueOf(statistics.getLoanCount())+1;
                statistics.setLoanCount(count.toString());

                statisticsService.update(statistics);
            }


            //加入记录表
            Checkresultrecord checkresultrecord = new Checkresultrecord();
            if(Iprocess.PROCESS13.equals(nowProcess)){
                checkresultrecord.setStage(Checkresultrecord.STAGE_6);
            }else{
                checkresultrecord.setStage(Checkresultrecord.STAGE_5);
            }

            checkresultrecord.setIndentId(indent.getId());
            checkresultrecord.setDescription("");
            checkresultrecord.setResult(Indent.RESULTT_1);
            if(Iprocess.PROCESS13.equals(nowProcess)){
                checkresultrecord.setAction(Checkresultrecord.ACTION_5);
            }else{
                checkresultrecord.setAction(Checkresultrecord.ACTION_4);
            }

            checkresultrecord.setModify("");
            checkresultrecord.setNumber(1 + "");
            checkresultrecord.setCreateBy(Long.valueOf(uid));
            checkresultrecord.setUpdateBy(Long.valueOf(uid));
            Long checkId =  checkresultrecordService.insert(checkresultrecord);
            log.info("   insert   checkresultrecord  id ="+checkId);

            //发送推送内容

            Saler saler = salerService.getObjectById(customer.getSalerId());
            //获取channlId
            String channelId = saler.getNoticeChannelId();
            log.info(" saler id = "+saler.getId()+"   saler "+saler.getName()+"  channelId = "+channelId);
            if(DataUtils.isNotNullOrEmpty(channelId)){
                Map<String,String> messageMap =
                        new NoticeMessageUtil().setNotice(indent.getProcess(),indent.getReplyResult(),customer.getName());
                String customContent = "{\""+"cid"+"\":"+customer.getId()+",\"productType\":\""+indent.getProductType()+"\"}";

                this.noticeUtil.pushMessae(channelId,messageMap.get("title"),messageMap.get("description"),3,1,86400 * 7,customContent);

            }



            model.addAttribute("code", 0);

        }catch (Exception e){
            e.printStackTrace();
            log.error("  update  process 13 error  id = " + id);

        }

        return "/common/success";
    }




    //归档并下载
    public  void  getCustomerFile( Long id,Long uid)throws Exception {
        log.info("  indent id =" + id+" , uid = "+uid);
        try {
            Indent indent = indentService.getObjectById(id);
            String newProcess = indent.getProcess();
            String newResult = indent.getReplyResult();
            log.info("nowProcess  =  " + newProcess + "  newResult = " + newResult);
            JSONObject jsonObject = getDocumentUrl(indent);
            log.info("  jsonObject =" + jsonObject);

            String jsonString = jsonObject.toString();
            String jsonTxt = Txt.creatTxtFile(indent.getNumber() + "filejson");
            log.info(" jsonTxt  name =  "+jsonTxt);
            Txt.writeTxtFile(jsonString);

            try {
                Process proc = Runtime.getRuntime().exec
                        ("python /data/server/resin-carjn-admin/scripts/download_3.py  " + jsonTxt);
//                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
//                String line;
//                while ((line = in.readLine()) != null) {
//                    log.info("  line  " + line);
//                }
//                in.close();
//                proc.waitFor();
                Customer customer = customerService.getObjectById(indent.getCustomerId());
                String url = "/download/" + customer.getName() + "" + indent.getNumber() + ".zip";

                log.info("  url = "+url);
                List<Long> dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                        Customer.c_personnelType + "", Iprocess.FILE, Iprocess.FILE_NAME, 0, Integer.MAX_VALUE);

                if (dids.size() > 0) {
                    Idocument idocument = idocumentService.getObjectById(dids.get(0));
                    idocument.setUploadType(Idocument.ING);
                    idocumentService.update(idocument);

                } else {
                    //保存数据
                    Idocument idocument = new Idocument();
                    idocument.setImg(url);
                    idocument.setPersonnelType(Customer.c_personnelType + "");
                    idocument.setDocumentType(Iprocess.FILE);
                    idocument.setDocumentName(Iprocess.FILE_NAME);
                    idocument.setCustomerId(indent.getCustomerId());
                    idocument.setUploadType(Idocument.ING);
                    idocument.setCreateBy(Long.valueOf(uid));
                    Long iId = idocumentService.insert(idocument);
                    log.info("  idcoumetn  id =" + iId);
                }
            } catch (Exception e) {
                log.info("  get zip  error ");
            }
        } catch (Throwable t) {
            log.error("  error  document  ");
            t.printStackTrace();
        }



    }


    //归档回调
    @RequestMapping(value = "/a/file", method = RequestMethod.PUT)
    public String  updateFileStatus(HttpServletRequest request,
                                   HttpServletResponse response, ModelMap model,  String file,
                                    String status
    )throws Exception {
        log.info("  file = "+file+" , status = "+status);
        Long id =  idocumentService.getIdByDocumentTypeAndImg(Iprocess.FILE,file);
        log.info("  document id = "+id);
        if(DataUtils.isNotNullOrEmpty(id)){
            Idocument idocument = idocumentService.getObjectById(id);
            log.info("  history  status = "+idocument.getUploadType());
            idocument.setUploadType(status);
            idocumentService.update(idocument);
        }
        model.addAttribute("code", 0);
        return "/common/success";

    }


    public  JSONObject  getDocumentUrl(Indent indent ) throws Exception{
        log.info("   make idocument start ");

        Customer customer = customerService.getObjectById(indent.getCustomerId());
        //客户材料信息
        List<Long>  cCmrIds =   cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                (customer.getId()+"",Customer.c_personnelType+"",0,Integer.MAX_VALUE);
        List<CustomerMaterialRelation> cCmrList = cmrService.getObjectsByIds(cCmrIds);
        //配偶材料信息
        String marriedFlag = customer.getMarriage();
        Guarantee spouse = new Guarantee();
        List<CustomerMaterialRelation> sCmrList = new ArrayList<>();
        if(Customer.married.equals(marriedFlag)){
            spouse = guaranteeService.getObjectById( guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(),Customer.s_personnelType+""));

            List<Long>  sCmrIds =   cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.s_personnelType + "", 0, Integer.MAX_VALUE);
            sCmrList = cmrService.getObjectsByIds(sCmrIds);
        }else{
            //父母信息
            Long parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.f_personnelType + "");
            log.info(" parentId = "+parentId);
            if(null == parentId){
                parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(), Customer.m_personnelType + "");
            }
            log.info(" parentId = "+parentId);
            if(null != parentId){
                spouse = guaranteeService.getObjectById(parentId);
            }

        }
        //担保人材料信息
        Guarantee guarantee = new Guarantee();
        List<CustomerMaterialRelation> gCmrList = new ArrayList<>();
        Boolean  guaFlag = false;
        for(CustomerMaterialRelation cmr : cCmrList){
            if(cmr.getMaterialName().contains(Customer.GUARANTEE)){
                guaFlag=true;
                break;
            }
        }
        if(guaFlag){
            guarantee = guaranteeService.getObjectById( guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(),Customer.g_personnelType+""));

            List<Long>  gCmrIds =   cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.g_personnelType + "", 0, Integer.MAX_VALUE);
            gCmrList = cmrService.getObjectsByIds(gCmrIds);
        }

        //未满24周岁，直系亲属担保人基本信息
        Long minGuaId =  guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.minor_personnelType + "");
        Guarantee minGua = new Guarantee();
        if(null != minGuaId){
            minGua = guaranteeService.getObjectById(minGuaId);
        }


        //新建txt文件
        String filenameTemp = Txt.creatTxtFile(customer.getName() + "" + indent.getNumber());
        String marriage = "";
        if(Customer.married.equals(customer.getMarriage())){
            marriage="已婚";
        }else if(Customer.unmarried.equals(customer.getMarriage())){
            marriage="未婚";
        }else if(Customer.divorced.equals(customer.getMarriage())){
            marriage="离异";
        }
        int length = 60;

        Txt.writeTxtFile("客户信息");
        Txt.writeTxtFile(formatStr("客户姓名："+customer.getName(),length)+"\r\n"+formatStr("婚姻状况："+marriage,length));

        Txt.writeTxtFile(formatStr("联系电话："+customer.getPhone(),length)+"\r\n"+formatStr("身份证号："+customer.getNumber(),length));
        Txt.writeTxtFile(formatStr("户籍地址：" + customer.getCensRegAddress(), length * 2));

        Txt.writeTxtFile(formatStr("工作单位：" + customer.getEmployer(), length * 2));
        Txt.writeTxtFile(formatStr("工作年限（年）：" + customer.getWorkExperience(), length * 2));
        Txt.writeTxtFile(formatStr("薪水：" + customer.getSalary(), length * 2));
        Txt.writeTxtFile(formatStr("具体工作地：" + customer.getWorkAddressDetail(), length * 2));
        Txt.writeTxtFile(formatStr("具体居住地：" + customer.getLiveAddressDetail(), length * 2));
        for(int i=0;i<cCmrList.size();i++){
            String metarialname1 = getMetarialName(cCmrList.get(i).getConstantName(),cCmrList.get(i).getMaterialName());
            cCmrList.get(i).setConstantName(cCmrList.get(i).getConstantName().split("_")[0]);
            String metarialname2 = "";
            if(i+1<cCmrList.size()){
                metarialname2 = getMetarialName(cCmrList.get(i+1).getConstantName(),cCmrList.get(i+1).getMaterialName());
                cCmrList.get(i+1).setConstantName(cCmrList.get(i+1).getConstantName().split("_")[0]);

            }


            if(i==cCmrList.size()-1){
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName()+"："+metarialname1,length*2)
                );
            }else{
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName()+"："+metarialname1,length)+"\r\n"+
                        formatStr(cCmrList.get(i+1).getConstantName()+"："+metarialname2,length));
            }
            i++;

        }



        if(Customer.married.equals(marriedFlag)){
            Txt.writeTxtFile("配偶信息");
            Txt.writeTxtFile(formatStr("姓名："+spouse.getName(),length)+"\r\n"+formatStr("身份证号："+spouse.getIDNumber(),length));
            Txt.writeTxtFile(formatStr("联系电话："+spouse.getPhone(),length*2));
            Txt.writeTxtFile(formatStr("户籍地址："+spouse.getCenRegAddress(),length*2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作年限（年）：" + spouse.getWorkExperience(), length * 2));
            Txt.writeTxtFile(formatStr("薪水：" + spouse.getSalary(), length * 2));
            for(int i=0;i<sCmrList.size();i++){
                String metarialname1 = getMetarialName(sCmrList.get(i).getConstantName(),sCmrList.get(i).getMaterialName());
                sCmrList.get(i).setConstantName(sCmrList.get(i).getConstantName().split("_")[0]);
                String metarialname2 = "";
                if(i+1<sCmrList.size()){

                    metarialname2 = getMetarialName(sCmrList.get(i+1).getConstantName(),sCmrList.get(i+1).getMaterialName());
                    sCmrList.get(i+1).setConstantName(sCmrList.get(i+1).getConstantName().split("_")[0]);

                }
                if(i==sCmrList.size()-1){
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName()+"："+metarialname1,length*2)
                    );
                }else{
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName()+"："+metarialname1,length)+"\r\n"+
                            formatStr(sCmrList.get(i+1).getConstantName()+"："+metarialname2,length));
                }
                i++;

            }
        }else{
            //没有配偶，填写父母信息

            Txt.writeTxtFile("父母信息");
            Txt.writeTxtFile(formatStr("与申请人关系：" + spouse.getPersonnelType(), length * 2));
            Txt.writeTxtFile(formatStr("姓名：" + spouse.getName(), length) + "\r\n" + formatStr("身份证号：" + spouse.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + spouse.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + spouse.getWorkAddress(), length * 2));
        }

        if(guaFlag){
            Txt.writeTxtFile("担保人信息");
            Txt.writeTxtFile(formatStr("姓名："+guarantee.getName(),length)+"\r\n"+formatStr("身份证号："+guarantee.getIDNumber(),length));
            Txt.writeTxtFile(formatStr("联系电话："+guarantee.getPhone(),length*2));
            Txt.writeTxtFile(formatStr("户籍地址："+guarantee.getCenRegAddress(),length*2));
            for(int i=0;i<gCmrList.size();i++){
                String metarialname1 = getMetarialName(gCmrList.get(i).getConstantName(),gCmrList.get(i).getMaterialName());
                gCmrList.get(i).setConstantName(gCmrList.get(i).getConstantName().split("_")[0]);

                String metarialname2 = "";
                if(i+1<gCmrList.size()){
                    metarialname2 = getMetarialName(gCmrList.get(i+1).getConstantName(),gCmrList.get(i+1).getMaterialName());
                    gCmrList.get(i+1).setConstantName(gCmrList.get(i+1).getConstantName().split("_")[0]);

                }
                if(i==gCmrList.size()-1){
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName()+"："+metarialname1,length*2)
                    );
                }else{
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName()+"："+metarialname1,length)+"\r\n"+
                            formatStr(gCmrList.get(i+1).getConstantName()+"："+metarialname2,length));
                }
                i++;

            }
        }
        if(null != minGuaId && null != minGua){
            Txt.writeTxtFile("未满24周岁，直系亲属担保人信息");
            Txt.writeTxtFile(formatStr("姓名：" + minGua.getName(), length) + "\r\n" + formatStr("身份证号：" + minGua.getIDNumber(), length));
            String relation = "";
            if(Guarantee.RELATION_1.equals(minGua.getRelation())){
                relation = Guarantee.PARENT;
            }
            if(Guarantee.RELATION_5.equals(minGua.getRelation())){
                relation = Guarantee.SISTER;
            }
            if(Guarantee.RELATION_10.equals(minGua.getRelation())){
                relation = Guarantee.CHILDREN;
            }
            Txt.writeTxtFile(formatStr("与主贷人关系：" + relation, length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + minGua.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + minGua.getWorkAddress(), length * 2));
        }



        //紧急联系人信息
        Txt.writeTxtFile("紧急联系人信息");
        List<Long> cusemerconIds =  cusemerconService.getCusemerconIdsByCustomerId(customer.getId(),0,Integer.MAX_VALUE);
        List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(cusemerconIds);

        for(int i =0; i<cusemerconIds.size();i++){
            int j = i+1;
            String relation = getRelationWithEmerCon(cusemerconList.get(i).getRelation());
            Txt.writeTxtFile(formatStr("第"+j+"位联系人姓名："+cusemerconList.get(i).getName(),length)+formatStr("第"+j+"位联系人电话："+cusemerconList.get(i).getPhone(),length)+formatStr("与第"+j+"位联系人关系："+relation,length));

        }
        Txt.writeTxtFile(formatStr("补充说明：",length*2));
        Txt.writeTxtFile(formatStr(customer.getDescrition(),length*2));



        //订单信息
        Txt.writeTxtFile("车辆信息");
        if(Product.loan_productType.equals(indent.getProductType())){
            Txt.writeTxtFile(formatStr("车型",length/2)+formatStr("评估价格(元)",length/2)+formatStr("出厂日期",length/2)+formatStr("上牌日期",length/2)+formatStr("行驶公里数",length/2));

        }else{
            Txt.writeTxtFile(formatStr("车型",length/2)+formatStr("价格(元)",length/2)+formatStr("出厂日期",length/2)+formatStr("上牌日期",length/2)+formatStr("行驶公里数",length/2));

        }        //转换一下时间
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  productionDate = "";
        if(DataUtils.isNotNullOrEmpty(indent.getProductionDate())){
            productionDate     = sdf.format(new Date(indent.getProductionDate()));
        }
        String  licenseDate = "";
        if(DataUtils.isNotNullOrEmpty(indent.getLicenseDate())){
            licenseDate = sdf.format(new Date(indent.getLicenseDate()));
        }
        String kilometers = "";
        if(DataUtils.isNotNullOrEmpty(indent.getDrivingKilometers())){
            kilometers = indent.getDrivingKilometers();
        }

        Txt.writeTxtFile(formatStr(indent.getCarType(), length / 2) + formatStr(indent.getSumPrice(), length / 2) + formatStr(productionDate, length / 2) + formatStr(licenseDate, length / 2) + formatStr(kilometers, length / 2));
        Txt.writeTxtFile("贷款方案");
        Txt.writeTxtFile(formatStr("业务类型",length/2)+formatStr("方案",length/2)+formatStr("渠道",length/2)+formatStr("利率",length/2)+formatStr("首付比例",length/2));
        //
        String productType = "";
        if(Product.new_productType.equals(indent.getProductType())){
            productType="新车贷款";
        }else if(Product.old_productType.equals(indent.getProductType())){
            productType="二手车贷款";
        }else if(Product.loan_productType.equals(indent.getProductType())){
            productType="车辆抵押贷款";
        }
        Product product = productService.getObjectById(indent.getProductId());
        Constant channel = constantService.getObjectById(product.getChannel());
        log.info("  replyamount = "+indent.getReplyAmount());
        Txt.writeTxtFile(formatStr(productType, length / 2) + formatStr(product.getName(), length / 2) + formatStr(channel.getName(), length / 2) + formatStr(product.getInterestRate(), length / 2) + formatStr(indent.getFirstPayPercent(), length / 2) );
        Txt.writeTxtFile(formatStr("贷款金额(元)", length / 2) + formatStr("贷款年限(月)", length / 2) + formatStr("月供(元)", length / 2) + formatStr("利息(元)", length / 2) + formatStr("批复金额", length / 2));
        Txt.writeTxtFile( formatStr(indent.getLoanAmount(), length / 2) + formatStr(indent.getLoanPeriod(), length / 2) + formatStr(indent.getMonthly(), length / 2) + formatStr(indent.getInterest(), length / 2) + formatStr(indent.getReplyAmount(), length / 2));




        //所有资料
        String customerName = customer.getName();
        String customerNumber = indent.getNumber();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", customer.getName() + "" + indent.getNumber()+Iprocess.FILE_NAME);
        jsonObject.put("txtUrl", filenameTemp);

        JSONArray jsonArray5 = new JSONArray();

        //查询申请资料
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("name", customerName+"申请资料"+customerNumber);
        JSONArray jsonArray = new JSONArray();


        //查找借款人需要上传的证件资料
        JSONObject  cusJsonObject = getIdocumentByPer(Customer.c_personnelType + "",
                Iprocess.CRTTIFICATE, indent.getProductId(), customer.getId(),customerNumber);
        jsonArray.add(cusJsonObject);


            //查找配偶上传的证件
        //身份证

        Long  sId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.s_personnelType + "");

        List<Long>  spouIds = idocumentService.getIdsByCidAndPersonnelTypeOrderByUpdateAt
                (customer.getId(), Customer.s_personnelType + "", 0, Integer.MAX_VALUE);

        if (DataUtils.isNotNullOrEmpty(sId)) {
            JSONObject spouJJsonObject= getIdocumentByPer(Customer.s_personnelType+"",
                    Iprocess.CRTTIFICATE,indent.getProductId(),customer.getId(),customerNumber);
            jsonArray.add(spouJJsonObject);
        }else  if(spouIds.size()>0){
            //查找配偶上传的证件
            JSONObject spouJJsonObject= getIdocumentByPer(Customer.s_personnelType+"",
                    Iprocess.CRTTIFICATE,indent.getProductId(),customer.getId(),customerNumber);
            jsonArray.add(spouJJsonObject);
        }


        //查找担保人申请资料
        Long  gId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.g_personnelType + "");
        log.info("  gid = "+gId);

        if (DataUtils.isNotNullOrEmpty(gId)) {
            JSONObject spouJJsonObject= getIdocumentByPer(Customer.g_personnelType+"",
                    Iprocess.CRTTIFICATE,indent.getProductId(),customer.getId(),customerNumber);
            jsonArray.add(spouJJsonObject);
        }



        jsonObject2.put("file",jsonArray);
      //  jsonObject.put("shenqingzl",jsonObject2);
        jsonArray5.add(jsonObject2);
       //查询合同资料是否已上传
       List<Long>  makeContractIds =  idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
               (customer.getId(), Iprocess.MAKE_CONTRACT, 0, Integer.MAX_VALUE);
        if(makeContractIds.size()>0){
            JSONObject jsonObject1 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(makeContractIds,Iprocess.MAKE_CONTRACT,customerName,customerNumber);
            jsonObject1.put("name",customerName+"合同资料"+customerNumber);
            jsonObject1.put("file", file);
          //  jsonObject.put("hetongzl",jsonObject1);
            jsonArray5.add(jsonObject1);

        }
        //查询合同是否已上传
        List<Long>  contractIds =  idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(),Iprocess.CONTRACT,0,Integer.MAX_VALUE);
        if(contractIds.size()>0){
            JSONObject jsonObject3 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(contractIds,Iprocess.CONTRACT,customerName,customerNumber);
            jsonObject3.put("name",customerName+"合同"+customerNumber);
            jsonObject3.put("file", file);
            //jsonObject.put("hetong",jsonObject3);
            jsonArray5.add(jsonObject3);

        }
        //查询放款资料是否已上传
        List<Long>  loantractIds =  idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(),Iprocess.LOAN,0,Integer.MAX_VALUE);
        if(loantractIds.size()>0){
            JSONObject jsonObject4 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(loantractIds,Iprocess.LOAN,customerName,customerNumber);
            jsonObject4.put("name",customerName+"放款资料"+customerNumber);
            jsonObject4.put("file",file);
//            jsonObject.put("fangkuanzl",jsonObject4);
            jsonArray5.add(jsonObject4);

        }
        //查询贷后资料是否已上传
        List<Long>  aftertractIds =  idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(),Iprocess.AFTER,0,Integer.MAX_VALUE);
        log.info("aftertractIds  size =   "+aftertractIds.size());
        if(aftertractIds.size()>0){
            JSONObject jsonObject5 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(aftertractIds,Iprocess.AFTER,customerName,customerNumber);
            jsonObject5.put("name",customerName+"贷后资料"+customerNumber);
            jsonObject5.put("file",file);
          //  jsonObject.put("daihouzl",jsonObject5);
            jsonArray5.add(jsonObject5);
        }

        jsonObject.put("file",jsonArray5);



        return jsonObject;
    }


    //查找人员的申请资料
    public JSONObject  getIdocumentByPer(String personnelType,String certifiType,Long pid,Long cid,String customerNumber )throws Exception{
        log.info("  certifiType=0 and personnelType="+personnelType);
        List<Long> sCertifiIds = pcertificateService.getPcertificateIdsByProductIdAndPersonnelTypeOrderByUpdateAt
                (pid.toString(), personnelType.toString(), 0, Integer.MAX_VALUE);

        List<Pcertificate> sCertifiList = pcertificateService.getObjectsByIds(sCertifiIds);

        Customer customer = customerService.getObjectById(cid);
        String customerName = customer.getName();
       // String customerNumber = customer.getNumber();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name",getFileName(personnelType,"申请资料",customerName,customerNumber));
        JSONArray  jsonArray = new JSONArray();

        List<Long> certificateIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt
                (cid, personnelType, certifiType, 0, Integer.MAX_VALUE);
        List<Idocument>  certificateList = idocumentService.getObjectsByIds(certificateIds);

        Boolean shenfenzhen = false;
        for(Idocument idocument : certificateList){
            if("身份证".equals(idocument.getDocumentName())){
                shenfenzhen= true;
                break;
            }
        }


           if(!shenfenzhen){
               JSONObject jsonObject7 = new JSONObject();
               if(Customer.c_personnelType.toString().equals(personnelType)){
                  // Customer customer =  customerService.getObjectById(cid);
                   jsonObject7.put("name",customerName+"身份证"+customerNumber);
                   JSONArray jsonArray1 = new JSONArray();
                   jsonArray1.add(customer.getIDCardFront());
                   jsonArray1.add(customer.getIDCardBack());
                   jsonObject7.put("url",jsonArray1);

               }else if(Customer.s_personnelType.toString().equals(personnelType)){
                   Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.s_personnelType + "");
                   if(DataUtils.isNotNullOrEmpty(id)){
                       Guarantee guarantee = guaranteeService.getObjectById(id);
                       jsonObject7.put("name",customerName+"配偶身份证"+customerNumber);
                       JSONArray jsonArray1 = new JSONArray();
                       jsonArray1.add(guarantee.getIDCardFront());
                       jsonArray1.add(guarantee.getIDCardBack());
                       jsonObject7.put("url",jsonArray1);
                   }

               }else if(Customer.g_personnelType.toString().equals(personnelType)){
                   Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.g_personnelType + "");
                   if(DataUtils.isNotNullOrEmpty(id)){
                       Guarantee guarantee = guaranteeService.getObjectById(id);
                       jsonObject7.put("name",customerName+"担保人身份证"+customerNumber);
                       JSONArray jsonArray1 = new JSONArray();
                       jsonArray1.add(guarantee.getIDCardFront());
                       jsonArray1.add(guarantee.getIDCardBack());
                       jsonObject7.put("url",jsonArray1);

                   }

               }
               jsonArray.add(jsonObject7);
           }else{
               List<Long> ids =  idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                       (cid, personnelType + "", certifiType,"身份证", 0, Integer.MAX_VALUE);

               JSONObject jsonObject1 = new JSONObject();
                   if(ids.size()>0){
                       List<Idocument>  idocuments = idocumentService.getObjectsByIds(ids);
                       JSONArray urljsonArray = new JSONArray();
                       for(Idocument idocument : idocuments){
                           urljsonArray.add(idocument.getImg());
                       }

                       jsonObject1.put("name",getFileName(personnelType,"身份证",customerName,customerNumber));
                       jsonObject1.put("url",urljsonArray);
                       // jsonObject1.put(cCertifi.getCertificateName(), urls);
                       //spouJsonArray.add(jsonObject);
                       //jsonObject.put(""+cCertifi.getId(),jsonObject1);
                       jsonArray.add(jsonObject1);
                   }



           }



            if(Customer.c_personnelType.toString().equals(personnelType)
                    ||Customer.s_personnelType.toString().equals(personnelType)){
                if(sCertifiList.size()>0) {
                    for (Pcertificate cCertifi : sCertifiList) {
                        JSONObject jsonObject1 = new JSONObject();
                        List<Long> ids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                                (cid, personnelType + "", certifiType, cCertifi.getCertificateName(), 0, Integer.MAX_VALUE);
                        log.info(" personnetltype =  " + personnelType + ",  idocument  size " + ids.size());
                        if (ids.size() > 0) {
                            List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                            JSONArray urljsonArray = new JSONArray();
                            for (Idocument idocument : idocuments) {
                                urljsonArray.add(idocument.getImg());
                            }
                            jsonObject1.put("name", getFileName(personnelType,cCertifi.getCertificateName(),customerName,customerNumber) );
                            jsonObject1.put("url", urljsonArray);
                            // jsonObject1.put(cCertifi.getCertificateName(), urls);
                            //spouJsonArray.add(jsonObject);
                            //jsonObject.put(""+cCertifi.getId(),jsonObject1);
                            jsonArray.add(jsonObject1);
                        }

                    }
                }

            }else{
                log.info("   add guarantee certificate  ");
                //查找担保人上传的证件
                List<String>  guaCertificateNameList = new ArrayList<>();
                List<Long> guaCertificateIds = guaCertificateService.getGuaCertificateIds(0, Integer.MAX_VALUE);
                log.info("   guaCertificateIds  size = " + guaCertificateIds.size());
                List<GuaCertificate> guaCertificateList = guaCertificateService.getObjectsByIds(guaCertificateIds);
                for(GuaCertificate guaCertificate : guaCertificateList){
                    guaCertificateNameList.add(guaCertificate.getCertificateName());
                }

                List<Long> cmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                        (cid.toString(), Customer.c_personnelType.toString(), 0, Integer.MAX_VALUE);
                List<CustomerMaterialRelation> cmrList = cmrService.getObjectsByIds(cmrIds);
                if (cmrList != null && cmrList.size() > 0) {
                    log.info("               ");
                    for (CustomerMaterialRelation customerMaterialRelation : cmrList) {

                        if (customerMaterialRelation.getMaterialName().contains(Customer.GUARANTEE)) {
                            // guarantee=true;
                            log.info("  guaCertificateName  = "+customerMaterialRelation.getConstantName());
                            guaCertificateNameList.add(customerMaterialRelation.getConstantName());
                        }

                    }
                }
                log.info(" guaCertificateNameList = " + guaCertificateNameList);
                for(String guaCertificateName :  guaCertificateNameList){
                    JSONObject jsonObject1 = new JSONObject();
                    List<Long> ids =  idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                            (cid, personnelType + "", certifiType,guaCertificateName, 0, Integer.MAX_VALUE);
                    List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                    JSONArray urljsonArray = new JSONArray();
                    for(Idocument idocument : idocuments){
                        urljsonArray.add(idocument.getImg());
                    }
                    jsonObject1.put("name",getFileName(personnelType,guaCertificateName,customerName,customerNumber));
                    jsonObject1.put("url",urljsonArray);
                    jsonArray.add(jsonObject1);
                }



            }





        jsonObject.put("file", jsonArray);
        return jsonObject;
    }
    //查询人员的合同资料、合同、贷后资料、放款资料
    public JSONArray  getIdocumentOtherByPer(List<Long> ids,String certificateType,String customerName,String customerNumber)throws Exception{
        List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);

        JSONArray  file = new JSONArray();
        for(Idocument idocument : idocuments){
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name",customerName+idocument.getDocumentName()+customerNumber);
         List<Long>  documentIdsByDocumentName =    idocumentService.getIdocumentIdsByAllOrderByUpdateAt(idocument.getCustomerId(),idocument.getPersonnelType(),
                    idocument.getDocumentType(),idocument.getDocumentName(),0,Integer.MAX_VALUE);
            List<Idocument>  idocumentList = idocumentService.getObjectsByIds(documentIdsByDocumentName);
            JSONArray urls = new JSONArray();
            for(Idocument idocument1 : idocumentList){
                urls.add(idocument1.getImg());
            }
            jsonObject.put("url",urls);
            file.add(jsonObject);
        }

        return file;
    }




    public String formatStr(String str, int length) {
        str = " "+str;
        int strLen = str.getBytes().length;
        if (strLen < length) {
            int temp = length - strLen;
            for (int i = 0; i < temp; i++) {
                str += " ";
            }
        }
        return str ;
    }



    public static  String getRegion(String region){
        log.info("  getRegion   start   ");
        StringBuilder regionValue = new StringBuilder("");
        Properties properties = new Properties();
        try {
            InputStream inputStream = ProductController.class.getClassLoader().getResourceAsStream("region");
            BufferedReader bf = new BufferedReader(new    InputStreamReader(inputStream));
            properties.load(bf);
            String provinceJson = properties.getProperty("province");
            log.info("  region.properties  province = " + provinceJson);
            ProvincesParam provincesParam  = GsonUtil.fromJson(provinceJson, ProvincesParam.class);
            String cityJson = properties.getProperty("city");
            CitesParam citiesParam = GsonUtil.fromJson(cityJson, CitesParam.class);
            // log.info("  region.properties  city = "+cityJson);
            String countyJson = properties.getProperty("District");
            CountiesParam countiesParam = GsonUtil.fromJson(countyJson, CountiesParam.class);
            // log.info("  region.properties  countyJson = "+countyJson);
            String[] regsionArr = region.split(",");
            String province = regsionArr[0];
            String city = regsionArr[1];
            String county  =  regsionArr[2];
            log.info(" province  +  "+province+" , city = "+city+" , county = "+county);
            List<ProvinceParam> provinceParamList = provincesParam.getList();
            for(ProvinceParam provinceParam : provinceParamList){
                if(province.equals(provinceParam.getProID().toString())){
                    regionValue.append(provinceParam.getProName()+",");
                    break;
                }
            }
            List<CityParam> cityParamList = citiesParam.getList();
            for(CityParam cityParam : cityParamList){
                if(city.equals(cityParam.getCityID().toString())){
                    regionValue.append(cityParam.getCityName()+",");
                    break;
                }
            }
            List<CountyParam> countyParams = countiesParam.getList();
            for(CountyParam countyParam : countyParams){
                if(county.equals(countyParam.getId().toString())){
                    regionValue.append(countyParam.getDisName());
                    break;
                }
            }
            return regionValue.toString();

        }catch (IOException e ){
            e.printStackTrace();
            log.error("  document get region  errr  region  "+region);
            return "";
        }

    }

    private String getMetarialName(String constantName,String metarialName){
        log.info("  getMetarialName  start    ");
        log.info("  constantName   ");
        String[] constantNameArr = constantName.split("_");

        if(constantNameArr.length>1&&constantNameArr[1].equals(Product.ADDRESS)){

            metarialName=getRegion(metarialName);
        }
        return metarialName;
    }
    private String getFileName (String personnelType,String filename,String customerName,String customerNumber){
        log.info("  getFileName  start    ");
        log.info("  personnelType   "+personnelType+"  filename = "+filename);
        String file = "";
        if(Customer.c_personnelType.toString().equals(personnelType)){
            file = customerName+filename+customerNumber;
        }else if(Customer.s_personnelType.toString().equals(personnelType)){
            file = customerName+"配偶"+filename+customerNumber;
        }else if(Customer.g_personnelType.toString().equals(personnelType)){
            file = customerName+"担保人"+filename+customerNumber;
        }
        return file;
    }



    //获取紧急联系人关系
    public String getRelationWithEmerCon(String relation){
        if(Cusemercon.PARENT.equals(relation)){
            return "父母";
        }else if(Cusemercon.CHILDREN.equals(relation)){
            return "子女";
        }else if(Cusemercon.COMPANY.equals(relation)){
            return "同事";
        }else if(Cusemercon.FRIENDS.equals(relation)){
            return "朋友";
        }else if(Cusemercon.RELATION.equals(relation)){
            return "亲戚";
        }else if(Cusemercon.OTHER.equals(relation)){
            return "其他";
        }

        return "";
    }
}
