package com.ptteng.common.carjn.controller;


import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.model.Iprocess;
import com.ptteng.common.carjn.model.Manager;
import com.ptteng.common.carjn.model.Saler;
import com.ptteng.common.carjn.service.ConstantService;
import com.ptteng.common.carjn.service.ManagerService;
import com.ptteng.util.CertificateUtil;
import com.ptteng.util.SalerUtil;
import com.qding.common.util.DataUtils;

import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.*;

/**
 * Created by liangxj on 2015/12/7.
 */
@Controller
public class certificateControler {
    private static final Log log = LogFactory.getLog(certificateControler.class);

    @Autowired
    private ConstantService constantService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private CookieUtil cookieUtil;
    //证件管理--新增
    @RequestMapping(value = "/a/u/certificate", method = RequestMethod.POST)
    public String addConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Constant certificate) throws Exception {

        log.info("update constant : certificate= " + certificate);

        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);

            if(  DataUtils.isNullOrEmpty(certificate)
                    || DataUtils.isNullOrEmpty(certificate.getValue())
                    //证件说明为非必填项：|| DataUtils.isNullOrEmpty(certificate.getDescription())
                    || DataUtils.isNullOrEmpty(certificate.getStatus())
                    || DataUtils.isNullOrEmpty(certificate.getType())
            ){
                model.addAttribute("code",-1000);
                return "/common/success";
            }



            log.info(" type = "+certificate.getType());
            if(Iprocess.CRTTIFICATE.equals(certificate.getType())){
                certificate.setType(Constant.CERTIFICATE);
            }else if(Iprocess.CONTRACT.equals(certificate.getType())){
                certificate.setType(Constant.CONTRACT);
            }else if(Iprocess.LOAN.equals(certificate.getType())){
                certificate.setType(Constant.LOAN);
            }else {

                model.addAttribute("code",-20002);
                return "/common/success";
            }

            Long id = constantService.getConstantIdByNameAndType
                    (certificate.getValue(),certificate.getType());
            if(DataUtils.isNotNullOrEmpty(id)){
                model.addAttribute("code", -20007);
                return "/common/success";
            }
            log.info("  type ="+certificate.getType());
            certificate.setName(certificate.getValue());
            certificate.setId(null);
            certificate.setCreateBy(Long.valueOf(userId));
            certificate.setPublishAt(System.currentTimeMillis());
            constantService.insert(certificate);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add constant error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }



    //证件管理--修改
    @RequestMapping(value = "/a/u/certificate/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                     @PathVariable Long id,Constant  certificate) throws Exception {

        log.info("update constant : certificate= " + certificate);

        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Constant certificate1 = constantService.getObjectById(id);
            if(  DataUtils.isNullOrEmpty(certificate)
                    || DataUtils.isNullOrEmpty(certificate.getValue())
                    //证件说明为非必填项：|| DataUtils.isNullOrEmpty(certificate.getDescription())
                    || DataUtils.isNullOrEmpty(certificate.getStatus())
                    || DataUtils.isNullOrEmpty(certificate.getType())
                    ){
                model.addAttribute("code",-1000);
                return "/common/success";
            }
            log.info(" type = "+certificate.getType());
            if(Iprocess.CRTTIFICATE.equals(certificate.getType())){
                certificate.setType(Constant.CERTIFICATE);
            }else if(Iprocess.CONTRACT.equals(certificate.getType())){
                certificate.setType(Constant.CONTRACT);
            }else if(Iprocess.LOAN.equals(Constant.LOAN)){
                certificate.setType(Constant.LOAN);
            }else {

                model.addAttribute("code",-20002);
                return "/common/success";
            }

            Long cid = constantService.getConstantIdByTypeAndValue
                    (certificate.getType(),certificate.getValue());

            log.info("  cid = "+cid);
            if(!id.equals(cid)){
                model.addAttribute("code",-20007);
                return "/common/success";
            }





            log.info("  type =" + certificate.getType());
            //key不能修改
           // certificate.setName(certificate.getValue());
            certificate.setName(certificate1.getName());


            certificate.setUpdateBy(Long.valueOf(userId));
            constantService.update(certificate);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update channel certificate,id is  " + certificate.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }



    //删除
    @RequestMapping(value = "/a/u/certificate/{id}", method = RequestMethod.DELETE)
    public String deleteConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete channel : id= " + id);
        try {
            Constant certificate = constantService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(certificate)){
                model.addAttribute("code", -20003);
                return "/common/success";
            }



            constantService.delete(id);

            log.info("add constant success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete certificate error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    //证件管理--根据ID查询单个证件详情
    @RequestMapping(value = "/a/u/certificate/{id}", method = RequestMethod.GET)
    public String getSalerJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Constant certificate = constantService.getObjectById(id);
            if(Constant.CERTIFICATE.equals(certificate.getType())){
                certificate.setType(Iprocess.CRTTIFICATE);
            }else if(Constant.CONTRACT.equals(certificate.getType())){
                certificate.setType(Iprocess.CONTRACT);
            }else if(Constant.LOAN.equals(certificate.getType())){
                certificate.setType(Iprocess.LOAN);
            }
            log.info("get certificate data is " + certificate);

            model.addAttribute("code", 0);

            model.addAttribute("constant", certificate);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get channel error,id is  " + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/channelDetailJson";
    }


    /**
     * 证件列表查询
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/certificate/", method = RequestMethod.GET)
    public String getCertificateJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page,
                                     Integer size,Long startAt,Long endAt,String status,String type) throws Exception {

        log.info(" startAt ="+startAt +" ,endAt="+endAt+"status = "+status);
        if(page==null){

            page=1;
        }

        if(size == null){
            size=10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size+"type   =   "+type);

        try {
            Boolean next = false;
            size+=1;


            Map<String, Object> map = new HashMap<>();
            if (DataUtils.isNotNullOrEmpty(startAt)) {
                map.put("publish_at", startAt);
            }
            if (DataUtils.isNotNullOrEmpty(endAt)) {
                map.put("publish_at", endAt);
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                map.put("status", status);
            }
            if (DataUtils.isNotNullOrEmpty(type)) {
                map.put("type", type);
            }
            String t = "'"+Constant.CERTIFICATE+"','"+Constant.CONTRACT+"','"+Constant.LOAN+"'";
            List<Long> ids;
            if (map.size() > 0) {

                if(Iprocess.CRTTIFICATE.equals(type)){
                   type=Constant.CERTIFICATE;
                }else if(Iprocess.LOAN.equals(type)) {
                    type=Constant.LOAN;
                }else if(Iprocess.CONTRACT.equals(type)){
                    type=Constant.CONTRACT;
                }
                log.info(" type = "+type);

                if(DataUtils.isNotNullOrEmpty(type)){
                    Map<String, Object> map1 = CertificateUtil.getBytype(startAt,endAt,status,type,false);

                    ids = constantService.getIdsByDynamicCondition(Constant.class, map1, start, size);
                }else{
                    Map<String, Object> map1 = CertificateUtil.getCertificateListParam(startAt,endAt,"",status,t,false);

                    ids = constantService.getIdsByDynamicCondition(Constant.class, map1, start, size);
                }


            } else {

                Map<String, Object> map1 = CertificateUtil.getCertificateListParamBytype
                        (t, false);
                ids = constantService.getIdsByDynamicCondition(Constant.class, map1, start, size);
            }

            log.info("get certificate size is " + ids.size());

            if(ids!=null && ids.size()>0){

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  "+ids.subList(0,size-1));
                    model.addAttribute("ids", ids.subList(0,size-1));
                }else{
                    log.info("ss  "+ids.subList(0,ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
            }else{
                model.addAttribute("ids", ids);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);




        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get channel list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/channelListJson";
    }

    /**
     * 证件列表查询
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/multi/certificate", method = RequestMethod.GET)
    public String getMultiCertificateJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                              Long[] ids) throws Exception {


        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {



            List<Constant> certificateList = constantService.getObjectsByIds(idList);
            log.info("get  certificateList data is " + certificateList.size());


            Map<Long,String> map = new HashMap<>();
            for(Constant constant : certificateList){
                if(DataUtils.isNotNullOrEmpty(constant)){
                    Manager manager =  managerService.getObjectById
                            (constant.getCreateBy());
                    if(DataUtils.isNotNullOrEmpty(manager)){
                        map.put(constant.getId(),manager.getName());
                    }

                }
                if(Constant.CERTIFICATE.equals(constant.getType())){
                    constant.setType(Iprocess.CRTTIFICATE);
                }else if(Constant.CONTRACT.equals(constant.getType())){
                    constant.setType(Iprocess.CONTRACT);
                }else if(Constant.LOAN.equals(constant.getType())){
                    constant.setType(Iprocess.LOAN);
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("total", certificateList.size());

            model.addAttribute("map",map);
            model.addAttribute("constantList", certificateList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get certificateList error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/channel/json/channelMultiListJson";
    }


}

