package com.ptteng.common.carjn.controller;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ptteng.common.carjn.controller.entity.Image;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.BASE64Encoder;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;

/**
 * 生成word文档类
 * @author liut
 */
public class WordDocTest {

    private static final Log log = LogFactory.getLog(IndentControler.class);

    /**
   * 图片下载目录
   */
  private static final String DOWN_PATH = "/data/temp/pdf/wordImages/";

  /**
   * 生成的word文档名字
   */
  //private static final String WORD_DOC_NAME = "imgDoc";
  
  /**
   * 生成带多个图片的word文档主方法
   * @param imgList 图片list
   */
  public void generateAnWordDoc(List<Image> imgList,String docName) {
    Map<String, Object> argsMap = new HashMap<>();
    List<Image> images = new ArrayList<>();
    for (Image img : imgList) {
      img.setBinData(obtainImageBinData(img.getImgUrl()));
      images.add(img);
    }
    argsMap.put("images", images);
    
    Configuration conf = new Configuration();
    conf.setDefaultEncoding("utf-8");
    conf.setClassForTemplateLoading(this.getClass(), "./templates");
    Template t = null;
    File wordFile = new File(docName);
    Writer out = null;
    try {
        t = conf.getTemplate("three_copy.ftl");
        //一定要设置编码，否则word打开不认识
        out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(wordFile), "utf-8")); 
        t.process(argsMap, out);
        out.close();
    }
    catch (UnsupportedEncodingException ex) {
        ex.printStackTrace();
    }
    catch (IOException ex) {
        ex.printStackTrace();
    }
    catch (TemplateException ex) {
        ex.printStackTrace();
    }

      WordDocTest  wordDocTest = new WordDocTest();
      wordDocTest.deleteDirectory(DOWN_PATH);
  }

    /**
     * 删除单个文件
     * @param   sPath    被删除文件的文件名
     * @return 单个文件删除成功返回true，否则返回false
     */
    public  boolean deleteFile(String sPath) {
       Boolean flag = false;
       File file = new File(sPath);
        // 路径为文件且不为空则进行删除
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }

    public  boolean deleteDirectory(String sPath) {
        //如果sPath不以文件分隔符结尾，自动添加文件分隔符
        if (!sPath.endsWith(File.separator)) {
            sPath = sPath + File.separator;
        }
        File dirFile = new File(sPath);
        //如果dir对应的文件不存在，或者不是一个目录，则退出
        if (!dirFile.exists() || !dirFile.isDirectory()) {
            return false;
        }
        Boolean flag = true;
        //删除文件夹下的所有文件(包括子目录)
        File[] files = dirFile.listFiles();
        for (int i = 0; i < files.length; i++) {
            //删除子文件
            if (files[i].isFile()) {
                flag = deleteFile(files[i].getAbsolutePath());
                if (!flag) break;
            } //删除子目录
            else {
                flag = deleteDirectory(files[i].getAbsolutePath());
                if (!flag) break;
            }
        }
        if (!flag) return false;
        //删除当前目录
//        if (dirFile.delete()) {
//            return true;
//        } else {
//            return false;
//        }
      return true;
    }
        /**
         * 生成表示该图片的二进制数据
         * @param imgUrl
         * @return
         */
  private String obtainImageBinData(String imgUrl) {
    String imgPathStr = downFromImgUrl(imgUrl, DOWN_PATH);
    InputStream in = null;
    byte[] data = null;
    try {
        in = new FileInputStream(imgPathStr);
        data = new byte[in.available()];
        in.read(data);
        in.close();
    }
    catch (IOException ex) {
        ex.printStackTrace();
    }
    BASE64Encoder encoder = new BASE64Encoder();
    return encoder.encode(data);
  }
  
  /**
   * 从给定的url下载对应图片到指定目录
   * @param imgUrl
   * @param downPath
   * @return
   */
  private String downFromImgUrl(String imgUrl, String downPath) {
    File savePath = new File(downPath);
    if (!savePath.exists()) {
        savePath.mkdir();
    }
    String[] urlName = imgUrl.split("/");
    String imgName = urlName[urlName.length - 1];
    try {
        File img = new File(savePath + "/" + imgName);
        if (img != null && !img.exists()) {
            img.createNewFile();
        }
        OutputStream oputStream = new FileOutputStream(img);
        URL url = new URL(imgUrl);
        HttpURLConnection uc = (HttpURLConnection) url.openConnection();
        uc.setDoInput(true);
        uc.connect();
        InputStream iputStream = uc.getInputStream();
       log.info("img size is:" + uc.getContentLength()); //��ӡͼƬ��С
        byte[] buffer = new byte[4 * 1024];
        int byteRead = -1;
        while ((byteRead = (iputStream.read(buffer))) != -1) {
            oputStream.write(buffer, 0, byteRead);
        }
        oputStream.flush();
        iputStream.close();
        oputStream.close();
        log.info("生成图片路径：" + downPath + imgName);
        return downPath + imgName;
    } catch (Exception ex) {
        log.info("从给定url=[" + imgUrl + "]下载失败！�");
        ex.printStackTrace();
    }
    return "";
  }
  
  private void deleteDir(File dir) {
    if (dir.isDirectory()) {
      String[] children = dir.list();
      for (int i=0; i < children.length; i++) {
         deleteDir(new File(dir, children[i]));
      }
    }
    // 目录此时为空，可以删除
    dir.delete();
  }
  
  public static void main(String[] args) {
    log.info("begin...");
    List<Image> images = new ArrayList<>();
    images.add(new Image("http://online-carjn.kss.ksyun.com/1/1456637447260.jpg", 415, 900));
    images.add(new Image("http://online-carjn.kss.ksyun.com/1/1456637415325.jpg", 415, 900));
    images.add(new Image("http://online-carjn.kss.ksyun.com/1/1456637426417.jpg", 415, 900));
    new WordDocTest().generateAnWordDoc(images, "C:\\wordTest\\outFiles\\" + System.currentTimeMillis()+".doc");
    log.info("end...");
  }
}
