package com.ptteng.common.carjn.controller;

import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.model.*;


import java.io.*;

import java.util.List;
import java.util.Properties;

/**
 * Created by liangxj on 2015/12/16.
 */
public class Txt {
    public static String path = "/data/temp/";
    public static String pdfPath = "/data/temp/pdf/";

    private static String filenameTemp;
    private static String filenamePdfTemp;

    /**
     * 创建文件
     *
     * @throws IOException
     */
    public static String creatTxtFile(String name) throws IOException {
        boolean flag = false;
        filenameTemp = path + name + ".txt";
        File filename = new File(filenameTemp);
        if (!filename.exists()) {
            filename.createNewFile();
            flag = true;
        }

        return filenameTemp;
    }
    /**
     * 创建文件
     *
     * @throws IOException
     */
    public static String creatTxtFile(String name,String type,String pathSelf ) throws IOException {
        boolean flag = false;
        if("pdf".equals(type)){
            filenameTemp = pathSelf + name + ".txt";
        }else{
            filenameTemp = path + name + ".txt";
        }

        File filename = new File(filenameTemp);
        if (!filename.exists()) {
            filename.createNewFile();
            flag = true;
        }

        return filenameTemp;
    }
    //创建文件夹
    public static String  creatPdfFile(String name) throws IOException {
        String ll  = pdfPath + name;
        File filename = new File(ll);
        filename.mkdir();
        return ll+"/";
    }


    /**
     * 写文件
     *
     * @param newStr
     *            新内容
     * @throws IOException
     */
    public static boolean writeTxtFile (String newStr)
            throws IOException {
// 先读取原有文件内容，然后进行写入操作
        boolean flag = false;
        String filein = newStr + "\r\n";
        String temp = "";

        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;

        FileOutputStream fos = null;
        PrintWriter pw = null;
        try {
// 文件路径
            File file = new File(filenameTemp);
// 将文件读入输入流
            fis = new FileInputStream(file);
            isr = new InputStreamReader(fis);
            br = new BufferedReader(isr);
            StringBuffer buf = new StringBuffer();

// 保存该文件原有的内容
            for (int j = 1; (temp = br.readLine()) != null; j++) {
                buf = buf.append(temp);
// System.getProperty("line.separator")
// 行与行之间的分隔符 相当于“\n”
                buf = buf.append("\r\n");
            }
            buf.append(filein);

            fos = new FileOutputStream(file);
            pw = new PrintWriter(fos);
            pw.write(buf.toString().toCharArray());
            pw.flush();
            flag = true;
        } catch (IOException e1) {
// TODO 自动生成 catch 块
            throw e1;
        } finally {
            if (pw != null) {
                pw.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return flag;
    }
    public String formatStr(String str, int length) {
        str = " "+str;
        int strLen = str.getBytes().length;
        if (strLen < length) {
            int temp = length - strLen;
            for (int i = 0; i < temp; i++) {
                str += " ";
            }
        }
        return str ;
    }
    public static  String getRegion(String region){

        StringBuilder regionValue = new StringBuilder("");
        Properties properties = new Properties();
        try {
            InputStream inputStream = ProductController.class.getClassLoader().getResourceAsStream("region");
            BufferedReader bf = new BufferedReader(new    InputStreamReader(inputStream));
            properties.load(bf);

            String provinceJson = properties.getProperty("province");

            ProvincesParam provincesParam  = GsonUtil.fromJson(provinceJson, ProvincesParam.class);
            String cityJson = properties.getProperty("city");
            CitesParam citiesParam = GsonUtil.fromJson(cityJson, CitesParam.class);
            // log.info("  region.properties  city = "+cityJson);
            String countyJson = properties.getProperty("District");
            CountiesParam countiesParam = GsonUtil.fromJson(countyJson, CountiesParam.class);
            // log.info("  region.properties  countyJson = "+countyJson);
            String[] regsionArr = region.split(",");
            String province = regsionArr[0];
            String city = regsionArr[1];
            String county  =  regsionArr[2];

            List<ProvinceParam> provinceParamList = provincesParam.getList();
            for(ProvinceParam provinceParam : provinceParamList){
                if(province.equals(provinceParam.getProID().toString())){
                    regionValue.append(provinceParam.getProName()+",");
                    break;
                }
            }
            List<CityParam> cityParamList = citiesParam.getList();
            for(CityParam cityParam : cityParamList){
                if(city.equals(cityParam.getCityID().toString())){
                    regionValue.append(cityParam.getCityName()+",");
                    break;
                }
            }
            List<CountyParam> countyParams = countiesParam.getList();
            for(CountyParam countyParam : countyParams){
                if(county.equals(countyParam.getId().toString())){
                    regionValue.append(countyParam.getDisName());
                    break;
                }
            }
            return regionValue.toString();

        }catch (IOException e ){
            e.printStackTrace();

            return "";
        }

    }
    public static  void main(String[] args)throws IOException{
//        String file =   creatTxtFile("hello");
//        System.out.println(filenameTemp);
 //       writeTxtFile("hello  world");
//        writeTxtFile("kkkkk");
//       String ll =  getRegion("1,1,1");
//        System.out.println(ll);


        creatPdfFile("aaaa");

    }

}
