package com.ptteng.common.carjn.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.Product;
import com.ptteng.common.carjn.model.Saler;
import com.ptteng.common.carjn.service.ProductService;
import com.ptteng.common.carjn.service.SalerService;
import com.ptteng.util.RegionUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.SalerProductRelation;
import com.ptteng.common.carjn.service.SalerProductRelationService;

/**
 * SalerProductRelation  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class SalerProductRelationController {
	private static final Log log = LogFactory.getLog(SalerProductRelationController.class);

	@Autowired
	private SalerProductRelationService salerProductRelationService;

	@Autowired
	private SalerService salerService;
	@Autowired
	private ProductService productService;

	
	

	//根据销售地区查询可以使用的产品
	@RequestMapping(value = "/a/u/salerProductRelation/", method = RequestMethod.GET)
	public String getSalerProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String province,String city,String county)
			throws Exception {

		log.info("get data : province = " + province +" city  = "+city +"  county ="+county);
		try {

			log.info("  saler  province = "+province+"  city = "+city+" county = "+county);
			List<Long> productIds = productService.getProductIds(0, Integer.MAX_VALUE);
			List<Product> productList = productService.getObjectsByIds(productIds);

			List<Product> newProductList = new ArrayList<>();
			List<Product> oldProductList = new ArrayList<>();
			List<Product> loanProductList = new ArrayList<>();

			Map<String,List<Product>> map = new HashMap<>();

			for(Product product :  productList){
				log.info(" saler  region  match  start .........");
				log.info(" region now  produce id = "+product.getId());
				String region = product.getRegion();
				Boolean match =  RegionUtil.regionMatch(province, city, county, region);
				if(match){
					if(Product.new_productType.equals(product.getType())){
						newProductList.add(product);
					}else if(Product.old_productType.equals(product.getType())){
						oldProductList.add(product);
					}else if(Product.loan_productType.equals(product.getType())){
						loanProductList.add(product);
					}
				}
			}
			map.put(Product.new_productType,newProductList);
			map.put(Product.old_productType,oldProductList);
			map.put(Product.loan_productType, loanProductList);


			 List<String> ls=new ArrayList();
			ls.add(Product.new_productType);
			ls.add(Product.old_productType);
			ls.add(Product.loan_productType);
			log.info("  newProductList  = " + newProductList.size());
			log.info("  oldProductList  = "+oldProductList.size());
			log.info("  loanProductList  = "+loanProductList.size());

			model.addAttribute("code", 0);
			model.addAttribute("ls",ls);
			model.addAttribute("map", map);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get salerProductRelation error,id is  " );
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/salerProductRelation/json/salerProductRelationListJson";
	}



//	private static  Boolean  regionMatch(String province,String city,String county,String region){
//		Boolean  match = false;
//
//		//log.info(" region now  produce id = "+product.getId());
//		//	String region = product.getRegion();
//		log.info("  region = "+region);
//		Map<String,Map<String,Map<String,String>>> regionMap = GsonUtil.fromJson(region, Map.class);
//		if(DataUtils.isNotNullOrEmpty(region)){
//			Set<String> countrySet= 	regionMap.keySet();
//			for(String countryCode :  countrySet){
//				log.info(" coutryCode = "+countryCode);
//				Map<String,Map<String,String> > provinceMap =  regionMap.get(countryCode);
//				if(DataUtils.isNotNullOrEmpty(provinceMap)&& provinceMap.size()>0){
//					Set<String>  provinceSet = 	provinceMap.keySet();
//					log.info("  provinceSet  size = "+provinceSet.size());
//
//					for(String provinceCode : provinceSet){
//						log.info("  provinceCode = "+provinceCode);
//						if(province.equals(provinceCode)){
//							log.info("  saler have provincecode = "+provinceCode);
//
//							//判断市
//							Map<String,String>  cityMap =	provinceMap.get(provinceCode);
//							log.info(" cityMap = "+cityMap);
//							if(DataUtils.isNotNullOrEmpty(cityMap)&&cityMap.size()>0){
//								log.info("  cityMap  size = "+cityMap);
//								//判断是否有符合的市
//								Set<String> citySet = cityMap.keySet();
//
//								if(citySet.size()>0){
//									for(String cityCode : citySet){
//										log.info(" city code = "+cityCode);
//										if(city.equals(cityCode)){
//											log.info("  saler have citycode = "+cityCode);
//											//判断县
//											String countyStr =	cityMap.get(cityCode);
//											String[]  countyList = countyStr.split(",");
//											log.info(" countyList length= "+countyList.length);
//											if(DataUtils.isNotNullOrEmpty(countyStr)&&
//													countyList.length>0){
//												for(String countyCode : countyList){
//													if(county.equals(countyCode)){
//														log.info("  saler have countyCode = "+countyCode);
//														match=true;
//														break;
//													}
//												}
//											}else{
//												log.info("  countyList size = 0");
//												log.info(" all  county  site  citycode = "+cityCode);
//												//全市都符合
//												match=true;
//												break;
//											}
//										}
//
//									}
//								}
//							}else{
//								//全省都符合
//								log.info(" all  city  site provicecode = "+provinceCode);
//								match=true;
//								break;
//							}
//						}
//
//
//					}
////							if(baohansheng){
////								break;
////							}
//
//				}else{
//					log.info(" all  privince  site countrycode = "+countryCode);
//					//全国都符合
//					match=true;
//					break;
//				}
//			}
//		}
//		log.info("  regionMap = "+regionMap);
//		return match;
//	}

	@RequestMapping(value = "/web/a/salerProductRelation/{id}", method = RequestMethod.PUT)
	public String updateSalerProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, SalerProductRelation salerProductRelation) throws Exception {
		
		log.info("update salerProductRelation : salerProductRelation= " + salerProductRelation);
		
		try {
			
			salerProductRelationService.update(salerProductRelation);

			model.addAttribute("code", 0);

			model.addAttribute("salerProductRelation", salerProductRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update salerProductRelation error,id is  " + salerProductRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/salerProductRelation", method = RequestMethod.POST)
	public String addSalerProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, SalerProductRelation salerProductRelation) throws Exception {
		
		log.info("update salerProductRelation : salerProductRelation= " + salerProductRelation);
		
		try { 
			salerProductRelation.setId(null);

			salerProductRelationService.insert(salerProductRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add salerProductRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/salerProductRelation/{id}", method = RequestMethod.DELETE)
	public String deleteSalerProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete salerProductRelation : id= " + id);
		try {
			salerProductRelationService.delete(id);

			log.info("add salerProductRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete salerProductRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/salerProductRelation", method = RequestMethod.GET)
	public String getMultiSalerProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<SalerProductRelation> salerProductRelationList = salerProductRelationService.getObjectsByIds(idList);
			log.info("get  salerProductRelation data is " + salerProductRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",salerProductRelationList.size());

			model.addAttribute("salerProductRelationList", salerProductRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get salerProductRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/salerProductRelation/json/salerProductRelationListJson";
	}
	
	
}

