package com.ptteng.common.carjn.controller;

import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.Product;
import com.ptteng.common.carjn.model.RoleProductRelation;
import com.ptteng.common.carjn.model.Saler;
import com.ptteng.common.carjn.model.SalerProductRelation;
import com.ptteng.common.carjn.service.ProductService;
import com.ptteng.common.carjn.service.SalerProductRelationService;
import com.ptteng.common.carjn.service.SalerService;

import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.util.SalerUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;


/**
 * Saler  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class SalerController  {
	private static final Log log = LogFactory.getLog(SalerController.class);

	@Autowired
	private SalerService salerService;

	@Autowired
	private CookieUtil cookieUtil;

	@Autowired
	private ProductService productService;
	@Autowired
	private SalerProductRelationService salerProductRelationService;





	@RequestMapping(value = "/web/c/saler", method = RequestMethod.GET)
	public String getsalerList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/saler  to /saler/view/salerList");

		return "/common-carjn-service/saler/view/salerList";
	}
    
    

    

	@RequestMapping(value = "/web/c/saler/{id}", method = RequestMethod.GET)
	public String getSaler(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/saler/" + id + "  to /saler/view/salerDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}



		return "/common-carjn-service/saler/json/salerDetail";
	}





	//销售管理--根据ID查询单个销售详情
	@RequestMapping(value = "/a/u/saler/{id}", method = RequestMethod.GET)
	public String getSalerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Saler saler = salerService.getObjectById(id);
			log.info("get saler data is " + saler);
			List<Long> spIds = salerProductRelationService.getSalerProductRelationIdsByRoleIdOrderByUpdateAt
					(saler.getId(),0,Integer.MAX_VALUE);
			log.info("  spIds   size = "+spIds.size());
			List<SalerProductRelation> salerProductRelationList = salerProductRelationService.getObjectsByIds(spIds);
			List<Long> productIds = new ArrayList<>();
			for(SalerProductRelation salerProductRelation : salerProductRelationList){
				productIds.add(salerProductRelation.getProductId());
			}

			log.info("  productIds  "+productIds);


			model.addAttribute("code", 0);

			model.addAttribute("saler", saler);
			model.addAttribute("productIds",productIds);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get saler error,id is  " + id);
			model.addAttribute("code", -1);
			return "/common/success";
		}

		return "/common-carjn-service/saler/json/salerDetailJson";
	}

	//销售管理--修改
	@RequestMapping(value = "/a/u/saler/{id}", method = RequestMethod.PUT)
	public String updateSalerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String saler,@PathVariable Long id
	,String productIds) throws Exception {
		
		log.info("update saler : id= " + id+" saler = "+saler);
		
		try {
			Saler s = salerService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(s)){
				model.addAttribute("code", -10005);
				return "/common/success";
			}

			Saler inputSaler = GsonUtil.fromJson(saler,Saler.class);
			log.info("  inputSaler = "+inputSaler);
			if(DataUtils.isNullOrEmpty(inputSaler.getPhone())
					||DataUtils.isNullOrEmpty(inputSaler.getName())
					||DataUtils.isNullOrEmpty(inputSaler.getEmail())
					||DataUtils.isNullOrEmpty(inputSaler.getPwd())){
				model.addAttribute("code", -1000);
				return "/common/success";
			}

			if(DataUtils.isNullOrEmpty(inputSaler.getProvince())
					||DataUtils.isNullOrEmpty(inputSaler.getCity())
					||DataUtils.isNullOrEmpty(inputSaler.getCounty())
					){
				model.addAttribute("code", -10007);
				return "/common/success";
			}
			String userId = cookieUtil.getKeyIdentity(request,
					CookieUtil.USER_ID);
			if(s.getPwd().equals(inputSaler.getPwd())){
				log.info("  pwd  not change");
			}else{

				String encodePass = com.gemantic.common.util.PasswordUtils.encode(inputSaler.getPwd());
				inputSaler.setPwd(encodePass);
			}






			Long sId = salerService.getSalerIdByPhone(inputSaler.getPhone());
			log.info(" same  phone sId = "+sId);
			if(null !=sId && !id.equals(sId)){
				model.addAttribute("code", -10006);
				return "/common/success";
			}

			log.info("   saler   = "+s);
			inputSaler.setId(id);
			inputSaler.setCreateAt(s.getCreateAt());
			inputSaler.setCreateBy(s.getCreateBy());
			inputSaler.setUpdateAt(System.currentTimeMillis());
			inputSaler.setUpdateBy(Long.valueOf(userId));
			log.info(" userId = "+userId+" updateBy = "+inputSaler.getUpdateBy());
			if(null == inputSaler.getUpdateBy()){
				log.info(" updateBy = null ");
				inputSaler.setUpdateBy(s.getUpdateBy());
			}
			salerService.update(inputSaler);


			if(StringUtil.isNotEmpty(productIds)){
				String[] proIdArr = productIds.split(",");
				log.info("   proIdArr  length =  " + proIdArr.length);
				//先删除
				List<Long> spIds = salerProductRelationService.getSalerProductRelationIdsByRoleIdOrderByUpdateAt
						(id,0,Integer.MAX_VALUE);
				if(spIds.size()>0){
					salerProductRelationService.deleteList(SalerProductRelation.class,spIds);
				}
				//再新增
				List<SalerProductRelation> salerProductRelationList = new ArrayList<>();
				log.info("  proIdArr[0]  = "+proIdArr[0]);
				if(DataUtils.isNotNullOrEmpty(proIdArr[0])){
					for(String proId : proIdArr){
						log.info("  proId  =  "+proId);
						SalerProductRelation salerProductRelation = new SalerProductRelation();
						salerProductRelation.setRoleId(id);
						salerProductRelation.setProductId(Long.valueOf(proId));
						salerProductRelation.setCreateBy(Long.valueOf(userId));
						salerProductRelationList.add(salerProductRelation);
					}
					log.info(" salerProductRelationList size "+salerProductRelationList.size());
					salerProductRelationService.insertList(salerProductRelationList);
				}


			}


			model.addAttribute("code", 0);

			model.addAttribute("saler", saler);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update saler error,id is  " + saler);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}

	//销售管理--新增
	@RequestMapping(value = "/a/u/saler", method = RequestMethod.POST)
	public String addSalerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String saler,String productIds) throws Exception {
		
		log.info("add saler : saler= " + saler+"  productIds = "+productIds);
		
		try {


			String userId = cookieUtil.getKeyIdentity(request,
					CookieUtil.USER_ID);
			Saler inputSaler = GsonUtil.fromJson(saler,Saler.class);

			inputSaler.setId(null);
			if(DataUtils.isNullOrEmpty(inputSaler.getName())){
				model.addAttribute("code",-10001);
				return "/common/success";
			}
			if(DataUtils.isNullOrEmpty(inputSaler.getPhone())){
				model.addAttribute("code",-10002);
				return "/common/success";
			}
			if(DataUtils.isNullOrEmpty(inputSaler.getEmail())){
				model.addAttribute("code",-10003);
				return "/common/success";
			}
			if(DataUtils.isNullOrEmpty(inputSaler.getPwd())){
				model.addAttribute("code",-10004);
				return "/common/success";
			}

			Long id = salerService.getSalerIdByPhone(inputSaler.getPhone());
			if(DataUtils.isNotNullOrEmpty(id)){
				model.addAttribute("code",-10006);
				return "/common/success";
			}
			if(DataUtils.isNullOrEmpty(inputSaler.getProvince())
					||DataUtils.isNullOrEmpty(inputSaler.getCity())
					||DataUtils.isNullOrEmpty(inputSaler.getCounty())){
				model.addAttribute("code",-10007);
				return "/common/success";
			}

			String encodePass = com.gemantic.common.util.PasswordUtils.encode(inputSaler.getPwd());
			inputSaler.setPwd(encodePass);
			inputSaler.setCreateBy(Long.valueOf(userId));
			inputSaler.setUpdateBy(Long.valueOf(userId));
			Long salerId = salerService.insert(inputSaler);
			String[] proIdArr = productIds.split(",");
			log.info("   proIdArr  =  "+proIdArr.length);
			log.info("  proIdArr[0]  = "+proIdArr[0]);
			if(DataUtils.isNotNullOrEmpty(proIdArr[0])){
				List<SalerProductRelation> salerProductRelationList = new ArrayList<>();
				for(String proId : proIdArr){
					log.info("  proId  =  "+proId);
					SalerProductRelation salerProductRelation = new SalerProductRelation();
					salerProductRelation.setRoleId(salerId);
					salerProductRelation.setProductId(Long.valueOf(proId));
					salerProductRelation.setCreateBy(Long.valueOf(userId));
					salerProductRelationList.add(salerProductRelation);
				}
				log.info(" salerProductRelationList size "+salerProductRelationList.size());
				salerProductRelationService.insertList(salerProductRelationList);
			}


			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add saler error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}

	//销售管理--删除
	@RequestMapping(value = "/a/u/saler/{id}", method = RequestMethod.DELETE)
	public String deleteSalerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete saler : id= " + id);
		try {
			Saler s = salerService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(s)){
				model.addAttribute("code",-10005);
				return "/common/success";
			}
			salerService.delete(id);

			//先删除
			List<Long> spIds = salerProductRelationService.getSalerProductRelationIdsByRoleIdOrderByUpdateAt
					(id, 0, Integer.MAX_VALUE);
			if(spIds.size()>0){
				salerProductRelationService.deleteList(SalerProductRelation.class, spIds);
			}


			log.info("delete saler success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete saler error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}
	/**
	 * 列表查询
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/saler/", method = RequestMethod.GET)
	public String getManagerJsonList(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Integer page,
									 Integer size, String name,String phone,String email,String province,
									 String city,String county) throws Exception {

		if(page==null){

			page=1;
		}

		if(size == null){
			size=10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size
				+ ",name=" + name + ",phone=" + phone+" , emaile ="+email);

		try {
			Boolean next = false;
			size+=1;


			Map<String, Object> map = new HashMap<>();
			if (DataUtils.isNotNullOrEmpty(name)) {
				map.put("name", name);
			}
			if (DataUtils.isNotNullOrEmpty(phone)) {
				map.put("phone", phone);
			}
			if (DataUtils.isNotNullOrEmpty(email)) {
				map.put("email", email);
			}

			List<Long> ids;
			if (map.size() > 0) {
				Map<String, Object> map1 = SalerUtil.getSalerListParam(name,phone,email,province,city,county,false);
				ids = salerService.getIdsByDynamicCondition(Saler.class,map1, start, size);

			} else {
				ids = salerService.getSalerIds(start, size);
			}

			log.info("get saler size is " + ids.size());

			if(ids!=null && ids.size()>0){

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  "+ids.subList(0,size-1));
					model.addAttribute("ids", ids.subList(0,size-1));
				}else{
					log.info("ss  "+ids.subList(0,ids.size()));
					model.addAttribute("ids", ids.subList(0, ids.size()));
				}
			}else{
				model.addAttribute("ids", ids);
			}
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size - 1);
			model.addAttribute("next", next);




		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get saler list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
			return "/common/success";
		}

		return "/common-carjn-service/saler/json/salerListJson";
	}

	//批量查询销售列表
	@RequestMapping(value = "/a/u/multi/saler", method = RequestMethod.GET)
	public String getMultiSalerJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {
			Map<Long,String>  productMap  =  new HashMap<>();
			for(Long salerId : idList){
				log.info("  salerId  = "+salerId);
				List<Long> rpIds =  salerProductRelationService.getSalerProductRelationIdsByRoleIdOrderByUpdateAt
						(salerId, 0, Integer.MAX_VALUE);
				log.info("  rpIds ="+rpIds);
				if(rpIds.size()>0){
					List<SalerProductRelation> salerProductRelationList = salerProductRelationService.getObjectsByIds(rpIds);
					StringBuilder productNames = new StringBuilder("");
					List<Long> productIds = new ArrayList<>();
					for(SalerProductRelation salerProductRelation : salerProductRelationList){
						productIds.add(salerProductRelation.getProductId());
					}
					log.info(" productIds = "+productIds);
					List<Product>  productList = productService.getObjectsByIds(productIds);
					for(int i = 0;i<productList.size();i++){
						if(i==productList.size()-1){
							productNames.append(productList.get(i).getAliases());
						}else{
							productNames.append(productList.get(i).getAliases()+",");
						}

					}
					productMap.put(salerId,productNames.toString());
					log.info("productNames =  "+productNames.toString());
				}else{
					productMap.put(salerId,"");
				}

			}



			

			List<Saler> salerList = salerService.getObjectsByIds(idList);
			log.info("get  saler data is " + salerList);

			model.addAttribute("code", 0);			
			model.addAttribute("total", salerList.size());
			model.addAttribute("productMap",productMap);
			model.addAttribute("salerList", salerList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get saler error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/saler/json/salerMultiListJson";
	}





}

