package com.ptteng.common.carjn.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.Product;
import com.ptteng.common.carjn.model.Role;
import com.ptteng.common.carjn.service.ProductService;
import com.ptteng.common.carjn.service.RoleService;
import com.ptteng.model.RoleProductRelationParam;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.RoleProductRelation;
import com.ptteng.common.carjn.service.RoleProductRelationService;

/**
 * RoleProductRelationParam  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class RoleProductRelationController {
	private static final Log log = LogFactory.getLog(RoleProductRelationController.class);

	@Autowired
	private RoleProductRelationService roleProductRelationService;

	@Autowired
	private RoleService roleService;

	@Autowired
	private ProductService productService;



	
	
	//查询单个角色的产品
	@RequestMapping(value = "/a/u/role/product/{id}", method = RequestMethod.GET)
	public String getRoleProductRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/a/u/roleProductRelation/{id}" + id + "  ");
		try{
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}
		Role role = roleService.getObjectById(id);
		List<Long> rpIds =  roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
				(id, 0, Integer.MAX_VALUE);
		log.info("  rpIds =" + rpIds);
		List<Long> productIds = new ArrayList<>();

		if(rpIds.size()>0){
			List<RoleProductRelation> roleProductRelationList = roleProductRelationService.getObjectsByIds(rpIds);

			for(RoleProductRelation roleProductRelation : roleProductRelationList){
				productIds.add(roleProductRelation.getProductId());
			}
		}
		log.info("  productIds =  " + productIds);
		List<Product>  productList = productService.getObjectsByIds(productIds);

		model.addAttribute("code",0);
		model.addAttribute("role",role);
		model.addAttribute("productList", productList);
		return "/common-carjn-service/roleProductRelation/json/roleProductRelationDetailJson";
		}catch (Exception e){
			e.printStackTrace();
			log.error("  error   get  by id id = "+id);
			model.addAttribute("code",-1);
			return "/common/success";
		}
	}
	
	
	
	    		
			
    /**
	 * 查询角色列表的产品
	 */
	
		@RequestMapping(value = "/a/u/role/product/", method = RequestMethod.GET)
	public String getRoleProductRelationIdsByRoleIdOrderByUpdateAtJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size) throws Exception {

			log.info("  page = "+page+" size = "+size);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			Boolean next = false;
			size+=1;

			List<Long> ids = roleService.getRoleIds(start, size);
			log.info("  ids = "+ids);
			List<Role>  roleList = roleService.getObjectsByIds(ids);
			Map<Long,String>  productMap  =  new HashMap<>();
			for(Long roleId : ids){
				log.info("  roleId  = "+roleId);
				List<Long> rpIds =  roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
						(roleId,0,Integer.MAX_VALUE);
				log.info("  rpIds ="+rpIds);
				if(rpIds.size()>0){
					List<RoleProductRelation> roleProductRelationList = roleProductRelationService.getObjectsByIds(rpIds);
					StringBuilder productNames = new StringBuilder("");
					List<Long> productIds = new ArrayList<>();
					for(RoleProductRelation roleProductRelation : roleProductRelationList){
						productIds.add(roleProductRelation.getProductId());
					}
					log.info(" productIds = "+productIds);
					List<Product>  productList = productService.getObjectsByIds(productIds);
					for(int i = 0;i<productList.size();i++){
						if(i==productList.size()-1){
							productNames.append(productList.get(i).getAliases());
						}else{
							productNames.append(productList.get(i).getAliases()+",");
						}

					}
					productMap.put(roleId,productNames.toString());
					log.info("productNames =  "+productNames.toString());
				}else{
					productMap.put(roleId,"");
				}

			}
			if(ids!=null && ids.size()>0){

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  "+ids.subList(0,size-1));

				}else{
					log.info("ss  "+ids.subList(0,ids.size()));

				}
			}
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size-1);
			
			model.addAttribute("next", next);

			model.addAttribute("roleList", roleList);
			model.addAttribute("productMap",productMap);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get roleProductRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/roleProductRelation/json/roleProductRelationListJson";
	}

	
	
		
	
	


	//修改
	@RequestMapping(value = "/a/u/role/product/{id}", method = RequestMethod.PUT)
	public String updateRoleProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String roleProductRelationJson,@PathVariable Long id) throws Exception {
		
		log.info("update roleProductRelation : roleProductRelation= " + roleProductRelationJson+"  roleId = "+id);
		
		try {

			List<RoleProductRelation> roleProductRelationList = new ArrayList<>();
			RoleProductRelationParam roleProductRelationParam =
					GsonUtil.fromJson(roleProductRelationJson,RoleProductRelationParam.class);
			Long roleId  = roleProductRelationParam.getRoleId();
			log.info(" roleId = " + roleId);
			if(DataUtils.isNullOrEmpty(roleId)){
				model.addAttribute("code",-60001);
				return "/common/success";
			}
			Role role = roleService.getObjectById(roleId);
			if(DataUtils.isNullOrEmpty(role)){
				model.addAttribute("code",-60004);
				return "/common/success";
			}



			List<Long>  rpIds = roleProductRelationService.
					getRoleProductRelationIdsByRoleIdOrderByUpdateAt(roleId, 0, Integer.MAX_VALUE);
			log.info(" rpIds = "+rpIds);
			//先删除
			if(rpIds.size()>0){
				roleProductRelationService.deleteList(RoleProductRelation.class,rpIds);
			}
			//再增加
			String productIds = roleProductRelationParam.getProductIds();

			if(DataUtils.isNotNullOrEmpty(productIds)){
				String[]  productIdArr = productIds.split(",");
				for(String productId : productIdArr){
					log.info("  productId = "+productId);
					RoleProductRelation roleProductRelation = new RoleProductRelation();
					roleProductRelation.setId(null);
					roleProductRelation.setRoleId(roleId);
					roleProductRelation.setProductId(Long.valueOf(productId));
					roleProductRelationList.add(roleProductRelation);
				}
			}
			roleProductRelationService.insertList(roleProductRelationList);
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update roleProductRelation error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/common/success";
	}

	//新增
	@RequestMapping(value = "/a/u/role/product", method = RequestMethod.POST)
	public String addRoleProductRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String roleProductRelationJson) throws Exception {
		
		log.info("update roleProductRelation : roleProductRelationJson= " + roleProductRelationJson);
		
		try {
			List<RoleProductRelation> roleProductRelationList = new ArrayList<>();
			RoleProductRelationParam roleProductRelationParam =
					GsonUtil.fromJson(roleProductRelationJson, RoleProductRelationParam.class);
			Long roleId  = roleProductRelationParam.getRoleId();
			log.info(" roleId = " + roleId);
			if(DataUtils.isNullOrEmpty(roleId)){
				model.addAttribute("code",-60001);
				return "/common/success";
			}
			Role role = roleService.getObjectById(roleId);
			if(DataUtils.isNullOrEmpty(role)){
				model.addAttribute("code",-60004);
				return "/common/success";
			}

		    List<Long>  rpIds =	roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
					(roleId, 0, Integer.MAX_VALUE);
			if(rpIds.size()>0){
				model.addAttribute("code",-60003);
				return "/common/success";
			}
			String productIds = roleProductRelationParam.getProductIds();

			if(DataUtils.isNotNullOrEmpty(productIds)){
				String[]  productIdArr = productIds.split(",");
				for(String productId : productIdArr){
					log.info("  productId = "+productId);
					RoleProductRelation roleProductRelation = new RoleProductRelation();
					roleProductRelation.setId(null);
					roleProductRelation.setRoleId(roleId);
					roleProductRelation.setProductId(Long.valueOf(productId));
					roleProductRelationList.add(roleProductRelation);
				}
			}else{
				model.addAttribute("code",-60002);
				return "/common/success";
			}


			roleProductRelationService.insertList(roleProductRelationList);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add roleProductRelation error ");
			model.addAttribute("code", -1);
		}

		return "/common/success";
	}


	
	

	
}

