package com.ptteng.common.carjn.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.PropdfileCertifiRelation;
import com.ptteng.common.carjn.service.PropdfileCertifiRelationService;

/**
 * PropdfileCertifiRelation  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class PropdfileCertifiRelationController {
	private static final Log log = LogFactory.getLog(PropdfileCertifiRelationController.class);

	@Autowired
	private PropdfileCertifiRelationService propdfileCertifiRelationService;








	@RequestMapping(value = "/web/c/propdfileCertifiRelation", method = RequestMethod.GET)
	public String getpropdfileCertifiRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/propdfileCertifiRelation  to /propdfileCertifiRelation/view/propdfileCertifiRelationList");

		return "/common-carjn-service/propdfileCertifiRelation/view/propdfileCertifiRelationList";
	}
    
    

    		
			

	 
	
		 @RequestMapping(value = "/web/c/propdfileCertifiRelation1 ", method = RequestMethod.GET)
	public String getPropdfileCertifiRelationIdsByPropdfileIdList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long propdfileId) throws Exception {

		log.info("/web/propdfileCertifiRelation  to /propdfileCertifiRelation/view/propdfileCertifiRelationList");

		return "/common-carjn-service/propdfileCertifiRelation/view/propdfileCertifiRelationList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/propdfileCertifiRelation/{id}", method = RequestMethod.GET)
	public String getPropdfileCertifiRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/propdfileCertifiRelation/" + id + "  to /propdfileCertifiRelation/view/propdfileCertifiRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/propdfileCertifiRelation/view/propdfileCertifiRelationDetail";
	}
	
	
	
	    		
			

	
		@RequestMapping(value = "/web/a/propdfileCertifiRelation1 ", method = RequestMethod.GET)
	public String getPropdfileCertifiRelationIdsByPropdfileIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long propdfileId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId(propdfileId,start,size);
		log.info("get countPropdfileCertifiRelationIdsByPropdfileId size is " + ids.size());

			List<PropdfileCertifiRelation> propdfileCertifiRelationList = propdfileCertifiRelationService.getObjectsByIds(ids);
			log.info("get propdfileCertifiRelation data is " + propdfileCertifiRelationList.size());

			Integer total = propdfileCertifiRelationService. countPropdfileCertifiRelationIdsByPropdfileId(propdfileId);
			log.info("get propdfileCertifiRelation count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("propdfileCertifiRelationList", propdfileCertifiRelationList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get propdfileCertifiRelation list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/propdfileCertifiRelation/json/propdfileCertifiRelationListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/web/a/propdfileCertifiRelation/{id}", method = RequestMethod.GET)
	public String getPropdfileCertifiRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			PropdfileCertifiRelation propdfileCertifiRelation = propdfileCertifiRelationService.getObjectById(id);
			log.info("get propdfileCertifiRelation data is " + propdfileCertifiRelation);

			model.addAttribute("code", 0);

			model.addAttribute("propdfileCertifiRelation", propdfileCertifiRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get propdfileCertifiRelation error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/propdfileCertifiRelation/json/propdfileCertifiRelationDetailJson";
	}

	@RequestMapping(value = "/web/a/propdfileCertifiRelation/{id}", method = RequestMethod.PUT)
	public String updatePropdfileCertifiRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, PropdfileCertifiRelation propdfileCertifiRelation) throws Exception {
		
		log.info("update propdfileCertifiRelation : propdfileCertifiRelation= " + propdfileCertifiRelation);
		
		try {
			
			propdfileCertifiRelationService.update(propdfileCertifiRelation);

			model.addAttribute("code", 0);

			model.addAttribute("propdfileCertifiRelation", propdfileCertifiRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update propdfileCertifiRelation error,id is  " + propdfileCertifiRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/propdfileCertifiRelation", method = RequestMethod.POST)
	public String addPropdfileCertifiRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, PropdfileCertifiRelation propdfileCertifiRelation) throws Exception {
		
		log.info("update propdfileCertifiRelation : propdfileCertifiRelation= " + propdfileCertifiRelation);
		
		try { 
			propdfileCertifiRelation.setId(null);

			propdfileCertifiRelationService.insert(propdfileCertifiRelation);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add propdfileCertifiRelation error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/propdfileCertifiRelation/{id}", method = RequestMethod.DELETE)
	public String deletePropdfileCertifiRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete propdfileCertifiRelation : id= " + id);
		try {
			propdfileCertifiRelationService.delete(id);

			log.info("add propdfileCertifiRelation success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete propdfileCertifiRelation error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/propdfileCertifiRelation", method = RequestMethod.GET)
	public String getMultiPropdfileCertifiRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<PropdfileCertifiRelation> propdfileCertifiRelationList = propdfileCertifiRelationService.getObjectsByIds(idList);
			log.info("get  propdfileCertifiRelation data is " + propdfileCertifiRelationList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",propdfileCertifiRelationList.size());

			model.addAttribute("propdfileCertifiRelationList", propdfileCertifiRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get propdfileCertifiRelation error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/propdfileCertifiRelation/json/propdfileCertifiRelationListJson";
	}
	
	
}

