package com.ptteng.common.carjn.controller;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.model.PropdfileCertifiRelation;
import com.ptteng.common.carjn.service.ConstantService;
import com.ptteng.common.carjn.service.PropdfileCertifiRelationService;
import com.ptteng.util.PropdffileDynamicUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.Propdffile;
import com.ptteng.common.carjn.service.PropdffileService;

/**
 * Propdffile  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class PropdffileController {
	private static final Log log = LogFactory.getLog(PropdffileController.class);

	@Autowired
	private PropdffileService propdffileService;


	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;

	@Autowired
	private PropdfileCertifiRelationService propdfileCertifiRelationService;
	@Autowired
	private ConstantService constantService;




	@RequestMapping(value = "/web/c/propdffile", method = RequestMethod.GET)
	public String getpropdffileList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/propdffile  to /propdffile/view/propdffileList");

		return "/common-carjn-service/propdffile/view/propdffileList";
	}
    
    

    		

	
		 @RequestMapping(value = "/web/c/propdffile1 ", method = RequestMethod.GET)
	public String getPropdffileIdsByProductIdList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long productId) throws Exception {

		log.info("/web/propdffile  to /propdffile/view/propdffileList");

		return "/common-carjn-service/propdffile/view/propdffileList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/propdffile/{id}", method = RequestMethod.GET)
	public String getPropdffile(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/propdffile/" + id + "  to /propdffile/view/propdffileDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/propdffile/view/propdffileDetail";
	}
	
	
	
	    //列表查询

		@RequestMapping(value = "/a/u/pdffile/", method = RequestMethod.GET)
	public String getPropdffileIdsByProductIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long channelId,String type ,String productType) throws Exception {

			log.info("  channelId  = "+channelId+" type = "+type+" productType = "+productType);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {
			size+=1;
			Boolean next = false;
			List<Long> ids= new ArrayList<>();
			if(DataUtils.isNotNullOrEmpty(channelId)
					||DataUtils.isNotNullOrEmpty(type)
					||DataUtils.isNotNullOrEmpty(productType)){
				log.info("    dyt   select    ");
				Map<String, Object> map = PropdffileDynamicUtil.getSolutionListParam(channelId,type,productType,false);
				ids=propdffileService.getIdsByDynamicCondition(Propdffile.class,map,start,size);
				log.info("  1    ids = "+ids);
			}else{
				ids= propdffileService.getPropdffileIds(start,size);
				log.info("  2     ids = "+ids);

			}
			if(size.equals(ids.size())){
				next=true;
				ids = ids.subList(0,size-1);
			}



		      log.info("get countPropdffileIdsByProductId size is " + ids.size());


			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size-1);
			model.addAttribute("next", next);
			model.addAttribute("ids", ids);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get propdffile list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

			return "/common-carjn-service/article/json/articleListJson";
	}

	
	
		
	
	

	//单个查询
	@RequestMapping(value = "/a/u/pdffile/{id}", method = RequestMethod.GET)
	public String getPropdffileJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Propdffile propdffile = propdffileService.getObjectById(id);
			log.info("get propdffile data is " + propdffile);
			List<Long> pcIds = 	propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId
					(propdffile.getId(),0,Integer.MAX_VALUE);
			log.info("  pcIds  size =  "+pcIds.size());
			log.info("  pcIds   =  "+pcIds);

			List<Constant> certificateList = new ArrayList<>();
			if(pcIds.size()>0){
				List<PropdfileCertifiRelation>  propdfileCertifiRelations = propdfileCertifiRelationService.getObjectsByIds(pcIds);
				for(PropdfileCertifiRelation propdfileCertifiRelation : propdfileCertifiRelations){
					Long certificateId = propdfileCertifiRelation.getCertificateId();
					Constant certificate =  constantService.getObjectById(certificateId);
					certificateList.add(certificate);
				}

				model.addAttribute("certificateList",certificateList);
			}
			model.addAttribute("code", 0);

			model.addAttribute("propdffile", propdffile);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get propdffile error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/propdffile/json/propdffileDetailJson";
	}

	//修改
	@RequestMapping(value = "/a/u/pdffile/{id}", method = RequestMethod.PUT)
	public String updatePropdffileJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, String pdffileJson,String certificateIds) throws Exception {

		log.info("add propdffile : pdffileJson= " + pdffileJson+"  certificateIds  =  "+certificateIds);
		
		try {
			String uid =  cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			Propdffile propdffile = GsonUtil.fromJson(pdffileJson,Propdffile.class);

			if(DataUtils.isNullOrEmpty(propdffile.getChannelId())
					||DataUtils.isNullOrEmpty(propdffile.getProductType())
					||DataUtils.isNullOrEmpty(propdffile.getFileName())
					||DataUtils.isNullOrEmpty(propdffile.getType())
					||DataUtils.isNullOrEmpty(propdffile.getId())
					||DataUtils.isNullOrEmpty(propdffile.getPersonnelType())){
				model.addAttribute("code",-1000);
				return "/data/json";
			}


			propdffile.setCreateBy(Long.valueOf(uid));
			propdffile.setUpdateBy(Long.valueOf(uid));
			 propdffileService.update(propdffile);
			log.info("  propdffile   id  =   "+propdffile.getId());
			String[] certificateArr = certificateIds.split(",");
			//先删除
		    List<Long> pcIds = 	propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId
					(propdffile.getId(),0,Integer.MAX_VALUE);
			log.info("  pcIds   size = "+pcIds.size());
			log.info("  pcIds    = "+pcIds);

			if(pcIds.size()>0){
				propdfileCertifiRelationService.deleteList(PropdfileCertifiRelation.class,pcIds);
			}


			//再增加
			List<PropdfileCertifiRelation> list = new ArrayList<>();
			for(String certificateId : certificateArr){
				log.info("   certificateId  =  "+certificateId);
				PropdfileCertifiRelation propdfileCertifiRelation = new PropdfileCertifiRelation();
				propdfileCertifiRelation.setCertificateId(Long.valueOf(certificateId));
				propdfileCertifiRelation.setPropdfileId(propdffile.getId());
				propdfileCertifiRelation.setCreateBy(Long.valueOf(uid));
				propdfileCertifiRelation.setUpdateBy(Long.valueOf(uid));
				list.add(propdfileCertifiRelation);
			}
			log.info("   list  size = " + list.size());
			propdfileCertifiRelationService.insertList(list);

			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update propdffile error,id is  " + pdffileJson);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}

	//新增
	@RequestMapping(value = "/a/u/pdffile", method = RequestMethod.POST)
	public String addPropdffileJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,String pdffileJson,String certificateIds) throws Exception {
		
		log.info("add propdffile : pdffileJson= " + pdffileJson+"  certificateIds  =  "+certificateIds);
		
		try {
			String uid =  cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
			Propdffile propdffile = GsonUtil.fromJson(pdffileJson,Propdffile.class);

			if(DataUtils.isNullOrEmpty(propdffile.getChannelId())
					||DataUtils.isNullOrEmpty(propdffile.getProductType())
					||DataUtils.isNullOrEmpty(propdffile.getFileName())
					||DataUtils.isNullOrEmpty(propdffile.getType())){
				model.addAttribute("code",-1000);
				return "/data/json";
			}

			propdffile.setId(null);
			propdffile.setCreateBy(Long.valueOf(uid));
			propdffile.setUpdateBy(Long.valueOf(uid));
			Long id = propdffileService.insert(propdffile);
			log.info("  propdffile   id  =   "+id);
			String[] certificateArr = certificateIds.split(",");
			List<PropdfileCertifiRelation> list = new ArrayList<>();
			for(String certificateId : certificateArr){
				log.info("   certificateId  =  "+certificateId);
				PropdfileCertifiRelation propdfileCertifiRelation = new PropdfileCertifiRelation();
				propdfileCertifiRelation.setCertificateId(Long.valueOf(certificateId));
				propdfileCertifiRelation.setPropdfileId(id);
				propdfileCertifiRelation.setCreateBy(Long.valueOf(uid));
				propdfileCertifiRelation.setUpdateBy(Long.valueOf(uid));
				list.add(propdfileCertifiRelation);
			}
			log.info("   list  size = "+list.size());
			propdfileCertifiRelationService.insertList(list);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add propdffile error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	//删除
	@RequestMapping(value = "/a/u/pdffile/{id}", method = RequestMethod.DELETE)
	public String deletePropdffileJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete propdffile : id= " + id);
		try {
			//先删除证件
			List<Long> pcIds = 	propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId
					(id,0,Integer.MAX_VALUE);
			log.info("  pcIds   size = "+pcIds.size());
			log.info("  pcIds    = "+pcIds);

			if(pcIds.size()>0){
				propdfileCertifiRelationService.deleteList(PropdfileCertifiRelation.class,pcIds);
			}

			propdffileService.delete(id);

			log.info("delete propdffile success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete propdffile error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}
	
	//详细
	@RequestMapping(value = "/a/u/multi/pdffile/", method = RequestMethod.GET)
	public String getMultiPropdffileJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			Map<Long,String>  certificateNameMap = new HashMap<>();
			Map<Long,String>  channelNameMap = new HashMap<>();

			List<Propdffile> propdffileList = propdffileService.getObjectsByIds(idList);
			log.info("get  propdffile data is " + propdffileList);
			for(Propdffile propdffile : propdffileList){
				log.info("  propdffile  id  = " + propdffile.getId());
				Constant constant =  constantService.getObjectById(propdffile.getChannelId());
				//添加渠道名称
				channelNameMap.put(propdffile.getId(),constant.getName());


				StringBuilder certificateNames = new StringBuilder();
				List<Long> pcIds =  propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId
						(propdffile.getId(),0,Integer.MAX_VALUE);
				log.info("  pcIds  =   "+pcIds);
				List<PropdfileCertifiRelation>  propdfileCertifiRelations = propdfileCertifiRelationService.getObjectsByIds(pcIds);
				for(int i=0;i<propdfileCertifiRelations.size();i++){
					Long certificateId = propdfileCertifiRelations.get(i).getCertificateId();
					log.info("  certificateId  =   "+certificateId);
					Constant certificate =  constantService.getObjectById(certificateId);
					if(i==propdfileCertifiRelations.size()-1){
						certificateNames.append(certificate.getName());
					}else{
						certificateNames.append(certificate.getName()+",");

					}

				}
				log.info("   certificateNames  = "+certificateNames.toString());
				certificateNameMap.put(propdffile.getId(),certificateNames.toString());
			}

			model.addAttribute("code", 0);			
			model.addAttribute("total",propdffileList.size());

			model.addAttribute("propdffileList", propdffileList);
			model.addAttribute("certificateNameMap", certificateNameMap);
			model.addAttribute("channelNameMap", channelNameMap);
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get propdffile error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/propdffile/json/propdffileListJson";
	}
	
	
}

