package com.ptteng.common.carjn.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemantic.common.util.StringUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.*;
import com.ptteng.common.carjn.service.*;
import com.ptteng.model.*;
import com.ptteng.util.ProductUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Created by ruan on 2015/12/9.
 */
@Controller
public class ProductController {
    private static final Log log = LogFactory.getLog(ProductController.class);

    @Autowired
    private ProductService productService;
    @Autowired
    private ProductMaterialRelationService productMaterialRelationService;
    @Autowired
    private PcertificateService pcertificateService;
    @Autowired
    private PloanService ploanService;
    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private ManagerService managerService;

    //1、新增方案
    @RequestMapping(value = "/a/u/product", method = RequestMethod.POST)
    public String addProductJson(HttpServletRequest request, HttpServletResponse response,
                                 ModelMap model, String product, String material,
                                 String certificate, String loan)
            throws Exception {
        log.info("add product : product= " + product);
        log.info(" add  material  =  "+material);
        log.info(" add  certificate  =  "+certificate);
        log.info(" add  loan  =  "+loan);


        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Product p = GsonUtil.fromJson(product,Product.class);

            p.setId(null);
            //增加产品--判断产品非空字段
            if (DataUtils.isNullOrEmpty(p)
                    || DataUtils.isNullOrEmpty(p.getType())
                    || DataUtils.isNullOrEmpty(p.getRecommendFlag())
                    || DataUtils.isNullOrEmpty(p.getStatus())
                    || DataUtils.isNullOrEmpty(p.getChannel())
                    || DataUtils.isNullOrEmpty(p.getFirstLowerPercent())
                    || DataUtils.isNullOrEmpty(p.getFirstUpperPercent())
                    || DataUtils.isNullOrEmpty(p.getLoanLowerLimit())
                    || DataUtils.isNullOrEmpty(p.getLoanUpperLimit())
                    || DataUtils.isNullOrEmpty(p.getVisit())
                    || DataUtils.isNullOrEmpty(p.getSpouseFlag())
                    || DataUtils.isNullOrEmpty(p.getName())
                    || DataUtils.isNullOrEmpty(p.getRegion())
                    || DataUtils.isNullOrEmpty(p.getAliases())) {
                model.addAttribute("code", -30003);
                return "/common/success";
            }

            if(DataUtils.isNullOrEmpty(material)){
                model.addAttribute("code", -30006);
                return "/common/success";
            }
            p.setCreateBy(Long.valueOf(userId));

            //增加规则--取出所有规则数据
            AllProductMeteRelationParam allProductMeteRelationParam = GsonUtil.fromJson(material, AllProductMeteRelationParam.class);
            //遍历，取出每条规则
            List<ProductMeteRelationParam> allProductMaterialRelationList = allProductMeteRelationParam.getAllList();
            //规则条数
            int roleCount = allProductMaterialRelationList.size();

            List<ProductMaterialRelation>  productMaterialRelations = new ArrayList<>();
            for(int i=0;i<roleCount;i++){
                ProductMeteRelationParam a = allProductMaterialRelationList.get(i);
                //保存每条规则
                if(a.getList().size()<=0){
                    model.addAttribute("code", -30007);
                    return "/common/success";
                }
            }
            Long pid = productService.insert(p);

            log.info("  roleCount  = "+roleCount);
            for(int i=0;i<roleCount;i++){
                ProductMeteRelationParam a = allProductMaterialRelationList.get(i);
                List<ProductMaterialRelation>  ProductMaterialRelationList =  a.getList();
                log.info(" ProductMaterialRelationList  size =   "+ProductMaterialRelationList.size());
                for(ProductMaterialRelation productMaterialRelation : ProductMaterialRelationList){
                    log.info("  getConstantName  = "+productMaterialRelation.getConstantName());
                    log.info("  getMaterialName  = "+productMaterialRelation.getMaterialName());

                    if(DataUtils.isNullOrEmpty(productMaterialRelation.getConstantName())
                            ||DataUtils.isNullOrEmpty(productMaterialRelation.getMaterialName())){
                        model.addAttribute("code",-1000);
                        return "/common/success";
                    }
                    productMaterialRelation.setProductId(pid+"");
                    productMaterialRelation.setParentType(i + "");
                    productMaterialRelations.add(productMaterialRelation);
                }


            }


            //添加每一条规则
            productMaterialRelationService.insertList(productMaterialRelations);
            Product product1 = productService.getObjectById(pid);
            product1.setRoleCount(Long.valueOf(roleCount));
            productService.update(product1);

            Boolean spouseFlag = !p.getSpouseFlag().equals("0");//true  需要
            log.info(" spouseFlag = "+spouseFlag);
            Boolean spouseCertificate = false;
            //增加证件--上传证件资料
            List<Pcertificate> pcertificates = new ArrayList<>();
            ProductCertificateRelationParam productCertificateRelationParam = GsonUtil.fromJson(certificate, ProductCertificateRelationParam.class);
            List<Pcertificate> productCertificateRelationList = productCertificateRelationParam.getList();

            if(productCertificateRelationList.size()<=0){
               model.addAttribute("code",-30005);
                return  "/common/success";
            }
            for (Pcertificate productCertificateRelation : productCertificateRelationList) {
                if (DataUtils.isNullOrEmpty(productCertificateRelation)
                        || DataUtils.isNullOrEmpty(productCertificateRelation.getPersonnelType())
                        || DataUtils.isNullOrEmpty(productCertificateRelation.getCertificateName())
                        ) {
                    model.addAttribute("code", -1004);
                    return "/common/success";
                }
                if(spouseFlag){
                    if(Customer.s_personnelType.toString().equals(productCertificateRelation.getPersonnelType())){
                        spouseCertificate = true;
                    }
                }
                String certificateNames = productCertificateRelation.getCertificateName();
                log.info("  certificateNames = "+certificateNames);
                if(StringUtil.isNotEmpty(certificateNames)){
                    log.info(" certificateNames is not null  ");
                    String[] certificateNameList = certificateNames.split(";");
                    for (String certificateName : certificateNameList) {
                        String[] cNameArr =  certificateName.split(",");

                        Pcertificate pcertificate = new Pcertificate();
                        pcertificate.setProductId(pid + "");
                        pcertificate.setCertificateName(cNameArr[0]);
                        pcertificate.setRequired(Integer.valueOf(cNameArr[1]));
                        pcertificate.setPersonnelType(productCertificateRelation.getPersonnelType());
                        pcertificates.add(pcertificate);
                    }
                }

            }
            if(spouseFlag){
                if(!spouseCertificate){
                    model.addAttribute("code",-30004);
                    return "/common/success";
                }
            }


            pcertificateService.insertList(pcertificates);

            //增加放款资料--上传放款资料列表
            List<Ploan>  ploanList = new ArrayList<>();
           String[] loanNameArr = loan.split(",");
            if(loan.length()>0){
                for(String loanName : loanNameArr){
                    Ploan ploan = new Ploan();
                    ploan.setProductId(pid);
                    ploan.setLoanName(loanName);
                    ploan.setCreateBy(Long.valueOf(userId));
                    ploanList.add(ploan);
                }

            }
            ploanService.insertList(ploanList);


            model.addAttribute("code",0);
            return "/common/success";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add product error ");
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //2、修改方案
    @RequestMapping(value = "/a/u/product", method = RequestMethod.PUT)
    public String updateProductJson(HttpServletRequest request, HttpServletResponse response,
                                    ModelMap model, String product, String material, String certificate,String loan)
            throws Exception {
        log.info("update product : product,material,certificate= " + product + material + certificate);
        String uid =  cookieUtil.getKeyIdentity(request,CookieUtil.USER_ID);
        try {
            Product pro = null; Product p=null;
            if(StringUtil.isNotEmpty(product)){
                ObjectMapper objectMapper = new ObjectMapper();
                pro = objectMapper.readValue(product,Product.class);
                if(null != product && null!= pro.getId()){
                    p = productService.getObjectById(pro.getId());
                }
            }else{
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            if ( DataUtils.isNullOrEmpty(pro.getType())
                    || DataUtils.isNullOrEmpty(pro.getRecommendFlag())
                    || DataUtils.isNullOrEmpty(pro.getStatus())
                    || DataUtils.isNullOrEmpty(pro.getChannel())
                    || DataUtils.isNullOrEmpty(pro.getFirstLowerPercent())
                    || DataUtils.isNullOrEmpty(pro.getFirstUpperPercent())
                    || DataUtils.isNullOrEmpty(pro.getLoanLowerLimit())
                    || DataUtils.isNullOrEmpty(pro.getLoanUpperLimit())
                    || DataUtils.isNullOrEmpty(pro.getVisit())
                    || DataUtils.isNullOrEmpty(pro.getSpouseFlag())
                    || DataUtils.isNullOrEmpty(pro.getName())
                    || DataUtils.isNullOrEmpty(pro.getRegion())
                    || DataUtils.isNullOrEmpty(pro.getAliases())) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            log.info("  metarial = "+material);
            if(DataUtils.isNullOrEmpty(material)){
                model.addAttribute("code", -30006);
                return "/common/success";
            }
            Boolean spouseFlag = !pro.getSpouseFlag().equals("0");//true  需要
            log.info(" spouseFlag = "+spouseFlag);
            Boolean spouseCertificate = false;
            //修改--判断product字段
            if(DataUtils.isNullOrEmpty(p)){
                model.addAttribute("code",-30001);
                return "/common/success";
            }
            Long pid = p.getId();
            if (DataUtils.isNullOrEmpty(pro)|| DataUtils.isNullOrEmpty(pro.getId()) || DataUtils.isNullOrEmpty(pro.getType())

                    ||DataUtils.isNullOrEmpty(pro.getStatus())
                    ||DataUtils.isNullOrEmpty(material)||DataUtils.isNullOrEmpty(certificate)) {
                log.info("product ： "+pro);
                log.info("mateiral: "+material);
                log.info("certificate: "+certificate);
                model.addAttribute("code", -1004);
                return "/common/success";
            }
            //如果产品字段符合要求，则修改产品

            //修改--判断产品-规则关系表要求的字段
            ObjectMapper objectMapper = new ObjectMapper();
            AllProductMeteRelationParam allProductMeteRelationParam = objectMapper.readValue(material, AllProductMeteRelationParam.class);
            List<ProductMeteRelationParam> allProductMaterialRelationList = allProductMeteRelationParam.getAllList();

            int roleCount = allProductMaterialRelationList.size();
            log.info("allProductMaterialRelationList.size() =  " + allProductMaterialRelationList.size());



            //判断非空
            for (ProductMeteRelationParam productMeteRelationParam : allProductMaterialRelationList) {
                if(productMeteRelationParam.getList().size()<=0){
                    model.addAttribute("code", -30007);
                    return "/common/success";
                }
                for (ProductMaterialRelation oneProductMaterialRelation : productMeteRelationParam.getList()) {
                    if (
                            DataUtils.isNullOrEmpty(oneProductMaterialRelation.getMaterialName())
                            || DataUtils.isNullOrEmpty(oneProductMaterialRelation.getConstantName())
                            ) {
                        model.addAttribute("code", -1004);
                        return "/common/success";
                    }
                }
            }
            pro.setRoleCount(Long.valueOf(roleCount));
            //如果规则各字段符合要求，则删除数据库里对应的规则，然后插入新规则
            List<Long> idList = productMaterialRelationService.getProductMaterialRelationIdsByPid(pro.getId(), 0, Integer.MAX_VALUE);
            productMaterialRelationService.deleteList(ProductMaterialRelation.class,idList);


            //插入新规则
            List<ProductMaterialRelation>  productMaterialRelations = new ArrayList<>();
            for(int i=0;i<roleCount;i++){
                ProductMeteRelationParam a = allProductMaterialRelationList.get(i);
                //保存每条规则
                List<ProductMaterialRelation>  ProductMaterialRelationList =  a.getList();
                for(ProductMaterialRelation productMaterialRelation : ProductMaterialRelationList){
                    if(DataUtils.isNullOrEmpty(productMaterialRelation.getConstantName())
                            ||DataUtils.isNullOrEmpty(productMaterialRelation.getMaterialName())){
                        model.addAttribute("code",-1000);
                        return "/common/success";
                    }


                    productMaterialRelation.setProductId(pid+"");
                    productMaterialRelation.setParentType(i + "");
                    productMaterialRelation.setCreateBy(Long.valueOf(uid));
                    productMaterialRelation.setUpdateBy(Long.valueOf(uid));
                    productMaterialRelations.add(productMaterialRelation);
                }


            }

            //添加每一条规则
            productMaterialRelationService.insertList(productMaterialRelations);



            //修改--判断申请资料字段
            List<Pcertificate> pcertificates = new ArrayList<>();
            ProductCertificateRelationParam productCertificateRelationParam = objectMapper.readValue(certificate, ProductCertificateRelationParam.class);

            List<Pcertificate> productCertificateRelationList = productCertificateRelationParam.getList();
            log.info("productCertificateRelationList   " + productCertificateRelationList.size());
            for (Pcertificate productCertificateRelation : productCertificateRelationList) {
                //判断Pcertificate字段
                if (DataUtils.isNullOrEmpty(productCertificateRelation.getPersonnelType())
                        || DataUtils.isNullOrEmpty(productCertificateRelation.getCertificateName())
                       ) {
                    model.addAttribute("code", -1004);
                    return "/common/success";
                }
                if(spouseFlag){
                    if(Customer.s_personnelType.toString().equals(productCertificateRelation.getPersonnelType())){
                        spouseCertificate = true;
                    }
                }
                //获取Pcertificate的id
               List<Long> pcerIds = pcertificateService.getIdsByProductId(pid+"",0,Integer.MAX_VALUE);
                pcertificateService.deleteList(Pcertificate.class, pcerIds);
                //插入新资料
                String certificateNames = productCertificateRelation.getCertificateName();
                log.info("  certificateNames = "+certificateNames);
                if(StringUtil.isNotEmpty(certificateNames)){
                    log.info(" certificateNames is not null  ");
                    String[] certificateNameList = certificateNames.split(";");
                    for (String certificateName : certificateNameList) {
                        String[] cNameArr =  certificateName.split(",");

                        Pcertificate pcertificate = new Pcertificate();
                        pcertificate.setProductId(pid + "");
                        pcertificate.setCertificateName(cNameArr[0]);
                        pcertificate.setRequired(Integer.valueOf(cNameArr[1]));
                        pcertificate.setPersonnelType(productCertificateRelation.getPersonnelType());
                        pcertificate.setCreateBy(Long.valueOf(uid));
                        pcertificate.setUpdateBy(Long.valueOf(uid));
                        pcertificates.add(pcertificate);
                    }
                }


            }
            if(spouseFlag){
                if(!spouseCertificate){
                    model.addAttribute("code",-30004);
                    return "/common/success";
                }
            }
            pcertificateService.insertList(pcertificates);




            //删除放款资料
            List<Long> oldPloanIds =  ploanService.getPloanIdsByProductIdOrderByUpdateAt(pid, 0, Integer.MAX_VALUE);
            ploanService.deleteList(Ploan.class, oldPloanIds);

            //增加放款资料--上传放款资料列表
            List<Ploan>  ploanList = new ArrayList<>();
            String[] loanNameArr = loan.split(",");
            if(loan.length()>0){
                for(String loanName : loanNameArr){
                    Ploan ploan = new Ploan();
                    ploan.setProductId(pid);
                    ploan.setLoanName(loanName);
                    ploan.setCreateBy(Long.valueOf(uid));
                    ploan.setUpdateBy(Long.valueOf(uid));
                    ploanList.add(ploan);
                }

            }
            ploanService.insertList(ploanList);
            //更新方案
            productService.update(pro);
            log.info("update : " + pro);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
//            log.error("update product error,id is  " + p.getId());
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //3、删除方案
    @RequestMapping(value = "/a/u/product/{id}", method = RequestMethod.DELETE)
    public String deleteProductJson(HttpServletRequest request, HttpServletResponse response,
                                    ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("delete product : id= " + id);
        try {
            Product product = productService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(product)){
                model.addAttribute("code",-1000);
                return "/common/success";
            }

            //删除规则
            List<Long> pmIds =  productMaterialRelationService.getProductMaterialRelationIdsByPid(id,0,Integer.MAX_VALUE);
            log.info("productMaterialRelationIds  size  =  "+pmIds.size());
            if(pmIds.size()>0){
                productMaterialRelationService.deleteList(ProductMaterialRelation.class, pmIds);
            }
            //删除申请资料
            List<Long> pcerIds = pcertificateService.getIdsByProductId(id + "", 0, Integer.MAX_VALUE);
            log.info(" pcertificate   size  ="+pcerIds.size());
            if(pcerIds.size()>0){
                pcertificateService.deleteList(Pcertificate.class,pcerIds);
            }
            //删除放款资料
            List<Long> loanIds = ploanService.getPloanIdsByProductIdOrderByUpdateAt(id,0,Integer.MAX_VALUE);
            log.info("  loanIds size = " + loanIds.size());
            if(loanIds.size()>0){
                ploanService.deleteList(Ploan.class,loanIds);
            }

            //删除方案
            productService.delete(id);
            model.addAttribute("code",0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete product error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }

    //4、根据id查询单个方案详情
    @RequestMapping(value = "/a/u/product/{id}", method = RequestMethod.GET)
    public String getProductJson(HttpServletRequest request, HttpServletResponse response,
                                 ModelMap model, @PathVariable Long id)
            throws Exception {
        log.info("get data : id= " + id);
        try {
            Product product = productService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(product)){
                model.addAttribute("code",-30001);
                return "/common/success";
            }
            //查询规则
            List<List>  metarial = new ArrayList<>();
            Long roleCount = product.getRoleCount();
            for(int i=0;i<roleCount;i++){

                List<Long> pmIds =  productMaterialRelationService.
                        getProductMaterialRelationIdsByPidAndParent(id,i+"",0,Integer.MAX_VALUE);
                List<ProductMaterialRelation>  productMaterialRelationList = productMaterialRelationService.
                        getObjectsByIds(pmIds);
                metarial.add(productMaterialRelationList);
            }
            model.addAttribute("metarial", metarial);
            List<CertificateResult>  certificateResults = new ArrayList<>();
            //查询借款人申请资料
              if( DataUtils.isNotNullOrEmpty( getCertificateName(id,Customer.c_personnelType+"")) ){
                  certificateResults.add(getCertificateName(id,Customer.c_personnelType+""));
              }
            //查询配偶申请资料
            if( DataUtils.isNotNullOrEmpty( getCertificateName(id,Customer.s_personnelType+"")) ){
                certificateResults.add(getCertificateName(id, Customer.s_personnelType + ""));
            }

            //查询放款资料

            List<Long> ploanIds =  ploanService.getPloanIdsByProductIdOrderByUpdateAt(id, 0, Integer.MAX_VALUE);
            List<Ploan> ploanList = ploanService.getObjectsByIds(ploanIds);
            StringBuilder loanNames = new StringBuilder();
            for(int i =0;i<ploanList.size();i++){
                if(i==ploanIds.size()-1){
                    loanNames.append(ploanList.get(i).getLoanName());
                }else{
                    loanNames.append(ploanList.get(i).getLoanName()+",");
                }
            }
            model.addAttribute("code", 0);
            model.addAttribute("product", product);
            model.addAttribute("metarial",metarial);
            model.addAttribute("certificate", certificateResults);
            model.addAttribute("loan",loanNames);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get product error,id is  " + id);

            model.addAttribute("code", -1);
            return "/common/success";
        }
        return "/common-carjn-service/product/json/productDetailJson";

    }

    //5、查询方案列表
    @RequestMapping(value = "/a/u/product/", method = RequestMethod.GET)
    public String getProductJsonList(HttpServletRequest request, HttpServletResponse response,
                                     ModelMap model, Integer page, Integer size,
                                     Long startAt,Long endAt,String productType,String status,
                                     Long channel,String firstPercent,
                                     String loanLimit)
            throws Exception {
        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }
        log.info("pageList : page= " + start + " , size=" + size);
        try {
            Boolean next = false;
            size += 1;
            List<Long> ids = new ArrayList<>();
            if(DataUtils.isNotNullOrEmpty(startAt)||DataUtils.isNotNullOrEmpty(endAt)
                    ||DataUtils.isNotNullOrEmpty(productType)||DataUtils.isNotNullOrEmpty(status)
                    ||DataUtils.isNotNullOrEmpty(channel)||DataUtils.isNotNullOrEmpty(firstPercent)
                    ||DataUtils.isNotNullOrEmpty(loanLimit)
                    ){
              List<Product> productList = ProductUtil.getProductIdsByCondition(start, size, startAt, endAt, productType, status, channel, firstPercent,loanLimit);
                for(Product product : productList){
                    ids.add(product.getId());
                }
            }else{
                ids = productService.getProductIds(start, size);

            }


            log.info("get product size is " + ids.size());
            if (ids != null && ids.size() > 0) {
                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  " + ids.subList(0, size - 1));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                }else{
                    log.info("ss  " + ids.subList(0, ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }

            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get product list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }
        return "/common-carjn-service/product/json/productListJson";
    }

    //6、批量查询
    @RequestMapping(value = "/a/u/multi/product", method = RequestMethod.GET)
    public String getMultiProductJson(HttpServletRequest request, HttpServletResponse response,
                                      ModelMap model, Long[] ids) throws Exception {
        List<Long> idList = new ArrayList();

        if (ids == null|| ids.length<=0) {
            model.addAttribute("code", 0);
            model.addAttribute("total", 0);
            model.addAttribute("size", 10);
            model.addAttribute("productList", "");
            model.addAttribute("channelMap","");
            model.addAttribute("managerMap","");
            return "/common-carjn-service/product/json/productMultiListJson";
        } else {
            idList = Arrays.asList(ids);
        }
        try {
            List<Product> productList = productService.getObjectsByIds(idList);
            log.info("  productList size = "+productList.size());
            Map<Long,String>  channelMap = new HashMap<>();
            Map<Long,String>  managerMap = new HashMap<>();
            List<Long> channelIds = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.TYPE_CHANNEL,0,Integer.MAX_VALUE);
            List<Constant> channelList = constantService.getObjectsByIds(channelIds);

            if(productList.size()>0){
                for(Product product : productList){
                    log.info(" product id = "+product.getId());
                    if(channelList.size()>0){
                        for(Constant channel : channelList){
                            if(product.getChannel().equals(channel.getId())){
                                channelMap.put(product.getId(),channel.getName());
                            }
                        }
                    }
                    log.info("  product createBy = "+product.getCreateBy());
                    if(DataUtils.isNotNullOrEmpty(product.getCreateBy())){
                        Manager manager=   managerService.getObjectById(product.getCreateBy());
                        log.info("  manager = "+manager);
                        managerMap.put(product.getId(), manager.getName());
                    }
                }

            }




            log.info("get  product data is " + productList.size());
            model.addAttribute("code", 0);
            model.addAttribute("total", productList.size());
            model.addAttribute("productList", productList);
            model.addAttribute("channelMap",channelMap);
            model.addAttribute("managerMap",managerMap);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get product error,id is  " + idList);
            model.addAttribute("code", -1);
        }
        return "/common-carjn-service/product/json/productMultiListJson";
    }



    public  CertificateResult getCertificateName(Long pid,String personnelType)throws Exception{
        CertificateResult certificateResult = new CertificateResult();
        List<Long> cusCertiIds =  pcertificateService.getPcertificateIdsByProductIdAndPersonnelTypeOrderByUpdateAt
                (pid+"",personnelType,0,Integer.MAX_VALUE);
        log.info(" cusCertiIds  size =" + cusCertiIds.size());
        if (cusCertiIds.size()>0){
            StringBuilder  c = new StringBuilder();
            List<Pcertificate>  cusPcertificateList = pcertificateService.getObjectsByIds(cusCertiIds);
            for(int i =0;i<cusPcertificateList.size();i++){
                if(i==cusPcertificateList.size()-1){
                    c.append(cusPcertificateList.get(i).getCertificateName()+","+cusPcertificateList.get(i).getRequired());
                }else{
                    c.append(cusPcertificateList.get(i).getCertificateName()+","+cusPcertificateList.get(i).getRequired()+";");
                }
            }
            certificateResult.setDocumentName(c+"");
        }
        certificateResult.setPersonnelType(personnelType+ "");
        if(cusCertiIds.size()<=0){
            return null;
        }
        return certificateResult;
    }
}
