package com.ptteng.common.carjn.controller;

import com.ptteng.model.PtypePermatrialParam;
import com.qding.common.util.http.cookie.CookieUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.*;
import com.ptteng.common.carjn.service.ConstantService;
import com.ptteng.common.carjn.service.MaterialService;
import com.ptteng.common.carjn.service.PermetarialService;
import com.ptteng.model.ProductMeteRelationParam;
import com.ptteng.util.CertificateUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;


import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.util.*;

/**
 * Created by ruan on 2015/12/16.
 */
@Controller
public class PerMaterialController {
    private static final Log log = LogFactory.getLog(PerMaterialController.class);
    @Autowired
    private PermetarialService permetarialService;
    @Autowired
    private MaterialService materialService;
    @Autowired
    private ConstantService constantService;

    @Autowired
    private CookieUtil cookieUtil;

    //列表查询
    @RequestMapping(value = "/a/u/per/metarial/", method = RequestMethod.GET)
    public String getPerMaterialList(HttpServletRequest request, HttpServletResponse response,
                                     ModelMap model) throws Exception {
        try {
            log.info(" /a/u/perMaterial/ ");
            List<PtypePermatrialParam>  list = new ArrayList<>();
            for(int i=0;i<3;i++){
                for(int j=0;j<3;j++){
                    PtypePermatrialParam ptypePermatrialParam = new PtypePermatrialParam();
                    ptypePermatrialParam.setProductType(i + "");
                    ptypePermatrialParam.setPersonnelType(j+"");
                 List<Long> ids =   permetarialService.getPermetarialIdsByPersonnelTypeOrderByUpdateAt
                            (i+"",j+"",0,Integer.MAX_VALUE);
                    List<Permetarial> permetarialList = permetarialService.getObjectsByIds(ids);
                    Set<String>  constantNames = new HashSet<>();
                    for (int k=0;k<permetarialList.size();k++) {

                        //取得material的id
                        Long materialId = permetarialList.get(k).getMetarialId();
                        log.info(" materialId  = "+ materialId);
                        Material material0 = materialService.getObjectById(materialId);
                        if(DataUtils.isNotNullOrEmpty(material0)){
                            log.info("  material0  ="+material0);
                            //取得constant的id
                            Long constantId = material0.getMetarialName();
                            if(DataUtils.isNotNullOrEmpty(constantId)){
                                log.info("  material0  ="+constantId);

                                Constant constant0 = constantService.getObjectById(constantId);
                                if(DataUtils.isNotNullOrEmpty(constant0)){
                                    log.info("  constant0  ="+constant0);

                                    String constantName = constant0.getName();
                                    constantNames.add(constantName);
                                }
                            }
                        }

                    }
                    ptypePermatrialParam.setNames(constantNames.toString());
                    list.add(ptypePermatrialParam);
                }
            }
            model.addAttribute("code",0);
            model.addAttribute("list",list);


        } catch (Throwable t) {
            log.error(t.getMessage());
            model.addAttribute("code", -1);
            return "/common/success";
        }
        return "/common-carjn-service/perMaterial/json/perMaterialListJson";
    }


    //修改
    @RequestMapping(value = "/a/u/per/metarial", method = RequestMethod.PUT)
    public String updatePerMaterial(HttpServletRequest request, HttpServletResponse response,
                                    ModelMap model,String productType, String personnelType, String material) throws Exception {

        log.info("update personnelMaterial : personnelType is :" + personnelType+" metarial = "+material );

        String uid = cookieUtil.getKeyIdentity(request, com.gemantic.common.util.http.cookie.CookieUtil.USER_ID);
        try {
            if(DataUtils.isNullOrEmpty(personnelType)){
                model.addAttribute("code",-1000);
                return "/common/success";
            }



            List<Long>  mIds = new ArrayList<>();
            ProductMeteRelationParam productMeteRelationParam = GsonUtil.
                    fromJson(material,ProductMeteRelationParam.class);

            List<ProductMaterialRelation>  list = productMeteRelationParam.getList();

            if(list.size()>0){

                //根据personnelType，找到permaterial表中对应的material_id
                List<Long> ids = permetarialService.getPermetarialIdsByPersonnelTypeOrderByUpdateAt(productType,personnelType, 0, Integer.MAX_VALUE);
                //删除相关记录
                log.info(ids);
                permetarialService.deleteList(Permetarial.class, ids);



                for(ProductMaterialRelation productMaterialRelation : list){
                    String metarialName = productMaterialRelation.getConstantName();
                    Long metarialId =  constantService.getConstantIdByNameAndType
                            (metarialName,Constant.TYPE_METARIAL);


                    log.info(" metarialId = "+metarialId);
                    String[] values = productMaterialRelation.getMaterialName().split(",");
                    for(String value : values){
                        Long valueId =  constantService.getConstantIdByNameAndType
                                (value,Constant.TYPE_METARIAL_VALUE);
                        log.info(" valueId =  "+valueId);
                        Long mId =  materialService.getIdBymetNameAndValueName(metarialId,valueId);

                        mIds.add(mId);
                    }

                }
                List<Permetarial> permetarialList = new ArrayList<>();
                for(Long mid : mIds){
                    Permetarial permetarial = new Permetarial();
                    permetarial.setProductType(productType);
                    permetarial.setPersonnelType(personnelType);
                    permetarial.setMetarialId(mid);
                    permetarial.setCreateBy(Long.valueOf(uid));
                    permetarial.setUpdateBy(Long.valueOf(uid));
                    permetarialList.add(permetarial);
                }

                permetarialService.insertList(permetarialList);
            }



            model.addAttribute("code", 0);
            return "/common/success";
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update personnelMaterial error,personnnelType is  " + personnelType);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }




    /**
     * 查询条件列表
     *
     * @param request
     * @param response
     * @param model
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/personnel/metarial", method = RequestMethod.GET)
    public String getManagerJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                     String productType,
                                     String personnelType
                                    ) throws Exception {
        log.info(" personnelType = " + personnelType );


        log.info("personnelType " + personnelType );

        try {
            if(DataUtils.isNullOrEmpty(productType)){
                model.addAttribute("code",-1000);
                return "/common/success";
            }
            if(DataUtils.isNullOrEmpty(personnelType)){
                model.addAttribute("code",-1000);
                return "/common/success";
            }

            List<ProductMaterialRelation> list = new ArrayList<>();

            List<Long>  metarialAllIds = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.TYPE_METARIAL, 0, Integer.MAX_VALUE);
            List<Constant>  metarialAllList = constantService.getObjectsByIds(metarialAllIds);

            log.info(" metarialAllList   size =   "+metarialAllList.size());
            List<Long> perMIds =  permetarialService.getPermetarialIdsByPersonnelTypeOrderByUpdateAt
                    (productType,personnelType, 0, Integer.MAX_VALUE);
            log.info(" perMIds   size  = "+perMIds.size());

            List<Permetarial> permetarialList = permetarialService.getObjectsByIds(perMIds);
            log.info(" permetarialList size =    "+permetarialList.size());
            List<Long> metarialIds = new ArrayList<>();

            for(Permetarial permetarial : permetarialList){
                metarialIds.add(permetarial.getMetarialId());
            }
            log.info(" metarialIds   size =   "+metarialIds.size());
            List<Material> materialList = materialService.getObjectsByIds(metarialIds);
            log.info("  materialList  size  = "+materialList.size());

            for(Constant  metarial : metarialAllList){
                Boolean  yes = false;
                StringBuilder metarialValues = new StringBuilder();
                for(int i=0;i<materialList.size();i++){
                    if(materialList.get(i).getMetarialName().equals(metarial.getId())){
                        yes = true;
                        Constant metarialValue = constantService.getObjectById(materialList.get(i).getMetarialValueName());
                       if(i==materialList.size()-1){
                           metarialValues.append(metarialValue.getName());
                       }else{
                           metarialValues.append(metarialValue.getName()+",");
                       }
                    }
                    log.info(" metarialValues  = "+metarialValues);
                }
                if(yes){
                    ProductMaterialRelation productMaterialRelation = new ProductMaterialRelation();
                    productMaterialRelation.setConstantName(metarial.getName());
                    productMaterialRelation.setMaterialName(metarialValues.toString());
                    list.add(productMaterialRelation);

                }

            }

            log.info("  list size  = "+list.size());


            model.addAttribute("code", 0);
            model.addAttribute("productType", productType);
            model.addAttribute("personnelType",personnelType);
            model.addAttribute("list",list);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get permetarial list error,personnelType is  " +personnelType );
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/perMaterial/json/yy";
    }






}