package com.ptteng.common.carjn.controller;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import com.lowagie.text.*;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


/**
 * Created by liangxj on 2016/2/26.
 */
public class PdfTest {
    private static final Log log = LogFactory.getLog(IndentControler.class);

    private static Font keyfont;// 设置字体大小

    public File Pdf(List<String> imagePathList , String mOutputPdfFileName) {
        Document doc = new Document(PageSize.A4, 40, 40, 40, 40);
        try {
            PdfWriter writer = PdfWriter.getInstance(doc, new FileOutputStream(
                    mOutputPdfFileName));
            doc.open();


            for(String  imagePath  : imagePathList){
                log.info("   imagePath  = "+imagePath);
                doc.newPage();
                Image png1 = Image.getInstance(imagePath);
                float heigth = png1.getHeight();
                float width = png1.getWidth();
                int percent = this.getPercent2(heigth, width);
                png1.setAlignment(Image.MIDDLE);
                png1.setAlignment(Image.TEXTWRAP);
                png1.scalePercent(percent + 3);
                doc.add(png1);
            }


            doc.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        File mOutputPdfFile = new File(mOutputPdfFileName);
        if (!mOutputPdfFile.exists()) {
            mOutputPdfFile.deleteOnExit();
            return null;
        }
        return mOutputPdfFile;
    }


    private int getPercent2(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 420 / w * 100;
        p = Math.round(p2);
        return p;
    }





    public  void writeSimplePdf(String url) throws Exception {

        // 1.新建document对象
        // 第一个参数是页面大小。接下来的参数分别是左、右、上和下页边距。
        Document document = new Document(PageSize.A4, 50, 50, 50, 50);

        // 2.建立一个书写器(Writer)与document对象关联，通过书写器(Writer)可以将文档写入到磁盘中。
        // 创建 PdfWriter 对象 第一个参数是对文档对象的引用，第二个参数是文件的实际名称，在该名称中还会给出其输出路径。
        PdfWriter writer = PdfWriter.getInstance(document, new FileOutputStream(url));
// 3.打开文档
        document.open();

        // 4.向文档中添加内容
        // 通过 com.lowagie.text.Paragraph 来添加文本。可以用文本及其默认的字体、颜色、大小等等设置来创建一个默认段落
        document.add(new Paragraph(" "));

        // 5.关闭文档
        document.close();
    }






    public static void main(String[] args) {



        PdfTest gp = new PdfTest();


        try {
            String url =    "C:\\1-my-ppteng\\ITextTest20.pdf";
            gp.writeSimplePdf(url);
            String pdfUrl = url;
            List<String> ll = new ArrayList<>();
            ll.add("http://online-carjn.kssws.ks-cdn.com/shuiyin/4bc8a955-476c-4fa2-95be-ff8bd5fe8e92.png");
            ll.add("http://online-carjn.kssws.ks-cdn.com/shuiyin/4bc8a955-476c-4fa2-95be-ff8bd5fe8e92.png");
            ll.add("http://online-carjn.kssws.ks-cdn.com/shuiyin/4bc8a955-476c-4fa2-95be-ff8bd5fe8e92.png");

            ll.add("http://online-carjn.kss.ksyun.com/1/1456637447260.jpg ");

            File file = gp
                    .Pdf(ll,pdfUrl);
            file.createNewFile();
        } catch (IOException e) {
            e.printStackTrace();
        }catch (Exception e){
            e.printStackTrace();
        }


    }



}
