package com.ptteng.common.carjn.controller;

import com.ksyun.ks3.dto.ObjectListing;
import com.ptteng.common.carjn.model.Manager;
import com.ptteng.common.carjn.model.Material;
import com.ptteng.common.carjn.service.ManagerService;
import com.ptteng.common.carjn.service.MaterialService;
import com.ptteng.util.CertificateUtil;
import com.qding.common.util.http.cookie.CookieUtil;
import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.service.ConstantService;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.Data;
import java.nio.LongBuffer;
import java.util.*;

/**
 * Created by liangxj on 2015/12/7.
 */
@Controller
public class MetarialControler {

    private static final Log log = LogFactory.getLog(MetarialControler.class);

    @Autowired
    private ConstantService constantService;

    @Autowired
    private MaterialService materialService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private CookieUtil cookieUtil;


    //父类列表查询
    @RequestMapping(value = "/a/u/metarial/type/", method = RequestMethod.GET)
    public String getConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model)
            throws Exception {

        log.info("get metarial type ");
        try {
            List<Long> metarialTypeIds = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.metarialType, 0, Integer.MAX_VALUE);
            List<Constant> metarialTypeList = constantService.getObjectsByIds(metarialTypeIds);

            model.addAttribute("total", metarialTypeList.size());

            model.addAttribute("constantList", metarialTypeList);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get metarial type  error");
            model.addAttribute("code", -1);
            return "/common/success";

        }
        return "/common-carjn-service/channel/json/channelMultiListJson";

    }


    //条件管理--新增
    @RequestMapping(value = "/a/u/metarial", method = RequestMethod.POST)
    public String addConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Long parentTypeId,
                                  String name, String status,
                                  String values) throws Exception {

        log.info("update constant : parentTypeId= " + parentTypeId + " , values =" + values + " ,name=" + name);

        try {

            String userId = cookieUtil.getKeyIdentity(request,
                    CookieUtil.USER_ID);
            if (DataUtils.isNullOrEmpty(parentTypeId)
                    || DataUtils.isNullOrEmpty(name)
                    || DataUtils.isNullOrEmpty(values)
                    || DataUtils.isNullOrEmpty(status)) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Long oId = constantService.getConstantIdByNameAndType
                    (name, Constant.TYPE_METARIAL);
            if (DataUtils.isNotNullOrEmpty(oId)) {
                log.info(" oId is = " + oId);
                model.addAttribute("code", -20004);
                return "/common/success";
            }

            Constant parentType = constantService.getObjectById(parentTypeId);
            //新增材料
            Constant metarial = new Constant();
            metarial.setType(Constant.TYPE_METARIAL);
            metarial.setValue(name);
            metarial.setName(name);
            metarial.setStatus(status);
            metarial.setParentType(parentType.getName());
            metarial.setCreateBy(Long.valueOf(userId));
            metarial.setId(null);
            Long id = constantService.insert(metarial);


            String[] metarialValues = values.split(",");
            List<Long> ids = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.TYPE_METARIAL_VALUE, 0, Integer.MAX_VALUE);
            List<Constant> metarialValueList = constantService.getObjectsByIds(ids);
            for (String metarialValue : metarialValues) {
                log.info(" metarialValue =" + metarialValue);
                Boolean exit = false;
                for (Constant constant : metarialValueList) {
                    if (metarialValue.equals(constant.getName())) {
                        log.info("  MetarialValueName =" + constant.getName());
                        log.info(" exit  = " + true);
                        exit = true;
                        Material material = new Material();
                        material.setMetarialName(id);
                        material.setMetarialValueName(constant.getId());
                        material.setCreateBy(Long.valueOf(userId));
                        materialService.insert(material);
                        break;
                    }
                }
                if (!exit) {
                    log.info(" exit  = " + false);
                    Constant constant = new Constant();
                    constant.setType(Constant.TYPE_METARIAL_VALUE);
                    constant.setName(metarialValue);
                    constant.setValue(metarialValue);
                    constant.setCreateBy(Long.valueOf(userId));
                    Long valueId = constantService.insert(constant);
                    Material material = new Material();
                    material.setMetarialName(id);
                    material.setMetarialValueName(valueId);
                    material.setCreateBy(Long.valueOf(userId));
                    materialService.insert(material);
                }
            }


            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add metarial error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }


    /*//条件管理--修改--未完成
    @RequestMapping(value = "/a/u/metarial/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                     @PathVariable Long id, Long parentTypeId, String name, String values,
                                     String status) throws Exception {

        log.info("update constant : metarial id= " + id + " , name=" + name);

        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Constant metarial = constantService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(metarial)) {
                model.addAttribute("code", -20005);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(parentTypeId)
                    || DataUtils.isNullOrEmpty(name)
                    || DataUtils.isNullOrEmpty(values)
                    || DataUtils.isNullOrEmpty(status)) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Constant parentType = constantService.getObjectById(parentTypeId);
            if (DataUtils.isNullOrEmpty(parentType)) {
                model.addAttribute("code", -20006);
                return "/common/success";
            }
            metarial.setName(name);
            metarial.setValue(name);
            metarial.setStatus(status);
            metarial.setParentType(parentType.getName());
            metarial.setUpdateBy(Long.valueOf(userId));
            constantService.update(metarial);

            String[] metarialValues = values.split(",");



            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update metarial error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }
*/

    //条件管理--修改（阮少楠）
    @RequestMapping(value = "/a/u/metarial/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model,
                                     @PathVariable Long id, Long parentTypeId, String name, String values,
                                     String status) throws Exception {
        log.info("update constant : metarial id= " + id + " , name=" + name);

        try {
            String userId = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Constant metarial = constantService.getObjectById(id);
            Long enId =  constantService.getConstantIdByTypeAndValue
                    (Constant.TYPE_METARIAL,name);
            if(DataUtils.isNotNullOrEmpty(enId)){
                if(!enId.equals(metarial.getId())){
                    model.addAttribute("code",-50005);
                    return "/common/success";
                }
            }



            if (DataUtils.isNullOrEmpty(metarial)) {
                model.addAttribute("code", -20005);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(parentTypeId)
                    || DataUtils.isNullOrEmpty(name)
                    || DataUtils.isNullOrEmpty(values)
                    || DataUtils.isNullOrEmpty(status)) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }
            Constant parentType = constantService.getObjectById(parentTypeId);
            //修改value值
            metarial.setParentType(parentType.getName());
            metarial.setValue(name);
            metarial.setStatus(status);
            constantService.update(metarial);
            //解除关系
            List<Long>  metarialIds =  materialService.getMaterialIdsByMetarialNameOrderByUpdateAt
                    (metarial.getId()+"",0,Integer.MAX_VALUE);
            materialService.deleteList(Material.class,metarialIds);

            //判断values
            String[] metarialValues = values.split(",");
            List<Long> ids = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.TYPE_METARIAL_VALUE, 0, Integer.MAX_VALUE);
            List<Constant> metarialValueList = constantService.getObjectsByIds(ids);
            for (String metarialValue : metarialValues) {
                log.info(" metarialValue =" + metarialValue);
                Boolean exit = false;
                for (Constant constant : metarialValueList) {
                    if (metarialValue.equals(constant.getName())) {
                        log.info("  MetarialValueName =" + constant.getName());
                        log.info(" exit  = " + true);
                        exit = true;
                        Material material = new Material();
                        material.setMetarialName(id);
                        material.setMetarialValueName(constant.getId());
                        material.setCreateBy(Long.valueOf(userId));
                        material.setStatus(status);
                        materialService.insert(material);
                        break;
                    }
                }
                if (!exit) {
                    log.info(" exit  = " + false);
                    Constant constant = new Constant();
                    constant.setType(Constant.TYPE_METARIAL_VALUE);
                    constant.setName(metarialValue);
                    constant.setValue(metarialValue);
                    constant.setCreateBy(Long.valueOf(userId));
                    Long valueId = constantService.insert(constant);
                    Material material = new Material();
                    material.setMetarialName(id);
                    material.setMetarialValueName(valueId);
                    material.setCreateBy(Long.valueOf(userId));
                    material.setStatus(status);
                    materialService.insert(material);
                }
            }



                model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update constant error,id is  " + id);
            model.addAttribute("code", -1);
        }
        return "/common/success";
    }


    //删除
    @RequestMapping(value = " /a/u/metarial/{id}", method = RequestMethod.DELETE)
    public String deleteConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete metarial : id= " + id);
        try {
            Constant metarial = constantService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(metarial)) {
                log.info(" metarial =" + metarial);
                model.addAttribute("code", -20005);
                return "/common/success";
            }

            //先删除metarial表中metarial和value的对应数据
            List<Long> metarialValueIds = materialService.getMaterialIdsByMetarialNameOrderByUpdateAt
                    (id + "", 0, Integer.MAX_VALUE);
            log.info(" metrail ids =" + metarialValueIds);
            materialService.deleteList(Material.class, metarialValueIds);

            //删除constant中的metrail
            constantService.delete(id);
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete constant error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    //条件管理--根据ID查找条件详情
    @RequestMapping(value = "/a/u/metarial/{id}", method = RequestMethod.GET)
    public String getSalerJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Constant metarial = constantService.getObjectById(id);
            if (DataUtils.isNullOrEmpty(metarial)) {
                model.addAttribute("code", -20005);
                return "/common/success";
            }
            List<Long> ids = materialService.getMaterialIdsByMetarialNameOrderByUpdateAt
                    (id + "", 0, Integer.MAX_VALUE);
            List<Material> materialList = materialService.getObjectsByIds(ids);
            List<Long> metarialValueIds = new ArrayList<>();
            for (Material material : materialList) {
                metarialValueIds.add(material.getMetarialValueName());
            }
            List<Constant> metarialValues = constantService.getObjectsByIds(metarialValueIds);
            StringBuffer values = new StringBuffer();
            for (int i = 0; i < metarialValues.size(); i++) {
                if (i == metarialValues.size() - 1) {
                    values.append(metarialValues.get(i).getName());
                } else {
                    values.append(metarialValues.get(i).getName() + ",");

                }
            }
            log.info(" values =" + values);
            Long parentId = constantService.getConstantIdByNameAndType(metarial.getParentType(), Constant.metarialType);
            metarial.setParentType(parentId + "");

            model.addAttribute("code", 0);

            model.addAttribute("constant", metarial);
            model.addAttribute("values", values);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get channel error,id is  " + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/metarialDetailJson";
    }

    /**
     * 查询条件列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/metarial/", method = RequestMethod.GET)
    public String getManagerJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page,
                                     Integer size, String parentType, String status, Long startAt, Long endAt) throws Exception {
        log.info(" page = " + page + " , size =" + size + " , parentType =" + parentType + " ,status =" + status);

        if (page == null) {

            page = 1;
        }

        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Boolean next = false;
            size += 1;

            Map<String, Object> map = new HashMap<>();
            if (DataUtils.isNotNullOrEmpty(parentType)) {
                map.put("parent_type", parentType);
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                map.put("status", status);
            }
            if (DataUtils.isNotNullOrEmpty(startAt)) {
                map.put("publish_at", startAt);
            }
            if (DataUtils.isNotNullOrEmpty(endAt)) {
                map.put("publish_at", endAt);
            }
            List<Long> ids;
            if (map.size() > 0) {
                if(DataUtils.isNotNullOrEmpty(parentType)){
                   Constant constant =   constantService.getObjectById(Long.valueOf(parentType));
                    parentType = constant.getName();
                }

                Map<String, Object> map1 = CertificateUtil.getCertificateListParam
                        (startAt, endAt, parentType, status, "'"+Constant.TYPE_METARIAL+"'", false);
                ids = constantService.getIdsByDynamicCondition(Constant.class, map1, start, size);

            } else {
                ids = constantService.getConstantIdsByTypeOrderByUpdateAt(Constant.TYPE_METARIAL, start, size);
            }


            log.info("get metarial size is " + ids.size());

            if (ids != null && ids.size() > 0) {

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  " + ids.subList(0, size - 1));
                    model.addAttribute("ids", ids.subList(0, size - 1));
                } else {
                    log.info("ss  " + ids.subList(0, ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
            } else {
                model.addAttribute("ids", ids);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get channel list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/channelListJson";
    }

    //批量查询条件列表
    @RequestMapping(value = "/a/u/multi/metarial", method = RequestMethod.GET)
    public String getMultiSalerJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Constant> metarialList = constantService.getObjectsByIds(idList);
            log.info("get  metarialList size is " + metarialList.size());

            Map<Long, String> map = new HashMap<>();
            Map<Long, String> valueMap = new HashMap<>();
            for (Constant metarial : metarialList) {
                if (DataUtils.isNotNullOrEmpty(metarial)) {
                    Manager manager = managerService.getObjectById
                            (metarial.getCreateBy());
                    if (DataUtils.isNotNullOrEmpty(manager)) {
                        map.put(metarial.getId(), manager.getName());
                    }

                }

                StringBuilder metarialValues = new StringBuilder();
                List<Long> matrialIds = materialService.getMaterialIdsByMetarialNameOrderByUpdateAt
                        (metarial.getId() + "", 0, Integer.MAX_VALUE);
                List<Material> materialList = materialService.getObjectsByIds(matrialIds);
                List<Long> metarialValueIds = new ArrayList<>();
                for (Material metarialValue : materialList) {
                    metarialValueIds.add(metarialValue.getMetarialValueName());
                }
                log.info(" metarialValueIds  = " + metarialValueIds);
                List<Constant> metarialValueList = constantService.getObjectsByIds(metarialValueIds);
                for (int i = 0; i < metarialValueList.size(); i++) {
                    if (i == metarialValueList.size() - 1) {
                        metarialValues.append(metarialValueList.get(i).getName());
                    } else {
                        metarialValues.append(metarialValueList.get(i).getName() + ",");
                    }
                }
                log.info("  metarialValues  " + metarialValues);
                valueMap.put(metarial.getId(), metarialValues + "");
            }


            model.addAttribute("code", 0);
            model.addAttribute("total", metarialList.size());

            model.addAttribute("constantList", metarialList);
            model.addAttribute("map", map);
            model.addAttribute("valueMap", valueMap);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get channel error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/channel/json/metarialMultiListJson";
    }


}
