package com.ptteng.common.carjn.controller;

import java.util.*;

import javax.annotation.Resource;
import javax.print.attribute.standard.MediaName;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.*;
import com.ptteng.common.carjn.service.ManagerService;
import com.ptteng.common.carjn.service.ProductService;
import com.ptteng.common.carjn.service.RoleProductRelationService;
import com.ptteng.common.carjn.service.RoleService;
import com.ptteng.model.RoleProductRelationParam;
import com.ptteng.util.RegionUtil;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * Manager  crud
 *
 * @author magenm 2014-4-16 13:43
 */
@Controller
public class ManagerController {
    private static final Log log = LogFactory.getLog(ManagerController.class);

    @Autowired
    private ManagerService managerService;
    //	@Autowired
//	private PuserPublicsRelationService puserPublicsRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private RoleProductRelationService roleProductRelationService;

    @Autowired
    private ProductService productService;

    @Resource(name = "managerServiceConfig")
    private Map<String, String> managerServiceConfig;

    @RequestMapping(value = "/web/c/manager", method = RequestMethod.GET)
    public String getPuserList(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model) throws Exception {

        log.info("/web/manager  to /manager/view/managerList");

        return "/manager/view/managerList";
    }

    /**
     * 修改密码
     *
     * @param request
     * @param response
     * @param model
     * @param oldPwd
     * @param newPwd
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/pwd", method = RequestMethod.PUT)
    public String updateManagerPassword(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, String oldPwd, String newPwd) throws Exception {
        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                CookieUtil.USER_ID));
        log.info("do update password params:uid" + uid + ",password=" + oldPwd + ",newpassword=" + newPwd);
        if (oldPwd == null || newPwd == null || oldPwd.trim().equals("") || newPwd.trim().equals("")) {
            log.info(" pwd  is null");
            model.addAttribute("code", -1004);
            return "/common/success";
        }

        if (oldPwd.length() > 200 || oldPwd.length() < 0 || newPwd.length() > 200 || newPwd.length() < 0) {
            log.info(" pwd  is null");
            model.addAttribute("code", -5012);
            return "/common/success";
        }

        String oldPwdEncode = com.gemantic.common.util.PasswordUtils.encode(oldPwd);
        Manager u = managerService.getObjectById(uid);
        if (u.getPwd().equals(oldPwdEncode)) {
            String newenp = com.gemantic.common.util.PasswordUtils.encode(newPwd);
            u.setPwd(newenp);
            u.setUpdateBy(uid);
            managerService.update(u);

            model.addAttribute("code", 0);
        } else {

            model.addAttribute("code", -5006);
            model.addAttribute("result", "你输入的旧密码有误！");
        }

        return "/common/success";
    }

    @RequestMapping(value = "/web/c/password", method = RequestMethod.GET)
    public String getPassword(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model) throws Exception {

        log.info("to update password page");

        return "/manager/view/managerPassword";
    }

    @RequestMapping(value = "/web/c/puser/{id}", method = RequestMethod.GET)
    public String getManager(HttpServletRequest request,
                             HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/web/manager/" + id + "  to /manager/view/managerDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/common-carjn-service/manager/view/managerDetail";
    }

    /**
     * 获取用户列表
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @param roleID
     * @param status
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/manager/", method = RequestMethod.GET)
    public String getManagerJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page,
                                     Integer size, String roleID, String status, String type, String phone,
                                     String name, String province, String city, String county) throws Exception {


        if (page == null) {

            page = 1;
        }

        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size
                + ",roleID=" + roleID + ",status=" + status + "  type   =  " + type + " province = " + province + " city = " + city + " county = " + county);

        try {
            Boolean next = false;
            size += 1;


            Map<String, Object> map = new HashMap<>();
            if (DataUtils.isNotNullOrEmpty(roleID)) {
                map.put("role_id", roleID);
            }
            if (DataUtils.isNotNullOrEmpty(status)) {
                map.put("status", status);
            }
            if (DataUtils.isNotNullOrEmpty(phone)) {
                map.put("phone", phone);
            }
            if (DataUtils.isNotNullOrEmpty(name)) {
                map.put("name", name);
            }


            List<Long> ids;
            if ("0".equals(type)) {
                log.info("  type = 0  is  fengkong  ");
                //风控
                //role_id = 风控
                if (DataUtils.isNullOrEmpty(province)) {
                    log.info("  provice is null ");
                    if (map.size() > 0) {
                        map.put("type", "0");
                        ids = managerService.getManagerIdsByCondition(map, start, size);
                    } else {
                        ids = managerService.getManagerIdsByType(type, start, size);
                    }
                } else {
                    log.info("  provice is not  null ");

                    if (map.size() > 0) {
                        map.put("type", "0");
                        ids = managerService.getManagerIdsByCondition(map, start, Integer.MAX_VALUE);
                    } else {
                        ids = managerService.getManagerIdsByType(type, start, Integer.MAX_VALUE);
                    }
                    log.info("   all ids size = " + ids.size());
                    List<Manager> managerList = managerService.getObjectsByIds(ids);
                    ids = new ArrayList<>();
                    for (Manager manager : managerList) {

                        Boolean match = RegionUtil.fengkongRegionMatch(province, city, county, manager.getRegion());
                        if (match) {
                            ids.add(manager.getId());
                        }
                    }
                    log.info("   match ids  = " + ids.size());

                }


            } else {
                if (map.size() > 0) {

                    ids = managerService.getManagerIdsByCondition(map, start, size);

                } else {
                    ids = managerService.getManagerIds(start, size);
                }
                log.info("get manager size is " + ids.size());
            }

            if (DataUtils.isNotNullOrEmpty(province)) {
                //省
                Integer total = ids.size();//10
                Integer cutTotal = start + size;//page=1,size=10   start=10  cuttotal=10

                if (cutTotal >= total) {
                    if (start > total) {
                        log.info(" start = " + start + " , total =" + total);
                        model.addAttribute("code", -2011);
                        return "/common/success";
                    }
                    ids = ids.subList(start, total);

                } else {
                    next = true;
                    if (start > cutTotal) {
                        log.info(" start = " + start + " , total =" + total);
                        model.addAttribute("code", -2011);
                        return "/common/success";
                    }
                    ids = ids.subList(start, cutTotal);
                }

            } else {
                if (ids != null && ids.size() > 0) {

                    if (size.equals(ids.size())) {
                        next = true;
                        log.info("ss  " + ids.subList(0, size - 1));
                        ids = ids.subList(0, size - 1);

                    } else {
                        log.info("ss  " + ids.subList(0, ids.size()));
                        ids = ids.subList(0, ids.size());

                    }
                } else {

                }
            }
            model.addAttribute("ids", ids);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get manager list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/manager/json/managerListJson";
    }

    /**
     * 根据ID查找用户
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/manager/{mid}", method = RequestMethod.GET)
    public String getManagerJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("get data : id= " + mid);
        try {
            List<Long> roleids = roleService.getRoleIds(0, Integer.MAX_VALUE);


            model.addAttribute("mid", mid);

            Manager manager = managerService.getObjectById(mid);
            if (manager == null) {
                log.info(" manager is null " + " id  is " + mid);
                model.addAttribute("code", -5003);
                return "/common/success";
            } else {
//				String rids = "";
//				log.info("get manager data is " + manager);
//				if (rids.length() > 0) {
//					rids = rids.substring(0, rids.length() - 1);
//				}
                manager.setRelationIds("");
                model.addAttribute("code", 0);
                model.addAttribute("manager", manager);
                model.addAttribute("rids", roleids);

                //查询产品ID集合
                List<Long> managerProductIds = roleProductRelationService.
                        getRoleProductRelationIdsByRoleIdOrderByUpdateAt(mid, 0, Integer.MAX_VALUE);
                if (managerProductIds.size() > 0) {
                    List<RoleProductRelation> roleProductRelationList =
                            roleProductRelationService.getObjectsByIds(managerProductIds);
                    List<Long> productIds = new ArrayList<>();
                    for (RoleProductRelation roleProductRelation : roleProductRelationList) {
                        productIds.add(roleProductRelation.getProductId());
                    }
                    model.addAttribute("productIds", productIds);
                }


            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get manager error,id is  " + mid);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/manager/json/managerDetailJson";
    }

    /**
     * 批量获取用户详细信息
     *
     * @param request
     * @param response
     * @param model
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/multi/manager", method = RequestMethod.GET)
    public String getAllManagerJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        log.info("get data : ids= " + ids);
        List<Long> idList = new ArrayList();
        if (ids == null || ids.length <= 0) {
            model.addAttribute("code", 0);
            model.addAttribute("size", 0);
            model.addAttribute("total", 0);

        } else {
            idList = Arrays.asList(ids);
        }
        try {

            if (idList == null || idList.size() <= 0) {
                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", 0);
            } else {
                List<Manager> managerList = managerService.getObjectsByIds(idList);
                log.info("get manager data is " + managerList);

                Map<Long, String> map = new HashMap<>();
                for (Manager manager : managerList) {
                    if (DataUtils.isNotNullOrEmpty(manager.getRoleId())) {
                        Role role = roleService.getObjectById(manager.getRoleId());
                        map.put(manager.getId(), role.getName());
                    }
                }

                model.addAttribute("code", 0);
                model.addAttribute("size", 0);
                model.addAttribute("total", managerList.size());

                model.addAttribute("managerList", managerList);

                model.addAttribute("map", map);


                Map<Long, String> productMap = new HashMap<>();
                for (Long managerId : idList) {
                    log.info("  managerId  =   " + managerId);
                    List<Long> mangerProductIds = roleProductRelationService.
                            getRoleProductRelationIdsByRoleIdOrderByUpdateAt(managerId, 0, Integer.MAX_VALUE);
                    log.info("  mangerProductIds =  " + mangerProductIds);

                    if (mangerProductIds.size() > 0) {
                        List<RoleProductRelation> roleProductRelationList = roleProductRelationService.getObjectsByIds(mangerProductIds);
                        StringBuilder productNames = new StringBuilder("");
                        List<Long> productIds = new ArrayList<>();
                        for (RoleProductRelation roleProductRelation : roleProductRelationList) {
                            productIds.add(roleProductRelation.getProductId());
                        }
                        log.info(" productIds = " + productIds);
                        List<Product> productList = productService.getObjectsByIds(productIds);
                        for (int i = 0; i < productList.size(); i++) {
                            if (i == productList.size() - 1) {
                                productNames.append(productList.get(i).getAliases());
                            } else {
                                productNames.append(productList.get(i).getAliases() + ",");
                            }

                        }
                        productMap.put(managerId, productNames.toString());
                        log.info("productNames =  " + productNames.toString());
                    } else {
                        productMap.put(managerId, "");
                    }
                }

                model.addAttribute("productMap", productMap);

            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get manager error,ids is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/manager/json/managerMultiJson";
    }

    @RequestMapping(value = "/web/a/check/manager", method = RequestMethod.GET)
    public String updatePuserJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, String name)
            throws Exception {

        log.info("check name : name = " + name);

        try {
            List<Long> ids = this.managerService.getManagerIdsByName(name, 0,
                    Integer.MAX_VALUE);
            log.info("get ids " + ids.size());

            if (ids.size() > 0) {
                model.addAttribute("code", -5019);
            } else {
                model.addAttribute("code", 0);
            }

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("check name error,name is  " + name);
            log.error("update manager error code -6003");
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }

    /**
     * 修改用户
     *
     * @param request
     * @param response
     * @param model
     * @param manager
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/manager/{mid}", method = RequestMethod.PUT)
    public String updateManagerJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Manager manager,
                                    String productIds)
            throws Exception {

        log.info("update manager : manager= " + manager);
        log.info("   productIds  =  " + productIds);

        try {
            Manager ma = managerService.getObjectById(manager.getId());
            if (ma == null) {
                model.addAttribute("code", -5003);
                log.info(" manager name is null");
                return "/common/success";
            } else {

                if (manager.getName() == null || manager.getName().trim().equals("")) {
                    model.addAttribute("code", -5007);
                    log.info(" manager name is null");
                    return "/common/success";
                } else {
                    if (manager.getName().length() > 50 || manager.getName().length() < 0) {
                        model.addAttribute("code", -2003);
                        log.info(" manager name is " + manager.getName());
                        return "/common/success";
                    }

                }

                if (manager.getPwd() == null || manager.getPwd().trim().equals("")) {
                    log.info(" pwd is null ");
                    manager.setPwd(ma.getPwd());
                } else {
                    if (manager.getPwd().length() > 200 || manager.getPwd().length() < 0) {
                        model.addAttribute("code", -2003);
                        log.info(" manager pwd is " + manager.getPwd());
                        return "/common/success";
                    } else {
                        String newenp = com.gemantic.common.util.PasswordUtils.encode(manager.getPwd());
                        manager.setPwd(newenp);

                    }
                }
                if (manager.getRoleId() == null) {
                    model.addAttribute("code", -7000);
                    log.info(" manager roleid is null");
                    return "/common/success";
                }

                Role role = roleService.getObjectById(manager.getRoleId());
                if (role == null) {
                    log.info(" roleid  not exit ");
                    model.addAttribute("code", -7001);
                    return "/common/success";
                }
                List<Long> managerIds = this.managerService.getManagerIdsByName(manager.getName(), 0, Integer.MAX_VALUE);
                log.info("manager name " + manager.getName());

                if (managerIds != null && managerIds.size() > 0) {
                    if (managerIds.size() == 1 && !(managerIds.get(0).equals(manager.getId()))) {
                        log.info(" manager name is exit ");
                        model.addAttribute("code", -5019);
                        return "/common/success";

                    }
                }


                if (Manager.RESET.equals(manager.getPwd())) {
                    String pwd = managerServiceConfig.get("pwd");
                    manager.setPwd(com.gemantic.common.util.PasswordUtils.encode(pwd));
                }


                String userId = cookieUtil.getKeyIdentity(request,
                        CookieUtil.USER_ID);
                log.info("login userId:" + userId);

                manager.setUpdateBy(Long.parseLong(userId));
                manager.setCreateAt(ma.getCreateAt());
                manager.setCreateBy(ma.getCreateBy());
                managerService.update(manager);

                //增加产品权限
                if (DataUtils.isNotNullOrEmpty(productIds)) {

                    //先删除
                    List<Long> mpIds = roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
                            (manager.getId(), 0, Integer.MAX_VALUE);
                    log.info("   mpIds   size   =  " + mpIds.size());
                    log.info("   mpIds  =  " + mpIds);
                    if (mpIds.size() > 0) {
                        roleProductRelationService.deleteList(RoleProductRelation.class, mpIds);

                    }

                    //再新增
                    List<RoleProductRelation> roleProductRelationList = new ArrayList<>();

                    String[] productArr = productIds.split(",");
                    log.info("  productArr[0]  = "+productArr[0]);
                    if(DataUtils.isNotNullOrEmpty(productArr[0])){
                        for (String productId : productArr) {
                            log.info(" productId  =   " + productId);
                            RoleProductRelation roleProductRelation = new RoleProductRelation();
                            roleProductRelation.setRoleId(manager.getId());
                            roleProductRelation.setProductId(Long.valueOf(productId));
                            roleProductRelation.setCreateBy(Long.valueOf(userId));
                            roleProductRelationList.add(roleProductRelation);
                        }
                        log.info("  roleProductRelationList  size  =  " + roleProductRelationList.size());
                        if (roleProductRelationList.size() > 0) {
                            roleProductRelationService.insertList(roleProductRelationList);
                        }
                    }



                }


                model.addAttribute("code", 0);
                model.addAttribute("manager", manager);
            }
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("update manager error,id is  " + manager.getId());
            log.error("update manager error code -100000");
            model.addAttribute("code", -100000);

        }

        return "/common-carjn-service/manager/json/managerDetailJson";
    }

    /**
     * 增加用户
     *
     * @param request
     * @param response
     * @param model
     * @param manager
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/manager", method = RequestMethod.POST)
    public String addManagerJson(HttpServletRequest request,
                                 HttpServletResponse response, ModelMap model, Manager manager,
                                 String productIds, String type)
            throws Exception {

        log.info("add manager : manager= " + manager.getName() + "rid  " + manager.getRoleId());
        log.info(" productIds  =   " + productIds);

        try {
            if (manager.getName() == null || manager.getName().trim().equals("")) {
                model.addAttribute("code", -5007);
                log.info(" manager name is null");
                return "/common/success";
            } else {
                if (manager.getName().length() > 50 || manager.getName().length() < 0) {
                    model.addAttribute("code", -2003);
                    log.info(" manager name is " + manager.getName());
                    return "/common/success";
                }

            }

            if (manager.getPwd() == null || manager.getPwd().trim().equals("")) {
                model.addAttribute("code", -5008);
                log.info(" manager pwd is null");
                return "/common/success";
            } else {
                if (manager.getPwd().length() > 200 || manager.getPwd().length() < 0) {
                    model.addAttribute("code", -2003);
                    log.info(" manager pwd is " + manager.getPwd());
                    return "/common/success";
                }
            }
            if (manager.getRoleId() == null) {
                model.addAttribute("code", -7000);
                log.info(" manager roleid is null");
                return "/common/success";
            }

            Role role = roleService.getObjectById(manager.getRoleId());
            if (role == null) {
                log.info(" roleid  not exit ");
                model.addAttribute("code", -7001);
                return "/common/success";
            }
            List<Long> managerIds = this.managerService.getManagerIdsByName(manager.getName(), 0, Integer.MAX_VALUE);
            log.info("manager name " + manager.getName());
            if (managerIds.size() > 0) {
                log.info(" manager name is exit ");
                model.addAttribute("code", -5019);
                return "/common/success";

            }


            manager.setId(null);

            //String pwd = managerServiceConfig.get("pwd");
            //manager.setPwd(com.gemantic.common.util.PasswordUtils.encode(pwd));

            String userId = cookieUtil.getKeyIdentity(request,
                    CookieUtil.USER_ID);
            log.info("login userId:" + userId);
            String encodePass = com.gemantic.common.util.PasswordUtils.encode(manager.getPwd());
            manager.setCreateBy(Long.parseLong(userId));
            manager.setUpdateBy(Long.parseLong(userId));
            //manager.setCreateBy(Long.parseLong("122"));
            //manager.setUpdateBy(Long.parseLong("122"));
            manager.setStatus(Manager.STATUS_USING);
            manager.setPwd(encodePass);
            if ("0".equals(type)) {
                manager.setType("0");
            }

            Long id = managerService.insert(manager);
            List<RoleProductRelation> roleProductRelationList = new ArrayList<>();
            if (DataUtils.isNotNullOrEmpty(productIds)) {
                String[] productArr = productIds.split(",");
                log.info("  productArr[0]  = "+productArr[0]);
                if(DataUtils.isNotNullOrEmpty(productArr[0])) {
                    for (String productId : productArr) {
                        log.info(" productId  =   " + productId);
                        RoleProductRelation roleProductRelation = new RoleProductRelation();
                        roleProductRelation.setRoleId(id);
                        roleProductRelation.setProductId(Long.valueOf(productId));
                        roleProductRelation.setCreateBy(Long.valueOf(userId));
                        roleProductRelationList.add(roleProductRelation);
                    }
                    log.info("  roleProductRelationList  size  =  " + roleProductRelationList.size());
                    if (roleProductRelationList.size() > 0) {
                        roleProductRelationService.insertList(roleProductRelationList);
                    }
                }
            }

            //	//if (null != userId) {
            //}
            request.setAttribute("objectId", id);
            model.addAttribute("code", 0);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("add manager error ");
            model.addAttribute("code", -100000);
        }

        return "/common/success";
    }

    /**
     * 删除用户
     *
     * @param request
     * @param response
     * @param model
     * @param mid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/manager/{mid}", method = RequestMethod.DELETE)
    public String deleteManagerJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, @PathVariable Long mid)
            throws Exception {

        log.info("delete manager : id= " + mid);
        try {
            if (mid == null) {
                log.info(" mid is null");
                model.addAttribute("code", -5013);
                return "/common/success";
            }
            Manager manager = managerService.getObjectById(mid);
            if (manager != null) {
                managerService.delete(mid);

                log.info("add manager success");
                model.addAttribute("code", 0);
            } else {
                model.addAttribute("code", -5003);
                return "/common/success";
            }

            //删除产品
            List<Long> rolePIds = roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
                    (mid, 0, Integer.MAX_VALUE);
            log.info("  rolePIds  size  =  " + rolePIds);
            log.info("  rolePIds  =   " + rolePIds);
            roleProductRelationService.deleteList(RoleProductRelation.class, rolePIds);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("delete manager error,id is  " + mid);
            model.addAttribute("code", -100000);

        }

        return "/common/success";
    }


    /**
     * 根据RoleID查找用户
     *
     * @param request
     * @param response
     * @param model
     * @param rid
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/role/{rid}/manager", method = RequestMethod.GET)
    public String getManagerByRoleIDJson(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, @PathVariable Long rid, Integer page,
                                         Integer size)
            throws Exception {

        log.info("get data : id= " + rid);
        try {

            if (page == null) {

                page = 1;
            }

            if (size == null) {
                size = 10;
            }
            int start = (page - 1) * size;
            if (start < 0) {
                start = 0;
            }

            List<Long> ids = managerService.getManagerIdsByRoleId(rid, start, size);
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);
            model.addAttribute("total", ids.size());
            model.addAttribute("ids", ids);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get manager error,role id is  " + rid);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/manager/json/managerListJson";
    }


    //根据帐户地区查询可以使用的产品
    @RequestMapping(value = "/a/u/managerProductRelation/", method = RequestMethod.GET)
    public String getMangerProductRelationJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                               String managerRegion) throws Exception {

        log.info("get data   manager  region = " + managerRegion);
        try {
            if (DataUtils.isNullOrEmpty(managerRegion)) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            List<Long> productIds = productService.getProductIds(0, Integer.MAX_VALUE);
            List<Product> productList = productService.getObjectsByIds(productIds);

            List<Product> newProductList = new ArrayList<>();
            List<Product> oldProductList = new ArrayList<>();
            List<Product> loanProductList = new ArrayList<>();

            Map<String, List<Product>> map = new HashMap<>();

            for (Product product : productList) {
                log.info(" saler  region  match  start .........");
                log.info(" region now  produce id = " + product.getId());
                String region = product.getRegion();
                Boolean match = RegionUtil.regionListMatch(managerRegion, region);
                if (match) {
                    if (Product.new_productType.equals(product.getType())) {
                        newProductList.add(product);
                    } else if (Product.old_productType.equals(product.getType())) {
                        oldProductList.add(product);
                    } else if (Product.loan_productType.equals(product.getType())) {
                        loanProductList.add(product);
                    }
                }
            }
            map.put(Product.new_productType, newProductList);
            map.put(Product.old_productType, oldProductList);
            map.put(Product.loan_productType, loanProductList);


            List<String> ls = new ArrayList();
            ls.add(Product.new_productType);
            ls.add(Product.old_productType);
            ls.add(Product.loan_productType);
            log.info("  newProductList  = " + newProductList.size());
            log.info("  oldProductList  = " + oldProductList.size());
            log.info("  loanProductList  = " + loanProductList.size());

            model.addAttribute("code", 0);
            model.addAttribute("ls", ls);
            model.addAttribute("map", map);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get salerProductRelation error,id is  ");
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/salerProductRelation/json/salerProductRelationListJson";
    }


    /**
     * 根据帐户地区查询可以使用的产品
     *
     * @param request
     * @param response
     * @param model
     * @param managerRegion
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/managerProductRelation/channel", method = RequestMethod.GET)
    public String getMangerProductRelationJsonByChannel(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                                        String managerRegion) throws Exception {
        if (DataUtils.isNullOrEmpty(managerRegion)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            List<Long> productIds = productService.getProductIds(0, Integer.MAX_VALUE);
            List<Product> productList = productService.getObjectsByIds(productIds);

            Map<Long, Map<String, List<Product>>> data = new HashMap<>();

            for (Product product : productList) {
                log.info(" saler  region  match  start .........");
                log.info(" region now  produce id = " + product.getId());
                String region = product.getRegion();
                Boolean match = RegionUtil.regionListMatch(managerRegion, region);
                if (match) {
                    Long productChannel = product.getChannel();
                    String productType = product.getType();
                    // 渠道
                    if (data.get(productChannel) == null) {
                        data.put(productChannel, new HashMap<String, List<Product>>());
                    }
                    // 业务类型
                    if (data.get(productChannel).get(productType) == null) {
                        data.get(productChannel).put(productType, new ArrayList<Product>());
                    }
                    // 添加产品
                    data.get(productChannel).get(productType).add(product);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("data", data);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("getMangerProductRelationJsonByChannel error ");
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/salerProductRelation/json/getMangerProductRelationJsonByChannel";
    }

    /**
     * 根据帐户地区查询可以使用的产品
     *
     * @param request
     * @param response
     * @param model
     * @param managerRegion
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/managerProductRelation/product", method = RequestMethod.GET)
    public String getMangerProductRelationJsonByProduct(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                                        String managerRegion) throws Exception {
        if (DataUtils.isNullOrEmpty(managerRegion)) {
            model.addAttribute("code", -1000);
            return "/common/success";
        }

        try {
            List<Long> productIds = productService.getProductIds(0, Integer.MAX_VALUE);
            List<Product> productList = productService.getObjectsByIds(productIds);

            Map<String, Map<Long, List<Product>>> data = new HashMap<>();

            for (Product product : productList) {
                log.info(" saler  region  match  start .........");
                log.info(" region now  produce id = " + product.getId());
                String region = product.getRegion();
                Boolean match = RegionUtil.regionListMatch(managerRegion, region);
                if (match) {
                    Long productChannel = product.getChannel();
                    String productType = product.getType();
                    // 业务类型
                    if (data.get(productType) == null) {
                        data.put(productType, new HashMap<Long, List<Product>>());
                    }
                    // 渠道
                    if (data.get(productType).get(productChannel) == null) {
                        data.get(productType).put(productChannel, new ArrayList<Product>());
                    }
                    // 添加产品
                    data.get(productType).get(productChannel).add(product);
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("data", data);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("getMangerProductRelationJsonByProduct error ");
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/salerProductRelation/json/getMangerProductRelationJsonByProduct";
    }

}

