package com.ptteng.common.carjn.controller;

import atg.taglib.json.util.JSONArray;
import atg.taglib.json.util.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemantic.common.util.StringUtil;
import com.google.gson.Gson;
import com.ptteng.common.carjn.controller.entity.Image;
import com.ptteng.common.storage.util.notice.NoticeUtil;

import com.ptteng.util.*;
import com.qding.common.util.http.cookie.CookieUtil;
import com.gemantic.common.util.json.GsonUtil;
import com.ptteng.common.carjn.model.*;
import com.ptteng.common.carjn.service.*;
import com.ptteng.model.*;
import com.qding.common.util.DataUtils;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * Created by liangxj on 2015/12/10.
 */
@Controller
public class IndentControler {
    private static final Log log = LogFactory.getLog(IndentControler.class);

    @Autowired
    private IndentService indentService;

    @Autowired
    private SalerService salerService;

    @Autowired
    private CustomerService customerService;

    @Autowired
    private IprocessService iprocessService;

    @Autowired
    private ConstantService constantService;

    @Autowired
    private ProductService productService;

    @Autowired
    private PermetarialService permetarialService;

    @Autowired
    private CustomerMaterialRelationService cmrService;

    @Autowired
    private MaterialService materialService;

    @Autowired
    private GuaranteeService guaranteeService;

    @Autowired
    private IdocumentService idocumentService;

    @Autowired
    private PcertificateService pcertificateService;


    @Autowired
    private ErrcertificateService errcertificateService;

    @Autowired
    private CheckresultrecordService checkresultrecordService;

    @Autowired
    private ManagerService managerService;

    @Autowired
    private CustomerMaterialRelationService customerMaterialRelationService;

    @Autowired
    private CookieUtil cookieUtil;

    @Autowired
    private GuaCertificateService guaCertificateService;

    @Autowired
    private PcontractService pcontractService;

    @Autowired
    private PloanService ploanService;

    @Autowired
    private StatisticsService statisticsService;

    @Autowired
    private RoleProductRelationService roleProductRelationService;

    @Autowired
    private CusemerconService cusemerconService;

    @Autowired
    private CussnService cussnService;

    @Autowired
    private PropdffileService propdffileService;

    @Autowired
    private PropdfileCertifiRelationService propdfileCertifiRelationService;

    @Autowired
    private NoticeUtil noticeUtil;


    /**
     * 订单列表查询
     * 进度从上传申请资料--上传放款资料或者补充放款资料通过
     *
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/indent/", method = RequestMethod.GET)
    public String getIndentList(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, Integer page,
                                Integer size, Long startAt, Long endAt, String salerName, String cusName,
                                String productType, Long channelId, String productName,
                                String process, String status, String operatorName) throws Exception {

        if (page == null) {

            page = 1;
        }

        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            Boolean next = false;
            size += 1;
            List<IndentParm> list = new ArrayList<>();
            String uid = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
            Manager manager = managerService.getObjectById(Long.valueOf(uid));
            Long roleId = manager.getRoleId();
            List<Long> rpIds = roleProductRelationService.getRoleProductRelationIdsByRoleIdOrderByUpdateAt
                    (roleId, 0, Integer.MAX_VALUE);
            List<Long> allPIds = productService.getProductIds(0, Integer.MAX_VALUE);
            log.info(" rpIds size =  " + rpIds.size() + "  allPIds size = " + allPIds.size());
            if (DataUtils.isNotNullOrEmpty(operatorName)) {
                if ("0".equals(manager.getType())) {
                    model.addAttribute("code", -40006);
                    return "/common/success";
                }
            }


            log.info("  uid = " + uid);
            String processes = "'" + Iprocess.PROCESS2 + "','" + Iprocess.PROCESS3 + "','" + Iprocess.PROCESS4 + "','" + Iprocess.PROCESS5 + "','" +
                    Iprocess.PROCESS6 + "','" + Iprocess.PROCESS7 + "','" + Iprocess.PROCESS8 + "','" + Iprocess.PROCESS9 + "','" +
                    Iprocess.PROCESS10 + "','" + Iprocess.PROCESS11 + "'" + ",'" + Iprocess.PROCESS12 + "'" + ",'" + Iprocess.PROCESS13 + "'" +
                    ",'" + Iprocess.PROCESS14 + "'";
            log.info(" processes  =" + processes);
//            Map<String,Object> indentMap =  IndentUtil.getIndentList(processes, false);
//            List<Long>   ids=  indentService.getIdsByDynamicCondition(Indent.class, indentMap, start, size);
            List<IndentParm> indentParmList = new ArrayList<>();

            if (!"0".equals(manager.getType())) {
                log.info("    manager  type !=0   = " + manager.getType());
                //不是风控
                if (DataUtils.isNotNullOrEmpty(process)) {
                    indentParmList = IndentUtil.getLoanListByMore(startAt,
                            endAt, salerName, cusName, productType, channelId, productName, process, status, "", start, size, uid, operatorName);

                } else {
                    indentParmList = IndentUtil.getLoanListByMore(startAt,
                            endAt, salerName, cusName, productType, channelId, productName, process, status, processes, start, size, uid, operatorName);
                }
            } else {
                log.info("    manager  type  =0   = " + manager.getType());
                //是风控
                if (DataUtils.isNotNullOrEmpty(process)) {
                    indentParmList = IndentUtil.getIndentListByMore(startAt,
                            endAt, salerName, cusName, productType, channelId, productName, process, status, "", start, size, uid);

                } else {
                    indentParmList = IndentUtil.getIndentListByMore(startAt,
                            endAt, salerName, cusName, productType, channelId, productName, process, status, processes, start, size, uid);
                }
            }


            log.info("  indentParam   = " + indentParmList.size());
            log.info("get indent size is " + list.size());


            for (IndentParm indentParm : indentParmList) {
                log.info("   operator id = " + indentParm.getOperator());
                if (DataUtils.isNotNullOrEmpty(indentParm.getOperator())
                        && uid.equals(indentParm.getOperator())) {
                    indentParm.setOperator(manager.getName());
                }
            }

            if (indentParmList != null && indentParmList.size() > 0) {

                if (size.equals(indentParmList.size())) {
                    next = true;
                    log.info("ss  " + indentParmList.subList(0, size - 1));
                    model.addAttribute("list", indentParmList.subList(0, size - 1));
                } else {
                    log.info("ss  " + indentParmList.subList(0, indentParmList.size()));
                    model.addAttribute("list", indentParmList.subList(0, indentParmList.size()));
                }
            } else {
                model.addAttribute("list", indentParmList);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);


        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get indent list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/indent/json/indentList";
    }


    //订单管理--根据ID查询单个订单详情
    @RequestMapping(value = "/a/u/indent/{id}", method = RequestMethod.GET)
    public String getIndentById(HttpServletRequest request,
                                HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            log.info(" get indent start");
            Indent indent = indentService.getObjectById(id);
            Product product = productService.getObjectById(indent.getProductId());
            if (DataUtils.isNullOrEmpty(indent)) {
                model.addAttribute("code", -40001);
                return "/common/success";
            }
            log.info(" get indent end");


            log.info("  make indentInfo  start");
            IndentParm indentParm = new IndentParm();
            indentParm.setNumber(indent.getNumber());
            indentParm.setCreateAt(indent.getCreateAt());
            Saler saler = salerService.getObjectById(indent.getSalerId());
            if (DataUtils.isNotNullOrEmpty(saler)) {
                indentParm.setSalerName(saler.getName());
                indentParm.setSalerePhone(saler.getPhone());
            }
            List<Long> iprocessIds = iprocessService.getIprocessIdsByCustomerIdOrderByUpdateAt
                    (indent.getCustomerId(), 0, Integer.MAX_VALUE);

            List<Iprocess> iprocessList = iprocessService.getObjectsByIds(iprocessIds);
            indentParm.setProcess(iprocessList.get(0).getProcess());
            indentParm.setResult(iprocessList.get(0).getResultFlag());

            log.info("  make indentInfo  end");


            log.info(" get customer baseinfo  start");
            Customer customer = customerService.getObjectById(indent.getCustomerId());
            log.info(" get customer  baseinfo end");

            log.info("get  cusMetList   start");
            List<Long> cmrIds = cmrService.
                    getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                            (customer.getId() + "", Customer.c_personnelType + "", 0, Integer.MAX_VALUE);
            List<CustomerMaterialRelation> cmrList = cmrService.getObjectsByIds(cmrIds);

            List<Long> parentIds = constantService.getConstantIdsByTypeOrderByUpdateAt
                    (Constant.metarialType, 0, Integer.MAX_VALUE);
            Map<Long, Map> cusParentMap = getMaterial(indent.getProductType(), Customer.c_personnelType + "", cmrList);
            log.info(" get  cusMetList   end  ");
            log.info("  get spouse  baseinfo  start ");
            String merriage = customer.getMarriage();
            if (Customer.married.equals(merriage)) {
                log.info("   customer  married  true");
                Guarantee spouse = guaranteeService.getObjectById(guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(), Customer.s_personnelType + ""));
                model.addAttribute("spouse", spouse);

                log.info("  get spouse  baseinfo  end ");
                log.info("get  spouMetList   start");


                List<Long> sCmrIds = cmrService.
                        getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                                (customer.getId() + "", Customer.s_personnelType + "", 0, Integer.MAX_VALUE);
                List<CustomerMaterialRelation> sCmrList = cmrService.getObjectsByIds(sCmrIds);

                Map<Long, Map> spouParentMap = getMaterial(indent.getProductType(), Customer.s_personnelType + "", sCmrList);
                model.addAttribute("spouMetarialList", sCmrList);
                model.addAttribute("spouParentMap", spouParentMap);
            }else{
                Guarantee parent = new Guarantee();
                //未婚和离异查询父母信息
                log.info("   customer  married  false");
                //父母信息
                Long parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(), Customer.f_personnelType + "");
                log.info(" parentId = "+parentId);
                if(null == parentId){
                    parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                            (customer.getId(), Customer.m_personnelType + "");
                }
                log.info(" parentId = "+parentId);
                if(null != parentId){
                    parent = guaranteeService.getObjectById(parentId);
                }

                model.addAttribute("parent", parent);

            }

            log.info(" get  spouMetList   end  ");

            //未满24周岁，直系担保人信息
            log.info(" minorGua = "+product.getMinorGuarantee());
            if(Product.NEED.equals(product.getMinorGuarantee())){
                log.info("  need minorGua");
                 Long minorGuaId =  guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(),Customer.minor_personnelType+"");
                log.info("  minorGuaId = "+minorGuaId);
                if(null != minorGuaId){
                    Guarantee minorGua =  guaranteeService.getObjectById(minorGuaId);
                    model.addAttribute("minorGua",minorGua);
                }
            }else{
                log.info("  don't need minorGua");
            }


            log.info("  get guarantee  baseinfo  start ");
            Boolean gua_flag = false;
            Long guaId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.g_personnelType + "");
            log.info(" guaId = " + guaId);
            if (DataUtils.isNotNullOrEmpty(guaId)) {
                log.info("  customer have guarantee");
                Guarantee guarantee = guaranteeService.getObjectById(guaId);
                model.addAttribute("guarantee", guarantee);

                log.info("  get guarantee  baseinfo  end ");
                log.info("get  guaMetList   start");
                List<Long> gCmrIds = cmrService.
                        getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                                (customer.getId() + "", Customer.g_personnelType + "", 0, Integer.MAX_VALUE);
                List<CustomerMaterialRelation> gCmrList = cmrService.getObjectsByIds(gCmrIds);

                Map<Long, Map> guaParentMap = getMaterial(indent.getProductType(), Customer.g_personnelType + "", gCmrList);

                model.addAttribute("guaMetarialList", gCmrList);
                model.addAttribute("guaParentMap", guaParentMap);
            }
            log.info(" get  guaMetList   end  ");

            log.info(" indent  process   ");


            //返回申请资料
            log.info(" customer  certificate  start ");

            for (Iprocess iprocess : iprocessList) {
                if (iprocess.getProcess().equals(Iprocess.PROCESS2) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS3) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS4) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS5) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS6)
                        ) {
                    log.info("  certirificateList   ");
                    IndentDocumentResult cerIndentDocumentResult = getDocumentResult
                            (customer.getId(), indent.getProductId(), Iprocess.CRTTIFICATE, iprocess.getResultFlag(), iprocess.getProcess()
                            ,Idocument.TYPE_2);
                    model.addAttribute("certificateList", cerIndentDocumentResult);

                    break;
                }
            }
            //查询申请资料操作记录
            List<Long> cerRecorIds = checkresultrecordService.getIdsByIndentIdAndStageOrderByUpdateAt
                    (indent.getId(), Checkresultrecord.STAGE_0, 0, Checkresultrecord.size);
            log.info(" cerRecorIds  size =  " + cerRecorIds.size());
            List<Checkresultrecord> cerRecordList = checkresultrecordService.getObjectsByIds(cerRecorIds);
            if (cerRecordList.size() > 0) {
                log.info("  cerRecordList  =  " + cerRecordList.size());
                model.addAttribute("cerRecordList", cerRecordList);
                Map<Long, String> cerMap = new HashMap<>();
                for (Checkresultrecord checkresultrecord : cerRecordList) {
                    log.info(" checkresultrecord  createBy =  " + checkresultrecord.getCreateBy());
                    Manager manager = managerService.getObjectById(checkresultrecord.getCreateBy());
                    cerMap.put(manager.getId(), manager.getName());
                }
                model.addAttribute("cerMap", cerMap);
            }
            log.info("  cerRecordList size = " + cerRecordList.size());

            log.info(" customer  certificate  end ");


            log.info(" customer  contract  start ");
            //返回合同资料
            for (Iprocess iprocess : iprocessList) {
                if (iprocess.getProcess().equals(Iprocess.PROCESS7) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS8) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS9)
                        ) {
                    log.info("  contirificateList   ");

                    IndentDocumentResult conIndentDocumentResult = getDocumentResult
                            (customer.getId(), indent.getProductId(), Iprocess.MAKE_CONTRACT, iprocess.getResultFlag(), iprocess.getProcess()
                            ,Idocument.TYPE_3);
                    model.addAttribute("contractList", conIndentDocumentResult);

                    break;
                }
            }
            List<Long> conRecorIds = checkresultrecordService.getIdsByIndentIdAndStageOrderByUpdateAt
                    (indent.getId(), Checkresultrecord.STAGE_2, 0, Checkresultrecord.size);
            List<Checkresultrecord> conRecordList = checkresultrecordService.getObjectsByIds(cerRecorIds);
            if (conRecordList.size() > 0) {
                model.addAttribute("conRecordList", conRecordList);
                Map<Long, String> conMap = new HashMap<>();
                for (Checkresultrecord checkresultrecord : conRecordList) {
                    Manager manager = managerService.getObjectById(checkresultrecord.getCreateBy());
                    conMap.put(manager.getId(), manager.getName());
                }
                model.addAttribute("conMap", conMap);
            }
            log.info(" customer  contract  end ");
            //返回放款资料
            log.info("  customer loan start");
            for (Iprocess iprocess : iprocessList) {
                if (iprocess.getProcess().equals(Iprocess.PROCESS10) ||
                        iprocess.getProcess().equals(Iprocess.PROCESS11)
                        ) {
                    log.info("  loanctirificateList   ");

                    IndentDocumentResult loanIndentDocumentResult = getDocumentResult
                            (customer.getId(), indent.getProductId(), Iprocess.LOAN, iprocess.getResultFlag(), iprocess.getProcess()
                            ,Idocument.TYPE_4);
                    model.addAttribute("loanList", loanIndentDocumentResult);

                    break;
                }
            }

            List<Long> loanRecorIds = checkresultrecordService.getIdsByIndentIdAndStageOrderByUpdateAt
                    (indent.getId(), Checkresultrecord.STAGE_3, 0, Checkresultrecord.size);
            List<Checkresultrecord> loanRecordList = checkresultrecordService.getObjectsByIds(loanRecorIds);
            Map<Long, String> loanMap = new HashMap<>();
            if (loanRecordList.size() > 0) {
                model.addAttribute("loanRecordList", loanRecordList);
                for (Checkresultrecord checkresultrecord : loanRecordList) {
                    Manager manager = managerService.getObjectById(checkresultrecord.getCreateBy());
                    loanMap.put(manager.getId(), manager.getName());
                }
                model.addAttribute("loanMap", loanMap);
            }
            log.info("  customer loan end");
            log.info(" product start   ");

            Constant channel = constantService.getObjectById(product.getChannel());
            log.info(" product end   ");

            //返回归档
            List<Long> dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                    Customer.c_personnelType + "", Iprocess.FILE, Iprocess.FILE_NAME, 0, Integer.MAX_VALUE);

            if (dids.size() > 0) {
                Idocument idocument = idocumentService.getObjectById(dids.get(0));
                model.addAttribute("url", idocument.getImg());
            }
            //返回PDF
            List<Long> pdfIds = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                    Customer.c_personnelType + "", Iprocess.PDF_FILE, Iprocess.PDF_FILE_NAME, 0, Integer.MAX_VALUE);
            if (pdfIds.size() > 0) {
                Idocument idocument = idocumentService.getObjectById(pdfIds.get(0));
                model.addAttribute("pdfUrl", idocument.getImg());
            }
            model.addAttribute("code", 0);


            //查询紧急联系人
            List<Long> cusemerconIds = cusemerconService.getCusemerconIdsByCustomerId
                    (customer.getId(), 0, Integer.MAX_VALUE);
            List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(cusemerconIds);
            log.info("  cusemerconIds  size = " + cusemerconIds.size());
            log.info("  cusemerconIds  ids  =  " + cusemerconIds);
            //查询sn码
            List<Long> cussnIds = cussnService.getCussnIdsByCustomerId(customer.getId(), 0, Integer.MAX_VALUE);
            log.info("  cussnIds  size = " + cussnIds.size());
            log.info("  cussnIds  ids  =  " + cussnIds);
            if (cussnIds.size() > 0) {
                List<Cussn> cussnList = cussnService.getObjectsByIds(cussnIds);
                model.addAttribute("cussnList", cussnList);
            }

            model.addAttribute("id", indent.getId());
            model.addAttribute("indentInfo", indentParm);
            model.addAttribute("customer", customer);
            model.addAttribute("cusMetarialList", cmrList);
            model.addAttribute("cusParentMap", cusParentMap);

            model.addAttribute("indent", indent);
            model.addAttribute("product", product);
            model.addAttribute("channel", channel.getName());
            model.addAttribute("parentIds", parentIds);
            model.addAttribute("cusemerconList", cusemerconList);


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get indent error,id is  " + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/indent/json/indentDetail";
    }


    //订单管理--修改
    @RequestMapping(value = "/a/u/indent/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, String customer,
                                     String cusMetListJson, String spouse,String parent, String spouMetListJson,
                                     String guarantee, String guaMetListJson, String cerListJson,
                                     String description, String result, String replyAmount, String message,
                                     String action, String contractUrl, String cusemerconListJson,
                                     String cussnListJson,String minorGua,
                                     @PathVariable Long id) throws Exception {
        log.info("  kjfkdjkdjkd ");
        log.info("  spouseStr = " + spouse);
        log.info("  parentStr = " + parent);

        log.info("  minorGua = "+minorGua);
        log.info("  cusemerconListJson  = " + cusemerconListJson);
        log.info("  cussnListJson  = " + cussnListJson);

        Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
                com.qding.common.util.http.cookie.CookieUtil.USER_ID));
        ObjectMapper mapper = new ObjectMapper();
        Customer cusObj = null;
        Guarantee inputSpouse = null;
        Guarantee inputParent = null;
        Guarantee inputGuarantee = null;
        Guarantee minorGuaObject = null;
        if (StringUtil.isNotEmpty(customer)) {
            cusObj = GsonUtil.fromJson(customer, Customer.class);
        }
        if (StringUtil.isNotEmpty(spouse)) {
            inputSpouse = GsonUtil.fromJson(spouse, Guarantee.class);
        }
        if (StringUtil.isNotEmpty(parent)) {
            inputParent = GsonUtil.fromJson(parent, Guarantee.class);
        }
        if(StringUtil.isNotEmpty(minorGua)){
            minorGuaObject = GsonUtil.fromJson(minorGua,Guarantee.class);
        }

        if (StringUtil.isNotEmpty(guarantee)) {
            inputGuarantee = GsonUtil.fromJson(guarantee, Guarantee.class);
        }
        Enumeration enumeration = request.getParameterNames();
        log.info("===========================================================");
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement() + "";
            log.info(name + "     " + request.getParameter(name));
        }
        log.info("===========================================================");
        log.info(cusObj);
//        log.info("Customer id: "+cusObj.getId());
//        log.info("update indent : indent  id= " + id+" action ="+action+" result ="+result+" description  = "+description);

        try {

            if (DataUtils.isNullOrEmpty(action)) {
                model.addAttribute("code", -40004);
                return "/common/success";
            }
            if (DataUtils.isNullOrEmpty(result)) {
                model.addAttribute("code", -40005);
                return "/common/success";
            }

            Indent indent = indentService.getObjectById(id);
            Product product = productService.getObjectById(indent.getProductId());
            Long cid = indent.getCustomerId();
            List<Long> iprocessIds = iprocessService.getIprocessIdsByCustomerIdOrderByUpdateAt
                    (cid, 0, Integer.MAX_VALUE);
            List<Iprocess> iprocessList = iprocessService.getObjectsByIds(iprocessIds);
            Iprocess iprocess = iprocessList.get(0);
            String process = iprocess.getProcess();
            log.info("  now  process  is  =" + process + " result =" + iprocess.getResultFlag());

            String modifyStr = "";
            //保存修改记录
            if (Iprocess.PROCESS3.equals(process)
                    || Iprocess.PROCESS4.equals(process)) {
                modifyStr = modify(customer, cusMetListJson, spouse, spouMetListJson,
                        guarantee, guaMetListJson, id,parent,minorGua);

                log.info("modifyStr is :" + modifyStr);
            }

            String stage = "";//阶段0--证件资料审核；1--合同资料审核；2--放款资料审核


            //找到该销售下的该业务类型的数据
            log.info("  saler id " + indent.getSalerId());
            Long sId = statisticsService.getStatisticsIdBySalerIdAndProductType
                    (indent.getSalerId(), indent.getProductType());

            Customer inputCustomer = customerService.getObjectById(cid);
            Statistics statistics = statisticsService.getObjectById(sId);
            Integer loanAmount = Integer.valueOf(indent.getLoanAmount());
            Integer money = 0;
            Integer salerCount = 0;

            if (DataUtils.isNotNullOrEmpty(cusObj)) {

                log.info(" customer id = " + cusObj.getId() + "  name =" + cusObj.getName());

                if (DataUtils.isNullOrEmpty(cusObj.getName())
                        || DataUtils.isNullOrEmpty(cusObj.getCensRegAddress())
                        || DataUtils.isNullOrEmpty(cusObj.getMarriage())
                        || DataUtils.isNullOrEmpty(cusObj.getPhone())
                        || DataUtils.isNullOrEmpty(cusObj.getNumber())
                        || DataUtils.isNullOrEmpty(cusObj.getEmployer())
                        || DataUtils.isNullOrEmpty(cusObj.getWorkExperience())
                        || DataUtils.isNullOrEmpty(cusObj.getSalary())) {
                    log.info("  cusObject  = " + cusObj);
                    model.addAttribute("code", -1000);
                    return "/common/success";
                }
                inputCustomer.setName(cusObj.getName());
                inputCustomer.setCensRegAddress(cusObj.getCensRegAddress());
                inputCustomer.setMarriage(cusObj.getMarriage());
                inputCustomer.setPhone(cusObj.getPhone());
                inputCustomer.setNumber(cusObj.getNumber());
                inputCustomer.setDescrition(cusObj.getDescrition());
                inputCustomer.setEmployer(cusObj.getEmployer());
                inputCustomer.setWorkExperience(cusObj.getWorkExperience());
                inputCustomer.setSalary(cusObj.getSalary());
                inputCustomer.setUpdateBy(uid);

                //修改配偶基本信息
                if (null != inputSpouse) {
                    Integer code = updateGuarantee(inputSpouse, uid);
                    if (DataUtils.isNotNullOrEmpty(code)) {
                        model.addAttribute("code", code);
                        return "/common/success";
                    }
                }
                //修改父母基本信息
                if (null != inputParent) {
                    Integer code = updateGuarantee(inputParent, uid);
                    if (DataUtils.isNotNullOrEmpty(code)) {
                        model.addAttribute("code", code);
                        return "/common/success";
                    }
                }
                //修改未满24周岁直系担保人信息
                if (null != minorGuaObject) {
                    Integer code = updateGuarantee(minorGuaObject, uid);
                    if (DataUtils.isNotNullOrEmpty(code)) {
                        model.addAttribute("code", code);
                        return "/common/success";
                    }
                }

                //修改担保人基本信息
                if (null != inputGuarantee) {
                    updateGuarantee(inputGuarantee, uid);
                }
                //修改紧急联系人信息
                if (DataUtils.isNotNullOrEmpty(cusemerconListJson)) {
                    log.info(" cusemerconListJson  =   " + cusemerconListJson);
                    CusemerconListParam cusemerconListParam = GsonUtil.fromJson
                            (cusemerconListJson, CusemerconListParam.class);
                    List<Cusemercon> cusemerconList = cusemerconListParam.getList();
                    for (Cusemercon cusemercon : cusemerconList) {
                        log.info("  cusemercon name = " + cusemercon.getName() + " phone = " + cusemercon.getPhone() + " relation = " + cusemercon.getRelation());
                        if (DataUtils.isNullOrEmpty(cusemercon.getName())
                                || DataUtils.isNullOrEmpty(cusemercon.getPhone())
                                || DataUtils.isNullOrEmpty(cusemercon.getRelation())) {
                            model.addAttribute("code", -1000);
                            return "/common/success";
                        }
                        cusemercon.setCreateBy(Long.valueOf(uid));
                        cusemercon.setUpdateBy(Long.valueOf(uid));
                    }
                    cusemerconService.updateList(cusemerconList);
                }


            }
            //修改客户材料信息
            if (DataUtils.isNotNullOrEmpty(cusMetListJson)) {
                Object ccode = updatePersonnelMetarials(cusMetListJson, Customer.c_personnelType + "", cid, uid);
                if (DataUtils.isNotNullOrEmpty(ccode)) {
                    model.addAttribute("code", ccode);
                    return "/common/success";
                }
            }


            //修改配偶材料信息
            if (DataUtils.isNotNullOrEmpty(spouMetListJson)) {
                Object scode = updatePersonnelMetarials(spouMetListJson, Customer.s_personnelType + "", cid, uid);
                if (DataUtils.isNotNullOrEmpty(scode)) {
                    model.addAttribute("code", scode);
                    return "/common/success";
                }
            }


            //修改担保人材料信息
            if (DataUtils.isNotNullOrEmpty(guaMetListJson)) {

                Object gcode = updatePersonnelMetarials
                        (guaMetListJson, Customer.g_personnelType + "", cid, uid);
                if (DataUtils.isNotNullOrEmpty(gcode)) {
                    model.addAttribute("code", gcode);
                    return "/common/success";
                }
            }


            //保存进度和结果、以及上传合同和批复结果
            //资料审核
            if (Indent.RESULTT_0.equals(result)) {
                if (Iprocess.PROCESS5.equals(process)) {

                } else {
                    if (DataUtils.isNullOrEmpty(cerListJson)) {
                        model.addAttribute("code", -50003);
                        return "/common/success";
                    }
                }

            }

            CertificateResultParam certificateResultParam = new CertificateResultParam();
            if (DataUtils.isNotNullOrEmpty(cerListJson)) {
                certificateResultParam = GsonUtil.fromJson(cerListJson, CertificateResultParam.class);
            }
            List<Errcertificate> errcertificateList = new ArrayList<>();
            //返回申请资料
            log.info(" customer  certificate  start ");


            if (Checkresultrecord.ACTION_0.equals(action)) {
                log.info("  process is =" + process);
                //资料审核--初审开始
                if (process.equals(Iprocess.PROCESS3)) {
                    stage = Checkresultrecord.STAGE_0;
                    //申请资料审核
                    if (Indent.RESULTT_0.equals(result)) {


                        log.info(" unchecked  result  =" + result);
                        //不通过，进度加4，最终进度变为补充申请资料且状态为待上传
                        //保存进度与结果
                        //  insertProcess(cid,Iprocess.PROCESS3,description,Indent.RESULTT_0,uid);
                        insertProcess(cid, Iprocess.PROCESS4, "", Indent.WAITING, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS4);
                        indent.setProcess(Iprocess.PROCESS4);
                        indent.setReplyResult(Indent.WAITING);
                        log.info(" update customer process = " + Iprocess.PROCESS4);
                        inputCustomer.setProcess(Iprocess.PROCESS4);
                        //保存不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.CERTIFICATE);
                        //减去销售申请金额
                        money = Integer.valueOf(statistics.getApplyMoney()) - loanAmount;
                        statistics.setApplyMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getApplyCount()) - 1;
                        statistics.setApplyCount(salerCount + "");
                        //加在退档里
                        money = Integer.valueOf(statistics.getReturnMoney()) + loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) + 1;
                        log.info(" salerCount = " + salerCount);
                        statistics.setReturnCount(salerCount + "");

                    } else if (Indent.RESULTT_1.equals(result)) {
                        //同，进度加5，最终进度变为终审，状态为通过
                        // insertProcess(cid, Iprocess.PROCESS3, description, Indent.RESULTT_1, uid);
                        insertProcess(cid, Iprocess.PROCESS5, description, Indent.RESULTT_1, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS5);
                        indent.setProcess(Iprocess.PROCESS5);
                        indent.setReplyResult(Indent.RESULTT_1);
                        log.info("  update customer process = " + Iprocess.PROCESS5);
                        inputCustomer.setProcess(Iprocess.PROCESS5);
                        //保存进度与结果
                        //不改变销售统计
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);

                        //归档申请资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_2);

                        //pdf归档，如果需要才加
                        List<Long> propdffileIds = propdffileService.getPropdffileIdsByChannelIdAndProductType
                                (product.getChannel(), product.getType(), 0, Integer.MAX_VALUE);
                        log.info(" propdffileIds  size =  " + propdffileIds.size());
                        if (propdffileIds.size() > 0) {
                            getCustomerFile(indent.getId(), uid, "pdf");
                        }

                    }
                } else if (process.equals(Iprocess.PROCESS4) && iprocessList.get(0).
                        getResultFlag().equals(indent.UNCHECK)) {
                    stage = Checkresultrecord.STAGE_0;
                    //补充申请资料审核
                    if (Indent.RESULTT_0.equals(result)) {
                        //不通过
                        //保存进度与结果--仍为补充上传
                        //状态为待上传
                        //insertProcess(cid, Iprocess.PROCESS4, description, Indent.WAITING, uid);
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.WAITING);
                        iprocessService.update(iprocess);
                        indent.setReplyResult(Indent.WAITING);


                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);
                        //保存现在不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.CERTIFICATE);

                        //不改变销售统计
                    } else if (Indent.RESULTT_1.equals(result)) {
                        //保存进度与结果--变为终审
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_1);
                        iprocessService.update(iprocess);
                        //状态为通过
                        insertProcess(cid, Iprocess.PROCESS5, description, Indent.RESULTT_1, uid);
                        log.info("  update indent process = " + Iprocess.PROCESS5);
                        indent.setProcess(Iprocess.PROCESS5);
                        indent.setReplyResult(Indent.RESULTT_1);
                        log.info("  update customer process = " + Iprocess.PROCESS5);
                        inputCustomer.setProcess(Iprocess.PROCESS5);
                        //删除错误证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);
                        //减去退档统计
                        money = Integer.valueOf(statistics.getReturnMoney()) - loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) - 1;
                        statistics.setReturnCount(salerCount + "");
                        //加在申请统计
                        money = Integer.valueOf(statistics.getApplyMoney()) + loanAmount;
                        statistics.setApplyMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getApplyCount()) + 1;
                        statistics.setApplyCount(salerCount + "");
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);

                        //归档申请资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_2);
                        //pdf归档，如果需要才加
                        List<Long> propdffileIds = propdffileService.getPropdffileIdsByChannelIdAndProductType
                                (product.getChannel(), product.getType(), 0, Integer.MAX_VALUE);
                        log.info(" propdffileIds  size =  " + propdffileIds.size());
                        if (propdffileIds.size() > 0) {
                            getCustomerFile(indent.getId(), uid, "pdf");
                        }

                    }
                } else if (process.equals(Iprocess.PROCESS7) && iprocessList.get(0).
                        getResultFlag().equals(Indent.UNCHECK)) {
                    stage = Checkresultrecord.STAGE_2;

                    //合同资料审核
                    if (Indent.RESULTT_0.equals(result)) {
                        //不通过，改变进度为8
                        //状态为待上传
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_0);
                        iprocessService.update(iprocess);
                        insertProcess(cid, Iprocess.PROCESS8, description, Indent.WAITING, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS8);
                        indent.setProcess(Iprocess.PROCESS8);
                        indent.setReplyResult(Indent.WAITING);

                        log.info(" update customer process = " + Iprocess.PROCESS8);
                        inputCustomer.setProcess(Iprocess.PROCESS8);


                        //保存不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.CONTRACT);

                        //减去销售审核通过统计
                        money = Integer.valueOf(statistics.getPassMoney()) - loanAmount;
                        statistics.setPassMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getPassCount()) - 1;
                        statistics.setPassCount(salerCount + "");
                        //加上退档统计
                        money = Integer.valueOf(statistics.getReturnMoney()) + loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) + 1;
                        statistics.setReturnCount(salerCount + "");

                    } else if (Indent.RESULTT_1.equals(result)) {

                        //通过，不改变进度，只保存结果，状态为通过
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_1);
                        iprocessService.update(iprocess);
                        indent.setReplyResult(Indent.RESULTT_1);
                        //不改变销售统计
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);
                        //归档合同资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_3);
                    }
                } else if (process.equals(Iprocess.PROCESS8) && iprocessList.get(0).
                        getResultFlag().equals(Indent.UNCHECK)) {
                    stage = Checkresultrecord.STAGE_2;

                    //补充合同资料审核
                    if (Indent.RESULTT_0.equals(result)) {
                        //不通过，进度不变
                        //状态为待上传
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.WAITING);
                        iprocessService.update(iprocess);

                        indent.setReplyResult(Indent.WAITING);
                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);
                        //保存现在的不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.CONTRACT);
                        //不改变销售统计
                    } else if (Indent.RESULTT_1.equals(result)) {
                        //通过，不改变进度，只保存结果
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_1);
                        iprocessService.update(iprocess);
                        indent.setReplyResult(Indent.RESULTT_1);

                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);

                        //减去退档统计
                        money = Integer.valueOf(statistics.getReturnMoney()) - loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) - 1;
                        statistics.setReturnCount(salerCount + "");
                        //加上审核通过统计
                        money = Integer.valueOf(statistics.getPassMoney()) + loanAmount;
                        statistics.setPassMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getPassCount()) + 1;
                        statistics.setPassCount(salerCount + "");
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);

                        //归档合同资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_3);
                    }
                } else if (process.equals(Iprocess.PROCESS10) && iprocessList.get(0).
                        getResultFlag().equals(Indent.UNCHECK)) {
                    stage = Checkresultrecord.STAGE_3;

                    //放款资料审核
                    if (Indent.RESULTT_0.equals(result)) {
                        //不通过，进度加变为11，状态为待上传
                        //保存进度与结果
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_0);
                        iprocessService.update(iprocess);
                        insertProcess(cid, Iprocess.PROCESS11, description, Indent.WAITING, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS11);
                        indent.setProcess(Iprocess.PROCESS11);
                        indent.setReplyResult(Indent.WAITING);
                        log.info(" update customer process = " + Iprocess.PROCESS11);
                        inputCustomer.setProcess(Iprocess.PROCESS11);

                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);
                        //保存现在的不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.LOAN);

                        //减去销售的审核金额
                        //加上退档金额
                        //减去销售审核通过统计
                        money = Integer.valueOf(statistics.getPassMoney()) - loanAmount;
                        statistics.setPassMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getPassCount()) - 1;
                        statistics.setPassCount(salerCount + "");
                        //加上退档统计
                        money = Integer.valueOf(statistics.getReturnMoney()) + loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) + 1;
                        statistics.setReturnCount(salerCount + "");


                    } else if (Indent.RESULTT_1.equals(result)) {
                        //通过，进度改为放款，状态为待上传
                        //保存进度与结果
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_1);
                        iprocessService.update(iprocess);
                        // insertProcess(cid, Iprocess.PROCESS12, description, Indent.WAITING, uid);
                        // indent.setProcess(Iprocess.PROCESS12);
                         indent.setReplyResult(Indent.RESULTT_1);
                        // inputCustomer.setProcess(Iprocess.PROCESS12);

                        //不改变销售统计
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);
                        //归档放款资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_4);

                    }
                } else if (process.equals(Iprocess.PROCESS11) && iprocessList.get(0).
                        getResultFlag().equals(Indent.UNCHECK)) {
                    stage = Checkresultrecord.STAGE_3;

                    //补充放款资料审核
                    if (Indent.RESULTT_0.equals(result)) {
                        //不通过，进度不变，状态为待上传
                        //保存进度与结果
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.WAITING);
                        iprocessService.update(iprocess);
                        indent.setReplyResult(Indent.WAITING);


                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);
                        //保存现在的不合格证件
                        insertErrCertificate(certificateResultParam.getCertificateResultList(), cid, Constant.LOAN);

                        //不改变销售统计
                    } else if (Indent.RESULTT_1.equals(result)) {
                        //通过，进度改为上传贷后，状态为代码上传
                        //保存进度与结果
                        iprocess.setDescrition(description);
                        iprocess.setResultFlag(Indent.RESULTT_1);
                        iprocessService.update(iprocess);

                        // insertProcess(cid, Iprocess.PROCESS12, description, Indent.WAITING, uid)
                        // indent.setProcess(Iprocess.PROCESS12);
                         indent.setReplyResult(Indent.RESULTT_1);
                        // inputCustomer.setProcess(Iprocess.PROCESS12);

                        //删除之前的不合格证件
                        List<Long> errCerIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                                (cid, 0, Integer.MAX_VALUE);
                        errcertificateService.deleteList(Errcertificate.class, errCerIds);


                        //减去退档统计
                        money = Integer.valueOf(statistics.getReturnMoney()) - loanAmount;
                        statistics.setReturnMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getReturnCount()) - 1;
                        statistics.setReturnCount(salerCount + "");
                        //加上审核通过统计
                        money = Integer.valueOf(statistics.getPassMoney()) + loanAmount;
                        statistics.setPassMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getPassCount()) + 1;
                        statistics.setPassCount(salerCount + "");
                        //归档全部
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);
                        //归档放款资料
                        getCustomerFile(indent.getId(), uid, Idocument.TYPE_4);

                    }
                }


            }


            //批复
            if (Checkresultrecord.ACTION_3.equals(action)) {
                log.info("  action   = " + action);
                if (process.equals(Iprocess.PROCESS5)) {
                    log.info("  process = " + process);
                    stage = Checkresultrecord.STAGE_0;


                    //状态为  全额批复或有条件批复或拒绝
                    //如果为全额批复或者有条件批复，进度变为上传合同资料，且状态为待上传
                    //如果为拒绝，不更新进度
                    if (Indent.RESULTT_2.equals(result)) {
                        log.info("  result2 =" + result);
                        //更新进度
                        insertProcess(indent.getCustomerId(), Iprocess.PROCESS6, description, Indent.RESULTT_2, uid);
                        indent.setReplyDescription(description);
                        indent.setProcess(Iprocess.PROCESS6);
                        indent.setReplyResult(result);
                        inputCustomer.setProcess(Iprocess.PROCESS6);
                        //减去销售的申请金额和单数
                        money = Integer.valueOf(statistics.getApplyMoney()) - loanAmount;
                        statistics.setApplyMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getApplyCount()) - 1;
                        statistics.setApplyCount(salerCount + "");
                        //加上销售的拒绝单数
                        money = Integer.valueOf(statistics.getRefuseMoney()) + loanAmount;
                        statistics.setRefuseMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getRefuseCount()) + 1;
                        statistics.setRefuseCount(salerCount + "");


                    } else {
                        //开始批复
                        //保存批复进度和结果
                        if (Indent.RESULTT_1.equals(result)) {
                            //有条件批复

                            if (DataUtils.isNotNullOrEmpty(replyAmount)) {
                                indent.setReplyAmount(replyAmount);
                            } else {
                                model.addAttribute("code", -40003);
                                return "/common/success";
                            }
                        } else if (Indent.RESULTT_0.equals(result)) {
                            log.info(" loanAmount =  " + indent.getLoanAmount());
                            //全额批复

                            indent.setReplyAmount(indent.getLoanAmount());
                            log.info(" replyAmount = " + indent.getReplyAmount());
                        }

                        log.info("  result1,0 =" + result);
                        insertProcess(cid, Iprocess.PROCESS6, description, result, uid);
                        insertProcess(cid, Iprocess.PROCESS7, "", Indent.WAITING, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS7);
                        indent.setProcess(Iprocess.PROCESS7);
                        indent.setReplyResult(Indent.WAITING);

                        log.info(" update customer process = " + Iprocess.PROCESS7);
                        inputCustomer.setProcess(Iprocess.PROCESS7);

                        //减去销售的申请统计
                        money = Integer.valueOf(statistics.getApplyMoney()) - loanAmount;
                        statistics.setApplyMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getApplyCount()) - 1;
                        statistics.setApplyCount(salerCount + "");
                        //加上销售的审核通过统计
                        money = Integer.valueOf(statistics.getPassMoney()) + loanAmount;
                        statistics.setPassMoney(money + "");
                        salerCount = Integer.valueOf(statistics.getPassCount()) + 1;
                        statistics.setPassCount(salerCount + "");

                    }

                    indent.setMessage(message);
                    indentService.update(indent);
                    //归档
                    log.info("  replyamount = " + indent.getReplyAmount());
                    getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);

                }
                if ("0".equals(message)) {
                    if (!Indent.RESULTT_2.equals(result)) {
                        //调用通知短信模块

                        messageUtil.sendMessage(inputCustomer.getPhone());
                    }

                }

            }

            //生成合同
            if (Checkresultrecord.ACTION_1.equals(action)) {
                //上传合同
                //保存上传结果
                if (process.equals(Iprocess.PROCESS8) && iprocessList.get(0).getResultFlag().equals(Indent.RESULTT_1)
                        || process.equals(Iprocess.PROCESS7) && iprocessList.get(0).getResultFlag().
                        equals(Indent.RESULTT_1)) {
                    stage = Checkresultrecord.STAGE_2;


                    //保存合同资料
                    if (DataUtils.isNullOrEmpty(contractUrl)) {
                        model.addAttribute("code", -1000);
                        return "/common/success";
                    }
                    Idocument idocument = new Idocument();
                    idocument.setCustomerId(cid);
                    idocument.setPersonnelType(Customer.c_personnelType + "");
                    idocument.setDocumentType(Iprocess.CONTRACT);
                    idocument.setDocumentName("合同");
                    idocument.setImg(contractUrl);
                    idocument.setCreateBy(uid);
                    Long iId = idocumentService.insert(idocument);


                    //保存进度--生成合同和上传放款资料，状态变为待上传
                    if (DataUtils.isNotNullOrEmpty(iId)) {
                        //上传成功
                        insertProcess(cid, Iprocess.PROCESS9, description, Indent.RESULTT_1, uid);
                        insertProcess(cid, Iprocess.PROCESS10, description, Indent.WAITING, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS10);
                        indent.setProcess(Iprocess.PROCESS10);
                        indent.setReplyResult(Indent.WAITING);
                        log.info(" update customer process = " + Iprocess.PROCESS10);
                        inputCustomer.setProcess(Iprocess.PROCESS10);


                    } else {
                        insertProcess(cid, Iprocess.PROCESS9, description, Indent.RESULTT_0, uid);
                        log.info(" update indent process = " + Iprocess.PROCESS9);
                        indent.setProcess(Iprocess.PROCESS9);
                        indent.setReplyResult(Indent.RESULTT_0);
                        log.info(" update customer process = " + Iprocess.PROCESS9);
                        inputCustomer.setProcess(Iprocess.PROCESS9);


                    }
                    //发送合同给销售
                    Saler saler = salerService.getObjectById(inputCustomer.getSalerId());
                    mailUtil.sendMail(contractUrl, saler.getEmail(), inputCustomer.getName(), saler.getName());
                    //归档
                    log.info(" contract   make idocumet   contract id = " + iId);
                    getCustomerFile(indent.getId(), uid, Idocument.TYPE_1);
                }


            }

            //保存销售统计
            statisticsService.update(statistics);

            //保存进度
            log.info("  update indent process ");
            indent.setOperator(Long.valueOf(uid));
            indentService.update(indent);
            log.info("  update customer process ");
            customerService.update(inputCustomer);
            model.addAttribute("code", 0);


            log.info("  stage = " + stage);
            //保存记录
            //记录表
            List<Long> recordIds = checkresultrecordService.getIdsByIndentIdAndStageOrderByUpdateAt
                    (indent.getId(), stage, 0, Integer.MAX_VALUE);
            Integer count = recordIds.size();
            Checkresultrecord checkresultrecord = new Checkresultrecord();
            checkresultrecord.setStage(stage);
            checkresultrecord.setIndentId(indent.getId());
            checkresultrecord.setDescription(description);
            checkresultrecord.setResult(result);
            checkresultrecord.setAction(action);
            checkresultrecord.setModify(modifyStr);
            if (count.equals(0)) {
                checkresultrecord.setNumber(1 + "");
            } else {
                checkresultrecord.setNumber((count + 1) + "");
            }
            checkresultrecord.setCreateBy(uid);
            Long checkId = checkresultrecordService.insert(checkresultrecord);
            log.info("  checkId = " + checkId);
            List<Long> newProcessIds = iprocessService.getIprocessIdsByCustomerIdOrderByUpdateAt(cid, 0, Integer.MAX_VALUE);
            List<Iprocess> newIprocesses = iprocessService.getObjectsByIds(newProcessIds);
            log.info("  new process = " + newIprocesses.get(0).getProcess());
            log.info("  new result  = " + newIprocesses.get(0).getResultFlag());
            //修改SN码
            if (DataUtils.isNotNullOrEmpty(cussnListJson)) {
                CussnListParam cussnListParam = GsonUtil.fromJson(cussnListJson, CussnListParam.class);
                List<Cussn> cussnList = cussnListParam.getList();
                for (Cussn cussn : cussnList) {
                    if (DataUtils.isNotNullOrEmpty(cussn.getCustomerId())
                            || DataUtils.isNotNullOrEmpty(cussn.getNumber())
                            || DataUtils.isNotNullOrEmpty(cussn.getId())) {
                        log.info(" customerId = " + cussn.getCustomerId() + " number = " + cussn.getNumber());
                        model.addAttribute("code", -1000);
                        return "/common/success";
                    }
                }
                cussnService.updateList(cussnList);
            }

            //发送推送内容

            Saler saler = salerService.getObjectById(inputCustomer.getSalerId());
            //获取channlId
            String channelId = saler.getNoticeChannelId();
            log.info(" saler id = " + saler.getId() + "   saler " + saler.getName() + "  channelId = " + channelId);
            if (DataUtils.isNotNullOrEmpty(channelId)) {
                Map<String, String> messageMap =
                        new NoticeMessageUtil().setNotice(indent.getProcess(), indent.getReplyResult(), inputCustomer.getName());
                String customContent = "{\"" + "cid" + "\":" + inputCustomer.getId() + ",\"productType\":\"" + indent.getProductType() + "\"}";
                log.info("  customConte = " + customContent);

                this.noticeUtil.pushMessae(channelId, messageMap.get("title"), messageMap.get("description"), 3, 1, 86400 * 7, customContent);

            }


        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update indent error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


    public Map<Long, Map> getMaterial(String productType, String personnelType, List<CustomerMaterialRelation> cmrList) throws Exception {
        List<Long> perMeIds = permetarialService.getPermetarialIdsByPersonnelTypeOrderByUpdateAt
                (productType, personnelType, 0, Integer.MAX_VALUE);
        //需要填写的所有材料信息
        List<Permetarial> permetarialList = permetarialService.getObjectsByIds(perMeIds);
        log.info("  permetarialList   size = " + permetarialList.size());

        List<Long> mIds = new ArrayList<>();

        for (Permetarial permetarial : permetarialList) {
            Long id = permetarial.getMetarialId();
            mIds.add(id);
        }
        List<Material> metarialTotalList = materialService.getObjectsByIds(mIds);
        log.info(" metarialTotalList   size  =  " + metarialTotalList.size());


        //查找出父类列表
        List<Long> metarialTypeIds = constantService.
                getConstantIdsByTypeOrderByUpdateAt(Constant.metarialType, 0, Integer.MAX_VALUE);
        List<Constant> parentMetarialList = constantService.getObjectsByIds(metarialTypeIds);
        log.info(" parentMetarialList  size  is " + parentMetarialList.size());


        Map<Long, Map> parentMap = new HashMap<>();
        Map<String, List> parentMetarialMap = new HashMap<>();
        List<String> parentNameList = new ArrayList<>();
        for (Constant parentMetarial : parentMetarialList) {

            parentNameList.add(parentMetarial.getName());
            //居住状况
            String parentName = parentMetarial.getName();
            List<Long> metarialIds = constantService.getConstantsIdsByParentTypeOrderByUpdateAt
                    (parentName, 0, Integer.MAX_VALUE);
            List<Constant> constantList = constantService.getObjectsByIds(metarialIds);//户口、居住地
            log.info("  constantList  size  is " + constantList.size() + "   " + constantList.get(0).getName());
            List<String> metarialNameList = new ArrayList<>();
            Map<String, StringBuilder> metarialNameMap = new HashMap<>();//平常的

            for (Constant metarial : constantList) {
                //户口、贷款记录
                metarialNameList.add(metarial.getName());

                StringBuilder metarialValue = new StringBuilder();
                List<Long> list1 = new ArrayList<>();
                List<String> metarialValueList = new ArrayList<>();

                for (Material material : metarialTotalList) {
                    Long metarialName = material.getMetarialName();

                    if (metarialName.equals(metarial.getId())) {
                        list1.add(material.getMetarialValueName());//河南、郑州
                    }
                }
                List<Constant> constantList1 = constantService.getObjectsByIds(list1);
                for (Constant constant : constantList1) {
                    metarialValueList.add(constant.getName());
                }
                for (int i = 0; i < metarialValueList.size(); i++) {
                    if (i == metarialValueList.size() - 1) {
                        metarialValue.append(metarialValueList.get(i));

                    } else {
                        metarialValue.append(metarialValueList.get(i) + "、");
                    }
                }
                for (CustomerMaterialRelation cmr : cmrList) {
                    if (metarial.getName().equals(cmr.getConstantName())) {
                        metarialValue.append("、" + cmr.getMaterialName());
                    }
                }
                if (metarialValueList.size() > 0) {
                    metarialNameMap.put(metarial.getName(), metarialValue);

                }

            }
            parentMetarialMap.put(parentMetarial.getName(), metarialNameList);
            parentMap.put(parentMetarial.getId(), metarialNameMap);

        }
        return parentMap;

    }


    public IndentDocument getIdocument(Long cid, Long pid, String personnelType, String certificateType)
            throws Exception {

        log.info("  getIdocument  cid " + cid + "  pid  " + pid + "  certificateType " + certificateType + "personnelType = " + personnelType);
        IndentDocument indentDocument = new IndentDocument();
        indentDocument.setPersonnelType(personnelType + "");

        List<Long> certificateIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt
                (cid, personnelType, certificateType, 0, Integer.MAX_VALUE);
        List<Idocument> certificateList = idocumentService.getObjectsByIds(certificateIds);
        List<IndentCertificateImg> indentCertificateImgList = new ArrayList<>();



        log.info(" certificateIds  size = " + certificateList.size());
        if (Iprocess.CRTTIFICATE.equals(certificateType)) {
            Boolean shenfenzhen = false;
            for (Idocument idocument : certificateList) {
                if ("身份证".equals(idocument.getDocumentName())) {
                    shenfenzhen = true;
                    break;
                }
            }
            if (shenfenzhen) {
                IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                indentCertificateImg.setDocumentName("身份证");
                indentCertificateImg.setRequired(Pcertificate.REQUIRED);
                StringBuilder img = new StringBuilder();
                for (int i = 0; i < certificateList.size(); i++) {

                    if ("身份证".equals(certificateList.get(i).getDocumentName())) {
                        if (i == certificateList.size() - 1) {
                            img.append(certificateList.get(i).getImg() + ",");
                            img.append(certificateList.get(i).getUploadType());
                        } else {
                            img.append(certificateList.get(i).getImg() + ",");
                            img.append(certificateList.get(i).getUploadType() + ";");
                        }
                    }

                }
                log.info("  img = " + img);
                indentCertificateImg.setImg(img + "");
                indentCertificateImgList.add(indentCertificateImg);


            } else {


                if (Customer.c_personnelType.toString().equals(personnelType)) {
                    Customer customer = customerService.getObjectById(cid);
                    IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                    indentCertificateImg.setDocumentName("身份证");
                    indentCertificateImg.setRequired(Pcertificate.REQUIRED);
                    indentCertificateImg.setImg(customer.getIDCardFront() + "," + customer.getFrontFlag() + ";" + customer.getIDCardBack() + "," + customer.getBackFlag());
                    indentCertificateImgList.add(indentCertificateImg);
                } else if (Customer.s_personnelType.toString().equals(personnelType)) {
                    Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.s_personnelType + "");
                    if (DataUtils.isNotNullOrEmpty(id)) {
                        Guarantee guarantee = guaranteeService.getObjectById(id);
                        IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                        indentCertificateImg.setDocumentName("身份证");
                        indentCertificateImg.setRequired(Pcertificate.REQUIRED);
                        indentCertificateImg.setImg(guarantee.getIDCardFront() + "," + guarantee.getFrontFlag() + ";" + guarantee.getIDCardBack() + "," + guarantee.getBackFlag());
                        indentCertificateImgList.add(indentCertificateImg);
                    }

                } else if (Customer.g_personnelType.toString().equals(personnelType)) {
                    Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.g_personnelType + "");
                    if (DataUtils.isNotNullOrEmpty(id)) {
                        Guarantee guarantee = guaranteeService.getObjectById(id);
                        IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                        indentCertificateImg.setDocumentName("身份证");
                        indentCertificateImg.setRequired(Pcertificate.REQUIRED);
                        indentCertificateImg.setImg(guarantee.getIDCardFront() + "," + guarantee.getFrontFlag() + ";" + guarantee.getIDCardBack() + "," + guarantee.getBackFlag());
                        indentCertificateImgList.add(indentCertificateImg);

                    }

                }
            }
        }


        if (certificateIds.size() > 0) {

            if (personnelType.equals(Customer.s_personnelType + "")
                    || personnelType.equals(Customer.c_personnelType + "")) {

                //ist<Pcertificate> pcertificateList =  new ArrayList<>();
                if (Iprocess.CRTTIFICATE.equals(certificateType)) {
                    List<Long> pcertificateIds = pcertificateService.getPcertificateIdsByProductIdAndPersonnelTypeOrderByUpdateAt
                            (pid + "", personnelType, 0, Integer.MAX_VALUE);
                    List<Pcertificate> pcertificateList = pcertificateService.getObjectsByIds(pcertificateIds);
                    for (Pcertificate pcertificate : pcertificateList) {
                        String ducomentName = pcertificate.getCertificateName();

                        IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                        indentCertificateImg.setDocumentName(ducomentName);
                        indentCertificateImg.setRequired(pcertificate.getRequired());
                        StringBuilder img = new StringBuilder();
                        for (int i = 0; i < certificateList.size(); i++) {

                            if (ducomentName.equals(certificateList.get(i).getDocumentName())) {

                                if (i == certificateList.size() - 1) {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType());
                                } else {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType() + ";");
                                }

                            }
                        }
                        log.info("  img = " + img + "");

                        if (DataUtils.isNotNullOrEmpty(img + "")) {
                            indentCertificateImg.setImg(img + "");
                            indentCertificateImgList.add(indentCertificateImg);
                        }


                    }
                } else if (Iprocess.MAKE_CONTRACT.equals(certificateType)) {
                    Product product = productService.getObjectById(pid);
                    List<Long> pcertificateIds = pcontractService.getPcontractIdsByProductType(product.getType(), 0, Integer.MAX_VALUE);
                    List<Pcontract> pcertificateList = pcontractService.getObjectsByIds(pcertificateIds);
                    for (Pcontract pcertificate : pcertificateList) {
                        String ducomentName = pcertificate.getContractName();

                        IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                        indentCertificateImg.setDocumentName(ducomentName);
                        StringBuilder img = new StringBuilder();
                        for (int i = 0; i < certificateList.size(); i++) {

                            if (ducomentName.equals(certificateList.get(i).getDocumentName())) {

                                if (i == certificateList.size() - 1) {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType());
                                } else {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType() + ";");
                                }

                            }
                        }
                        log.info("  img = " + img);
                        indentCertificateImg.setImg(img + "");
                        indentCertificateImgList.add(indentCertificateImg);

                    }
                } else if (Iprocess.LOAN.equals(certificateType)) {
                    Product product = productService.getObjectById(pid);
                    List<Long> pcertificateIds = ploanService.getPloanIdsByProductIdOrderByUpdateAt(pid, 0, Integer.MAX_VALUE);
                    List<Ploan> pcertificateList = ploanService.getObjectsByIds(pcertificateIds);
                    for (Ploan pcertificate : pcertificateList) {
                        String ducomentName = pcertificate.getLoanName();

                        IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                        indentCertificateImg.setDocumentName(ducomentName);
                        StringBuilder img = new StringBuilder();
                        for (int i = 0; i < certificateList.size(); i++) {

                            if (ducomentName.equals(certificateList.get(i).getDocumentName())) {

                                if (i == certificateList.size() - 1) {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType());
                                } else {
                                    img.append(certificateList.get(i).getImg() + ",");
                                    img.append(certificateList.get(i).getUploadType() + ";");
                                }

                            }
                        }
                        log.info("  img = " + img);
                        indentCertificateImg.setImg(img + "");
                        indentCertificateImgList.add(indentCertificateImg);

                    }
                }

            } else {
                //  Boolean guarantee = false;
                //查找担保人上传的证件
                List<String> guaCertificateNameList = new ArrayList<>();
                Map<String,Integer> cerMap = new HashMap<>();
                List<Long> guaCertificateIds = guaCertificateService.getGuaCertificateIds(0, Integer.MAX_VALUE);
                log.info("   guaCertificateIds  size = " + guaCertificateIds.size());
                List<GuaCertificate> guaCertificateList = guaCertificateService.getObjectsByIds(guaCertificateIds);
                for (GuaCertificate guaCertificate : guaCertificateList) {
                    cerMap.put(guaCertificate.getCertificateName(),guaCertificate.getRequired());
                    guaCertificateNameList.add(guaCertificate.getCertificateName());
                }

                List<Long> cmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                        (cid.toString(), Customer.c_personnelType.toString(), 0, Integer.MAX_VALUE);
                List<CustomerMaterialRelation> cmrList = cmrService.getObjectsByIds(cmrIds);
                if (cmrList != null && cmrList.size() > 0) {
                    log.info("               ");
                    for (CustomerMaterialRelation customerMaterialRelation : cmrList) {

                        if (customerMaterialRelation.getMaterialName().contains(Customer.GUARANTEE)) {
                            // guarantee=true;
                            log.info("  guaCertificateName  = " + customerMaterialRelation.getConstantName());
                            cerMap.put(customerMaterialRelation.getConstantName(),Pcertificate.REQUIRED);
                            guaCertificateNameList.add(customerMaterialRelation.getConstantName());
                        }

                    }
                }
                //  log.info("  guarantee  = "+guarantee);
                //  if(guarantee){
                for (String guaCertificateName : guaCertificateNameList) {

                    IndentCertificateImg indentCertificateImg = new IndentCertificateImg();
                    indentCertificateImg.setDocumentName(guaCertificateName);
                    indentCertificateImg.setRequired(cerMap.get(guaCertificateName));
                    StringBuilder img = new StringBuilder();
                    for (int i = 0; i < certificateList.size(); i++) {
                        if (guaCertificateName.equals(certificateList.get(i).getDocumentName())) {
                            if (i == certificateList.size() - 1) {
                                img.append(certificateList.get(i).getImg() + ",");
                                img.append(certificateList.get(i).getUploadType());
                            } else {
                                img.append(certificateList.get(i).getImg() + ",");
                                img.append(certificateList.get(i).getUploadType() + ";");
                            }
                        }
                    }
                    indentCertificateImg.setImg(img + "");
                    indentCertificateImgList.add(indentCertificateImg);


                }
            }


            //}
        }


        log.info("  indentCertificateImgList = " + indentCertificateImgList.size());


        indentDocument.setIndentCertificateImgList(indentCertificateImgList);


        return indentDocument;


    }

    public IndentDocumentResult getDocumentResult(Long cid, Long pid, String certificateType, String result, String process,String type)
            throws Exception {
        log.info(" getDocumentResult  cid =" + cid + " pid " + pid + " certificateType  " + certificateType + " result " + result);

        IndentDocumentResult indentDocumentResult = new IndentDocumentResult();

        //返回归档资料
        String documentName = "";
        if(Idocument.TYPE_2.equals(type)){
            documentName = Idocument.APPLY;
        }else if(Idocument.TYPE_3.equals(type)){
            documentName = Idocument.CONTRACT;
        }else if(Idocument.TYPE_4.equals(type)){
            documentName = Idocument.LOAN;
        }
        log.info("  documentName = "+documentName);
        List<Long> dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(cid,
                Customer.c_personnelType + "", Iprocess.FILE, documentName, 0, Integer.MAX_VALUE);
        log.info(" dids  = "+dids);
        if (dids.size() > 0) {
            Idocument idocument = idocumentService.getObjectById(dids.get(0));
            indentDocumentResult.setZipUrl(idocument.getImg());
        }


        List<IndentDocument> indentDocumentList = new ArrayList<>();
        IndentDocument cIndentDocument =
                getIdocument(cid, pid, Customer.c_personnelType + "", certificateType);
        if (DataUtils.isNotNullOrEmpty(cIndentDocument)) {
            indentDocumentList.add(cIndentDocument);
        }

        if (Iprocess.CRTTIFICATE.equals(certificateType)) {

            IndentDocument sIndentDocument =
                    getIdocument(cid, pid, Customer.s_personnelType + "", certificateType);
            IndentDocument gIndentDocument =
                    getIdocument(cid, pid, Customer.g_personnelType + "", certificateType);
            if (DataUtils.isNotNullOrEmpty(sIndentDocument)) {
                indentDocumentList.add(sIndentDocument);
            }
            if (DataUtils.isNotNullOrEmpty(gIndentDocument)) {
                indentDocumentList.add(gIndentDocument);
            }
        }


        if (Indent.UNCHECK.equals(result)
                || Iprocess.PROCESS3.equals(process)) {
            indentDocumentResult.setResult(Indent.UNCHECK);
        }

        if (Iprocess.PROCESS4.equals(process)
                || Iprocess.PROCESS8.equals(process)
                || Iprocess.PROCESS11.equals(process)) {
            //不通过
            indentDocumentResult.setResult(Indent.RESULTT_0);


            List<Long> errIds = errcertificateService.getErrcertificateIdsByCustomerIdOrderByUpdateAt
                    (cid, 0, Integer.MAX_VALUE);
            log.info(" errIds  = " + errIds);
            List<Errcertificate> errcertificateList = errcertificateService.getObjectsByIds(errIds);
            if (errIds.size() > 0) {
                for (Errcertificate errcertificate : errcertificateList) {
                    log.info("  errcertificate  personnelType = " + errcertificate.getPersonnelType());
                    for (IndentDocument indentDocument : indentDocumentList) {
                        log.info(" indentDocument  personnelType  = " + indentDocument.getPersonnelType());
                        if (indentDocument.getPersonnelType().equals(errcertificate.getPersonnelType())) {
                            log.info("  ===   ");
                            for (IndentCertificateImg img : indentDocument.getIndentCertificateImgList()) {
                                log.info(" indentDocument.getIndentCertificateImgList() size  " + indentDocument.getIndentCertificateImgList().size());
                                //    Constant constant =  constantService.getObjectById(Long.valueOf(errcertificate.getCertificateName()));

                                if (img.getDocumentName().equals(errcertificate.getCertificateName())) {
                                    //某个证件设置为他的结果状态
                                    img.setResult(errcertificate.getResult());
                                }
                            }
                        }
                    }
                }
            }


        }
        if (Iprocess.PROCESS6.equals(process) && Indent.RESULTT_0.equals(result)) {
            //如果进度是批复，而且结果是全额批复，那么最终结果是通过
            indentDocumentResult.setResult(Indent.RESULTT_1);
        }

        if (Indent.RESULTT_1.equals(result) && !(Iprocess.PROCESS3.equals(process))) {
            //通过
            indentDocumentResult.setResult(Indent.RESULTT_1);
        }
        indentDocumentResult.setIndentDocumentList(indentDocumentList);

        log.info(" indentDocumentList = " + indentDocumentList);
        return indentDocumentResult;
    }


    public Object updatePersonnelMetarials(String metJson, String personnelType, Long cid, Long uid) throws Exception {

        log.info("  updatePersonnelMetarials   personnelType  = " + personnelType);
        List<CustomerMaterialRelation> list = new ArrayList<>();
        CusMetRelationParameter cusMetRelationParameter = GsonUtil.fromJson(metJson, CusMetRelationParameter.class);
        ObjectMapper objectMapper = new ObjectMapper();
        //  CusMetRelationParameter  cusMetRelationParameter = objectMapper.readValue(metJson,CusMetRelationParameter.class);
        if (null != cusMetRelationParameter) {
            List<CustomerMaterialRelation> relations = cusMetRelationParameter.getCustomerMaterialRelationList();
            for (CustomerMaterialRelation relation : relations) {
                log.info("aname: " + relation.getMaterialName());
            }
        }


        if (cusMetRelationParameter != null) {
            List<CustomerMaterialRelation> customerMaterialRelations = cusMetRelationParameter.getCustomerMaterialRelationList();
            if (customerMaterialRelations != null && customerMaterialRelations.size() > 0) {
                for (CustomerMaterialRelation cm : customerMaterialRelations) {

                    Long cmrId = customerMaterialRelationService.getIdsByCidAndPersonnelTypeAndConstantname(cid + "", personnelType, cm.getConstantName());
                    log.info("  customerMetarialRelation id = " + cmrId);
                    if (DataUtils.isNullOrEmpty(cmrId)) {
                        log.info("  customerMetarialRelation id = =  null ");
                        return -2003;
                    } else {

                        CustomerMaterialRelation customerMaterialRelation = customerMaterialRelationService.getObjectById(cmrId);
                        log.info(" cm constant = " + cm.getConstantName());
                        if (DataUtils.isNullOrEmpty(cm.getMaterialName())) {
                            log.info(" customerMetarialRelation  metarialName =  " + cm.getMaterialName());
                            return -2003;
                        } else {
                            customerMaterialRelation.setMaterialName(cm.getMaterialName());
                            customerMaterialRelation.setUpdateBy(uid);
                            list.add(customerMaterialRelation);
                        }
                    }
                }
                customerMaterialRelationService.updateList(list);
            }
        }
        return "";
    }


    public Integer updateGuarantee(Guarantee guarantee, Long uid) throws Exception {
        if (DataUtils.isNotNullOrEmpty(guarantee.getId())) {
            log.info(" guarantee id = " + guarantee.getId() + "  name =" + guarantee.getName());
            Guarantee inputGuarantee = guaranteeService.getObjectById(guarantee.getId());

            if (DataUtils.isNullOrEmpty(inputGuarantee.getName())
                    || DataUtils.isNullOrEmpty(inputGuarantee.getIDNumber())
                    ) {
                return -1000;
            }
            inputGuarantee.setName(guarantee.getName());
            inputGuarantee.setCenRegAddress(guarantee.getCenRegAddress());
            inputGuarantee.setPhone(guarantee.getPhone());
            inputGuarantee.setIDNumber(guarantee.getIDNumber());
            inputGuarantee.setEmployer(guarantee.getEmployer());
            inputGuarantee.setWorkExperience(guarantee.getWorkExperience());
            inputGuarantee.setSalary(guarantee.getSalary());
            inputGuarantee.setWorkAddress(guarantee.getWorkAddress());
            inputGuarantee.setPersonnelType(guarantee.getPersonnelType());
            inputGuarantee.setRelation(guarantee.getRelation());
            inputGuarantee.setUpdateBy(uid);
            guaranteeService.update(inputGuarantee);

        }
        return null;
    }


    //保存不合格证件
    public void insertErrCertificate(List<CertificateResult> certificateResultList, Long cid, String type) throws Exception {
        List<Errcertificate> errcertificateList = new ArrayList<>();
        log.info(" certificateResultList  size =  " + certificateResultList.size());
        if (certificateResultList.size() > 0) {
            for (CertificateResult certificateResult : certificateResultList) {
                Errcertificate errcertificate = new Errcertificate();
                errcertificate.setCustomerId(cid);
                errcertificate.setPersonnelType(certificateResult.getPersonnelType());
                errcertificate.setResult(certificateResult.getResult());
                //   Long id =  constantService.getConstantIdByNameAndType(certificateResult.getDocumentName(),type);

                errcertificate.setCertificateName(certificateResult.getDocumentName());
                errcertificateList.add(errcertificate);
            }
        }

        List<Errcertificate> errcertificates = errcertificateService.insertList(errcertificateList);
        log.info(" errcertificates  size =  " + errcertificates.size());

    }

    public void insertProcess(Long cid, String process, String decription, String resultFlag, Long uid) throws Exception {

        Iprocess iprocess = new Iprocess();
        iprocess.setProcess(process);
        iprocess.setCustomerId(cid);
        iprocess.setResultFlag(resultFlag);
        iprocess.setDescrition(decription);
        iprocess.setCreateBy(uid);
        iprocessService.insert(iprocess);
    }


    //保存修改记录
    //存储客户、配偶、担保人资料修改记录
    public String modify(String customer, String cusMetListJson,
                         String spouseStr, String spouMetListJson, String guaranteeStr,
                         String guaMetListJson, @PathVariable Long id,String parentStr,String minGuaStr) throws Exception {

        ObjectMapper mapper = new ObjectMapper();
        Customer cusObj = null;
        Guarantee spouse = null;
        Guarantee guarantee = null;
        Guarantee parent = null;
        Guarantee minGua = null;
        if (StringUtil.isNotEmpty(customer)) {
            cusObj = GsonUtil.fromJson(customer, Customer.class);
            log.info("cusObj is :" + cusObj.getName());
        }
        if (StringUtil.isNotEmpty(spouseStr)) {
            spouse = GsonUtil.fromJson(spouseStr, Guarantee.class);
            log.info("spouse is :" + spouse.getId());
        }
        if(StringUtil.isNotEmpty(parentStr)){
            parent = GsonUtil.fromJson(parentStr, Guarantee.class);
            log.info("parent is :" + parent.getId());
        }
        if(StringUtil.isNotEmpty(minGuaStr)){
            minGua = GsonUtil.fromJson(minGuaStr, Guarantee.class);
            log.info("parent is :" + minGua.getId());
        }
        if (StringUtil.isNotEmpty(guaranteeStr)) {
            guarantee = GsonUtil.fromJson(guaranteeStr, Guarantee.class);
            log.info("guarantee is :" + guarantee.getId());
        }

        //根据传进的id，找到customerOld
        Indent indent = indentService.getObjectById(id);
        Customer customerOld = customerService.getObjectById(indent.getCustomerId());
        log.info("customerOld is :" + customerOld.getId());

        //保存被修改的客户基本信息
        StringBuilder str = new StringBuilder();
        if (DataUtils.isNotNullOrEmpty(customer)) {
            str.append("客户：");

            if (!customerOld.getName().equals(cusObj.getName())) {
                str.append("客户姓名 ");
            }
            if (!customerOld.getCensRegAddress().equals(cusObj.getCensRegAddress())) {
                str.append("户籍地址 ");
            }
            if (!customerOld.getMarriage().equals(cusObj.getMarriage())) {
                str.append("婚姻状况 ");
            }
            if (!customerOld.getPhone().equals(cusObj.getPhone())) {
                str.append("联系电话 ");
            }
            if (!customerOld.getNumber().equals(cusObj.getNumber())) {
                str.append("身份证号 ");
            }
            if(!customerOld.getEmployer().equals(cusObj.getEmployer())){
                str.append("工作单位 ");
            }
            if(!customerOld.getWorkExperience().equals(cusObj.getWorkExperience())){
                str.append("工作年限（年） ");
            }
            if(!customerOld.getSalary().equals(cusObj.getSalary())){
                str.append("薪水 ");
            }
            if(!customerOld.getWorkAddressDetail().equals(cusObj.getWorkAddressDetail())){
                str.append("具体工作地 ");
            }
            if(!customerOld.getLiveAddressDetail().equals(cusObj.getLiveAddressDetail())){
                str.append("具体居住地 ");
            }

            if (DataUtils.isNotNullOrEmpty(customerOld.getDescrition()) &&
                    (!customerOld.getDescrition().equals(cusObj.getDescrition()))) {
                str.append("说明 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getFirstConName()) &&
                    (!customerOld.getFirstConName().equals(cusObj.getFirstConName()))) {
                str.append("紧急联系人一姓名 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getFirstConPhone()) &&
                    (!customerOld.getFirstConPhone().equals(cusObj.getFirstConPhone()))) {
                str.append("紧急联系人一电话 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getSecondConName()) &&
                    (!customerOld.getSecondConName().equals(cusObj.getSecondConName()))) {
                str.append("紧急联系人二姓名 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getSecondConPhone()) &&
                    (!customerOld.getSecondConPhone().equals(cusObj.getSecondConPhone()))) {
                str.append("紧急联系人二电话 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getThirdConName()) &&
                    (!customerOld.getThirdConName().equals(cusObj.getThirdConName()))) {
                str.append("紧急联系人三姓名 ");
            }
            if (DataUtils.isNotNullOrEmpty(customerOld.getThirdConPhone()) &&
                    (!customerOld.getThirdConPhone().equals(cusObj.getThirdConPhone()))) {
                str.append("紧急联系人三电话 ");
            }
            log.info("str is :" + str);
        }


        //保存被修改的客户材料信息
        //找到原来的材料信息
        List<Long> cusMatIdsOld =
                customerMaterialRelationService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(customerOld.getId() + "", Customer.c_personnelType + "", 0, Integer.MAX_VALUE);
        List<CustomerMaterialRelation> cusMatRelOld = customerMaterialRelationService.getObjectsByIds(cusMatIdsOld);


        //找到新传进的信息
        if (DataUtils.isNotNullOrEmpty(cusMetListJson)) {


            CusMetRelationParameter cusMetRelationParameter = GsonUtil.fromJson(cusMetListJson, CusMetRelationParameter.class);

            List<CustomerMaterialRelation> cusMatRelNew = cusMetRelationParameter.getCustomerMaterialRelationList();


            //对比信息是否被修改，若修改，则保存
            if (DataUtils.isNotNullOrEmpty(cusMatRelOld) && (DataUtils.isNotNullOrEmpty(cusMatRelNew))) {

                for (CustomerMaterialRelation cusMatsOld : cusMatRelOld) {

                    for (CustomerMaterialRelation cusMatsNew : cusMatRelNew) {


                        if (cusMatsOld.getConstantName().equals(cusMatsNew.getConstantName()) &&
                                (!cusMatsOld.getMaterialName().equals(cusMatsNew.getMaterialName()))) {
                            str.append(cusMatsOld.getConstantName() + " ");
                        }
                    }
                }
            }
            log.info("str is :" + str);
        }


        //根据customerOld，找到spouseOld
        Long spouseIdOld = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerOld.getId(), Customer.s_personnelType + "");

        Guarantee spouseOld = new Guarantee();
        if (DataUtils.isNotNullOrEmpty(spouseIdOld)) {
            spouseOld = guaranteeService.getObjectById(spouseIdOld);
        }


        log.info("spouseIdOld is :" + spouseIdOld);
        if (DataUtils.isNotNullOrEmpty(spouseIdOld)) {
            log.info(" 1  ");
            if (DataUtils.isNotNullOrEmpty(spouse)) {
                log.info(" 2 ");
                str.append("    配偶：");
                if (!spouseOld.getName().equals(spouse.getName())) {
                    str.append("姓名 ");
                }
                if (!spouseOld.getIDNumber().equals(spouse.getIDNumber())) {
                    str.append("身份证号 ");
                }
                if (!spouseOld.getCenRegAddress().equals(spouse.getCenRegAddress())) {
                    str.append("户籍地址 ");
                }
                if (!spouseOld.getPhone().equals(spouse.getPhone())) {
                    str.append("联系电话 ");
                }
                if(!spouseOld.getEmployer().equals(spouse.getEmployer())){
                    str.append("工作单位 ");
                }
                if(!spouseOld.getWorkExperience().equals(spouse.getWorkExperience())){
                    str.append("工作年限（年） ");
                }
                if(!spouseOld.getSalary().equals(spouse.getSalary())){
                    str.append("薪水 ");
                }
            }

            log.info("str is :" + str);

            //找到spoMatRelOld
            List<Long> spoMatIdsOlds =
                    customerMaterialRelationService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                            (cusObj.getId() + "", Customer.s_personnelType + "", 0, Integer.MAX_VALUE);
            List<CustomerMaterialRelation> spoMatRelOld = customerMaterialRelationService.getObjectsByIds(spoMatIdsOlds);


            //根据传进的spouMetListJson，找到spoMatsNew

            if ("".equals(spouMetListJson) || null == spouMetListJson) {
                log.info("   spouMetListJson  = " + spouMetListJson);
            } else {
                log.info("   spouMetListJson  = " + spouMetListJson);
                CusMetRelationParameter spoMetRelationParameter = GsonUtil.fromJson(spouMetListJson, CusMetRelationParameter.class);
                List<CustomerMaterialRelation> spoMatRelNew = spoMetRelationParameter.getCustomerMaterialRelationList();

                for (CustomerMaterialRelation spoMatsOld : spoMatRelOld) {

                    for (CustomerMaterialRelation spoMatsNew : spoMatRelNew) {
                        //  log.info("   spoMatsNew id   = "+spoMatsNew.getId());
                        if (spoMatsOld.getConstantName().equals(spoMatsNew.getConstantName()) &&
                                (!spoMatsOld.getMaterialName().equals(spoMatsNew.getMaterialName()))) {

                            str.append(spoMatsOld.getConstantName() + " ");
                        }
                    }
                }
                log.info("str is :" + str);
            }



            //根据customerOld，找到parentOld
            Long parentOldId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerOld.getId(), Customer.f_personnelType + "");
            if(null == parentOldId){
                parentOldId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerOld.getId(), Customer.m_personnelType + "");
            }

            log.info("  parentOldId = "+parentOldId);
            Guarantee parentOld = new Guarantee();
            if (DataUtils.isNotNullOrEmpty(parentOldId)) {
                parentOld = guaranteeService.getObjectById(parentOldId);
                if (DataUtils.isNotNullOrEmpty(parent)) {
                    log.info(" 4 ");
                    str.append("    父母信息：");
                    if (!parentOld.getPersonnelType().equals(parent.getPersonnelType())) {
                        str.append("与申请人关系 ");
                    }
                    if (!parentOld.getName().equals(parent.getName())) {
                        str.append("姓名 ");
                    }
                    if (!parentOld.getIDNumber().equals(parent.getIDNumber())) {
                        str.append("身份证号 ");
                    }
                    if (!parentOld.getPhone().equals(parent.getPhone())) {
                        str.append("联系电话 ");
                    }
                    if(!parentOld.getEmployer().equals(parent.getEmployer())){
                        str.append("工作单位 ");
                    }
                    if(!parentOld.getWorkAddress().equals(parent.getWorkAddress())){
                        str.append("工作地址 ");
                    }
                }

                log.info("str is :" + str);




            }

            //根据customerOld，找到parentOld
            Long minGuaOldId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerOld.getId(), Customer.minor_personnelType + "");
            log.info("  minGuaOldId = "+minGuaOldId);
            Guarantee minGuaOld = new Guarantee();
            if (DataUtils.isNotNullOrEmpty(minGuaOldId)) {
                minGuaOld = guaranteeService.getObjectById(minGuaOldId);
                if (DataUtils.isNotNullOrEmpty(minGua)) {
                    log.info(" 5 ");
                    str.append("    直系亲属担保人信息：");
                    if (!minGuaOld.getRelation().equals(minGua.getRelation())) {
                        str.append("与申请人关系 ");
                    }
                    if (!minGuaOld.getName().equals(minGua.getName())) {
                        str.append("姓名 ");
                    }
                    if (!minGuaOld.getIDNumber().equals(minGua.getIDNumber())) {
                        str.append("身份证号 ");
                    }
//                    if (!minGuaOld.getPhone().equals(minGua.getPhone())) {
//                        str.append("联系电话 ");
//                    }
                    if(!minGuaOld.getEmployer().equals(minGua.getEmployer())){
                        str.append("工作单位 ");
                    }
                    if(!minGuaOld.getWorkAddress().equals(minGua.getWorkAddress())){
                        str.append("工作地址 ");
                    }
                }

                log.info("str is :" + str);




            }





            //根据customerOld，则找到其对应的guaranteeOld
            Long guaranteeOldId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customerOld.getId(), Customer.g_personnelType + "");


            Guarantee guaranteeOld = new Guarantee();
            if (DataUtils.isNotNullOrEmpty(guaranteeOldId)) {
                guaranteeOld = guaranteeService.getObjectById(guaranteeOldId);
            }


            log.info("guaranteeOldId is :" + guaranteeOldId);

            //保存被修改的基本信息
            if (DataUtils.isNotNullOrEmpty(guaranteeOldId)) {
                if (DataUtils.isNotNullOrEmpty(guarantee)) {
                    str.append("    担保人：");
                    if (!guaranteeOld.getName().equals(guarantee.getName())) {
                        str.append("姓名 ");
                    }
                    if (!guaranteeOld.getIDNumber().equals(guarantee.getIDNumber())) {
                        str.append("身份证号 ");
                    }
                    if (!guaranteeOld.getCenRegAddress().equals(guarantee.getCenRegAddress())) {
                        str.append("户籍地址 ");
                    }
                    if (!guaranteeOld.getPhone().equals(guarantee.getPhone())) {
                        str.append("联系电话 ");
                    }
                }

                log.info("str is :" + str);


                //找到guaMatRelOld
//                Long guaMatRelId =
//                        customerMaterialRelationService.getCustomerMaterialRelationIdByCustomerIdAndPersonnelType(guaranteeOldId + "", Customer.c_personnelType + "");
                List<Long> guaMatIdsOld =
                        customerMaterialRelationService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt(customerOld.getId() + "", Customer.g_personnelType + "", 0, Integer.MAX_VALUE);
                List<CustomerMaterialRelation> guaMatRelOld = customerMaterialRelationService.getObjectsByIds(guaMatIdsOld);

                //找到guaMatRelNew，保存被修改的材料信息
                if (DataUtils.isNotNullOrEmpty(guaMetListJson)) {
                    if (!"".equals(guaMetListJson)) {
                        CusMetRelationParameter guaMetRelationParameter = GsonUtil.fromJson(guaMetListJson, CusMetRelationParameter.class);

                        // if (DataUtils.isNotNullOrEmpty(guaMetRelationParameter)) {
                        List<CustomerMaterialRelation> guaMatRelNew = guaMetRelationParameter.getCustomerMaterialRelationList();


                        if (DataUtils.isNotNullOrEmpty(guaMatRelNew)) {

                            for (CustomerMaterialRelation guaMatsOld : guaMatRelOld) {
                                log.info(" guaMatsOld   = " + guaMatsOld);
                                for (CustomerMaterialRelation guaMatsNew : guaMatRelNew) {
                                    log.info("  guaMatsNew  =  " + guaMatsNew);
                                    if (guaMatsOld.getConstantName().equals(guaMatsNew.getConstantName()) &&
                                            (!guaMatsOld.getMaterialName().equals(guaMatsNew.getMaterialName()))) {
                                        str.append(guaMatsOld.getConstantName() + " ");
                                    }
                                }
                            }
                        }
                        //}
                        log.info("str is :" + str);
                    }

                }
            }
        }
        return str + "";
    }


    //归档并下载
    public void getCustomerFile(Long id, Long uid, String type) throws Exception {
        log.info("  indent id =" + id + " , uid = " + uid);
        try {
            Indent indent = indentService.getObjectById(id);
            Customer customer = customerService.getObjectById(indent.getCustomerId());
            String newProcess = indent.getProcess();
            String newResult = indent.getReplyResult();
            log.info("nowProcess  =  " + newProcess + "  newResult = " + newResult);
            JSONObject jsonObject = new JSONObject();
            if ("pdf".equals(type)) {
                jsonObject = getPDFDocumentUrlJson(indent);
            } else if(Idocument.TYPE_1.equals(type)
                    ||Idocument.TYPE_2.equals(type)){
                log.info(" 1 or  2 ");
                //归档全部或者申请资料，使用同一方法，只是zip名称不同
                jsonObject = getDocumentUrl(indent,type);
            }else if(Idocument.TYPE_3.equals(type)
                    ||Idocument.TYPE_4.equals(type)){
                log.info(" 3 or  4 ");
                //归档合同资料或者放款资料，使用同一方法，只是zip名称不同
                jsonObject = getContractDocumentUrl(indent, type);
            }

            log.info("  jsonObject =" + jsonObject);
            System.out.println(jsonObject);
            String jsonString = jsonObject.toString();
            String jsonTxt = "";
            String datafileName = Txt.pdfPath + customer.getName() + indent.getNumber() + "/";


            if ("pdf".equals(type)) {
                jsonTxt = Txt.creatTxtFile(indent.getNumber() + "pdfjson", "pdf", datafileName);
            } else if(Idocument.TYPE_1.equals(type)){
                //全部
                jsonTxt = Txt.creatTxtFile(indent.getNumber() + "filejson");
            }else if(Idocument.TYPE_2.equals(type)){
                //申请资料
                jsonTxt = Txt.creatTxtFile(indent.getNumber() + "applyjson");
            }else if(Idocument.TYPE_3.equals(type)){
                //合同资料
                jsonTxt = Txt.creatTxtFile(indent.getNumber() + "contractjson");
            }else if(Idocument.TYPE_4.equals(type)){
                //放款资料
                jsonTxt = Txt.creatTxtFile(indent.getNumber() + "loanjson");
            }
            log.info("  json.txt name = " + jsonTxt);
            Txt.writeTxtFile(jsonString);

            try {
                Process proc = null;
//                Process proc = Runtime.getRuntime().exec
//                        ("python /data/server/resin-carjn-admin/scripts/download_3.py  " + jsonTxt);
                if ("pdf".equals(type)) {
                   proc = Runtime.getRuntime().exec
                            ("python /data/server/resin-carjn-admin/scripts/pdfdownload.py  " + jsonTxt);
                } else if(Idocument.TYPE_1.equals(type)){
                    proc = Runtime.getRuntime().exec
                            ("python /data/server/resin-carjn-admin/scripts/download_3.py  " + jsonTxt);
                }else if(Idocument.TYPE_2.equals(type)){
                    proc = Runtime.getRuntime().exec
                            ("python /data/server/resin-carjn-admin/scripts/other/download_3_apply.py  " + jsonTxt);
                }else {
                    proc = Runtime.getRuntime().exec
                            ("python /data/server/resin-carjn-admin/scripts/other/download_3.py  " + jsonTxt);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line;
                while ((line = in.readLine()) != null) {
                    log.info("  line  " + line);
                }
                  in.close();
                  proc.waitFor();

                String url = "";
                if ("pdf".equals(type)) {
                    url = "/pdfdownload/" + customer.getName() + "" + indent.getNumber() + ".zip";
                }else if(Idocument.TYPE_1.equals(type)){
                    //全部
                    url = "/download/" + customer.getName() + "" + indent.getNumber() + Iprocess.FILE_NAME+".zip";
                }else if(Idocument.TYPE_2.equals(type)){
                    //申请资料
                    url = "/download/" + customer.getName() + "" + indent.getNumber() + Idocument.APPLY+".zip";
                }else if(Idocument.TYPE_3.equals(type)){
                    //合同资料
                    url = "/download/" + customer.getName() + "" + indent.getNumber() + Idocument.CONTRACT+".zip";
                }else if(Idocument.TYPE_4.equals(type)){
                    //放款资料
                    url = "/download/" + customer.getName() + "" + indent.getNumber() + Idocument.LOAN+".zip";
                }


                List<Long> dids = new ArrayList<>();

                if ("pdf".equals(type)) {
                    dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                            Customer.c_personnelType + "", Iprocess.PDF_FILE, Iprocess.PDF_FILE_NAME, 0, Integer.MAX_VALUE);
                } else if(Idocument.TYPE_1.equals(type)){
                    //全部
                    dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                            Customer.c_personnelType + "", Iprocess.FILE, Iprocess.FILE_NAME, 0, Integer.MAX_VALUE);
                }else if(Idocument.TYPE_2.equals(type)){
                    //申请
                    dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                            Customer.c_personnelType + "", Iprocess.FILE, Idocument.APPLY, 0, Integer.MAX_VALUE);
                }else if(Idocument.TYPE_3.equals(type)){
                    //合同
                    dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                            Customer.c_personnelType + "", Iprocess.FILE, Idocument.CONTRACT, 0, Integer.MAX_VALUE);
                }else if(Idocument.TYPE_4.equals(type)){
                    //放款
                    dids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(indent.getCustomerId(),
                            Customer.c_personnelType + "", Iprocess.FILE, Idocument.LOAN, 0, Integer.MAX_VALUE);
                }


                if (dids.size() > 0) {
                    Idocument idocument = idocumentService.getObjectById(dids.get(0));
                    idocument.setImg(url);
                    idocument.setUploadType(Idocument.ING);
                    idocumentService.update(idocument);

                } else {
                    //保存数据
                    Idocument idocument = new Idocument();
                    idocument.setImg(url);
                    idocument.setPersonnelType(Customer.c_personnelType + "");
                    if ("pdf".equals(type)) {
                        idocument.setDocumentType(Iprocess.PDF_FILE);
                        idocument.setDocumentName(Iprocess.PDF_FILE_NAME);
                    } else  if(Idocument.TYPE_1.equals(type)){
                        idocument.setDocumentType(Iprocess.FILE);
                        idocument.setDocumentName(Iprocess.FILE_NAME);
                    } else  if(Idocument.TYPE_2.equals(type)){
                        idocument.setDocumentType(Iprocess.FILE);
                        idocument.setDocumentName(Idocument.APPLY);
                    } else  if(Idocument.TYPE_3.equals(type)){
                        idocument.setDocumentType(Iprocess.FILE);
                        idocument.setDocumentName(Idocument.CONTRACT);
                    } else  if(Idocument.TYPE_4.equals(type)){
                        idocument.setDocumentType(Iprocess.FILE);
                        idocument.setDocumentName(Idocument.LOAN);
                    }

                    idocument.setCustomerId(indent.getCustomerId());
                    idocument.setUploadType(Idocument.ING);
                    idocument.setCreateBy(Long.valueOf(uid));
                    Long iId = idocumentService.insert(idocument);
                    log.info("  idcoumetn  id =" + iId);
                }
            } catch (Exception e) {
                log.info("  get zip  error ");
            }
        } catch (Throwable t) {
            log.error("  error  document  ");
            t.printStackTrace();
        }


    }
    //生成合同的以及放款资料的
    public JSONObject getContractDocumentUrl(Indent indent,String type) throws Exception {

        log.info("  getContractDocumentUrl  type = "+type);
        Customer customer = customerService.getObjectById(indent.getCustomerId());
        JSONObject jsonObject = new JSONObject();

        if(Idocument.TYPE_3.equals(type)){
            log.info(" json  contract  ");
            jsonObject.put("name", customer.getName() + "" + indent.getNumber()+Idocument.CONTRACT);
        }else if(Idocument.TYPE_4.equals(type)){
            log.info(" json  loan  ");
            jsonObject.put("name", customer.getName() + "" + indent.getNumber()+Idocument.LOAN);
        }
        log.info("  zip file name = "+jsonObject.getString("name"));
        String customerName = customer.getName();
        String customerNumber = indent.getNumber();
        JSONArray jsonArray5 = new JSONArray();
        if(Idocument.TYPE_3.equals(type)){

            log.info("  contract  ");
            //查询合同资料是否已上传
            List<Long> makeContractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                    (customer.getId(), Iprocess.MAKE_CONTRACT, 0, Integer.MAX_VALUE);

            if (makeContractIds.size() > 0) {
                JSONObject jsonObject1 = new JSONObject();
                JSONArray file = getIdocumentOtherByPer(makeContractIds, Iprocess.MAKE_CONTRACT, customerName, customerNumber);
                jsonObject1.put("name", customerName + "合同资料" + customerNumber);
                jsonObject1.put("file", file);
                //  jsonObject.put("hetongzl",jsonObject1);
                jsonArray5.add(jsonObject1);

            }
        }else if (Idocument.TYPE_4.equals(type)){
            log.info("  loan  ");
            //查询放款资料是否已上传
            List<Long> loantractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                    (customer.getId(), Iprocess.LOAN, 0, Integer.MAX_VALUE);
            if (loantractIds.size() > 0) {
                JSONObject jsonObject4 = new JSONObject();
                JSONArray file = getIdocumentOtherByPer(loantractIds, Iprocess.LOAN, customerName, customerNumber);
                jsonObject4.put("name", customerName + "放款资料" + customerNumber);
                jsonObject4.put("file", file);
//            jsonObject.put("fangkuanzl",jsonObject4);
                jsonArray5.add(jsonObject4);

            }
        }




        jsonObject.put("file", jsonArray5);


        return jsonObject;
    }
    //生成全部的以及申请资料的
    public JSONObject getDocumentUrl(Indent indent,String type) throws Exception {
        log.info("   make idocument start ");
        log.info("  getDocumentUrl  type = "+type);
        Customer customer = customerService.getObjectById(indent.getCustomerId());
        //客户材料信息
        List<Long> cCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                (customer.getId() + "", Customer.c_personnelType + "", 0, Integer.MAX_VALUE);
        List<CustomerMaterialRelation> cCmrList = cmrService.getObjectsByIds(cCmrIds);
        //配偶材料信息
        String marriedFlag = customer.getMarriage();
        Guarantee spouse = new Guarantee();
        List<CustomerMaterialRelation> sCmrList = new ArrayList<>();
        if (Customer.married.equals(marriedFlag)) {
            //已婚，填配偶信息
            spouse = guaranteeService.getObjectById(guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.s_personnelType + ""));

            List<Long> sCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.s_personnelType + "", 0, Integer.MAX_VALUE);
            sCmrList = cmrService.getObjectsByIds(sCmrIds);
        }else{
            //父母信息
            Long parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.f_personnelType + "");
            log.info(" parentId = "+parentId);
            if(null == parentId){
                parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(), Customer.m_personnelType + "");
            }
            log.info(" parentId = "+parentId);
            if(null != parentId){
                spouse = guaranteeService.getObjectById(parentId);
            }

        }
        //担保人材料信息
        Guarantee guarantee = new Guarantee();
        List<CustomerMaterialRelation> gCmrList = new ArrayList<>();
        Long guaId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.g_personnelType + "");
        Boolean guaFlag = false;
        if (DataUtils.isNotNullOrEmpty(guaId)) {
            guaFlag = true;
            guarantee = guaranteeService.getObjectById(guaId);

            List<Long> gCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.g_personnelType + "", 0, Integer.MAX_VALUE);
            gCmrList = cmrService.getObjectsByIds(gCmrIds);
        }
        //未满24周岁，直系亲属担保人基本信息
        Long minGuaId =  guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.minor_personnelType + "");
        Guarantee minGua = new Guarantee();
        if(null != minGuaId){
            minGua = guaranteeService.getObjectById(minGuaId);
        }

        String filenameTemp = "";
        //新建txt文件

        filenameTemp = Txt.creatTxtFile(customer.getName() + "" + indent.getNumber());
        String marriage = "";
        if (Customer.married.equals(customer.getMarriage())) {
            marriage = "已婚";
        } else if (Customer.unmarried.equals(customer.getMarriage())) {
            marriage = "未婚";
        } else if (Customer.divorced.equals(customer.getMarriage())) {
            marriage = "离异";
        }
        int length = 60;

        Txt.writeTxtFile("客户信息");
        Txt.writeTxtFile(formatStr("客户姓名：" + customer.getName(), length) + "\r\n" + formatStr("婚姻状况：" + marriage, length));

        Txt.writeTxtFile(formatStr("联系电话：" + customer.getPhone(), length) + "\r\n" + formatStr("身份证号：" + customer.getNumber(), length));
        Txt.writeTxtFile(formatStr("户籍地址：" + customer.getCensRegAddress(), length * 2));
        Txt.writeTxtFile(formatStr("工作单位：" + customer.getEmployer(), length * 2));
        Txt.writeTxtFile(formatStr("工作年限（年）：" + customer.getWorkExperience(), length * 2));
        Txt.writeTxtFile(formatStr("薪水：" + customer.getSalary(), length * 2));
        Txt.writeTxtFile(formatStr("具体工作地：" + customer.getWorkAddressDetail(), length * 2));
        Txt.writeTxtFile(formatStr("具体居住地：" + customer.getLiveAddressDetail(), length * 2));



        for (int i = 0; i < cCmrList.size(); i++) {
            String metarialname1 = getMetarialName(cCmrList.get(i).getConstantName(), cCmrList.get(i).getMaterialName());
            cCmrList.get(i).setConstantName(cCmrList.get(i).getConstantName().split("_")[0]);
            String metarialname2 = "";
            if (i + 1 < cCmrList.size()) {
                metarialname2 = getMetarialName(cCmrList.get(i + 1).getConstantName(), cCmrList.get(i + 1).getMaterialName());
                cCmrList.get(i + 1).setConstantName(cCmrList.get(i + 1).getConstantName().split("_")[0]);

            }


            if (i == cCmrList.size() - 1) {
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                );
            } else {
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                        formatStr(cCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
            }
            i++;

        }


        if (Customer.married.equals(marriedFlag)) {
            Txt.writeTxtFile("配偶信息");
            Txt.writeTxtFile(formatStr("姓名：" + spouse.getName(), length) + "\r\n" + formatStr("身份证号：" + spouse.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + spouse.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("户籍地址：" + spouse.getCenRegAddress(), length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作年限（年）：" + spouse.getWorkExperience(), length * 2));
            Txt.writeTxtFile(formatStr("薪水：" + spouse.getSalary(), length * 2));
            for (int i = 0; i < sCmrList.size(); i++) {
                String metarialname1 = getMetarialName(sCmrList.get(i).getConstantName(), sCmrList.get(i).getMaterialName());
                sCmrList.get(i).setConstantName(sCmrList.get(i).getConstantName().split("_")[0]);
                String metarialname2 = "";
                if (i + 1 < sCmrList.size()) {

                    metarialname2 = getMetarialName(sCmrList.get(i + 1).getConstantName(), sCmrList.get(i + 1).getMaterialName());
                    sCmrList.get(i + 1).setConstantName(sCmrList.get(i + 1).getConstantName().split("_")[0]);

                }
                if (i == sCmrList.size() - 1) {
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                    );
                } else {
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                            formatStr(sCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
                }
                i++;

            }
        }else{
            //没有配偶，填写父母信息

            Txt.writeTxtFile("父母信息");
            Txt.writeTxtFile(formatStr("与申请人关系：" + spouse.getPersonnelType(), length * 2));
            Txt.writeTxtFile(formatStr("姓名：" + spouse.getName(), length) + "\r\n" + formatStr("身份证号：" + spouse.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + spouse.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + spouse.getWorkAddress(), length * 2));
        }

        if (guaFlag) {
            Txt.writeTxtFile("担保人信息");
            Txt.writeTxtFile(formatStr("姓名：" + guarantee.getName(), length) + "\r\n" + formatStr("身份证号：" + guarantee.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + guarantee.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("户籍地址：" + guarantee.getCenRegAddress(), length * 2));
            for (int i = 0; i < gCmrList.size(); i++) {
                String metarialname1 = getMetarialName(gCmrList.get(i).getConstantName(), gCmrList.get(i).getMaterialName());
                gCmrList.get(i).setConstantName(gCmrList.get(i).getConstantName().split("_")[0]);

                String metarialname2 = "";
                if (i + 1 < gCmrList.size()) {
                    metarialname2 = getMetarialName(gCmrList.get(i + 1).getConstantName(), gCmrList.get(i + 1).getMaterialName());
                    gCmrList.get(i + 1).setConstantName(gCmrList.get(i + 1).getConstantName().split("_")[0]);

                }
                if (i == gCmrList.size() - 1) {
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                    );
                } else {
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                            formatStr(gCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
                }
                i++;

            }
        }
        if(null != minGuaId && null != minGua){
            Txt.writeTxtFile("未满24周岁，直系亲属担保人信息");
            Txt.writeTxtFile(formatStr("姓名：" + minGua.getName(), length) + "\r\n" + formatStr("身份证号：" + minGua.getIDNumber(), length));
            String relation = "";
            if(Guarantee.RELATION_1.equals(minGua.getRelation())){
                relation = Guarantee.PARENT;
            }
            if(Guarantee.RELATION_5.equals(minGua.getRelation())){
                relation = Guarantee.SISTER;
            }
            if(Guarantee.RELATION_10.equals(minGua.getRelation())){
                relation = Guarantee.CHILDREN;
            }
            Txt.writeTxtFile(formatStr("与主贷人关系：" + relation, length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + minGua.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + minGua.getWorkAddress(), length * 2));
        }

        //紧急联系人信息
        Txt.writeTxtFile("紧急联系人信息");
        List<Long> cusemerconIds = cusemerconService.getCusemerconIdsByCustomerId(customer.getId(), 0, Integer.MAX_VALUE);
        List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(cusemerconIds);

        for (int i = 0; i < cusemerconIds.size(); i++) {
            int j = i + 1;
            String relation = getRelationWithEmerCon(cusemerconList.get(i).getRelation());
            Txt.writeTxtFile(formatStr("第" + j + "位联系人姓名：" + cusemerconList.get(i).getName(), length) + formatStr("第" + j + "位联系人电话：" + cusemerconList.get(i).getPhone(), length) + formatStr("与第" + j + "位联系人关系：" + relation, length));


        }

        Txt.writeTxtFile(formatStr("补充说明：", length * 2));
        Txt.writeTxtFile(formatStr(customer.getDescrition(), length * 2));


        //订单信息
        Txt.writeTxtFile("车辆信息");
        if (Product.loan_productType.equals(indent.getProductType())) {
            Txt.writeTxtFile(formatStr("车型", length / 2) + formatStr("评估价格(元)", length / 2) + formatStr("出厂日期", length / 2) + formatStr("上牌日期", length / 2) + formatStr("行驶公里数", length / 2));

        } else {
            Txt.writeTxtFile(formatStr("车型", length / 2) + formatStr("价格(元)", length / 2) + formatStr("出厂日期", length / 2) + formatStr("上牌日期", length / 2) + formatStr("行驶公里数", length / 2));

        }
        //转换一下时间
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String productionDate = "";
        if (DataUtils.isNotNullOrEmpty(indent.getProductionDate())) {
            productionDate = sdf.format(new Date(indent.getProductionDate()));
        }
        String licenseDate = "";
        if (DataUtils.isNotNullOrEmpty(indent.getLicenseDate())) {
            licenseDate = sdf.format(new Date(indent.getLicenseDate()));
        }
        String kilometers = "";
        if (DataUtils.isNotNullOrEmpty(indent.getDrivingKilometers())) {
            kilometers = indent.getDrivingKilometers();
        }

        Txt.writeTxtFile(formatStr(indent.getCarType(), length / 2) + formatStr(indent.getSumPrice(), length / 2) + formatStr(productionDate, length / 2) + formatStr(licenseDate, length / 2) + formatStr(kilometers, length / 2));
        Txt.writeTxtFile("贷款方案");
        Txt.writeTxtFile(formatStr("业务类型", length / 2) + formatStr("方案", length / 2) + formatStr("渠道", length / 2) + formatStr("利率", length / 2) + formatStr("首付比例", length / 2));
        //
        String productType = "";
        if (Product.new_productType.equals(indent.getProductType())) {
            productType = "新车贷款";
        } else if (Product.old_productType.equals(indent.getProductType())) {
            productType = "二手车贷款";
        } else if (Product.loan_productType.equals(indent.getProductType())) {
            productType = "车辆抵押贷款";
        }
        Product product = productService.getObjectById(indent.getProductId());
        Constant channel = constantService.getObjectById(product.getChannel());
        log.info("  replyamount = " + indent.getReplyAmount());
        Txt.writeTxtFile(formatStr(productType, length / 2) + formatStr(product.getName(), length / 2) + formatStr(channel.getName(), length / 2) + formatStr(product.getInterestRate(), length / 2) + formatStr(indent.getFirstPayPercent(), length / 2));
        Txt.writeTxtFile(formatStr("贷款金额(元)", length / 2) + formatStr("贷款年限(月)", length / 2) + formatStr("月供(元)", length / 2) + formatStr("利息(元)", length / 2) + formatStr("批复金额", length / 2));
        Txt.writeTxtFile(formatStr(indent.getLoanAmount(), length / 2) + formatStr(indent.getLoanPeriod(), length / 2) + formatStr(indent.getMonthly(), length / 2) + formatStr(indent.getInterest(), length / 2) + formatStr(indent.getReplyAmount(), length / 2));


        //所有资料
        String customerName = customer.getName();
        String customerNumber = indent.getNumber();

        JSONObject jsonObject = new JSONObject();

        if(Idocument.TYPE_1.equals(type)){
            jsonObject.put("name", customer.getName() + "" + indent.getNumber()+Iprocess.FILE_NAME);
        }else if(Idocument.TYPE_2.equals(type)){
            jsonObject.put("name", customer.getName() + "" + indent.getNumber()+Idocument.APPLY);
        }
        log.info("  zip file name = "+jsonObject.getString("name"));

        jsonObject.put("txtUrl", filenameTemp);

        JSONArray jsonArray5 = new JSONArray();

        //查询申请资料
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("name", customerName + "申请资料" + customerNumber);
        JSONArray jsonArray = new JSONArray();


        //查找借款人需要上传的证件资料
        JSONObject cusJsonObject = getIdocumentByPer(Customer.c_personnelType + "",
                Iprocess.CRTTIFICATE, indent.getProductId(), customer.getId(), customerNumber);
        jsonArray.add(cusJsonObject);


        //查找配偶上传的证件
        //身份证

        Long sId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.s_personnelType + "");

        List<Long> spouIds = idocumentService.getIdsByCidAndPersonnelTypeOrderByUpdateAt
                (customer.getId(), Customer.s_personnelType + "", 0, Integer.MAX_VALUE);

        if (DataUtils.isNotNullOrEmpty(sId)) {
            JSONObject spouJJsonObject = getIdocumentByPer(Customer.s_personnelType + "",
                    Iprocess.CRTTIFICATE, indent.getProductId(), customer.getId(), customerNumber);
            jsonArray.add(spouJJsonObject);
        } else if (spouIds.size() > 0) {
            //查找配偶上传的证件
            JSONObject spouJJsonObject = getIdocumentByPer(Customer.s_personnelType + "",
                    Iprocess.CRTTIFICATE, indent.getProductId(), customer.getId(), customerNumber);
            jsonArray.add(spouJJsonObject);
        }


        //查找担保人申请资料
        Long gId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.g_personnelType + "");
        log.info("  gid = " + gId);

        if (DataUtils.isNotNullOrEmpty(gId)) {
            JSONObject spouJJsonObject = getIdocumentByPer(Customer.g_personnelType + "",
                    Iprocess.CRTTIFICATE, indent.getProductId(), customer.getId(), customerNumber);
            jsonArray.add(spouJJsonObject);
        }


        jsonObject2.put("file", jsonArray);
        //  jsonObject.put("shenqingzl",jsonObject2);
        jsonArray5.add(jsonObject2);
        //查询合同资料是否已上传
        List<Long> makeContractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(), Iprocess.MAKE_CONTRACT, 0, Integer.MAX_VALUE);
        if (makeContractIds.size() > 0) {
            JSONObject jsonObject1 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(makeContractIds, Iprocess.MAKE_CONTRACT, customerName, customerNumber);
            jsonObject1.put("name", customerName + "合同资料" + customerNumber);
            jsonObject1.put("file", file);
            //  jsonObject.put("hetongzl",jsonObject1);
            jsonArray5.add(jsonObject1);

        }
        //查询合同是否已上传
        List<Long> contractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(), Iprocess.CONTRACT, 0, Integer.MAX_VALUE);
        if (contractIds.size() > 0) {
            JSONObject jsonObject3 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(contractIds, Iprocess.CONTRACT, customerName, customerNumber);
            jsonObject3.put("name", customerName + "合同" + customerNumber);
            jsonObject3.put("file", file);
            //jsonObject.put("hetong",jsonObject3);
            jsonArray5.add(jsonObject3);

        }
        //查询放款资料是否已上传
        List<Long> loantractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(), Iprocess.LOAN, 0, Integer.MAX_VALUE);
        if (loantractIds.size() > 0) {
            JSONObject jsonObject4 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(loantractIds, Iprocess.LOAN, customerName, customerNumber);
            jsonObject4.put("name", customerName + "放款资料" + customerNumber);
            jsonObject4.put("file", file);
//            jsonObject.put("fangkuanzl",jsonObject4);
            jsonArray5.add(jsonObject4);

        }
        //查询贷后资料是否已上传
        List<Long> aftertractIds = idocumentService.getIdocumentIdsByIndentIdAndDocumentTypeOrderByUpdateAt
                (customer.getId(), Iprocess.AFTER, 0, Integer.MAX_VALUE);
        log.info("aftertractIds  size =   "+aftertractIds.size());
        if (aftertractIds.size() > 0) {

            JSONObject jsonObject5 = new JSONObject();
            JSONArray file = getIdocumentOtherByPer(aftertractIds, Iprocess.AFTER, customerName, customerNumber);
            jsonObject5.put("name", customerName + "贷后资料" + customerNumber);
            jsonObject5.put("file", file);
            //  jsonObject.put("daihouzl",jsonObject5);
            jsonArray5.add(jsonObject5);
        }

        jsonObject.put("file", jsonArray5);


        return jsonObject;
    }


    //查找人员的申请资料
    public JSONObject getIdocumentByPer(String personnelType, String certifiType, Long pid, Long cid, String customerNumber) throws Exception {
        log.info("  certifiType=0 and personnelType=" + personnelType);
        List<Long> sCertifiIds = pcertificateService.getPcertificateIdsByProductIdAndPersonnelTypeOrderByUpdateAt
                (pid.toString(), personnelType.toString(), 0, Integer.MAX_VALUE);

        List<Pcertificate> sCertifiList = pcertificateService.getObjectsByIds(sCertifiIds);

        Customer customer = customerService.getObjectById(cid);
        String customerName = customer.getName();
        // String customerNumber = .getNumber();

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", getFileName(personnelType, "申请资料", customerName, customerNumber));
        JSONArray jsonArray = new JSONArray();

        List<Long> certificateIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt
                (cid, personnelType, certifiType, 0, Integer.MAX_VALUE);
        List<Idocument> certificateList = idocumentService.getObjectsByIds(certificateIds);

        Boolean shenfenzhen = false;
        for (Idocument idocument : certificateList) {
            if ("身份证".equals(idocument.getDocumentName())) {
                shenfenzhen = true;
                break;
            }
        }


        if (!shenfenzhen) {
            JSONObject jsonObject7 = new JSONObject();
            if (Customer.c_personnelType.toString().equals(personnelType)) {
                // Customer customer =  customerService.getObjectById(cid);
                jsonObject7.put("name", customerName + "身份证" + customerNumber);
                JSONArray jsonArray1 = new JSONArray();
                jsonArray1.add(customer.getIDCardFront());
                jsonArray1.add(customer.getIDCardBack());
                jsonObject7.put("url", jsonArray1);

            } else if (Customer.s_personnelType.toString().equals(personnelType)) {
                Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.s_personnelType + "");
                if (DataUtils.isNotNullOrEmpty(id)) {
                    Guarantee guarantee = guaranteeService.getObjectById(id);
                    jsonObject7.put("name", customerName + "配偶身份证" + customerNumber);
                    JSONArray jsonArray1 = new JSONArray();
                    jsonArray1.add(guarantee.getIDCardFront());
                    jsonArray1.add(guarantee.getIDCardBack());
                    jsonObject7.put("url", jsonArray1);
                }

            } else if (Customer.g_personnelType.toString().equals(personnelType)) {
                Long id = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(cid, Customer.g_personnelType + "");
                if (DataUtils.isNotNullOrEmpty(id)) {
                    Guarantee guarantee = guaranteeService.getObjectById(id);
                    jsonObject7.put("name", customerName + "担保人身份证" + customerNumber);
                    JSONArray jsonArray1 = new JSONArray();
                    jsonArray1.add(guarantee.getIDCardFront());
                    jsonArray1.add(guarantee.getIDCardBack());
                    jsonObject7.put("url", jsonArray1);

                }

            }
            jsonArray.add(jsonObject7);
        } else {
            List<Long> ids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                    (cid, personnelType + "", certifiType, "身份证", 0, Integer.MAX_VALUE);

            JSONObject jsonObject1 = new JSONObject();
            if (ids.size() > 0) {
                List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                JSONArray urljsonArray = new JSONArray();
                for (Idocument idocument : idocuments) {
                    urljsonArray.add(idocument.getImg());
                }

                jsonObject1.put("name", getFileName(personnelType, "身份证", customerName, customerNumber));
                jsonObject1.put("url", urljsonArray);
                // jsonObject1.put(cCertifi.getCertificateName(), urls);
                //spouJsonArray.add(jsonObject);
                //jsonObject.put(""+cCertifi.getId(),jsonObject1);
                jsonArray.add(jsonObject1);
            }


        }


        if (Customer.c_personnelType.toString().equals(personnelType)
                || Customer.s_personnelType.toString().equals(personnelType)) {
            if (sCertifiList.size() > 0) {
                for (Pcertificate cCertifi : sCertifiList) {
                    JSONObject jsonObject1 = new JSONObject();
                    List<Long> ids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                            (cid, personnelType + "", certifiType, cCertifi.getCertificateName(), 0, Integer.MAX_VALUE);
                    log.info(" personnetltype =  " + personnelType + ",  idocument  size " + ids.size());
                    if (ids.size() > 0) {
                        List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                        JSONArray urljsonArray = new JSONArray();
                        for (Idocument idocument : idocuments) {
                            urljsonArray.add(idocument.getImg());
                        }
                        jsonObject1.put("name", getFileName(personnelType, cCertifi.getCertificateName(), customerName, customerNumber));
                        jsonObject1.put("url", urljsonArray);
                        // jsonObject1.put(cCertifi.getCertificateName(), urls);
                        //spouJsonArray.add(jsonObject);
                        //jsonObject.put(""+cCertifi.getId(),jsonObject1);
                        jsonArray.add(jsonObject1);
                    }

                }
            }

        } else {
            log.info("   add guarantee certificate  ");
            //查找担保人上传的证件
            List<String> guaCertificateNameList = new ArrayList<>();
            List<Long> guaCertificateIds = guaCertificateService.getGuaCertificateIds(0, Integer.MAX_VALUE);
            log.info("   guaCertificateIds  size = " + guaCertificateIds.size());
            List<GuaCertificate> guaCertificateList = guaCertificateService.getObjectsByIds(guaCertificateIds);
            for (GuaCertificate guaCertificate : guaCertificateList) {
                guaCertificateNameList.add(guaCertificate.getCertificateName());
            }

            List<Long> cmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (cid.toString(), Customer.c_personnelType.toString(), 0, Integer.MAX_VALUE);
            List<CustomerMaterialRelation> cmrList = cmrService.getObjectsByIds(cmrIds);
            if (cmrList != null && cmrList.size() > 0) {
                log.info("               ");
                for (CustomerMaterialRelation customerMaterialRelation : cmrList) {

                    if (customerMaterialRelation.getMaterialName().contains(Customer.GUARANTEE)) {
                        // guarantee=true;
                        log.info("  guaCertificateName  = " + customerMaterialRelation.getConstantName());
                        guaCertificateNameList.add(customerMaterialRelation.getConstantName());
                    }

                }
            }
            log.info(" guaCertificateNameList = " + guaCertificateNameList);
            for (String guaCertificateName : guaCertificateNameList) {
                JSONObject jsonObject1 = new JSONObject();
                List<Long> ids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                        (cid, personnelType + "", certifiType, guaCertificateName, 0, Integer.MAX_VALUE);
                List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                JSONArray urljsonArray = new JSONArray();
                for (Idocument idocument : idocuments) {
                    urljsonArray.add(idocument.getImg());
                }
                jsonObject1.put("name", getFileName(personnelType, guaCertificateName, customerName, customerNumber));
                jsonObject1.put("url", urljsonArray);
                jsonArray.add(jsonObject1);
            }


        }


        jsonObject.put("file", jsonArray);
        return jsonObject;
    }

    //查询人员的合同资料、合同、贷后资料、放款资料
    public JSONArray getIdocumentOtherByPer(List<Long> ids, String certificateType, String customerName, String customerNumber) throws Exception {
        List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);

        JSONArray file = new JSONArray();
        for (Idocument idocument : idocuments) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", customerName + idocument.getDocumentName() + customerNumber);
            List<Long> documentIdsByDocumentName = idocumentService.getIdocumentIdsByAllOrderByUpdateAt(idocument.getCustomerId(), idocument.getPersonnelType(),
                    idocument.getDocumentType(), idocument.getDocumentName(), 0, Integer.MAX_VALUE);
            List<Idocument> idocumentList = idocumentService.getObjectsByIds(documentIdsByDocumentName);
            JSONArray urls = new JSONArray();
            for (Idocument idocument1 : idocumentList) {
                urls.add(idocument1.getImg());
            }
            jsonObject.put("url", urls);
            file.add(jsonObject);
        }

        return file;
    }


    public String formatStr(String str, int length) {
        str = " " + str;
        int strLen = str.getBytes().length;
        if (strLen < length) {
            int temp = length - strLen;
            for (int i = 0; i < temp; i++) {
                str += " ";
            }
        }
        return str;
    }

    public static String getRegion(String region) {
        log.info("  getRegion   start   ");
        StringBuilder regionValue = new StringBuilder("");
        Properties properties = new Properties();
        try {
            InputStream inputStream = ProductController.class.getClassLoader().getResourceAsStream("region");
            BufferedReader bf = new BufferedReader(new InputStreamReader(inputStream));
            properties.load(bf);
            String provinceJson = properties.getProperty("province");

            ProvincesParam provincesParam = GsonUtil.fromJson(provinceJson, ProvincesParam.class);
            String cityJson = properties.getProperty("city");
            CitesParam citiesParam = GsonUtil.fromJson(cityJson, CitesParam.class);
            // log.info("  region.properties  city = "+cityJson);
            String countyJson = properties.getProperty("District");
            CountiesParam countiesParam = GsonUtil.fromJson(countyJson, CountiesParam.class);
            // log.info("  region.properties  countyJson = "+countyJson);
            String[] regsionArr = region.split(",");
            String province = regsionArr[0];
            String city = regsionArr[1];
            String county = regsionArr[2];
            log.info(" province  +  " + province + " , city = " + city + " , county = " + county);
            List<ProvinceParam> provinceParamList = provincesParam.getList();
            for (ProvinceParam provinceParam : provinceParamList) {
                if (province.equals(provinceParam.getProID().toString())) {
                    regionValue.append(provinceParam.getProName() + ",");
                    break;
                }
            }
            List<CityParam> cityParamList = citiesParam.getList();
            for (CityParam cityParam : cityParamList) {
                if (city.equals(cityParam.getCityID().toString())) {
                    regionValue.append(cityParam.getCityName() + ",");
                    break;
                }
            }
            List<CountyParam> countyParams = countiesParam.getList();
            for (CountyParam countyParam : countyParams) {
                if (county.equals(countyParam.getId().toString())) {
                    regionValue.append(countyParam.getDisName());
                    break;
                }
            }
            return regionValue.toString();

        } catch (IOException e) {
            e.printStackTrace();
            log.error("  document get region  errr  region  " + region);
            return "";
        }

    }

    private String getMetarialName(String constantName, String metarialName) {
        log.info("  getMetarialName  start    ");
        log.info("  constantName   ");
        String[] constantNameArr = constantName.split("_");

        if (constantNameArr.length > 1 && constantNameArr[1].equals(Product.ADDRESS)) {

            metarialName = getRegion(metarialName);
        }
        return metarialName;
    }


    private String getFileName(String personnelType, String filename, String customerName, String customerNumber) {
        log.info("  getFileName  start    ");
        log.info("  personnelType   " + personnelType + "  filename = " + filename);
        String file = "";
        if (Customer.c_personnelType.toString().equals(personnelType)) {
            file = customerName + filename + customerNumber;
        } else if (Customer.s_personnelType.toString().equals(personnelType)) {
            file = customerName + "配偶" + filename + customerNumber;
        } else if (Customer.g_personnelType.toString().equals(personnelType)) {
            file = customerName + "担保人" + filename + customerNumber;
        }
        return file;
    }

    //初审状态修改接口
    @RequestMapping(value = "/a/u/indent/process/{id}", method = RequestMethod.PUT)
    public String updateIndentProcess13(HttpServletRequest request,
                                        HttpServletResponse response, ModelMap model, @PathVariable Long id
    ) throws Exception {
        log.info("   updateIndentProcess13 id  =" + id);
        String uid = cookieUtil.getKeyIdentity(request, CookieUtil.USER_ID);
        try {
            Indent indent = indentService.getObjectById(id);
            //添加进度
            Iprocess iprocess = new Iprocess();
            iprocess.setCustomerId(indent.getCustomerId());
            if (Iprocess.PROCESS2.equals(indent.getProcess())
                    ) {
                iprocess.setProcess(Iprocess.PROCESS3);
            }
            iprocess.setResultFlag(Indent.UNCHECK);
            iprocess.setDescrition("");
            iprocess.setCreateBy(Long.valueOf(uid));
            iprocess.setUpdateBy(Long.valueOf(uid));
            Long processId = iprocessService.insert(iprocess);
            log.info(" processId  = " + processId);

            //修改订单进度
            indent.setOperator(Long.valueOf(uid));
            indent.setProcess(Iprocess.PROCESS3);
            indent.setReplyResult(Indent.UNCHECK);
            indentService.update(indent);

            //修改客户进度
            Customer customer = customerService.getObjectById(indent.getCustomerId());
            customer.setProcess(Iprocess.PROCESS3);
            customerService.update(customer);

            //加入记录表
            Checkresultrecord checkresultrecord = new Checkresultrecord();
            checkresultrecord.setStage(Checkresultrecord.STAGE_0);
            checkresultrecord.setIndentId(indent.getId());
            checkresultrecord.setDescription("");
            checkresultrecord.setResult(Indent.UNCHECK);
            checkresultrecord.setAction(Checkresultrecord.ACTION_0);
            checkresultrecord.setModify("");
            checkresultrecord.setNumber(1 + "");
            checkresultrecord.setCreateBy(Long.valueOf(uid));
            checkresultrecord.setUpdateBy(Long.valueOf(uid));
            Long checkId = checkresultrecordService.insert(checkresultrecord);
            log.info("   insert   checkresultrecord  id =" + checkId);


            //发送推送内容

            Saler saler = salerService.getObjectById(customer.getSalerId());
            //获取channlId
            String channelId = saler.getNoticeChannelId();
            log.info(" saler id = " + saler.getId() + "   saler " + saler.getName() + "  channelId = " + channelId);
            if (DataUtils.isNotNullOrEmpty(channelId)) {
                Map<String, String> messageMap =
                        new NoticeMessageUtil().setNotice(indent.getProcess(), indent.getReplyResult(), customer.getName());
                String customContent = "{\"" + "cid" + "\":" + customer.getId() + ",\"productType\":\"" + indent.getProductType() + "\"}";
                log.info("  customConte = " + customContent);
                this.noticeUtil.pushMessae(channelId, messageMap.get("title"), messageMap.get("description"), 3, 1, 86400 * 7, customContent);

            }
            model.addAttribute("code", 0);
            log.info("   new  indent  process = " + indent.getProcess());

        } catch (Exception e) {
            e.printStackTrace();
            log.error("  update  process 13 error  id = " + id);

        }

        return "/common/success";
    }


    //生成PDF
    public Map<String, List<String>> getPDFDocumentUrl(Indent indent) throws Exception {
        Map<String, List<String>> map = new HashMap<>();


        Customer customer = customerService.getObjectById(indent.getCustomerId());
        String datafileName = Txt.creatPdfFile(customer.getName() + indent.getNumber());
        String fileName = customer.getName() + indent.getNumber();
        //Txt.creatPdfFile(fileName);
        List<String> pdfNames = new ArrayList<>();
        List<String> pdfCertificateId = new ArrayList<>();

        Product product = productService.getObjectById(indent.getProductId());
        List<Long> propdffileIds = propdffileService.getPropdffileIdsByChannelIdAndProductType
                (product.getChannel(), product.getType(), 0, Integer.MAX_VALUE);
        log.info("   propdffileIds  =  " + propdffileIds);

        if (propdffileIds.size() > 0) {
            List<Propdffile> propdffileList = propdffileService.getObjectsByIds(propdffileIds);

            for (Propdffile propdffile : propdffileList) {
                log.info("  personnelType = " + propdffile.getPersonnelType());
                //判断人员类型，如果是配偶的，查看是否已婚，已婚继续，不是则不生成文件
                if (Customer.s_personnelType.toString().equals(propdffile.getPersonnelType())) {
                    //判断是否已婚
                    if (Customer.married.equals(customer.getMarriage())) {
                        log.info("  customer married");
                    } else {
                        log.info("  customer  hasn't  married");
                        continue;
                    }
                }


                //生成pdf文件
                String pdfUrl = "";
                log.info("  filename  =  " + propdffile.getFileName());
                if ("0".equals(propdffile.getType())) {
                    //生成pdf
                    if ("0".equals(propdffile.getFileName())) {
                        pdfUrl = datafileName + customer.getNumber() + ".pdf";
                    } else {
                        pdfUrl = datafileName + propdffile.getFileName() + ".pdf";//文件名
                    }
                } else if ("1".equals(propdffile.getType())) {
                    //生成word
                    if ("0".equals(propdffile.getFileName())) {
                        pdfUrl = datafileName + customer.getNumber() + ".doc";
                    } else {
                        pdfUrl = datafileName + propdffile.getFileName() + ".doc";//文件名
                    }
                }


                pdfNames.add(pdfUrl);
                log.info(" pdfUrl " + pdfUrl);


                //新建list保存该pdf文件需要的照片
                List<String> certificateUrls = new ArrayList<>();
                log.info("  propdffile  =  " + propdffile);
                List<Long> pcIds = propdfileCertifiRelationService.getPropdfileCertifiRelationIdsByPropdfileId
                        (propdffile.getId(), 0, Integer.MAX_VALUE);
                log.info("   pcIds  = " + pcIds);
                if (pcIds.size() > 0) {
                    List<PropdfileCertifiRelation> propdfileCertifiRelationList =
                            propdfileCertifiRelationService.getObjectsByIds(pcIds);

                    for (PropdfileCertifiRelation propdfileCertifiRelation : propdfileCertifiRelationList) {
                        log.info(" propdfileCertifiRelation id =   " + propdfileCertifiRelation.getId());
                        Long certificateId = propdfileCertifiRelation.getCertificateId();
                        pdfCertificateId.add(certificateId.toString());//将要生成pdf的证件归类
                        //查找此客户的此证件的照片资料
                        Constant constant = constantService.getObjectById(certificateId);
                        log.info("  certificateID = " + certificateId + "  name = " + constant.getName());
                        //用来判断是否有身份证
                        List<Long> certificateIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt
                                (customer.getId(), propdffile.getPersonnelType() + "", Iprocess.CRTTIFICATE, 0, Integer.MAX_VALUE);
                        List<Idocument> certificateList = idocumentService.getObjectsByIds(certificateIds);
                        //身份证生成
                        Boolean shenfenzhen = false;
                        for (Idocument idocument : certificateList) {
                            if ("身份证".equals(idocument.getDocumentName())) {
                                shenfenzhen = true;
                                break;
                            }
                        }


                        //加上身份证
                        if ("身份证".equals(constant.getName())) {
                            log.info(" shenfenzhen ");
                            if (!shenfenzhen) {
                                log.info("   1mmm    ");
                                //区分主贷人和配偶
                                if (Customer.s_personnelType.toString().equals(propdffile.getPersonnelType())) {
                                    log.info("  add spouse IDcard img ");
                                    Long sId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType(customer.getId(), Customer.s_personnelType + "");
                                    Guarantee spouse = guaranteeService.getObjectById(sId);
                                    certificateUrls.add(spouse.getIDCardFront());
                                    certificateUrls.add(spouse.getIDCardBack());
                                } else {
                                    log.info("  add customer IDcard img ");
                                    //主贷人
                                    certificateUrls.add(customer.getIDCardFront());
                                    certificateUrls.add(customer.getIDCardBack());
                                }
                            } else {
                                log.info("   2mmm    ");

                                List<Long> idocumentIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt
                                        (customer.getId(), propdffile.getPersonnelType() + "", Iprocess.CRTTIFICATE, constant.getName(), 0, Integer.MAX_VALUE);
                                log.info(" idocumentIds size =  " + idocumentIds.size());

                                if (idocumentIds.size() > 0) {
                                    List<Idocument> idocumentList = idocumentService.getObjectsByIds(idocumentIds);
                                    for (Idocument idocument : idocumentList) {
                                        certificateUrls.add(idocument.getImg());
                                    }
                                }
                            }

                        } else {

                            List<Long> idocumentIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeAndDocumentNameOrderByUpdateAt
                                    (customer.getId(), propdffile.getPersonnelType() + "", Iprocess.CRTTIFICATE, constant.getName(), 0, Integer.MAX_VALUE);
                            log.info(" idocumentIds size =  " + idocumentIds.size());
                            //只需判断有没有,没有不新建
                            if (idocumentIds.size() > 0) {
                                List<Idocument> idocumentList = idocumentService.getObjectsByIds(idocumentIds);
                                for (Idocument idocument : idocumentList) {
                                    certificateUrls.add(idocument.getImg());
                                }
                            }
                        }

                    }

                }
                log.info("  certificateUrls  size = " + certificateUrls.size());
                log.info("  certificateUrls   = " + certificateUrls);

                if ("0".equals(propdffile.getType())) {
                    //pdf
                    PdfTest gp = new PdfTest();
                    gp.writeSimplePdf(pdfUrl);
                    if (certificateUrls.size() > 0) {
                        File file = gp
                                .Pdf(certificateUrls, pdfUrl);
                        file.createNewFile();
                    }
                } else if ("1".equals(propdffile.getType())) {
                    //doc
                    WordDocTest wordDocTest = new WordDocTest();
                    List<Image> images = new ArrayList<>();
                    for (String imgUrl : certificateUrls) {
                        Image image = new Image(imgUrl, 415, 900);
                        images.add(image);
                    }
                    wordDocTest.generateAnWordDoc(images, pdfUrl);
                }

            }

        }

        map.put("pdfname", pdfNames);
        map.put("certificateId", pdfCertificateId);
        return map;
    }

    //生成PDFjson

    public JSONObject getPDFDocumentUrlJson(Indent indent) throws Exception {
        Customer customer = customerService.getObjectById(indent.getCustomerId());

        log.info("  getPDFDocumentUrlJson  start  ");
        //生成PDF/WORD文件
        Map<String, List<String>> map = getPDFDocumentUrl(indent);
        //生成TXT文件
        String datafileName = Txt.pdfPath + customer.getName() + indent.getNumber() + "/";
        getCustomerInfoTxt(indent, "pdf", datafileName);
        //生成json
        List<String> pdfNames = map.get("pdfname");
        List<String> pdfCertificateIdList = map.get("certificateId");
        log.info("  map  " + map.keySet());


        JSONObject jsonObject = new JSONObject();
        jsonObject.put("name", customer.getName() + "" + indent.getNumber());
        // List<String> txtpdf = new ArrayList<>();
        pdfNames.add(datafileName + customer.getName() + "" + indent.getNumber() + ".txt");
        JSONArray jsonArray1 = new JSONArray();
        for (String pdfname : pdfNames) {
            jsonArray1.add(pdfname);
        }

        jsonObject.put("txtpdf", jsonArray1);

        //生成剩余不需要转成pdf文件的
        //先找出所有的需要的证件
        List<Long> sCertifiIds = pcertificateService.getPcertificateIdsByProductIdAndPersonnelTypeOrderByUpdateAt
                (indent.getProductId().toString(), Customer.c_personnelType + "", 0, Integer.MAX_VALUE);
        List<Pcertificate> pcertificateList = pcertificateService.getObjectsByIds(sCertifiIds);
        List<Long> allCertificateIds = new ArrayList<>();

        for (Pcertificate pcertificate : pcertificateList) {
            Long certificateId = constantService.getConstantIdByNameAndType(pcertificate.getCertificateName(), Constant.CERTIFICATE);
            allCertificateIds.add(certificateId);
        }

        Long shenfenzhengId = constantService.getConstantIdByNameAndType("身份证", Constant.CERTIFICATE);
        log.info("  shenfenzhengId  = " + shenfenzhengId);
        //pcertificate里没有身份证，将其加入
        allCertificateIds.add(shenfenzhengId);
        log.info("  all  certificateIds size  = " + allCertificateIds.size());
        log.info("  pdf  certificateIds size  = " + pdfCertificateIdList.size());
        List<Long> certificateIds = new ArrayList<>();
        for (Long certificateId : allCertificateIds) {
            Boolean have = false;
            for (String pdfCertificateId : pdfCertificateIdList) {
                if (certificateId.equals(Long.valueOf(pdfCertificateId))) {
                    have = true;
                    break;
                }
            }
            if (!have) {
                certificateIds.add(certificateId);
            }

        }
        log.info(" dont include pdf   certificateIds = " + certificateIds);
        List<Constant> constants = constantService.getObjectsByIds(certificateIds);
        JSONArray jsonArray = getNoPdfJson(customer.getId(), constants, indent.getNumber());
        jsonObject.put("file", jsonArray);

        return jsonObject;

    }

    //生成不用生成PDF的申请资料JSON
    public JSONArray getNoPdfJson(Long cid, List<Constant> constants, String customerNumber) throws Exception {
        log.info("   getNoPdfJson  start  -   ");

        List<Long> certificateIds = idocumentService.getIdocumentIdsByIndentIdAndPersonnelTypeAndDocumentTypeOrderByUpdateAt
                (cid, Customer.c_personnelType + "", Iprocess.CRTTIFICATE, 0, Integer.MAX_VALUE);
        List<Idocument> certificateList = idocumentService.getObjectsByIds(certificateIds);
        //身份证生成
        Boolean shenfenzhen = false;
        for (Idocument idocument : certificateList) {
            if ("身份证".equals(idocument.getDocumentName())) {
                shenfenzhen = true;
                break;
            }
        }


        Customer customer = customerService.getObjectById(cid);
        JSONArray jsonArray = new JSONArray();
        for (Constant constant : constants) {

            log.info("  constant name = " + constant.getName());
            if ("身份证".equals(constant.getName()) && !shenfenzhen) {
                log.info("   shenfenzheng     ");
                JSONObject jsonObject7 = new JSONObject();
                jsonObject7.put("name", customer.getName() + "身份证" + customerNumber);
                JSONArray jsonArray1 = new JSONArray();
                jsonArray1.add(customer.getIDCardFront());
                jsonArray1.add(customer.getIDCardBack());
                jsonObject7.put("url", jsonArray1);
                jsonArray.add(jsonObject7);

            } else {
                log.info("  not   shenfenzheng     ");


                List<Long> ids = idocumentService.getIdocumentIdsByAllOrderByUpdateAt
                        (cid, Customer.c_personnelType + "", Iprocess.CRTTIFICATE, constant.getName(), 0, Integer.MAX_VALUE);
                log.info(" Customer.c_personnelType =  " + Customer.c_personnelType + ",  idocument  size " + ids.size());


                if (ids.size() > 0) {
                    JSONObject jsonObject1 = new JSONObject();
                    List<Idocument> idocuments = idocumentService.getObjectsByIds(ids);
                    JSONArray urljsonArray = new JSONArray();
                    for (Idocument idocument : idocuments) {
                        urljsonArray.add(idocument.getImg());
                    }
                    jsonObject1.put("name", getFileName(Customer.c_personnelType + "", constant.getName(), customer.getName(), customerNumber));
                    jsonObject1.put("url", urljsonArray);
                    // jsonObject1.put(cCertifi.getCertificateName(), urls);
                    //spouJsonArray.add(jsonObject);
                    //jsonObject.put(""+cCertifi.getId(),jsonObject1);
                    jsonArray.add(jsonObject1);
                }
            }
        }

        return jsonArray;

    }

    //生成客户基本信息txt
    public void getCustomerInfoTxt(Indent indent, String type, String path) throws Exception {
        log.info("  getCustomerInfoTxt  startt    ");
        Customer customer = customerService.getObjectById(indent.getCustomerId());
        //客户材料信息
        List<Long> cCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                (customer.getId() + "", Customer.c_personnelType + "", 0, Integer.MAX_VALUE);
        List<CustomerMaterialRelation> cCmrList = cmrService.getObjectsByIds(cCmrIds);
        //配偶材料信息
        String marriedFlag = customer.getMarriage();
        Guarantee spouse = new Guarantee();
        List<CustomerMaterialRelation> sCmrList = new ArrayList<>();
        if (Customer.married.equals(marriedFlag)) {
            spouse = guaranteeService.getObjectById(guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.s_personnelType + ""));

            List<Long> sCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.s_personnelType + "", 0, Integer.MAX_VALUE);
            sCmrList = cmrService.getObjectsByIds(sCmrIds);
        }else{
            //父母信息
            Long parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.f_personnelType + "");
            log.info(" parentId = "+parentId);
            if(null == parentId){
                parentId = guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                        (customer.getId(), Customer.m_personnelType + "");
            }
            log.info(" parentId = "+parentId);
            if(null != parentId){
                spouse = guaranteeService.getObjectById(parentId);
            }

        }
        //担保人材料信息
        Guarantee guarantee = new Guarantee();
        List<CustomerMaterialRelation> gCmrList = new ArrayList<>();
        Boolean guaFlag = false;
        for (CustomerMaterialRelation cmr : cCmrList) {
            if (cmr.getMaterialName().contains(Customer.GUARANTEE)) {
                guaFlag = true;
                break;
            }
        }

        //未满24周岁，直系亲属担保人基本信息
        Long minGuaId =  guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                (customer.getId(), Customer.minor_personnelType + "");
        Guarantee minGua = new Guarantee();
        if(null != minGuaId){
            minGua = guaranteeService.getObjectById(minGuaId);
        }

        if (guaFlag) {
            guarantee = guaranteeService.getObjectById(guaranteeService.getGuaranteeIdByCustomerIdAndPersonnelType
                    (customer.getId(), Customer.g_personnelType + ""));

            List<Long> gCmrIds = cmrService.getCustomerMaterialRelationIdsByCustomerIdAndPersonnelTypeOrderByUpdateAt
                    (customer.getId() + "", Customer.g_personnelType + "", 0, Integer.MAX_VALUE);
            gCmrList = cmrService.getObjectsByIds(gCmrIds);
        }


        //新建txt文件
        String filenameTemp = Txt.creatTxtFile(customer.getName() + "" + indent.getNumber(), type, path);
        String marriage = "";
        if (Customer.married.equals(customer.getMarriage())) {
            marriage = "已婚";
        } else if (Customer.unmarried.equals(customer.getMarriage())) {
            marriage = "未婚";
        } else if (Customer.divorced.equals(customer.getMarriage())) {
            marriage = "离异";
        }
        int length = 60;

        Txt.writeTxtFile("客户信息");
        Txt.writeTxtFile(formatStr("客户姓名：" + customer.getName(), length) + "\r\n" + formatStr("婚姻状况：" + marriage, length));

        Txt.writeTxtFile(formatStr("联系电话：" + customer.getPhone(), length) + "\r\n" + formatStr("身份证号：" + customer.getNumber(), length));
        Txt.writeTxtFile(formatStr("户籍地址：" + customer.getCensRegAddress(), length * 2));
        Txt.writeTxtFile(formatStr("工作单位：" + customer.getEmployer(), length * 2));
        Txt.writeTxtFile(formatStr("工作年限（年）：" + customer.getWorkExperience(), length * 2));
        Txt.writeTxtFile(formatStr("薪水：" + customer.getSalary(), length * 2));
        Txt.writeTxtFile(formatStr("具体工作地：" + customer.getWorkAddressDetail(), length * 2));
        Txt.writeTxtFile(formatStr("具体居住地：" + customer.getLiveAddressDetail(), length * 2));
        for (int i = 0; i < cCmrList.size(); i++) {
            String metarialname1 = getMetarialName(cCmrList.get(i).getConstantName(), cCmrList.get(i).getMaterialName());
            cCmrList.get(i).setConstantName(cCmrList.get(i).getConstantName().split("_")[0]);
            String metarialname2 = "";
            if (i + 1 < cCmrList.size()) {
                metarialname2 = getMetarialName(cCmrList.get(i + 1).getConstantName(), cCmrList.get(i + 1).getMaterialName());
                cCmrList.get(i + 1).setConstantName(cCmrList.get(i + 1).getConstantName().split("_")[0]);

            }


            if (i == cCmrList.size() - 1) {
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                );
            } else {
                Txt.writeTxtFile(formatStr(cCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                        formatStr(cCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
            }
            i++;

        }


        if (Customer.married.equals(marriedFlag)) {
            Txt.writeTxtFile("配偶信息");
            Txt.writeTxtFile(formatStr("姓名：" + spouse.getName(), length) + "\r\n" + formatStr("身份证号：" + spouse.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + spouse.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("户籍地址：" + spouse.getCenRegAddress(), length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作年限（年）：" + spouse.getWorkExperience(), length * 2));
            Txt.writeTxtFile(formatStr("薪水：" + spouse.getSalary(), length * 2));
            for (int i = 0; i < sCmrList.size(); i++) {
                String metarialname1 = getMetarialName(sCmrList.get(i).getConstantName(), sCmrList.get(i).getMaterialName());
                sCmrList.get(i).setConstantName(sCmrList.get(i).getConstantName().split("_")[0]);
                String metarialname2 = "";
                if (i + 1 < sCmrList.size()) {

                    metarialname2 = getMetarialName(sCmrList.get(i + 1).getConstantName(), sCmrList.get(i + 1).getMaterialName());
                    sCmrList.get(i + 1).setConstantName(sCmrList.get(i + 1).getConstantName().split("_")[0]);

                }
                if (i == sCmrList.size() - 1) {
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                    );
                } else {
                    Txt.writeTxtFile(formatStr(sCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                            formatStr(sCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
                }
                i++;

            }
        }else{
            //没有配偶，填写父母信息

            Txt.writeTxtFile("父母信息");
            Txt.writeTxtFile(formatStr("与申请人关系：" + spouse.getPersonnelType(), length * 2));
            Txt.writeTxtFile(formatStr("姓名：" + spouse.getName(), length) + "\r\n" + formatStr("身份证号：" + spouse.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + spouse.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + spouse.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + spouse.getWorkAddress(), length * 2));
        }

        if (guaFlag) {
            Txt.writeTxtFile("担保人信息");
            Txt.writeTxtFile(formatStr("姓名：" + guarantee.getName(), length) + "\r\n" + formatStr("身份证号：" + guarantee.getIDNumber(), length));
            Txt.writeTxtFile(formatStr("联系电话：" + guarantee.getPhone(), length * 2));
            Txt.writeTxtFile(formatStr("户籍地址：" + guarantee.getCenRegAddress(), length * 2));
            for (int i = 0; i < gCmrList.size(); i++) {
                String metarialname1 = getMetarialName(gCmrList.get(i).getConstantName(), gCmrList.get(i).getMaterialName());
                gCmrList.get(i).setConstantName(gCmrList.get(i).getConstantName().split("_")[0]);

                String metarialname2 = "";
                if (i + 1 < gCmrList.size()) {
                    metarialname2 = getMetarialName(gCmrList.get(i + 1).getConstantName(), gCmrList.get(i + 1).getMaterialName());
                    gCmrList.get(i + 1).setConstantName(gCmrList.get(i + 1).getConstantName().split("_")[0]);

                }
                if (i == gCmrList.size() - 1) {
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName() + "：" + metarialname1, length * 2)
                    );
                } else {
                    Txt.writeTxtFile(formatStr(gCmrList.get(i).getConstantName() + "：" + metarialname1, length) + "\r\n" +
                            formatStr(gCmrList.get(i + 1).getConstantName() + "：" + metarialname2, length));
                }
                i++;

            }
        }

        if(null != minGuaId && null != minGua){
            Txt.writeTxtFile("未满24周岁，直系亲属担保人信息");
            Txt.writeTxtFile(formatStr("姓名：" + minGua.getName(), length) + "\r\n" + formatStr("身份证号：" + minGua.getIDNumber(), length));
            String relation = "";
            if(Guarantee.RELATION_1.equals(minGua.getRelation())){
                relation = Guarantee.PARENT;
            }
            if(Guarantee.RELATION_5.equals(minGua.getRelation())){
                relation = Guarantee.SISTER;
            }
            if(Guarantee.RELATION_10.equals(minGua.getRelation())){
                relation = Guarantee.CHILDREN;
            }
            Txt.writeTxtFile(formatStr("与主贷人关系：" + relation, length * 2));
            Txt.writeTxtFile(formatStr("工作单位：" + minGua.getEmployer(), length * 2));
            Txt.writeTxtFile(formatStr("工作地址：" + minGua.getWorkAddress(), length * 2));
        }
        //紧急联系人信息
        Txt.writeTxtFile("紧急联系人信息");
        List<Long> cusemerconIds = cusemerconService.getCusemerconIdsByCustomerId(customer.getId(), 0, Integer.MAX_VALUE);
        List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(cusemerconIds);

        for (int i = 0; i < cusemerconIds.size(); i++) {
            int j = i + 1;
            String relation = getRelationWithEmerCon(cusemerconList.get(i).getRelation());
            Txt.writeTxtFile(formatStr("第" + j + "位联系人姓名：" + cusemerconList.get(i).getName(), length) + formatStr("第" + j + "位联系人电话：" + cusemerconList.get(i).getPhone(), length) + formatStr("与第" + j + "位联系人关系：" + relation, length));

        }
        Txt.writeTxtFile(formatStr("补充说明：", length * 2));
        Txt.writeTxtFile(formatStr(customer.getDescrition(), length * 2));


        //订单信息
        Txt.writeTxtFile("车辆信息");
        if (Product.loan_productType.equals(indent.getProductType())) {
            Txt.writeTxtFile(formatStr("车型", length / 2) + formatStr("评估价格(元)", length / 2) + formatStr("出厂日期", length / 2) + formatStr("上牌日期", length / 2) + formatStr("行驶公里数", length / 2));

        } else {
            Txt.writeTxtFile(formatStr("车型", length / 2) + formatStr("价格(元)", length / 2) + formatStr("出厂日期", length / 2) + formatStr("上牌日期", length / 2) + formatStr("行驶公里数", length / 2));

        }        //转换一下时间
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String productionDate = "";
        if (DataUtils.isNotNullOrEmpty(indent.getProductionDate())) {
            productionDate = sdf.format(new Date(indent.getProductionDate()));
        }
        String licenseDate = "";
        if (DataUtils.isNotNullOrEmpty(indent.getLicenseDate())) {
            licenseDate = sdf.format(new Date(indent.getLicenseDate()));
        }
        String kilometers = "";
        if (DataUtils.isNotNullOrEmpty(indent.getDrivingKilometers())) {
            kilometers = indent.getDrivingKilometers();
        }

        Txt.writeTxtFile(formatStr(indent.getCarType(), length / 2) + formatStr(indent.getSumPrice(), length / 2) + formatStr(productionDate, length / 2) + formatStr(licenseDate, length / 2) + formatStr(kilometers, length / 2));
        Txt.writeTxtFile("贷款方案");
        Txt.writeTxtFile(formatStr("业务类型", length / 2) + formatStr("方案", length / 2) + formatStr("渠道", length / 2) + formatStr("利率", length / 2) + formatStr("首付比例", length / 2));
        //
        String productType = "";
        if (Product.new_productType.equals(indent.getProductType())) {
            productType = "新车贷款";
        } else if (Product.old_productType.equals(indent.getProductType())) {
            productType = "二手车贷款";
        } else if (Product.loan_productType.equals(indent.getProductType())) {
            productType = "车辆抵押贷款";
        }
        Product product = productService.getObjectById(indent.getProductId());
        Constant channel = constantService.getObjectById(product.getChannel());
        log.info("  replyamount = " + indent.getReplyAmount());
        Txt.writeTxtFile(formatStr(productType, length / 2) + formatStr(product.getName(), length / 2) + formatStr(channel.getName(), length / 2) + formatStr(product.getInterestRate(), length / 2) + formatStr(indent.getFirstPayPercent(), length / 2));
        Txt.writeTxtFile(formatStr("贷款金额(元)", length / 2) + formatStr("贷款年限(月)", length / 2) + formatStr("月供(元)", length / 2) + formatStr("利息(元)", length / 2) + formatStr("批复金额", length / 2));
        Txt.writeTxtFile(formatStr(indent.getLoanAmount(), length / 2) + formatStr(indent.getLoanPeriod(), length / 2) + formatStr(indent.getMonthly(), length / 2) + formatStr(indent.getInterest(), length / 2) + formatStr(indent.getReplyAmount(), length / 2));
        log.info("  getCustomerInfoTxt  end    ");
    }

    //获取紧急联系人关系
    public String getRelationWithEmerCon(String relation) {
        if (Cusemercon.PARENT.equals(relation)) {
            return "父母";
        } else if (Cusemercon.CHILDREN.equals(relation)) {
            return "子女";
        } else if (Cusemercon.COMPANY.equals(relation)) {
            return "同事";
        } else if (Cusemercon.FRIENDS.equals(relation)) {
            return "朋友";
        } else if (Cusemercon.RELATION.equals(relation)) {
            return "亲戚";
        } else if (Cusemercon.OTHER.equals(relation)) {
            return "其他";
        }

        return "";
    }


    /**
     * 风控主页
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/indent/index/risk", method = RequestMethod.GET)
    public String riskIndex(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            Integer type) throws Exception {
        if (type == null || type < 0 || type > 3) {
            type = 0;
        }

        try {
            Map<String, Object> indentCount = IndentUtil.getIndentCount(1, type);

            model.addAttribute("code", 0);
            model.addAttribute("data", indentCount);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("riskIndex error ");
            model.addAttribute("code", -1);
        }
        return "/common-carjn-service/indent/json/riskIndex";
    }


    /**
     * 贷后主页
     *
     * @param request
     * @param response
     * @param model
     * @param type
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/indent/index/loan", method = RequestMethod.GET)
    public String loanIndex(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                            Integer type) throws Exception {
        if (type == null || type < 0 || type > 3) {
            type = 0;
        }

        try {
            Map<String, Object> indentCount = IndentUtil.getIndentCount(2, type);

            model.addAttribute("code", 0);
            model.addAttribute("data", indentCount);
        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("riskIndex error ");
            model.addAttribute("code", -1);
        }
        return "/common-carjn-service/indent/json/loanIndex";
    }


    //27.取消申请订单
    @RequestMapping(value = "/a/u/indent/status/{indentId}", method = RequestMethod.PUT)
    public String updateIndentJson(HttpServletRequest request, HttpServletResponse response, ModelMap model,
                                   @PathVariable Long indentId, String description) throws Exception {

        log.info("update indent : indentId= " + indentId);
        // Saler user  = UserUtil.getUserFromAttribute(request);

        try {
            String userId = cookieUtil.getKeyIdentity(request,
                    CookieUtil.USER_ID);
            if (DataUtils.isNullOrEmpty(indentId) || DataUtils.isNullOrEmpty(description)) {
                model.addAttribute("code", -1000);
                return "/common/success";
            }

            Indent indent = indentService.getObjectById(indentId);
            if (DataUtils.isNullOrEmpty(indent)) {
                model.addAttribute("code", -2012);
                return "/common/success";
            }


          //  Long uid = indent.getSalerId();

            indent.setProcess(Iprocess.PROCESS17);
            log.info("  indent process = "+indent.getProcess());
            indent.setStatus(Indent.CANCEL);
            indent.setUpdateBy(Long.valueOf(userId));
            indentService.update(indent);


            Customer customer = customerService.getObjectById(indent.getCustomerId());
            customer.setProcess(Iprocess.PROCESS17);
            customerService.update(customer);


            //修改销售统计金额：业务咨询不提供取消功能
            List<Long> iprocessIds = iprocessService.getIprocessIdsByCustomerIdOrderByUpdateAt
                    (indent.getCustomerId(), 0, Integer.MAX_VALUE);
            List<Iprocess> iprocessList = iprocessService.getObjectsByIds(iprocessIds);
            //目前进度
            String process = iprocessList.get(0).getProcess();
            log.info(" process  = " + process);
            if (Iprocess.PROCESS1.equals(process)) {
                model.addAttribute("code", -2013);
                return "/common/success";
            }


            //找到该销售下的该业务类型的数据
            Long sId = statisticsService.getStatisticsIdBySalerIdAndProductType
                    (indent.getSalerId(), indent.getProductType());
            Statistics statistics = statisticsService.getObjectById(sId);
            //判断目前进度分属哪个范围
            //是不是申请
            if (Iprocess.PROCESS2.equals(process)
                    ||
                    Iprocess.PROCESS3.equals(process)
                    ||
                    Iprocess.PROCESS5.equals(process)) {

                log.info(" update   statitics  uid is " + Long.valueOf(userId) + "  productType = " + indent.getProductType());
                //销售当前申请单数
                String applyCount = statistics.getApplyCount();
                log.info("  applyCount  is " + applyCount);
                //减去-
                Integer a = Integer.valueOf(applyCount) - 1;
                statistics.setApplyCount(a + "");
                //销售当前申请金额
                String applyMoney = statistics.getApplyMoney();

                log.info("   applyMoney  is " + applyMoney);
                //减去该单金额
                Integer b = Integer.valueOf(applyMoney) - Integer.valueOf(indent.getLoanAmount());
                log.info(" b  " + b);
                statistics.setApplyMoney(b + "");


            }

            //是不是退档
            if (
                    Iprocess.PROCESS4.equals(process)

//                            || Iprocess.PROCESS8.equals(process)
//                            || Iprocess.PROCESS11.equals(process)
            ) {
                log.info(" update   statitics  uid is " + Long.valueOf(userId) + "  productType = " + indent.getProductType());
                //销售当前退档单数
                String returnCount = statistics.getReturnCount();
                log.info("  returnCount  is " + returnCount);
                //单数减去-
                Integer a = Integer.valueOf(returnCount) - 1;
                statistics.setReturnCount(a + "");
                //销售当前退档金额
                String returnMoney = statistics.getReturnMoney();

                log.info("   returnMoney  is " + returnMoney);
                //减去该单金额
                Integer b = Integer.valueOf(returnMoney) - Integer.valueOf(indent.getLoanAmount());
                log.info(" b  " + b);
                statistics.setReturnMoney(b + "");


            }

            //是不是审核通过
//            if (Iprocess.PROCESS6.equals(process)
//                    || Iprocess.PROCESS7.equals(process)
//                    || Iprocess.PROCESS9.equals(process)
//                    || Iprocess.PROCESS10.equals(process)) {
//                //判断是否是拒绝
//                if (!(Indent.RESULTT_2.equals(indent.getReplyResult()))) {
//                    log.info(" update   statitics  uid is " + Long.valueOf(userId) + "  productType = " + indent.getProductType());
//                    //销售当前审核通过单数
//                    String passCount = statistics.getPassCount();
//                    log.info("  passCount  is " + passCount);
//                    //单数减去-
//                    Integer a = Integer.valueOf(passCount) - 1;
//                    statistics.setPassCount(a + "");
//                    //销售当前审核通过金额
//                    String passMoney = statistics.getPassMoney();
//
//                    log.info("   passMoney  is " + passMoney);
//                    //减去该单金额
//                    Integer b = Integer.valueOf(passMoney) - Integer.valueOf(indent.getLoanAmount());
//                    log.info(" b  " + b);
//                    statistics.setPassMoney(b + "");
//
//                }
//
//            }


            //是不是放款
//            if (Iprocess.PROCESS12.equals(process)) {
//                log.info(" update   statitics  uid is " + Long.valueOf(userId) + "  productType = " + indent.getProductType());
//                //销售当前放款单数
//                String loanCount = statistics.getLoanCount();
//                log.info("  loanCount  is " + loanCount);
//                //单数减去-
//                Integer a = Integer.valueOf(loanCount) - 1;
//                statistics.setLoanCount(a + "");
//                //销售当前放款金额
//                String loanMoney = statistics.getLoanMoney();
//
//                log.info("   loanMoney  is " + loanMoney);
//                //减去该单金额
//                Integer b = Integer.valueOf(loanMoney) - Integer.valueOf(indent.getLoanAmount());
//                log.info(" b  " + b);
//                statistics.setLoanMoney(b + "");
//
//            }

            //拒绝单数、金额上增加
            Integer refuseCount = Integer.valueOf(statistics.getRefuseCount());
            log.info("  old  refuseCount = "+refuseCount);
            refuseCount += 1;
            statistics.setRefuseCount(refuseCount + "");
            Integer refuseMoney = Integer.valueOf(statistics.getRefuseMoney());
            log.info("  old  refuseMoney = "+refuseMoney);
            refuseMoney += Integer.valueOf(indent.getLoanAmount());
            statistics.setRefuseMoney(refuseMoney + "");
            log.info("  new  saler = "+indent.getSalerId()+" refuseCount = "+refuseCount+" refuseMoney = "+refuseMoney);
            statisticsService.update(statistics);


            //添加取消进度
            Iprocess iprocess = new Iprocess();
            iprocess.setId(null);
            iprocess.setCustomerId(indent.getCustomerId());
            iprocess.setProcess(Iprocess.PROCESS17);
            iprocess.setDescrition(description);
            iprocess.setCreateBy(Long.valueOf(userId));
            iprocess.setUpdateBy(Long.valueOf(userId));
            iprocessService.insert(iprocess);

            //发送推送内容

            Saler saler = salerService.getObjectById(customer.getSalerId());
            //获取channlId
            String channelId = saler.getNoticeChannelId();
            log.info(" saler id = " + saler.getId() + "   saler " + saler.getName() + "  channelId = " + channelId);
            if (DataUtils.isNotNullOrEmpty(channelId)) {
                Map<String, String> messageMap =
                        new NoticeMessageUtil().setNotice(indent.getProcess(), indent.getReplyResult(), customer.getName());
                String customContent = "{\"" + "cid" + "\":" + customer.getId() + ",\"productType\":\"" + indent.getProductType() + "\"}";
                log.info("  customConte = " + customContent);

                this.noticeUtil.pushMessae(channelId, messageMap.get("title"), messageMap.get("description"), 3, 1, 86400 * 7, customContent);

            }



            model.addAttribute("code", 0);

            //model.addAttribute("indent", indent);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update indent error,id is  " + indentId);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }


}




