package com.ptteng.common.carjn.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.Cussn;
import com.ptteng.common.carjn.service.CussnService;

/**
 * Cussn  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class CussnController {
	private static final Log log = LogFactory.getLog(CussnController.class);

	@Autowired
	private CussnService cussnService;








	@RequestMapping(value = "/web/c/cussn", method = RequestMethod.GET)
	public String getcussnList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/cussn  to /cussn/view/cussnList");

		return "/common-carjn-service/cussn/view/cussnList";
	}
    
    

    		
			

	
		 @RequestMapping(value = "/web/c/cussn1 ", method = RequestMethod.GET)
	public String getCussnIdsByCustomerIdList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long customerId) throws Exception {

		log.info("/web/cussn  to /cussn/view/cussnList");

		return "/common-carjn-service/cussn/view/cussnList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/cussn/{id}", method = RequestMethod.GET)
	public String getCussn(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/cussn/" + id + "  to /cussn/view/cussnDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/cussn/view/cussnDetail";
	}
	
	
	
	    		
			

	
		@RequestMapping(value = "/web/a/cussn1 ", method = RequestMethod.GET)
	public String getCussnIdsByCustomerIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long customerId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= cussnService.getCussnIdsByCustomerId(customerId,start,size);
		log.info("get countCussnIdsByCustomerId size is " + ids.size());

			List<Cussn> cussnList = cussnService.getObjectsByIds(ids);
			log.info("get cussn data is " + cussnList.size());

			Integer total = cussnService. countCussnIdsByCustomerId(customerId);
			log.info("get cussn count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("cussnList", cussnList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cussn list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cussn/json/cussnListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/web/a/cussn/{id}", method = RequestMethod.GET)
	public String getCussnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Cussn cussn = cussnService.getObjectById(id);
			log.info("get cussn data is " + cussn);

			model.addAttribute("code", 0);

			model.addAttribute("cussn", cussn);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cussn error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cussn/json/cussnDetailJson";
	}

	@RequestMapping(value = "/web/a/cussn/{id}", method = RequestMethod.PUT)
	public String updateCussnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Cussn cussn) throws Exception {
		
		log.info("update cussn : cussn= " + cussn);
		
		try {
			
			cussnService.update(cussn);

			model.addAttribute("code", 0);

			model.addAttribute("cussn", cussn);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update cussn error,id is  " + cussn.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/cussn", method = RequestMethod.POST)
	public String addCussnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Cussn cussn) throws Exception {
		
		log.info("update cussn : cussn= " + cussn);
		
		try { 
			cussn.setId(null);

			cussnService.insert(cussn);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add cussn error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/cussn/{id}", method = RequestMethod.DELETE)
	public String deleteCussnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete cussn : id= " + id);
		try {
			cussnService.delete(id);

			log.info("add cussn success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete cussn error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/cussn", method = RequestMethod.GET)
	public String getMultiCussnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Cussn> cussnList = cussnService.getObjectsByIds(idList);
			log.info("get  cussn data is " + cussnList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",cussnList.size());

			model.addAttribute("cussnList", cussnList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get cussn error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cussn/json/cussnListJson";
	}
	
	
}

