package com.ptteng.common.carjn.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;




import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.Cusemercon;
import com.ptteng.common.carjn.service.CusemerconService;

/**
 * Cusemercon  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class CusemerconController {
	private static final Log log = LogFactory.getLog(CusemerconController.class);

	@Autowired
	private CusemerconService cusemerconService;




	@RequestMapping(value = "/web/c/cusemercon", method = RequestMethod.GET)
	public String getcusemerconList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/cusemercon  to /cusemercon/view/cusemerconList");

		return "/common-carjn-service/cusemercon/view/cusemerconList";
	}
    
    

	 
	
		 @RequestMapping(value = "/web/c/cusemercon1 ", method = RequestMethod.GET)
	public String getCusemerconIdsByCustomerIdList1(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Long customerId) throws Exception {

		log.info("/web/cusemercon  to /cusemercon/view/cusemerconList");

		return "/common-carjn-service/cusemercon/view/cusemerconList";
	}

	
	
	
	
	
	
	@RequestMapping(value = "/web/c/cusemercon/{id}", method = RequestMethod.GET)
	public String getCusemercon(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/cusemercon/" + id + "  to /cusemercon/view/cusemerconDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/cusemercon/view/cusemerconDetail";
	}
	
	
	
	    		
			

	
		@RequestMapping(value = "/web/a/cusemercon1 ", method = RequestMethod.GET)
	public String getCusemerconIdsByCustomerIdJsonList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Integer page,
			Integer size,Long customerId) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= cusemerconService.getCusemerconIdsByCustomerId(customerId,start,size);
		log.info("get countCusemerconIdsByCustomerId size is " + ids.size());

			List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(ids);
			log.info("get cusemercon data is " + cusemerconList.size());

			Integer total = cusemerconService. countCusemerconIdsByCustomerId(customerId);
			log.info("get cusemercon count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			
			model.addAttribute("total", total);

			model.addAttribute("cusemerconList", cusemerconList);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cusemercon list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cusemercon/json/cusemerconListJson";
	}

	
	
		
	
	

	@RequestMapping(value = "/web/a/cusemercon/{id}", method = RequestMethod.GET)
	public String getCusemerconJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Cusemercon cusemercon = cusemerconService.getObjectById(id);
			log.info("get cusemercon data is " + cusemercon);

			model.addAttribute("code", 0);

			model.addAttribute("cusemercon", cusemercon);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get cusemercon error,id is  " + id);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cusemercon/json/cusemerconDetailJson";
	}

	@RequestMapping(value = "/web/a/cusemercon/{id}", method = RequestMethod.PUT)
	public String updateCusemerconJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Cusemercon cusemercon) throws Exception {
		
		log.info("update cusemercon : cusemercon= " + cusemercon);
		
		try {
			
			cusemerconService.update(cusemercon);

			model.addAttribute("code", 0);

			model.addAttribute("cusemercon", cusemercon);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update cusemercon error,id is  " + cusemercon.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/cusemercon", method = RequestMethod.POST)
	public String addCusemerconJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Cusemercon cusemercon) throws Exception {
		
		log.info("update cusemercon : cusemercon= " + cusemercon);
		
		try { 
			cusemercon.setId(null);

			cusemerconService.insert(cusemercon);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add cusemercon error ");
			model.addAttribute("code", -6002);
		}

		return "/data/json";
	}

	@RequestMapping(value = "/web/a/cusemercon/{id}", method = RequestMethod.DELETE)
	public String deleteCusemerconJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete cusemercon : id= " + id);
		try {
			cusemerconService.delete(id);

			log.info("add cusemercon success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete cusemercon error,id is  " + id);
			model.addAttribute("code", -6004);

		}

		return "/data/json";
	}
	
	
	@RequestMapping(value = "/web/a/multi/cusemercon", method = RequestMethod.GET)
	public String getMultiCusemerconJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Cusemercon> cusemerconList = cusemerconService.getObjectsByIds(idList);
			log.info("get  cusemercon data is " + cusemerconList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",cusemerconList.size());

			model.addAttribute("cusemerconList", cusemerconList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get cusemercon error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/cusemercon/json/cusemerconListJson";
	}
	
	
}

