package com.ptteng.common.carjn.controller;

import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.service.ConstantService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Constant  crud
 *
 * @author magenm 2014-4-16 13:43
 */
@Controller
public class ConstantController {
    private static final Log log = LogFactory.getLog(ConstantController.class);

    @Autowired
    private ConstantService constantService;


    @RequestMapping(value = "/web/c/constant", method = RequestMethod.GET)
    public String getconstantList(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model) throws Exception {


        log.info("/web/constant  to /constant/view/constantList");
        return "/common-carjn-service/constant/view/constantList";
    }


    @RequestMapping(value = "/web/c/constant1 ", method = RequestMethod.GET)
    public String getConstantIdsByTypeOrderByUpdateAtList1(HttpServletRequest request,
                                                           HttpServletResponse response, ModelMap model, String type) throws Exception {

        log.info("/web/constant  to /constant/view/constantList");

        return "/common-carjn-service/constant/view/constantList";
    }


    @RequestMapping(value = "/web/c/constant/{id}", method = RequestMethod.GET)
    public String getConstant(HttpServletRequest request,
                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/web/constant/" + id + "  to /constant/view/constantDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/common-carjn-service/constant/view/constantDetail";
    }


    @RequestMapping(value = "/web/a/constant1 ", method = RequestMethod.GET)
    public String getConstantIdsByTypeOrderByUpdateAtJsonList(HttpServletRequest request,
                                                              HttpServletResponse response, ModelMap model, Integer page,
                                                              Integer size, String type) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = constantService.getConstantIdsByTypeOrderByUpdateAt(type, start, size);
            log.info("get countConstantIdsByTypeOrderByUpdateAt size is " + ids.size());

            List<Constant> constantList = constantService.getObjectsByIds(ids);
            log.info("get constant data is " + constantList.size());

            Integer total = constantService.countConstantIdsByTypeOrderByUpdateAt(type);
            log.info("get constant count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("constantList", constantList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get constant list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/constant/json/constantListJson";
    }


    @RequestMapping(value = "/web/a/constant/{id}", method = RequestMethod.GET)
    public String getConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Constant constant = constantService.getObjectById(id);
            log.info("get constant data is " + constant);

            model.addAttribute("code", 0);

            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get constant error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/constant/json/constantDetailJson";
    }

    @RequestMapping(value = "/web/a/constant/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Constant constant) throws Exception {

        log.info("update constant : constant= " + constant);

        try {

            constantService.update(constant);

            model.addAttribute("code", 0);

            model.addAttribute("constant", constant);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update constant error,id is  " + constant.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    //条件管理--新增
    @RequestMapping(value = "/web/a/constant", method = RequestMethod.POST)
    public String addConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Constant constant) throws Exception {

        log.info("update constant : constant= " + constant);

        try {
            constant.setId(null);

            constantService.insert(constant);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add constant error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/constant/{id}", method = RequestMethod.DELETE)
    public String deleteConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete constant : id= " + id);
        try {
            constantService.delete(id);

            log.info("add constant success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete constant error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/constant", method = RequestMethod.GET)
    public String getMultiConstantJson(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Constant> constantList = constantService.getObjectsByIds(idList);
            log.info("get  constant data is " + constantList);

            model.addAttribute("code", 0);
            model.addAttribute("total", constantList.size());

            model.addAttribute("constantList", constantList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get constant error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/constant/json/constantListJson";
    }


}

