package com.ptteng.common.carjn.controller;

import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.util.StringUtil;
import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.model.Manager;
import com.ptteng.common.carjn.service.ManagerService;
import com.ptteng.util.CertificateUtil;
import com.ptteng.util.CheckresultrecordUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.Checkresultrecord;
import com.ptteng.common.carjn.service.CheckresultrecordService;

/**
 * Checkresultrecord  crud
 *
 * @author magenm 2014-4-16 13:43
 */
@Controller
public class CheckresultrecordController {
    private static final Log log = LogFactory.getLog(CheckresultrecordController.class);

    @Autowired
    private CheckresultrecordService checkresultrecordService;
    @Autowired
    private ManagerService managerService;

    @RequestMapping(value = "/a/u/checkresultrecord/indent", method = RequestMethod.GET)
    public String getCertificateJsonList(HttpServletRequest request,
                                         HttpServletResponse response, ModelMap model, Integer page,
                                         Integer size, Long indentId, String stage) throws Exception {

        log.info(" indentId =" + indentId + " ,stage=" + stage);
        if (page == null) {
            page = 1;
        }

        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            if(DataUtils.isNullOrEmpty(indentId)
                    ||"".equals(stage)
                    ||null == stage){
                model.addAttribute("code",-1000);
                return "/common/success";
            }

            Boolean next = false;
            size += 1;

            Map<String, Object> map = new HashMap<>();

            Map<String, Object> map1 = CheckresultrecordUtil.getCheckresultrecordListParam(indentId, stage, false);
            List<Long> ids  = checkresultrecordService.getIdsByDynamicCondition(Checkresultrecord.class, map1, start, size);


            log.info("get checkresultrecord size is " + ids.size());

            List<Long> kk = new ArrayList<>();
            for(Long id : ids){
                kk.add(id);
            }

            if (ids != null && ids.size() > 0) {

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  " + ids.subList(0, size - 1));
                   ids= ids.subList(0, size - 1);
                } else {
                    log.info("ss  " + ids.subList(0, ids.size()));
                   ids = ids.subList(0, ids.size());
                }
            } else{
                model.addAttribute("code", 0);
                model.addAttribute("page", page);
                model.addAttribute("size", size - 1);
                model.addAttribute("next", next);
                model.addAttribute("map2","");
                model.addAttribute("checkresultrecordList","");
            }
            log.info(" kk = "+kk);

            List<Checkresultrecord> checkresultrecordList = checkresultrecordService.getObjectsByIds(kk);
            log.info("checkresultrecordList  "+checkresultrecordList);
            Map<Long,String>  map2 =  new HashMap<>();
            for(Checkresultrecord  checkresultrecord : checkresultrecordList){
                log.info("  checkresultrecord.getCreateBy()) "+checkresultrecord.getCreateBy());
                if(DataUtils.isNotNullOrEmpty(checkresultrecord.getCreateBy())){
                    Manager manager = managerService.getObjectById(checkresultrecord.getCreateBy());
                    map2.put(checkresultrecord.getId(),manager.getName());
                }
            }

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);
            model.addAttribute("map2",map2);
            model.addAttribute("checkresultrecordList",checkresultrecordList);
            log.info("  size "+checkresultrecordList.size());

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get checkresultrecord list error,page is  " + start + " , size " + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/checkresultrecord/json/checkresultrecordListJson";
    }



    @RequestMapping(value = "/web/c/checkresultrecord", method = RequestMethod.GET)
    public String getcheckresultrecordList(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model) throws Exception {


        log.info("/web/checkresultrecord  to /checkresultrecord/view/checkresultrecordList");

        return "/common-carjn-service/checkresultrecord/view/checkresultrecordList";
    }



    @RequestMapping(value = "/web/c/checkresultrecord1 ", method = RequestMethod.GET)
    public String getCheckresultrecordIdsByIndentIdOrderByUpdateAtList1(HttpServletRequest request,
                                                                        HttpServletResponse response, ModelMap model, Long indentId) throws Exception {

        log.info("/web/checkresultrecord  to /checkresultrecord/view/checkresultrecordList");

        return "/common-carjn-service/checkresultrecord/view/checkresultrecordList";
    }


    @RequestMapping(value = "/web/c/checkresultrecord/{id}", method = RequestMethod.GET)
    public String getCheckresultrecord(HttpServletRequest request,
                                       HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("/web/checkresultrecord/" + id + "  to /checkresultrecord/view/checkresultrecordDeail");
        if (null != id) {
            model.addAttribute("id", id);
        } else {
            model.addAttribute("id", 0);
        }

        return "/common-carjn-service/checkresultrecord/view/checkresultrecordDetail";
    }




    @RequestMapping(value = "/web/a/checkresultrecord1 ", method = RequestMethod.GET)
    public String getCheckresultrecordIdsByIndentIdOrderByUpdateAtJsonList(HttpServletRequest request,
                                                                           HttpServletResponse response, ModelMap model, Integer page,
                                                                           Integer size, Long indentId) throws Exception {


        if (page == null) {
            page = 1;
        }
        if (size == null) {
            size = 10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {

            List<Long> ids = checkresultrecordService.getCheckresultrecordIdsByIndentIdOrderByUpdateAt(indentId, start, size);
            log.info("get countCheckresultrecordIdsByIndentIdOrderByUpdateAt size is " + ids.size());

            List<Checkresultrecord> checkresultrecordList = checkresultrecordService.getObjectsByIds(ids);
            log.info("get checkresultrecord data is " + checkresultrecordList.size());

            Integer total = checkresultrecordService.countCheckresultrecordIdsByIndentIdOrderByUpdateAt(indentId);
            log.info("get checkresultrecord count is " + total);

            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size);

            model.addAttribute("total", total);

            model.addAttribute("checkresultrecordList", checkresultrecordList);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get checkresultrecord list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/checkresultrecord/json/checkresultrecordListJson";
    }


    @RequestMapping(value = "/web/a/checkresultrecord/{id}", method = RequestMethod.GET)
    public String getCheckresultrecordJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Checkresultrecord checkresultrecord = checkresultrecordService.getObjectById(id);
            log.info("get checkresultrecord data is " + checkresultrecord);

            model.addAttribute("code", 0);

            model.addAttribute("checkresultrecord", checkresultrecord);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get checkresultrecord error,id is  " + id);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/checkresultrecord/json/checkresultrecordDetailJson";
    }

    @RequestMapping(value = "/web/a/checkresultrecord/{id}", method = RequestMethod.PUT)
    public String updateCheckresultrecordJson(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, Checkresultrecord checkresultrecord) throws Exception {

        log.info("update checkresultrecord : checkresultrecord= " + checkresultrecord);

        try {

            checkresultrecordService.update(checkresultrecord);

            model.addAttribute("code", 0);

            model.addAttribute("checkresultrecord", checkresultrecord);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update checkresultrecord error,id is  " + checkresultrecord.getId());
            model.addAttribute("code", -6003);

        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/checkresultrecord", method = RequestMethod.POST)
    public String addCheckresultrecordJson(HttpServletRequest request,
                                           HttpServletResponse response, ModelMap model, Checkresultrecord checkresultrecord) throws Exception {

        log.info("update checkresultrecord : checkresultrecord= " + checkresultrecord);

        try {
            checkresultrecord.setId(null);

            checkresultrecordService.insert(checkresultrecord);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add checkresultrecord error ");
            model.addAttribute("code", -6002);
        }

        return "/data/json";
    }

    @RequestMapping(value = "/web/a/checkresultrecord/{id}", method = RequestMethod.DELETE)
    public String deleteCheckresultrecordJson(HttpServletRequest request,
                                              HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete checkresultrecord : id= " + id);
        try {
            checkresultrecordService.delete(id);

            log.info("add checkresultrecord success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete checkresultrecord error,id is  " + id);
            model.addAttribute("code", -6004);

        }

        return "/data/json";
    }


    @RequestMapping(value = "/web/a/multi/checkresultrecord", method = RequestMethod.GET)
    public String getMultiCheckresultrecordJson(HttpServletRequest request,
                                                HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {


            List<Checkresultrecord> checkresultrecordList = checkresultrecordService.getObjectsByIds(idList);
            log.info("get  checkresultrecord data is " + checkresultrecordList);

            model.addAttribute("code", 0);
            model.addAttribute("total", checkresultrecordList.size());

            model.addAttribute("checkresultrecordList", checkresultrecordList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get checkresultrecord error,id is  " + idList);
            model.addAttribute("code", -100000);
        }

        return "/common-carjn-service/checkresultrecord/json/checkresultrecordListJson";
    }


}

