package com.ptteng.common.carjn.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.Channelsn;
import com.ptteng.common.carjn.service.ChannelsnService;

/**
 * Channelsn  crud
 * 
 * @author magenm 2014-4-16 13:43
 * 
 */
@Controller
public class ChannelsnController {
	private static final Log log = LogFactory.getLog(ChannelsnController.class);

	@Autowired
	private ChannelsnService channelsnService;



	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;




	@RequestMapping(value = "/web/c/channelsn", method = RequestMethod.GET)
	public String getchannelsnList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {

		
		
		log.info("/web/channelsn  to /channelsn/view/channelsnList");

		return "/common-carjn-service/channelsn/view/channelsnList";
	}
    
    

    
	
	@RequestMapping(value = "/web/c/channelsn/{id}", method = RequestMethod.GET)
	public String getChannelsn(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/channelsn/" + id + "  to /channelsn/view/channelsnDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/channelsn/view/channelsnDetail";
	}
	
	
	
	    
	

	//查询单个
	@RequestMapping(value = "/a/u/channelsn/{id}", method = RequestMethod.GET)
	public String getChannelsnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			Channelsn channelsn = channelsnService.getObjectById(id);
			log.info("get channelsn data is " + channelsn);
			if(DataUtils.isNullOrEmpty(channelsn)){
				model.addAttribute("code",-60005);
				return "/data/json";
			}

			model.addAttribute("code", 0);

			model.addAttribute("channelsn", channelsn);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get channelsn error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/channelsn/json/channelsnDetailJson";
	}

	//修改
	@RequestMapping(value = "/a/u/channelsn/{id}", method = RequestMethod.PUT)
	public String updateChannelsnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Channelsn channelsn,@PathVariable Long id) throws Exception {
		
		log.info("update channelsn : channelsn= " + channelsn);
		
		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			Channelsn channelsn1 = channelsnService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(channelsn1)){
				model.addAttribute("code",-60005);
				return "/data/json";
			}
			if(DataUtils.isNullOrEmpty(channelsn.getChannelId())
					||DataUtils.isNullOrEmpty(channelsn.getCount())
					||DataUtils.isNullOrEmpty(channelsn.getId())
					||DataUtils.isNullOrEmpty(channelsn.getProductType())){
				model.addAttribute("code",-1000);
				return "/common/success";
			}
			channelsn.setUpdateBy(uid);
			channelsnService.update(channelsn);

			model.addAttribute("code", 0);

			model.addAttribute("channelsn", channelsn);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update channelsn error,id is  " + channelsn.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//新增
	@RequestMapping(value = "/a/u/channelsn", method = RequestMethod.POST)
	public String addChannelsnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Channelsn channelsn) throws Exception {
		
		log.info("add channelsn : channelsn= " + channelsn);
		
		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			channelsn.setId(null);
			if(DataUtils.isNullOrEmpty(channelsn.getChannelId())
					||DataUtils.isNullOrEmpty(channelsn.getCount())
					||DataUtils.isNullOrEmpty(channelsn.getProductType())){
				model.addAttribute("code",-1000);
				return "/common/success";
			}
			channelsn.setCreateBy(uid);
			channelsn.setUpdateBy(uid);
			Long id = channelsnService.insert(channelsn);
			log.info("  id  =  " + id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add channelsn error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}

	//删除
	@RequestMapping(value = "/a/u/channelsn/{id}", method = RequestMethod.DELETE)
	public String deleteChannelsnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete channelsn : id= " + id);
		try {
			Channelsn channelsn =  channelsnService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(channelsn)){
				model.addAttribute("code",-60005);
				return "/data/json";
			}
			channelsnService.delete(id);

			log.info("add channelsn success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete channelsn error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}


	//查询列表ids
	@RequestMapping(value = "/a/u/channelsn/", method = RequestMethod.GET)
	public String deleteCertificateChannelRelationJson(HttpServletRequest request,
													   HttpServletResponse response, ModelMap model,Integer page, Integer size)
			throws Exception {
		log.info("/web/a/channelsn/list ,page is:"+page+",size is"+size);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Boolean next = false;
			size+=1;

			List<Long>  ids = new ArrayList<Long>();
			ids =  channelsnService.getChannelsnIds(start, size);
			if(ids!=null && ids.size()>0){

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  "+ids.subList(0,size-1));
					model.addAttribute("ids", ids.subList(0,size-1));
				}else{
					log.info("ss  " + ids.subList(0,ids.size()));
					model.addAttribute("ids", ids.subList(0, ids.size()));
				}
			}else{
				model.addAttribute("ids", ids);
			}

			model.addAttribute("code",0);
			model.addAttribute("size", size - 1);
			model.addAttribute("page", page);
			model.addAttribute("next",next);


		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete certificateChannelRelation error,page is  " + page+"size = "+size);
			model.addAttribute("code", -1);

		}

		return "/common-carjn-service/article/json/articleListJson";
	}


	//详细
	@RequestMapping(value = "/a/u/multi/channelsn", method = RequestMethod.GET)
	public String getMultiChannelsnJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			log.info("  ids  = "+ids);
		List<Long> idList = new ArrayList();	
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {

			

			List<Channelsn> channelsnList = channelsnService.getObjectsByIds(idList);
			log.info("get  channelsn data is " + channelsnList);

			model.addAttribute("code", 0);			
			model.addAttribute("total",channelsnList.size());

			model.addAttribute("channelsnList", channelsnList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get channelsn error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/channelsn/json/channelsnListJson";
	}
	
	
}

