package com.ptteng.common.carjn.controller;

import com.ptteng.common.carjn.model.Constant;
import com.ptteng.common.carjn.model.Saler;
import com.ptteng.common.carjn.service.ConstantService;
import com.ptteng.util.SalerUtil;
import com.qding.common.util.DataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * Created by liangxj on 2015/12/7.
 */
@Controller
public class ChannelControler {
    private static final Log log = LogFactory.getLog(ChannelControler.class);

    @Autowired
    private ConstantService constantService;

    //渠道管理--新增
    @RequestMapping(value = "/a/u/channel", method = RequestMethod.POST)
    public String addConstantJson(HttpServletRequest request,
                                  HttpServletResponse response, ModelMap model, Constant channel) throws Exception {

        log.info("update constant : channel= " + channel);

        try {
            if(  DataUtils.isNullOrEmpty(channel)
                    // 渠道说明为非必填项：|| DataUtils.isNullOrEmpty(channel.getDescription())
                   || DataUtils.isNullOrEmpty(channel.getValue())){
                model.addAttribute("code",-1000);
                return "/common/success";
            }
            Long channelId = constantService.getConstantIdByNameAndType
                    (channel.getValue(),Constant.TYPE_CHANNEL);
            if(DataUtils.isNotNullOrEmpty(channelId)){
                model.addAttribute("code",-50004);
                return "/common/success";
            }

            channel.setType(Constant.TYPE_CHANNEL);
            channel.setName(channel.getValue());
            channel.setId(null);

            constantService.insert(channel);

            model.addAttribute("code", 0);
        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("add constant error ");
            model.addAttribute("code", -1);
        }

        return "/common/success";
    }

    //渠道管理--修改
    @RequestMapping(value = "/a/u/channel/{id}", method = RequestMethod.PUT)
    public String updateConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Constant channel,
                                     @PathVariable Long id) throws Exception {

        log.info("update constant : channel= " + channel);

        try {
            Constant channel1 = constantService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(channel1)){
                model.addAttribute("code",-20001);
                return "/common/success";
            }
            if(  DataUtils.isNullOrEmpty(channel)
                    //渠道说明为非必填项： || DataUtils.isNullOrEmpty(channel.getDescription())
                    || DataUtils.isNullOrEmpty(channel.getValue())){
                model.addAttribute("code",-1000);
                return "/common/success";
            }
            Long channelId = constantService.getConstantIdByNameAndType
                    (channel.getValue(),Constant.TYPE_CHANNEL);
            if(!id.equals(channelId)){
                model.addAttribute("code",-50004);
                return "/common/success";
            }




            channel1.setValue(channel.getValue());
            channel1.setDescription(channel.getDescription());
            channel1.setName(channel.getValue());
            constantService.update(channel1);

            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("update channel error,id is  " + channel.getId());
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    //删除
    @RequestMapping(value = "/a/u/channel/{id}", method = RequestMethod.DELETE)
    public String deleteConstantJson(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("delete channel : id= " + id);
        try {
            Constant channel1 = constantService.getObjectById(id);
            if(DataUtils.isNullOrEmpty(channel1)){
                model.addAttribute("code",-20001);
                return "/common/success";
            }
            constantService.delete(id);

            log.info("add constant success");
            model.addAttribute("code", 0);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("delete constant error,id is  " + id);
            model.addAttribute("code", -1);

        }

        return "/common/success";
    }

    //渠道管理--根据ID查询单个渠道详情
    @RequestMapping(value = "/a/u/channel/{id}", method = RequestMethod.GET)
    public String getSalerJson(HttpServletRequest request,
                               HttpServletResponse response, ModelMap model, @PathVariable Long id)
            throws Exception {

        log.info("get data : id= " + id);
        try {
            Constant channel = constantService.getObjectById(id);
            log.info("get channel data is " + channel);

            model.addAttribute("code", 0);

            model.addAttribute("constant", channel);

        } catch (Throwable t) {
            t.printStackTrace();
            log.error(t.getMessage());
            log.error("get channel error,id is  " + id);
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/channelDetailJson";
    }

    /**
     * 渠道列表查询
     * @param request
     * @param response
     * @param model
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/a/u/channel/", method = RequestMethod.GET)
    public String getManagerJsonList(HttpServletRequest request,
                                     HttpServletResponse response, ModelMap model, Integer page,
                                     Integer size) throws Exception {

        if(page==null){

            page=1;
        }

        if(size == null){
            size=10;
        }
        int start = (page - 1) * size;
        if (start < 0) {
            start = 0;
        }

        log.info("pageList : page= " + start + " , size=" + size);

        try {
            Boolean next = false;
            size+=1;


            List<Long> ids = constantService.getConstantIdsByTypeOrderByUpdateAt(Constant.TYPE_CHANNEL,start, size);


            log.info("get channel size is " + ids.size());

            if(ids!=null && ids.size()>0){

                if (size.equals(ids.size())) {
                    next = true;
                    log.info("ss  "+ids.subList(0,size-1));
                    model.addAttribute("ids", ids.subList(0,size-1));
                }else{
                    log.info("ss  "+ids.subList(0,ids.size()));
                    model.addAttribute("ids", ids.subList(0, ids.size()));
                }
            }else{
                model.addAttribute("ids", ids);
            }
            model.addAttribute("code", 0);
            model.addAttribute("page", page);
            model.addAttribute("size", size - 1);
            model.addAttribute("next", next);




        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get channel list error,page is  " + start + " , size "
                    + size);
            // for test
            model.addAttribute("code", -1);
            return "/common/success";
        }

        return "/common-carjn-service/channel/json/channelListJson";
    }


    //批量查询渠道列表
    @RequestMapping(value = "/a/u/multi/channel", method = RequestMethod.GET)
    public String getMultiSalerJson(HttpServletRequest request,
                                    HttpServletResponse response, ModelMap model, Long[] ids)
            throws Exception {

        List<Long> idList = new ArrayList();
        if (ids == null) {

        } else {
            idList = Arrays.asList(ids);
        }
        try {



            List<Constant> channelList = constantService.getObjectsByIds(idList);
            log.info("get  channel data is " + channelList.size());

            model.addAttribute("code", 0);
            model.addAttribute("total", channelList.size());

            model.addAttribute("constantList", channelList);

        } catch (Throwable t) {
            log.error(t.getMessage());
            log.error("get channel error,id is  " + idList);
            model.addAttribute("code", -1);
        }

        return "/common-carjn-service/channel/json/channelMultiListJson";
    }




}
