package com.ptteng.common.carjn.controller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.ptteng.carjn.framework.interceptor.CookieConstant;
import com.qding.common.util.DataUtils;
import com.qding.common.util.http.cookie.CookieUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.ptteng.common.carjn.model.CertificateChannelRelation;
import com.ptteng.common.carjn.service.CertificateChannelRelationService;

/**
 * CertificateChannelRelation  crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class CertificateChannelRelationController {
	private static final Log log = LogFactory.getLog(CertificateChannelRelationController.class);

	@Autowired
	private CertificateChannelRelationService certificateChannelRelationService;

	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;





	@RequestMapping(value = "/web/c/certificateChannelRelation", method = RequestMethod.GET)
	public String getcertificateChannelRelationList(HttpServletRequest request,
			HttpServletResponse response, ModelMap model) throws Exception {



		log.info("/web/certificateChannelRelation  to /certificateChannelRelation/view/certificateChannelRelationList");

		return "/common-carjn-service/certificateChannelRelation/view/certificateChannelRelationList";
	}





	@RequestMapping(value = "/web/c/certificateChannelRelation/{id}", method = RequestMethod.GET)
	public String getCertificateChannelRelation(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/certificateChannelRelation/" + id + "  to /certificateChannelRelation/view/certificateChannelRelationDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/certificateChannelRelation/view/certificateChannelRelationDetail";
	}






	//查询单个
	@RequestMapping(value = " /a/u/certifichannelrelaion/{id}", method = RequestMethod.GET)
	public String getCertificateChannelRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("get data : id= " + id);
		try {
			CertificateChannelRelation certificateChannelRelation = certificateChannelRelationService.getObjectById(id);
			log.info("get certificateChannelRelation data is " + certificateChannelRelation);

			if(DataUtils.isNullOrEmpty(certificateChannelRelation)){
				model.addAttribute("code",-1000);
				return "/common/success";
			}
			model.addAttribute("code", 0);

			model.addAttribute("certificateChannelRelation", certificateChannelRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("get certificateChannelRelation error,id is  " + id);
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/certificateChannelRelation/json/certificateChannelRelationDetailJson";
	}

	//修改
	@RequestMapping(value = " /a/u/certifichannelrelaion/{id}", method = RequestMethod.PUT)
	public String updateCertificateChannelRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,
													   CertificateChannelRelation certificateChannelRelation,
													   @PathVariable Long id) throws Exception {

		log.info("update certificateChannelRelation : certificateChannelRelation= " + certificateChannelRelation);

		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			CertificateChannelRelation certificateChannelRelation1 = certificateChannelRelationService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(certificateChannelRelation)){
				model.addAttribute("code",-60005);
				return "/common/success";
			}
			if(DataUtils.isNullOrEmpty(certificateChannelRelation.getCertificateId())
					||DataUtils.isNullOrEmpty(certificateChannelRelation.getChannelId())
					||DataUtils.isNullOrEmpty(certificateChannelRelation.getProductType())
					||DataUtils.isNullOrEmpty(certificateChannelRelation.getId())){
				model.addAttribute("code",1000);
				return "/common/success";
			}
			certificateChannelRelation.setUpdateBy(uid);
			certificateChannelRelationService.update(certificateChannelRelation);

			model.addAttribute("code", 0);

			model.addAttribute("certificateChannelRelation", certificateChannelRelation);

		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("update certificateChannelRelation error,id is  " + certificateChannelRelation.getId());
			model.addAttribute("code", -6003);

		}

		return "/data/json";
	}

	//新增
	@RequestMapping(value = "/a/u/certifichannelrelaion", method = RequestMethod.POST)
	public String addCertificateChannelRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, CertificateChannelRelation certificateChannelRelation) throws Exception {

		log.info("update certificateChannelRelation : certificateChannelRelation= " + certificateChannelRelation);

		try {
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			certificateChannelRelation.setId(null);
			if(DataUtils.isNullOrEmpty(certificateChannelRelation.getCertificateId())
					||DataUtils.isNullOrEmpty(certificateChannelRelation.getChannelId())
					||DataUtils.isNullOrEmpty(certificateChannelRelation.getProductType())){
				model.addAttribute("code",1000);
				return "/common/success";
			}
			certificateChannelRelation.setCreateBy(uid);
			certificateChannelRelation.setUpdateBy(uid);

			Long id = certificateChannelRelationService.insert(certificateChannelRelation);
			log.info("  id = " + id);
			model.addAttribute("code", 0);
		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("add certificateChannelRelation error ");
			model.addAttribute("code", -1);
		}

		return "/data/json";
	}
	//删除
	@RequestMapping(value = "/a/u/certifichannelrelaion/{id}", method = RequestMethod.DELETE)
	public String deleteChannelsnJson(HttpServletRequest request,
									  HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("delete channelsn : id= " + id);
		try {
			CertificateChannelRelation certificateChannelRelation =
					certificateChannelRelationService.getObjectById(id);
			if(DataUtils.isNullOrEmpty(certificateChannelRelation)){
				model.addAttribute("code",-60005);
				return "/data/json";
			}

			certificateChannelRelationService.delete(id);

			log.info("add channelsn success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete channelsn error,id is  " + id);
			model.addAttribute("code", -1);

		}

		return "/data/json";
	}





	//查询列表ids
	@RequestMapping(value = "/a/u/certifichannelrelaion/", method = RequestMethod.GET)
	public String deleteCertificateChannelRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model,Integer page, Integer size)
			throws Exception {
		log.info("/web/a/certificateChannelRelation/list ,page is:"+page+",size is"+size);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Boolean next = false;
			size+=1;

			List<Long>  ids = new ArrayList<Long>();
			ids =  certificateChannelRelationService.getCertificateChannelRelationIds(start, size);
			if(ids!=null && ids.size()>0){

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  "+ids.subList(0,size-1));
					model.addAttribute("ids", ids.subList(0,size-1));
				}else{
					log.info("ss  " + ids.subList(0,ids.size()));
					model.addAttribute("ids", ids.subList(0, ids.size()));
				}
			}else{
				model.addAttribute("ids", ids);
			}

			model.addAttribute("code",0);
			model.addAttribute("size", size-1);
			model.addAttribute("page", page);
			model.addAttribute("next",next);


		} catch (Throwable t) {
		    t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete certificateChannelRelation error,page is  " + page+"size = "+size);
			model.addAttribute("code", -1);

		}

		return "/common-carjn-service/article/json/articleListJson";
	}

	//查询列表详细
	@RequestMapping(value = "/a/u/multi/certifichannelrelaion/", method = RequestMethod.GET)
	public String getMultiCertificateChannelRelationJson(HttpServletRequest request,
			HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {
			log.info("  ids  =  "+ids);
		List<Long> idList = new ArrayList();
	   if (ids == null) {

		} else {
			idList = Arrays.asList(ids);
		}
		try {



			List<CertificateChannelRelation> certificateChannelRelationList = certificateChannelRelationService.getObjectsByIds(idList);
			log.info("get  certificateChannelRelation data is " + certificateChannelRelationList);

			model.addAttribute("code", 0);
			model.addAttribute("total",certificateChannelRelationList.size());

			model.addAttribute("certificateChannelRelationList", certificateChannelRelationList);

		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get certificateChannelRelation error,id is  " + idList);
			model.addAttribute("code", -1);
		}

		return "/common-carjn-service/certificateChannelRelation/json/certificateChannelRelationListJson";
	}
	
	
}

