package com.ptteng.common.carjn.controller;
import java.io.File;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.carjn.model.Article;
import com.ptteng.common.carjn.model.Manager;
import com.ptteng.common.carjn.service.ArticleService;
import com.ptteng.common.carjn.service.ManagerService;
import com.ptteng.common.storage.util.ImgStorageUtil;
import com.ptteng.util.DynamicUtil;
import com.qding.common.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

/**
 * Article  crud
 *
 * @author magenm 2014-4-16 13:43
 *
 */
@Controller
public class ArticleController {
	private static final Log log = LogFactory.getLog(ArticleController.class);

	private final String Img_Module_Common = "common";
	@Autowired
	private ArticleService articleService;

	@Autowired
	private ImgStorageUtil imgStorageUtil;


	@Autowired
	private com.qding.common.util.http.cookie.CookieUtil cookieUtil;






	@RequestMapping(value = "/index", method = RequestMethod.GET)
	public String index(HttpServletRequest request,
						HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the indexpage~");

		List<Article> articleList1 =  getArticleListByType(0, 4, 1);

		List<Article> articleList2 =  getArticleListByType(0, 4, 2);

		List<Article> articleList3 =  getArticleListByType(0, 4, 3);
		List<Article> articleList4 =  getArticleListByType(0, Integer.MAX_VALUE, 4);

		log.info("list1 :"+articleList1+" and list2 :"+articleList2+" and list3 :"+articleList3);

		model.addAttribute("articleList1", articleList1);

		model.addAttribute("articleList2", articleList2);

		model.addAttribute("articleList3", articleList3);
		model.addAttribute("articleList4", articleList4);
		String highLight = "active";

		model.addAttribute("index", "active");

		return "/web/index/index";


	}


	@RequestMapping(value = "/a/test", method = RequestMethod.GET)
	public String testJsp(HttpServletRequest request,
						  HttpServletResponse response, ModelMap model ) throws Exception {

		log.info("show the test page~");

		return "/common-carjn-service/link";

	}


	@RequestMapping(value = "/product", method = RequestMethod.GET)
	public String product(HttpServletRequest request,
						  HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the indexpage~");

		model.addAttribute("code", 0);

		String highLight = "active";

		model.addAttribute("product", highLight);

		return "/web/index/product";


	}

	@RequestMapping(value = "/knowledge", method = RequestMethod.GET)
	public String knowledge(HttpServletRequest request,
							HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the indexpage~");

		model.addAttribute("code", 0);

		String highLight = "active";

		model.addAttribute("knowledge", highLight);

		return "/web/index/knowledge";


	}

	@RequestMapping(value = "/movement", method = RequestMethod.GET)
		 public String movement(HttpServletRequest request,
								HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the indexpage~");

		model.addAttribute("code", 0);

		model.addAttribute("movement", "active");

		return "/web/index/movement";


	}
	@RequestMapping(value = "/movement/expert", method = RequestMethod.GET)
	public String movementExpert(HttpServletRequest request,
						   HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the expert~");

		model.addAttribute("code", 0);

		model.addAttribute("movement", "active");
		model.addAttribute("type", 2);
		model.addAttribute("module", "专家团队");

		return "/web/index/expert";


	}

	@RequestMapping(value = "/about", method = RequestMethod.GET)
	public String about(HttpServletRequest request,
						HttpServletResponse response, ModelMap model) throws Exception {

		log.info("show the indexpage~");
		List<Article> managers =  getArticleListByType(0, Integer.MAX_VALUE, 5);
		for(Article  manager : managers){
			if(manager.getContent().contains("p>")){
				manager.setContent(manager.getContent().replace("<p>", ""));
				manager.setContent(manager.getContent().replace("</p>","</br>"));

			}
		}


		model.addAttribute("code", 0);
		model.addAttribute("about", "active");
        model.addAttribute("managers",managers);
		return "/web/index/about";


	}


	@RequestMapping(value = "/movement/{id}", method = RequestMethod.GET)
	public String movementDetail(HttpServletRequest request,
						HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("show the movementDetail~");

		Article article = new Article();
		if(id.equals(0L)){
			article = articleService.getObjectById(1L);
		}else {
			article = articleService.getObjectById(id);
		}
		model.addAttribute("code", 0);

		model.addAttribute("article", article);

		model.addAttribute("movement", "active");
		model.addAttribute("type",1);
		model.addAttribute("module","公司动态");
		return "/web/index/movement";


	}

	@RequestMapping(value = "/expert/{id}", method = RequestMethod.GET)
	public String expertDetail(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id) throws Exception {

		log.info("show the expertDetail~");

		Article article = new Article();
		if(id.equals(0L)){
			article = articleService.getObjectById(1L);
		}else {
			article = articleService.getObjectById(id);
		}
		model.addAttribute("code", 0);

		model.addAttribute("article",article);

		model.addAttribute("expert", "active");
		model.addAttribute("type",2);
		model.addAttribute("module","专家团队");
		return "/web/index/movement";


	}
	//动态列表页
	@RequestMapping(value = "/movement/{type}/list/{page}", method = RequestMethod.GET)
	public String movementList(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Integer type, @PathVariable Integer page) throws Exception {

		log.info("show the movementList~ ,get type: "+type +", page: "+page);

		if(type!=1&&type!=2&&type!=3&&type!=4){
			type = 1;
		}

//		List<Article> all = getArticleListByType(0, Integer.MAX_VALUE, type);
//
//		int count = all.size();
//		double lastPage = Math.ceil(count / 5);
//		int lastPage1=(int) lastPage;

		if (page == null) {
			page = 1;
		}
		int start = (page - 1) * 5;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids= articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, 6);

		List<Article> articleList1 =  articleService.getObjectsByIds(ids);

		List<Article> articleList =  getArticleListByType(page, 5, type);

		int size = articleList1.size();

		String module = new String();
		if(type.equals(2)){
			module = "专家团队";
			model.addAttribute("expert", "active");
		}else{
			module = "公司动态";
			model.addAttribute("movement", "active");
		}

		String first = new String();
		String last = new String();
		String herf1 = new String();
		String herf2 = new String();
		if(page<2){
			if(size<6) {
				first = "first";
				last = "first";
			}else{
				first = "first";
				last = "last";
				herf2 = "href=\"/movement/" + type + "/list/" + (page + 1) + "\"";
			}
		}else{
			if(size<6){
				first = "last";
				last = "first";
				herf1 = "href=\"/movement/"+type+"/list/"+(page-1)+"\"";
			}else {
				first = "last";
				last = "last";
				herf1 = "href=\"/movement/"+type+"/list/"+(page-1)+"\"";
				herf2 = "href=\"/movement/"+type+"/list/" + (page + 1) + "\"";
			}
		}

		log.info("module: " + module + ", type: " + type + ", page: " + page + ", size: " + size +
				", articleList1: " + articleList1 + ", articleList: " + articleList+", first: "+first+", last: "+last);

		model.addAttribute("code", 0);

		model.addAttribute("module", module);

		model.addAttribute("type", type);

		model.addAttribute("herf1", herf1);

		model.addAttribute("herf2", herf2);

		model.addAttribute("first", first);

		model.addAttribute("last", last);

		model.addAttribute("page", page);

		model.addAttribute("articleList",articleList);



		return "/web/index/health";


	}



	@RequestMapping(value = "/web/c/article", method = RequestMethod.GET)
	public String getArticleList(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model) throws Exception {



		log.info("/web/article  to /article/view/articleList");

		return "/common-carjn-service/article/view/articleList";
	}








	@RequestMapping(value = "/web/c/article1 ", method = RequestMethod.GET)
	public String getArticleIdsByStatusAndSourceOrderByPublishatList1(HttpServletRequest request,
																		  HttpServletResponse response, ModelMap model,Long status,String source) throws Exception {

		log.info("/web/article  to /article/view/ArticleList");

		return "/common-carjn-service/article/view/ArticleList";
	}








	@RequestMapping(value = "/web/c/article2 ", method = RequestMethod.GET)
	public String getArticleIdsBySourceOrderByPublishatList2(HttpServletRequest request,
																 HttpServletResponse response, ModelMap model,String source) throws Exception {

		log.info("/web/Article  to /Article/view/ArticleList");

		return "/common-carjn-service/Article/view/ArticleList";
	}










	@RequestMapping(value = "/web/c/Article3 ", method = RequestMethod.GET)
	public String getArticleIdsByTypeOrderByPublishatList3(HttpServletRequest request,
															   HttpServletResponse response, ModelMap model,Integer type) throws Exception {

		log.info("/web/Article  to /Article/view/ArticleList");

		return "/common-carjn-service/Article/view/ArticleList";
	}







	@RequestMapping(value = "/web/c/Article/{id}", method = RequestMethod.GET)
	public String getArticle(HttpServletRequest request,
								 HttpServletResponse response, ModelMap model, @PathVariable Long id)
			throws Exception {

		log.info("/web/Article/" + id + "  to /Article/view/ArticleDeail");
		if(null != id){
			model.addAttribute("id", id);
		}else{
			model.addAttribute("id", 0);
		}

		return "/common-carjn-service/Article/view/ArticleDetail";
	}






	@RequestMapping(value = "/web/a/Article1 ", method = RequestMethod.GET)
	public String getArticleIdsByStatusAndSourceOrderByPublishatJsonList(HttpServletRequest request,
																			 HttpServletResponse response, ModelMap model, Integer page,
																			 Integer size,Integer status,String source) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= articleService.getArticleIdsByStatusAndSourceOrderByPublishat(Long.valueOf(status), source, start, size);
			log.info("get countArticlenIdsByStatusAndSourceOrderByPublishat size is " + ids.size());

			List<Article> articleList = articleService.getObjectsByIds(ids);
			log.info("get Article data is " + articleList.size());

			Integer total = articleService. countArticleIdsByStatusAndSourceOrderByPublishat(Long.valueOf(status), source);
			log.info("get Article count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("articleList", articleList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get Article list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleListJson";
	}








	@RequestMapping(value = "/web/a/article2 ", method = RequestMethod.GET)
	public String getArticleIdsBySourceOrderByPublishatJsonList(HttpServletRequest request,
																	HttpServletResponse response, ModelMap model, Integer page,
																	Integer size,String source) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= articleService.getArticleIdsBySourceOrderByPublishat(source, start, size);
			log.info("get countarticleIdsBySourceOrderByPublishat size is " + ids.size());

			List<Article> articleList = articleService.getObjectsByIds(ids);
			log.info("get article data is " + articleList.size());

			Integer total = articleService. countArticleIdsBySourceOrderByPublishat(source);
			log.info("get article count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("articleList", articleList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleListJson";
	}






	/**
	 * 根据类型发布状体查找内容
	 */

	@RequestMapping(value = "/web/a/article/{type} ", method = RequestMethod.GET)
	public String getArticleIdsByTypeOrderByPublishatJsonList(HttpServletRequest request,
																  HttpServletResponse response, ModelMap model, Integer page,
																  Integer size,@PathVariable Integer type) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Unpublished, start, size);
			log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids.size());

			List<Article> articleList = articleService.getObjectsByIds(ids);
			log.info("get article data is " + articleList);


			Integer total = articleService. countArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Unpublished);
			log.info("get article count is " + total);

			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);

			model.addAttribute("total", total);

			model.addAttribute("articleList", articleList);
			return "/common-carjn-service/article/json/articleListJson";
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}
	/**
	 * 查询所有内容
	 */

	@RequestMapping(value = "/a/u/article ", method = RequestMethod.GET)
	public String getArticleIdsJsonList(HttpServletRequest request,
											HttpServletResponse response, ModelMap model, Integer page,
											Integer size) throws Exception {


		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		log.info("pageList : page= " + start + " , size=" + size);

		try {

			List<Long> ids= articleService.getArticleIds(start, size);
			log.info("get countarticleIdsList size is " + ids.size());

			List<Article> articleList = articleService.getObjectsByIds(ids);
			log.info("get article data is " + articleList);
           if(articleList != null&& articleList.size()>0 ) {
			   Integer total = articleList.size();
			   log.info("get article count is " + total);
			   model.addAttribute("total", total);
		   }else{

			   model.addAttribute("total", 0);
		   }
			model.addAttribute("code", 0);
			model.addAttribute("page", page);
			model.addAttribute("size", size);
			model.addAttribute("articleList", articleList);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article list error,page is  " + start + " , size "
					+ size);
			// for test
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleListJson";
	}



	/**
	 * 单个查询展示内容
	 * @param request
	 * @param response
	 * @param model
	 * @param aid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.GET)
	public String getArticleJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, @PathVariable Long aid)
			throws Exception {

		log.info("get data : id= " + aid);
		try {
			if(aid == null) {
				model.addAttribute("code", -1004);
				return "/common/success";
			}else {

			Article article = articleService.getObjectById(aid);
			if (article == null) {
				model.addAttribute("code", -9003);
				return "/common/success";
			}else{
					log.info("get article data is " + article);
					model.addAttribute("code", 0);
					model.addAttribute("article", article);
				}
			}
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("get article error,id is  " + aid);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleDetailJson";
	}

	/**
	 * 修改内容
	 * @param request
	 * @param response
	 * @param model
	 * @param article
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.PUT)
	public String updateArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, Article article,@PathVariable Long aid) throws Exception {

		log.info("update article : article= " + article);

		try {
			//	if("-1".equals(article.getStatus())){
			//	article.setStatus(-1L);//保存草稿，不发布
			//}else{
			//		article.setStatus(System.currentTimeMillis());//发布
			//	}
			if(article == null){
				model.addAttribute("code",-1004);
				return "/common/success";
			}
			if(//摘要和内容为非必填项：|| article.getContent()==null||article.getContent().equals("")
			// ||article.getSummary()==null || article.getSummary().equals("")
					article.getType()==null || article.getImg() == null|| article.getImg().equals("")
							||article.getTitle()==null|| article.getTitle().equals("")
					){
				model.addAttribute("code",-1004);
				return "/common/success";
			}

			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			article.setUpdateBy(uid);
			articleService.update(article);

			model.addAttribute("code", 0);

			model.addAttribute("article", article);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update article error,id is  " + article.getId());
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

	/**
	 * 发布或取消内容
	 * @param request
	 * @param response
	 * @param model
	 * @param status
	 * @param aid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}/status", method = RequestMethod.PUT)
	public String updateArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model,Integer status,@PathVariable Long aid) throws Exception {

		log.info("update article status : article id ,status = " +aid+" , "+status);

		try {
			Article article =  articleService.getObjectById(aid);
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));

			article.setUpdateBy(uid);
			log.info("article is  " + article);
			if(Article.Status_Unpublished == status){
				article.setStatus( Long.valueOf( Article.Status_Unpublished)  );//取消发布
			}else{
				Long time = System.currentTimeMillis();
				article.setStatus( Long.valueOf(Article.Status_Published) );//发布内容
				article.setPublishat(time);
			}


			articleService.update(article);

			model.addAttribute("code", 0);



		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("update article error,id is  " + aid);
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

	/**
	 * 添加内容
	 * @param request
	 * @param response
	 * @param model
	 * @param article
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article", method = RequestMethod.POST)
	public String addArticleJson(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Article article) throws Exception {

		log.info("update article : article= " + article);

		try {
			if(article == null){
				model.addAttribute("code",-1004);
				return "/common/success";
			}
			if(//摘要作者和内容为非必填项： article.getContent()==null||article.getSummary()==null || article.getSummary().equals("")
					article.getType()==null || article.getType().equals("") || article.getImg() == null|| article.getImg().equals("")
							|| article.getTitle().equals("")

					){
             model.addAttribute("code",-1004);
				return "/common/success";
			}
			Long time = System.currentTimeMillis();

			if(Long.valueOf(Article.Status_Unpublished).equals(article.getStatus())){
				article.setStatus(Long.valueOf(Article.Status_Unpublished) );//保存草稿，不发布
				article.setPublishat(time);
			}else if(Long.valueOf(Article.Status_Published).equals(article.getStatus())){

				article.setStatus( Long.valueOf(Article.Status_Published));//发布
				article.setPublishat(time);
			}else{
				article.setStatus(Long.valueOf(Article.Status_Unpublished));
			}
			Long uid = Long.valueOf(cookieUtil.getKeyIdentity(request,
					com.qding.common.util.http.cookie.CookieUtil.USER_ID));
			article.setCreateBy(uid);
			article.setUpdateBy(uid);

			article.setId(null);

			articleService.insert(article);

			model.addAttribute("code", 0);
		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("add article error ");
			model.addAttribute("code", -100000);
		}

		return "/common/success";
	}

	/**
	 * 删除内容
	 * @param request
	 * @param response
	 * @param model
	 * @param aid
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/{aid}", method = RequestMethod.DELETE)
	public String deleteArticleJson(HttpServletRequest request,
										HttpServletResponse response, ModelMap model, @PathVariable Long aid)
			throws Exception {

		log.info("delete article : id= " + aid);
		try {
			articleService.delete(aid);

			log.info("add article success");
			model.addAttribute("code", 0);

		} catch (Throwable t) {
			t.printStackTrace();
			log.error(t.getMessage());
			log.error("delete article error,id is  " + aid);
			model.addAttribute("code", -100000);

		}

		return "/common/success";
	}

	/**
	 * 批量获取文章详细信息
	 * @param request
	 * @param response
	 * @param model
	 * @param ids
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/multi/article", method = RequestMethod.GET)
	public String getMultiArticleJson(HttpServletRequest request,
										  HttpServletResponse response, ModelMap model, Long[] ids)
			throws Exception {

		List<Long> idList = new ArrayList();
		if (ids == null|| ids.length<=0) {

			model.addAttribute("code",0);
			model.addAttribute("size", 10);
			model.addAttribute("total",0);


		} else {
			idList = Arrays.asList(ids);
		}
		try {
			if(idList == null || idList.size()<=0){
				model.addAttribute("code",0);
				model.addAttribute("size", 0);
				model.addAttribute("total",0);
			}else {


				List<Article> articleList = articleService.getObjectsByIds(idList);
				log.info("get  article data is " + articleList);

				if (articleList != null && articleList.size() <= 0) {
					model.addAttribute("code", 0);
					model.addAttribute("size", 10);
					model.addAttribute("total", 0);

					model.addAttribute("articleList", articleList);
				} else {

					model.addAttribute("code", 0);
					model.addAttribute("size", 10);
					model.addAttribute("total", articleList.size());

					model.addAttribute("articleList", articleList);
				}
			}
		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get article error,id is  " + idList);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleMultiJson";
	}

	/**
	 * 条件查询内容
	 * @param request
	 * @param response
	 * @param model
	 * @param page
	 * @param size
	 * @param startAt
	 * @param endAt
	 * @param type
	 * @param createBy
	 * @param status
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "/a/u/article/", method = RequestMethod.GET)
	public String getArticleJsonList(HttpServletRequest request,
									 HttpServletResponse response, ModelMap model, Integer page, Integer size,
									 Long startAt,Long endAt,String type,String source,String createBy,String status)
			throws Exception {
		log.info("/web/a/article/list ,page is:"+page+",size is"+size+",startAt is"+startAt+",endAt is"+endAt+", type is " +
				""+type+" , source is "+source+" createBy is " +
				createBy+" status is "+status);
		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}

		try {
			Boolean next = false;
			size+=1;

			List<Long>  ids = new ArrayList<Long>();

			if(startAt == null && endAt == null && type == null && source == null && createBy == null && status == null){

				 ids =  articleService.getArticleIds(start, size);
			}else {
				Map<String, Object> param = DynamicUtil.getSolutionListParam(startAt, endAt, type, createBy, source, status, false);
				log.info("        param is    " + param);
				Map<String, Object> countparam = DynamicUtil.getSolutionListParam(startAt, endAt, type, createBy, source, status, true);
				log.info("pageList : page= " + start + " , size=" + size);
				 ids = articleService.getIdsByDynamicCondition(Article.class, param, start, size);


			}


			if(ids!=null && ids.size()>0){

				if (size.equals(ids.size())) {
					next = true;
					log.info("ss  "+ids.subList(0,size-1));
					model.addAttribute("ids", ids.subList(0,size-1));
				}else{
					log.info("ss  "+ids.subList(0,ids.size()));
					model.addAttribute("ids", ids.subList(0, ids.size()));
				}
			}else{
				model.addAttribute("ids", ids);
			}

			model.addAttribute("code",0);
			model.addAttribute("size", size-1);
			model.addAttribute("page", page);
           model.addAttribute("next",next);


		} catch (Throwable t) {
			log.error(t.getMessage());
			log.error("get articleList error,qfrom is"+startAt+",qto is"+endAt+", type is " +
					""+type+" , source is "+source+" createBy is " +
					createBy+" status is "+status);
			model.addAttribute("code", -100000);
		}

		return "/common-carjn-service/article/json/articleListJson";
	}
//	// 图片上传
//	@RequestMapping(value = "/a/u/img/{module}", method = RequestMethod.POST)
//	public String uploadFile(HttpServletRequest request,
//							 HttpServletResponse response, ModelMap model,
//							 @RequestParam MultipartFile file, @PathVariable String module)
//			throws Exception {
//		log.info("hello upload " + module);
//		if (StringUtils.isBlank(module)) {
//			log.info("type is null");
//		}
//		int code = 0;
//		log.info(file.getOriginalFilename());
//
//		Long uid = cookieUtil.getID(request, response);
//		try {
//
//			String extend = FileUtil.getFileExtension(file.getOriginalFilename());
//
//			String fileName = UUID.randomUUID().toString() + "." + extend;
//			log.info("new name is " + fileName);
////			String filePath = "/temp/" + fileName;
//			String filePath = "/data/img/"+module + "/" + fileName;
//			String dirPath = "/data/img/"+module;
//
//			File dir = new File("/data/img/"+module);
//			if (dir.exists()) {
//				log.info("创建目录" + dirPath + "失败，目标目录已经存在");
//			}else {
//				//创建目录
//				if (dir.mkdirs()) {
//					log.info("创建目录" + dirPath + "成功！");
//				} else {
//					log.info("创建目录" + dirPath + "失败！");
//				}
//			}
//
//			File tempPic = new File(filePath);
//			file.transferTo(tempPic);
//			String url = this.imgStorageUtil.imgStorage(null, module + "/"
//					+ fileName, filePath);
//			log.info(module + " upload success ,and file name is " + fileName
//					+ "temp path is " + filePath + " access url is " + url);
////			tempPic.delete();
////			log.info(file.getOriginalFilename() + " delete success ");
//			model.addAttribute("url", url);
//			model.addAttribute("code", 0);
//
//			return "/common/img";
//		} catch (Throwable t) {
//			t.printStackTrace();
//			log.error(t.getMessage());
//			model.addAttribute("code",-100000);
//		}
//
//		return "/common/success";
//	}

	/**
	 * 根据type查找已发布内容
	 * @param page
	 * @param size
	 * @param type
	 * @return
	 * @throws Exception
	 */
	public List<Article> getArticleListByType(Integer page,Integer size,Integer type) throws  Exception{

		if (page == null) {
			page = 1;
		}
		if (size == null) {
			size = 10;
		}
		int start = (page - 1) * size;
		if (start < 0) {
			start = 0;
		}
		List<Long> ids= articleService.getArticleIdsByTypeAndStatusOrderByPublishat(type, Article.Status_Published, start, size);
		log.info("get countArticleIdsByTypeAndStatusOrderByPublishat size is " + ids);


		List<Article> articleList = articleService.getObjectsByIds(ids);
		log.info("get article data is " + articleList);




		return  articleList;
	}
}

