/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.RecommendStatistics;
import com.ptteng.academy.user.model.UesrCourseRelation;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOrder;
import com.ptteng.academy.user.model.UserRecommend;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.RecommendStatisticsService;
import com.ptteng.academy.user.service.UesrCourseRelationService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOrderService;
import com.ptteng.academy.user.service.UserRecommendService;
import com.ptteng.academy.user.service.UserService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.qding.common.util.DataUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class UserOrderServiceImpl
extends BaseDaoServiceImpl
implements UserOrderService {
    private static final Log log = LogFactory.getLog((String)"userOrderImpl");
    @Autowired
    UserService userService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    private UesrCourseRelationService uesrCourseRelationService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private RecommendStatisticsService recommendStatisticsService;

    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + userOrder));
        if (userOrder == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
        userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(Long.valueOf(currentTimeMillis));
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (userOrder == null ? "null" : userOrder.getId())));
        boolean result = false;
        if (userOrder == null) {
            return true;
        }
        userOrder.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)userOrder);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + userOrder));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + userOrder));
        }
        return result;
    }

    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (userOrderList == null ? "null" : Integer.valueOf(userOrderList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(userOrderList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + userOrderList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + userOrderList.size()));
        return result;
    }

    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        UserOrder userOrder = null;
        if (id == null) {
            return userOrder;
        }
        try {
            userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return userOrder;
    }

    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List userOrder = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }
        try {
            userOrder = this.dao.getList(UserOrder.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (userOrder == null ? "null" : Integer.valueOf(userOrder.size()))));
        return userOrder;
    }

    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by order_id  : " + orderId));
        }
        UserOrder userOrder = null;
        if (orderId == null) {
            return userOrder;
        }
        try {
            Long id = (Long)this.dao.getMapping("getIdByOrderId", new Object[]{orderId});
            log.info((Object)("the id =" + id));
            if (id != null) {
                userOrder = (UserOrder)this.dao.get(UserOrder.class, (Serializable)id);
            }
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by orderId  : " + orderId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + orderId));
        }
        return userOrder;
    }

    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
        }
        Long id = null;
        try {
            id = (Long)this.dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id success : " + id));
        }
        return id;
    }

    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
        }
        List ids = null;
        try {
            ids = this.dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + ids));
        }
        return ids;
    }

    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit));
        }
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid,buyType  : " + uid + " , " + buyType));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info((Object)(" count ids by uid  : " + uid));
        }
        Integer count = null;
        try {
            count = this.dao.count("getUserOrderIdsByUid", new Object[]{uid});
        }
        catch (DaoException e) {
            log.error((Object)(" count ids  wrong by uid)  : " + uid));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  success : " + count));
        }
        return count;
    }

    public List<Long> getUserOrderIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getUserOrderIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countUserOrderIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getUserOrderIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getUserOrderIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }

    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        try {
            log.info((Object)("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner));
            UserOrder order = this.getOrderObjectByOrderId(indentCode);
            log.info((Object)("get order : " + order.toString()));
            if (!Integer.valueOf(1).equals(order.getStatus())) {
                log.info((Object)" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = this.userService.getObjectById(uid);
            block1 : switch (respCode) {
                case 1: {
                    status = 3;
                    log.info((Object)("lesson order : " + order.getId() + " completed "));
                    switch (order.getBuyType()) {
                        case 1: {
                            log.info((Object)"==========\u89e3\u9501\u4e13\u9898\u903b\u8f91==========");
                            log.info((Object)("order target id is " + order.getTargetId()));
                            Long relationId = this.uesrCourseRelationService.getUesrCourseRelationIdByUidAndTypeAndTargetId(uid, Long.valueOf(1L), order.getTargetId());
                            if (DataUtils.isNotNullOrEmpty((Object)relationId)) {
                                UesrCourseRelation hasBoughtRelation = this.uesrCourseRelationService.getObjectById(relationId);
                                hasBoughtRelation.setCreateAt(Long.valueOf(System.currentTimeMillis()));
                                this.uesrCourseRelationService.update(hasBoughtRelation);
                                break block1;
                            }
                            UesrCourseRelation uesrCourseRelation = new UesrCourseRelation();
                            uesrCourseRelation.setUid(uid);
                            uesrCourseRelation.setType(Long.valueOf(order.getBuyType().intValue()));
                            uesrCourseRelation.setTargetId(order.getTargetId());
                            this.uesrCourseRelationService.insert(uesrCourseRelation);
                            break block1;
                        }
                        case 6: {
                            log.info((Object)"==========\u8d2d\u4e70\u4f1a\u5458\u903b\u8f91========== pay noticeBack ,type is member");
                            Member member = this.memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;
                            List userMemberRelationIds = this.userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            if (CollectionUtils.isEmpty((Collection)userMemberRelationIds)) {
                                log.info((Object)(" user " + uid + " is not a member "));
                                log.info((Object)"==========\u5f00\u4f1a\u5458\u903b\u8f91==========");
                                startAt = now;
                            } else {
                                List userMemberRelations = this.userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    log.info((Object)(" user member endAt is " + UserOrderServiceImpl.getDate(userMemberRelation.getEndAt()) + " now is " + UserOrderServiceImpl.getDate(now)));
                                    if (userMemberRelation.getEndAt() >= endAt) {
                                        log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt));
                                        endAt = (long)userMemberRelation.getEndAt();
                                        continue;
                                    }
                                    log.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt));
                                }
                                log.info((Object)("final end at member time is : " + endAt));
                                startAt = endAt;
                            }
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(Integer.valueOf(1));
                            userMemberRelation.setStartAt(startAt);
                            Date startDate = new Date(startAt);
                            Date endDateByActualMonth = DateUtils.addMonths((Date)startDate, (int)member.getPeriod().intValue());
                            log.info((Object)("userId is " + user.getId() + "period is " + member.getPeriod()));
                            log.info((Object)("===== startAt " + startAt));
                            endAt = startAt + 2678400000L * (long)member.getPeriod().intValue();
                            log.info((Object)("endAt =====" + endAt));
                            userMemberRelation.setEndAt(endAt);
                            log.info((Object)(" user " + uid + " member startAt = " + UserOrderServiceImpl.getDate(now) + " usedToBeEndAt = " + endDateByActualMonth));
                            log.info((Object)(" user " + uid + " member startAt = " + UserOrderServiceImpl.getDate(now) + " endAtBy31 = " + UserOrderServiceImpl.getDate(endAt)));
                            Long userMemberRelationId = this.userMemberRelationService.insert(userMemberRelation);
                            log.info((Object)(" user " + uid + " member id is = " + userMemberRelationId));
                            break block1;
                        }
                    }
                    break;
                }
                case 2: {
                    status = 2;
                    log.info((Object)("lesson order : " + order.getId() + " close "));
                    break;
                }
            }
            if (1 == respCode) {
                log.info((Object)"==========\u652f\u4ed8\u6210\u529f\uff0c\u8bb0\u5f55\u63a8\u5e7f\u7edf\u8ba1\u4fe1\u606f==========");
                Long recommendBy = user.getRecommendId();
                log.info((Object)("user recommend is = " + recommendBy));
                if ("ios".equals(user.getPlatform())) {
                    BigDecimal iosAmount = user.getIosAmount();
                    user.setIosAmount(iosAmount.add(order.getPrice()));
                    log.info((Object)("user ios amount " + iosAmount + " >>>>>>>>>> " + user.getIosAmount()));
                } else {
                    BigDecimal androidAmount = user.getAndroidAmount();
                    user.setAndroidAmount(androidAmount.add(order.getPrice()));
                    log.info((Object)("user ios amount " + androidAmount + " >>>>>>>>>> " + user.getAndroidAmount()));
                }
                if (User.NO_SPEND.equals(user.getSpendStatus())) {
                    user.setSpendStatus(User.SPEND);
                    this.userService.update(user);
                    log.info((Object)"user spend status update ");
                    if (null != recommendBy) {
                        UserRecommend uRcmd = this.userRecommendService.getUserRecommendByUserId(recommendBy);
                        if (DataUtils.isNotNullOrEmpty((Object)uRcmd)) {
                            log.info((Object)("user recommend info " + uRcmd.getId()));
                        } else {
                            UserRecommend userRecommend = new UserRecommend();
                            userRecommend.setUserId(recommendBy);
                            userRecommend.setSpendNum(Integer.valueOf(1));
                            Long insert = this.userRecommendService.insert(userRecommend);
                            log.info((Object)("insert userRecommend success and id is " + insert));
                        }
                    }
                }
                this.updateRecommendStatistics(recommendBy, order, user);
            } else {
                log.info((Object)"==========\u652f\u4ed8\u5931\u8d25\uff0c\u4e0d\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f==========");
            }
            order.setStatus(status);
            order.setPayType(Integer.valueOf(payManner));
            order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            order.setPayAt(Long.valueOf(System.currentTimeMillis()));
            this.update(order);
            log.info((Object)"update order over");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)e.getStackTrace());
            e.printStackTrace(System.out);
            log.error((Object)"error : ", (Throwable)e);
        }
    }

    public void updateRecommendStatistics(Long recommendId, UserOrder order, User user) throws ServiceException, ServiceDaoException {
        if (DataUtils.isNullOrEmpty((Object)recommendId)) {
            return;
        }
        log.info((Object)" add recommend statistics ");
        RecommendStatistics recommendStatistics = null;
        Long todayZero = MyTimeUtil.getTodayZeroTimeMillions();
        log.info((Object)(" today is = " + UserOrderServiceImpl.getDate(todayZero)));
        List recommendStatisticsIds = this.recommendStatisticsService.getIdsByUserId(recommendId, Integer.valueOf(0), Integer.valueOf(1));
        log.info((Object)(" recommendStatisticsIds size = " + recommendStatisticsIds.size()));
        if (recommendStatisticsIds.size() > 0) {
            recommendStatistics = this.recommendStatisticsService.getObjectById((Long)recommendStatisticsIds.get(0));
            if (todayZero.equals(recommendStatistics.getStaticAt())) {
                log.info((Object)" add 1 ");
                recommendStatistics.setAmount(recommendStatistics.getAmount().add(order.getPrice()));
                this.recommendStatisticsService.update(recommendStatistics);
            } else {
                log.info((Object)" new  recommendStatistics  ");
                recommendStatistics = new RecommendStatistics();
                recommendStatistics.setStaticAt(todayZero);
                recommendStatistics.setUid(recommendId);
                recommendStatistics.setAmount(order.getPrice());
                this.recommendStatisticsService.insert(recommendStatistics);
            }
        } else {
            log.info((Object)" new  recommendStatistics  ");
            recommendStatistics = new RecommendStatistics();
            recommendStatistics.setStaticAt(todayZero);
            recommendStatistics.setUid(recommendId);
            recommendStatistics.setAmount(order.getPrice());
            this.recommendStatisticsService.insert(recommendStatistics);
        }
        UserRecommend usRcmRecord = this.userRecommendService.getUserRecommendByUserId(recommendId);
        if (DataUtils.isNullOrEmpty((Object)usRcmRecord)) {
            UserRecommend newRecommend = new UserRecommend();
            newRecommend.setUserId(recommendId);
            newRecommend.setSpendNum(Integer.valueOf(1));
            Long insert = this.userRecommendService.insert(newRecommend);
            usRcmRecord = this.userRecommendService.getObjectById(insert);
            log.info((Object)("user recommend info not exist , inserted data : " + usRcmRecord));
            Integer spendNumRecord = usRcmRecord.getSpendNum();
            this.userRecommendService.update(usRcmRecord);
            log.info((Object)("user : " + recommendId + " spendNum history is " + spendNumRecord + " >>>>>>>>>> " + usRcmRecord.getSpendNum()));
        } else {
            log.info((Object)("user recommend info : " + usRcmRecord));
            Integer newSpendNum = 0;
            if (User.NO_SPEND.equals(user.getSpendStatus())) {
                user.setSpendStatus(User.SPEND);
                this.userService.update(user);
                log.info((Object)"user spend status update ");
                newSpendNum = 1;
            }
            usRcmRecord.setSpendNum(Integer.valueOf(usRcmRecord.getSpendNum() + newSpendNum));
            boolean updateFlag = this.userRecommendService.update(usRcmRecord);
            log.info((Object)("update usRcmRecord success and id is " + usRcmRecord.getId() + " userId is" + recommendId));
        }
        if ("ios".equals(user.getPlatform())) {
            BigDecimal IosAmount = usRcmRecord.getIosAmount();
            usRcmRecord.setIosAmount(IosAmount.add(order.getPrice()));
            log.info((Object)("user ios amount " + IosAmount + " >>>>>>>>>> " + usRcmRecord.getIosAmount()));
        } else {
            BigDecimal AndroidAmount = usRcmRecord.getAndroidAmount();
            usRcmRecord.setAndroidAmount(AndroidAmount.add(order.getPrice()));
            log.info((Object)("user ios amount " + AndroidAmount + " >>>>>>>>>> " + usRcmRecord.getAndroidAmount()));
        }
        this.userRecommendService.update(usRcmRecord);
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }
}

