/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.google.gson.Gson;
import com.ptteng.academy.user.model.Member;
import com.ptteng.academy.user.model.UesrCourseRelation;
import com.ptteng.academy.user.model.User;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.model.UserOrder;
import com.ptteng.academy.user.service.MemberService;
import com.ptteng.academy.user.service.UesrCourseRelationService;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.academy.user.service.UserOrderService;
import com.ptteng.academy.user.service.UserService;
import com.qding.common.pay.model.IndentInfo;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.common.util.DataUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osoa.sca.annotations.Service;
import org.springframework.beans.factory.annotation.Autowired;

@Service(value=IndentInfoService.class)
public class IndentInfoServiceImpl
implements IndentInfoService {
    @Resource(name="userService")
    private UserService userService;
    @Resource(name="memberService")
    private MemberService memberService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Resource(name="userOrderService")
    private UserOrderService userOrderService;
    @Autowired
    private UesrCourseRelationService uesrCourseRelationService;
    private Log indentLog = LogFactory.getLog((String)"indent");
    @Autowired
    private Dao dao;

    public String getIndentByIndentCode(String IndentCode) throws ServiceException, ServiceDaoException {
        IndentInfo indentInfo = new IndentInfo();
        this.indentLog.info((Object)("========++++++++++" + IndentCode));
        try {
            UserOrder order = this.userOrderService.getOrderObjectByOrderId(IndentCode);
            this.indentLog.info((Object)order);
            BigDecimal price = order.getPrice();
            this.indentLog.info((Object)("get order : " + order.toString()));
            indentInfo.setGoodsName("order_" + IndentCode);
            indentInfo.setCreateAt(order.getCreateAt());
            indentInfo.setTotalMoney(Double.valueOf(price.doubleValue()));
            indentInfo.setPayManner(order.getPayType());
            indentInfo.setStatus(order.getStatus().intValue());
            indentInfo.setPayAt(order.getPayAt());
            indentInfo.setUserId(order.getUid());
            this.indentLog.info((Object)indentInfo);
        }
        catch (Exception e) {
            this.indentLog.info((Object)("this is a error" + e));
            this.indentLog.error((Object)e.getStackTrace());
        }
        Gson gson = new Gson();
        String indentInfoJson = gson.toJson((Object)indentInfo);
        this.indentLog.info((Object)("indentInfoJson : " + indentInfoJson));
        return indentInfoJson;
    }

    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {
        try {
            this.indentLog.info((Object)("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner));
            UserOrder order = this.userOrderService.getOrderObjectByOrderId(indentCode);
            this.indentLog.info((Object)("get order : " + order.toString()));
            if (!Integer.valueOf(1).equals(order.getStatus())) {
                this.indentLog.info((Object)" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = this.userService.getObjectById(uid);
            block1 : switch (respCode) {
                case 1: {
                    status = 3;
                    this.indentLog.info((Object)("lesson order : " + order.getId() + " completed "));
                    switch (order.getBuyType()) {
                        case 1: {
                            this.indentLog.info((Object)"==========\u89e3\u9501\u4e13\u9898\u903b\u8f91==========");
                            this.indentLog.info((Object)("order target id is " + order.getTargetId()));
                            Long relationId = this.uesrCourseRelationService.getUesrCourseRelationIdByUidAndTypeAndTargetId(uid, Long.valueOf(1L), order.getTargetId());
                            if (DataUtils.isNotNullOrEmpty((Object)relationId)) {
                                UesrCourseRelation hasBoughtRelation = this.uesrCourseRelationService.getObjectById(relationId);
                                hasBoughtRelation.setCreateAt(Long.valueOf(System.currentTimeMillis()));
                                this.uesrCourseRelationService.update(hasBoughtRelation);
                                break block1;
                            }
                            this.indentLog.info((Object)("new userCourseRelation uid is: " + uid + " targetId is: " + targetId));
                            UesrCourseRelation uesrCourseRelation = new UesrCourseRelation();
                            uesrCourseRelation.setUid(uid);
                            uesrCourseRelation.setType(Long.valueOf(order.getBuyType().intValue()));
                            uesrCourseRelation.setTargetId(order.getTargetId());
                            this.uesrCourseRelationService.insert(uesrCourseRelation);
                            break block1;
                        }
                        case 6: {
                            this.indentLog.info((Object)"==========\u8d2d\u4e70\u4f1a\u5458\u903b\u8f91==========");
                            this.indentLog.info((Object)" pay noticeBack ,type is member ");
                            Member member = this.memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;
                            List userMemberRelationIds = this.userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(Integer.MAX_VALUE));
                            if (CollectionUtils.isEmpty((Collection)userMemberRelationIds)) {
                                this.indentLog.info((Object)(" user " + uid + " is not a member "));
                                this.indentLog.info((Object)"==========\u5f00\u4f1a\u5458\u903b\u8f91==========");
                                startAt = now;
                            } else {
                                List userMemberRelations = this.userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    this.indentLog.info((Object)(" user member endAt is " + IndentInfoServiceImpl.getDate(userMemberRelation.getEndAt()) + " now is " + IndentInfoServiceImpl.getDate(now)));
                                    if (userMemberRelation.getEndAt() >= endAt) {
                                        this.indentLog.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt));
                                        endAt = (long)userMemberRelation.getEndAt();
                                        continue;
                                    }
                                    this.indentLog.info((Object)(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt));
                                }
                                this.indentLog.info((Object)("final end at member time is : " + endAt));
                                startAt = endAt;
                            }
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(Integer.valueOf(1));
                            userMemberRelation.setStartAt(startAt);
                            Date startDate = new Date(startAt);
                            Date endDate = DateUtils.addMonths((Date)startDate, (int)member.getPeriod().intValue());
                            endAt = endDate.getTime();
                            userMemberRelation.setEndAt(endAt);
                            this.indentLog.info((Object)(" user " + uid + " member startAt = " + IndentInfoServiceImpl.getDate(now) + " endAt = " + IndentInfoServiceImpl.getDate(endAt)));
                            Long userMemberRelationId = this.userMemberRelationService.insert(userMemberRelation);
                            this.indentLog.info((Object)(" user " + uid + " member id is = " + userMemberRelationId));
                            break block1;
                        }
                    }
                    break;
                }
                case 2: {
                    status = 2;
                    this.indentLog.info((Object)("lesson order : " + order.getId() + " close "));
                }
            }
            if (1 == respCode) {
                this.indentLog.info((Object)"==========\u652f\u4ed8\u6210\u529f\uff0c\u8bb0\u5f55\u63a8\u5e7f\u7edf\u8ba1\u4fe1\u606f==========");
            } else {
                this.indentLog.info((Object)"==========\u652f\u4ed8\u5931\u8d25\uff0c\u4e0d\u8bb0\u5f55\u7edf\u8ba1\u4fe1\u606f==========");
            }
            order.setStatus(status);
            order.setPayType(Integer.valueOf(payManner));
            order.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
            order.setPayAt(Long.valueOf(System.currentTimeMillis()));
            this.userOrderService.update(order);
            this.indentLog.info((Object)"update order over");
        }
        catch (Exception e) {
            this.indentLog.error((Object)e.getMessage());
            this.indentLog.error((Object)e.getStackTrace());
            e.printStackTrace(System.out);
            this.indentLog.error((Object)"error : ", (Throwable)e);
        }
    }

    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";
        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }

    public Boolean setPayAt(String orderId, Long payAt) {
        return false;
    }

    public static void main(String[] args) {
        long a = System.currentTimeMillis();
        System.out.println(a);
        long aa = a + 5184000000L;
        System.out.println(" aa = " + aa);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        System.out.print(" bb = " + format.format(new Date(aa)));
    }
}

