package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.common.util.MyTimeUtil;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.*;
import com.ptteng.academy.user.service.*;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


public class UserOrderServiceImpl extends BaseDaoServiceImpl implements UserOrderService {


    private static final Log log = LogFactory.getLog("userOrderImpl");

    @Autowired
    UserService userService;
    @Autowired
    MemberService memberService;
    @Autowired
    UserMemberRelationService userMemberRelationService;
    @Autowired
    private UesrCourseRelationService uesrCourseRelationService;
    @Autowired
    private UserRecommendService userRecommendService;
    @Autowired
    private RecommendStatisticsService recommendStatisticsService;


    @Override
    public Long insert(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" insert data : " + userOrder);

        if (userOrder == null) {
            return null;
        }

        long currentTimeMillis = System.currentTimeMillis();
        userOrder.setCreateAt(currentTimeMillis);
        userOrder.setUpdateAt(currentTimeMillis);

        Long result = null;
        try {
            result = (Long) dao.save(userOrder);
        } catch (DaoException e) {
            log.error(" insert wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert data success : " + result);

        return result;
    }


    @Override
    public List<UserOrder> insertList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" insert lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        List<UserOrder> resultList = null;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return new ArrayList<UserOrder>();
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setCreateAt(currentTimeMillis);
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            resultList = (List<UserOrder>) dao.batchSave(userOrderList);
        } catch (DaoException e) {
            log.error(" insert list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

        return resultList;


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {


        log.info(" delete data : " + id);

        boolean result = false;

        if (id == null) {
            return true;
        }

        try {
            result = dao.delete(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" delete wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" delete data success : " + id);

        return result;

    }


    @Override
    public boolean update(UserOrder userOrder) throws ServiceException, ServiceDaoException {


        log.info(" update data : " + (userOrder == null ? "null" : userOrder.getId()));

        boolean result = false;

        if (userOrder == null) {
            return true;
        }

        userOrder.setUpdateAt(System.currentTimeMillis());

        try {
            result = dao.update(userOrder);
        } catch (DaoException e) {
            log.error(" update wrong : " + userOrder);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" update data success : " + userOrder);
        }
        return result;
    }


    @Override
    public boolean updateList(List<UserOrder> userOrderList) throws ServiceException, ServiceDaoException {


        log.info(" update lists : " + (userOrderList == null ? "null" : userOrderList.size()));

        boolean result = false;

        if (CollectionUtils.isEmpty(userOrderList)) {
            return true;
        }

        long currentTimeMillis = System.currentTimeMillis();
        for (UserOrder userOrder : userOrderList) {
            userOrder.setUpdateAt(currentTimeMillis);
        }

        try {
            result = dao.batchUpdate(userOrderList);
        } catch (DaoException e) {
            log.error(" update list wrong : " + userOrderList);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" update lists success : " + userOrderList.size());

        return result;
    }


    @Override
    public UserOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {


        log.info(" get data : " + id);

        UserOrder userOrder = null;

        if (id == null) {
            return userOrder;
        }

        try {
            userOrder = (UserOrder) dao.get(UserOrder.class, id);
        } catch (DaoException e) {
            log.error(" get wrong : " + id);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + id);

        return userOrder;
    }


    @Override
    public List<UserOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {


        log.info(" get lists : " + (ids == null ? "null" : ids));

        List<UserOrder> userOrder = null;

        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<UserOrder>();
        }

        try {
            userOrder = (List<UserOrder>) dao.getList(UserOrder.class, ids);
        } catch (DaoException e) {
            log.error(" get wrong : " + ids);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }

        log.info(" get data success : " + (userOrder == null ? "null" : userOrder.size()));

        return userOrder;
    }

    @Override
    public UserOrder getOrderObjectByOrderId(String orderId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by order_id  : " + orderId);
        }
//        Long id = null;
        UserOrder userOrder = null;
        //Controller中代码已经做了空值判断,这里不需要再判断.
        if (orderId == null) {
            return userOrder;
        }

        // TODO 参数检查!

        try {

            Long id = (Long) dao.getMapping("getIdByOrderId", new Object[]{orderId});
            log.info("the id =" + id);
            if (id != null) {
                userOrder = (UserOrder) dao.get(UserOrder.class, id);
            }
        } catch (DaoException e) {
            log.error(" get id wrong by orderId  : " + orderId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + orderId);
        }
        return userOrder;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUidAndBuyType(Long uid, Integer buyType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,buyType,start,limit  : " + uid + " , " + buyType + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,buyType,start,limit)  : " + uid + " , " + buyType + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public Long getUserOrderIdsByUidAndBuyTypeAndTargetId(Long uid, Integer buyType, Long targetId) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
        }
        Long id = null;

        // TODO 参数检查!

        try {

            id = (Long) dao.getMapping("getUserOrderIdsByUidAndBuyTypeAndTargetId", new Object[]{uid, buyType, targetId});
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,targetId : " + uid + " , " + buyType + " , " + targetId);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get id success : " + id);
        }
        return id;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndBuyTypeAndStatus(Long uid, Integer buyType, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get id by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
        }
        List<Long> ids = null;

        // TODO 参数检查!

        try {

            ids = dao.getIdList("getUserOrderIdsByUidAndBuyTypeAndStatus", new Object[]{uid, buyType, status}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get id wrong by uid,buyType,status : " + uid + " , " + buyType + " , " + status);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + ids);
        }
        return ids;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;


    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatus(Long uid, Integer status, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status,start,limit  : " + uid + " , " + status + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatus", new Object[]{uid, status}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,start,limit)  : " + uid + " , " + status + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getUserOrderIdsByUidAndStatusAndOs(Long uid, Integer status, Integer os, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid, status, os, start, limit  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsByUidAndStatusAndOs", new Object[]{uid, status, os}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,status,os,start,limit)  : " + uid + " , " + status + " , " + os + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }

    @Override
    public List<Long> getPaperUserOrderIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        if (log.isInfoEnabled()) {
            log.info(" get ids by uid,start,limit  : " + uid + " , " + start + " , " + limit);
        }
        List<Long> idList = null;

        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getPaperUserOrderIdsByUid", new Object[]{uid}, start, limit, false);


        } catch (DaoException e) {
            log.error(" get ids  wrong by uid,start,limit)  : " + uid + " , " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUidAndBuyType(Long uid, Integer buyType) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid,buyType  : " + uid + " , " + buyType);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUidAndBuyType", new Object[]{uid, buyType});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid,buyType)  : " + uid + " , " + buyType);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countUserOrderIdsByUid(Long uid) throws ServiceException, ServiceDaoException {

        if (log.isInfoEnabled()) {
            log.info(" count ids by uid  : " + uid);
        }
        Integer count = null;


        try {

            count = dao.count("getUserOrderIdsByUid", new Object[]{uid});


        } catch (DaoException e) {
            log.error(" count ids  wrong by uid)  : " + uid);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  success : " + count);
        }
        return count;


    }


    @Override
    public List<Long> getUserOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
        List<Long> idList = null;


        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

        try {
            idList = dao.getIdList("getUserOrderIdsAll", new Object[]{}, start, limit, false);
        } catch (DaoException e) {
            log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
        }
        return idList;
    }


    @Override
    public Integer countUserOrderIds() throws ServiceException,
            ServiceDaoException {
        Integer count = 0;
        try {
            count = dao.count("getUserOrderIdsAll", new Object[]{});
        } catch (DaoException e) {
            log.error(" count by getUserOrderIds ");
            log.error(e);
            e.printStackTrace();
            throw new ServiceDaoException(e);
        }
        if (log.isInfoEnabled()) {
            log.info(" count  : " + count);
        }
        return count;
    }


    //在发送课程资料的时候，将课程所有的课时（包括上下架）资料全部发送
    //已经下架的课时，可以发送资料
    @Override
    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {


        try {
            log.info("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : " + payManner);
            UserOrder order = getOrderObjectByOrderId(indentCode);
            log.info("get order : " + order.toString());
            if (!Integer.valueOf(UserOrder.WAITFORPAY).equals(order.getStatus())) {
                log.info(" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = userService.getObjectById(uid);

            switch (respCode) {
                case UserOrder.PAY_SUCCESS:         //支付成功
                    status = UserOrder.COMPLETED;  //订单状态设为完成
                    log.info("lesson order : " + order.getId() + " completed ");

                    switch (order.getBuyType()) {
                        case UserOrder.ORDER_LESSON: {

                            log.info("==========解锁专题逻辑==========");
                            log.info("order target id is " + order.getTargetId());
                            Long relationId = uesrCourseRelationService.getUesrCourseRelationIdByUidAndTypeAndTargetId(uid, 1L, order.getTargetId());
                            if (DataUtils.isNotNullOrEmpty(relationId)) {

                                UesrCourseRelation hasBoughtRelation = uesrCourseRelationService.getObjectById(relationId);
                                hasBoughtRelation.setCreateAt(System.currentTimeMillis());
                                uesrCourseRelationService.update(hasBoughtRelation);
                            } else {

                                UesrCourseRelation uesrCourseRelation = new UesrCourseRelation();
                                uesrCourseRelation.setUid(uid);
                                uesrCourseRelation.setType((long) order.getBuyType());
                                uesrCourseRelation.setTargetId(order.getTargetId());
                                uesrCourseRelationService.insert(uesrCourseRelation);
                            }

                            break;
                        }


                        case UserOrder.ORDER_MEMBER: {

                            log.info("==========购买会员逻辑========== pay noticeBack ,type is member");
                            Member member = memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;

                            //判断是开会员还是续费会员
                            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, Integer.MAX_VALUE);
                            if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                                log.info(" user " + uid + " is not a member ");
                                log.info("==========开会员逻辑==========");
                                startAt = now;

                            } else {
                                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    log.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                                        endAt = userMemberRelation.getEndAt().longValue();
                                    } else {
                                        log.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                                    }
                                }
                                log.info("final end at member time is : " + endAt);
                                startAt = endAt;
                            }

                            //给用户添加会员记录
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(User.IS_MEMBER);
                            userMemberRelation.setStartAt(startAt);

                            Date startDate = new Date(startAt);
                            Date endDateByActualMonth = DateUtils.addMonths(startDate, member.getPeriod().intValue());

                            // bug 4940 给用户开通会员 每月天数都按31天计算
                            log.info("userId is " + user.getId() + "period is " + member.getPeriod());
                            log.info("===== startAt " + startAt);
                            endAt = startAt + 86400000L * 31 * member.getPeriod().intValue();
                            log.info("endAt =====" + endAt);
                            userMemberRelation.setEndAt(endAt);

                            log.info(" user " + uid + " member startAt = " + getDate(now) + " usedToBeEndAt = " + endDateByActualMonth);
                            log.info(" user " + uid + " member startAt = " + getDate(now) + " endAtBy31 = " + getDate(endAt));

                            Long userMemberRelationId = userMemberRelationService.insert(userMemberRelation);
                            log.info(" user " + uid + " member id is = " + userMemberRelationId);

                            break;
                        }

                    }
                    break;

                case UserOrder.PAY_FAIL:         //支付失败
                    status = UserOrder.CLOSED; //订单状态设为关闭
                    log.info("lesson order : " + order.getId() + " close ");

                    break;
                default:
            }

            if (UserOrder.PAY_SUCCESS == respCode) {
                log.info("==========支付成功，记录推广统计信息==========");
                Long recommendBy = user.getRecommendId();
                log.info("user recommend is = " + recommendBy);

                // 记录该用户在不同os下的消费
                if ("ios".equals(user.getPlatform())) {
                    BigDecimal iosAmount = user.getIosAmount();
                    user.setIosAmount(iosAmount.add(order.getPrice()));
                    log.info("user ios amount " + iosAmount + " >>>>>>>>>> " + user.getIosAmount());
                } else {
                    BigDecimal androidAmount = user.getAndroidAmount();
                    user.setAndroidAmount(androidAmount.add(order.getPrice()));
                    log.info("user ios amount " + androidAmount + " >>>>>>>>>> " + user.getAndroidAmount());
                }
                if (User.NO_SPEND.equals(user.getSpendStatus())) {
                    user.setSpendStatus(User.SPEND);
                    userService.update(user);
                    log.info("user spend status update ");
                    if (null != recommendBy) {

                        UserRecommend uRcmd = userRecommendService.getUserRecommendByUserId(recommendBy);

                        if (DataUtils.isNotNullOrEmpty(uRcmd)) {
                            log.info("user recommend info " + uRcmd.getId());
                        } else {
                            UserRecommend userRecommend = new UserRecommend();
                            userRecommend.setUserId(recommendBy);
                            userRecommend.setSpendNum(1);
                            Long insert = userRecommendService.insert(userRecommend);
                            log.info("insert userRecommend success and id is " + insert);

                        }
                    }
                }

                //记录推广人消费信息
                updateRecommendStatistics(recommendBy, order, user);


            } else {
                log.info("==========支付失败，不记录统计信息==========");
            }

            order.setStatus(status);
            order.setPayType(payManner);
            order.setUpdateAt(System.currentTimeMillis());
            order.setPayAt(System.currentTimeMillis());
            update(order);
            log.info("update order over");


        } catch (Exception e) {
            log.error(e.getMessage());
            log.error(e.getStackTrace());

            e.printStackTrace(System.out);
            log.error("error : ", e);
        }

    }


    public void updateRecommendStatistics(Long recommendId, UserOrder order, User user) throws ServiceException, ServiceDaoException {

        if (DataUtils.isNullOrEmpty(recommendId)) {
            return;
        }
        log.info(" add recommend statistics ");
        RecommendStatistics recommendStatistics = null;

        Long todayZero = MyTimeUtil.getTodayZeroTimeMillions();
        log.info(" today is = " + getDate(todayZero));
        List<Long> recommendStatisticsIds = recommendStatisticsService.getIdsByUserId(recommendId, 0, 1);
        log.info(" recommendStatisticsIds size = " + recommendStatisticsIds.size());

        if (recommendStatisticsIds.size() > 0) {
            recommendStatistics = recommendStatisticsService.getObjectById(recommendStatisticsIds.get(0));
            if (todayZero.equals(recommendStatistics.getStaticAt())) {
                log.info(" add 1 ");
                recommendStatistics.setAmount(recommendStatistics.getAmount().add(order.getPrice()));
                recommendStatisticsService.update(recommendStatistics);

            } else {
                log.info(" new  recommendStatistics  ");
                recommendStatistics = new RecommendStatistics();
                recommendStatistics.setStaticAt(todayZero);
                recommendStatistics.setUid(recommendId);
                recommendStatistics.setAmount(order.getPrice());
                recommendStatisticsService.insert(recommendStatistics);
            }

        } else {
            log.info(" new  recommendStatistics  ");
            recommendStatistics = new RecommendStatistics();
            recommendStatistics.setStaticAt(todayZero);
            recommendStatistics.setUid(recommendId);
            recommendStatistics.setAmount(order.getPrice());
            recommendStatisticsService.insert(recommendStatistics);
        }

        //修改用户推荐人推广消费记录
        UserRecommend usRcmRecord = userRecommendService.getUserRecommendByUserId(recommendId);
        if (DataUtils.isNullOrEmpty(usRcmRecord)) {
            //推荐用户是推广人有邀请码但是无userRecommend数据（可能是老版本数据，补充userRecommend数据）
            UserRecommend newRecommend = new UserRecommend();
            newRecommend.setUserId(recommendId);
            newRecommend.setSpendNum(1);
            Long insert = userRecommendService.insert(newRecommend);
            usRcmRecord = userRecommendService.getObjectById(insert);
            log.info("user recommend info not exist , inserted data : " + usRcmRecord);

            Integer spendNumRecord = usRcmRecord.getSpendNum();
            userRecommendService.update(usRcmRecord);
            log.info("user : " + recommendId + " spendNum history is " + spendNumRecord + " >>>>>>>>>> " + usRcmRecord.getSpendNum());
        } else {
            log.info("user recommend info : " + usRcmRecord);

            Integer newSpendNum = 0;
            // 更改 spendNum
            if (User.NO_SPEND.equals(user.getSpendStatus())) {
                user.setSpendStatus(User.SPEND);
                userService.update(user);
                log.info("user spend status update ");
                newSpendNum = 1;
            }

            usRcmRecord.setSpendNum(usRcmRecord.getSpendNum() + newSpendNum);
            boolean updateFlag = userRecommendService.update(usRcmRecord);
            log.info("update usRcmRecord success and id is " + usRcmRecord.getId() + " userId is" + recommendId);

        }

        if ("ios".equals(user.getPlatform())) {
            BigDecimal IosAmount = usRcmRecord.getIosAmount();
            usRcmRecord.setIosAmount(IosAmount.add(order.getPrice()));
            log.info("user ios amount " + IosAmount + " >>>>>>>>>> " + usRcmRecord.getIosAmount());
        } else {
            BigDecimal AndroidAmount = usRcmRecord.getAndroidAmount();
            usRcmRecord.setAndroidAmount(AndroidAmount.add(order.getPrice()));
            log.info("user ios amount " + AndroidAmount + " >>>>>>>>>> " + usRcmRecord.getAndroidAmount());
        }

        userRecommendService.update(usRcmRecord);

    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }


}

