package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.academy.user.model.UserMemberRelation;
import com.ptteng.academy.user.service.UserMemberRelationService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class UserMemberRelationServiceImpl extends BaseDaoServiceImpl implements UserMemberRelationService {

 

	private static final Log log = LogFactory.getLog(UserMemberRelationServiceImpl.class);



		   
		@Override
		public Long insert(UserMemberRelation userMemberRelation)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + userMemberRelation);

		if (userMemberRelation == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		userMemberRelation.setCreateAt(currentTimeMillis);
		userMemberRelation.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(userMemberRelation);
		} catch (DaoException e) {
			log.error(" insert wrong : " + userMemberRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<UserMemberRelation> insertList(List<UserMemberRelation> userMemberRelationList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (userMemberRelationList == null ? "null" : userMemberRelationList.size()));
      
		List<UserMemberRelation> resultList = null;

		if (CollectionUtils.isEmpty(userMemberRelationList)) {
			return new ArrayList<UserMemberRelation>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserMemberRelation userMemberRelation : userMemberRelationList) {
			userMemberRelation.setCreateAt(currentTimeMillis);
			userMemberRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<UserMemberRelation>) dao.batchSave(userMemberRelationList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + userMemberRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(UserMemberRelation.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(UserMemberRelation userMemberRelation)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (userMemberRelation == null ? "null" : userMemberRelation.getId()));

		boolean result = false;

		if (userMemberRelation == null) {
			return true;
		}

		userMemberRelation.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(userMemberRelation);
		} catch (DaoException e) {
			log.error(" update wrong : " + userMemberRelation);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + userMemberRelation);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<UserMemberRelation> userMemberRelationList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (userMemberRelationList == null ? "null" : userMemberRelationList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(userMemberRelationList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (UserMemberRelation userMemberRelation : userMemberRelationList) {
			userMemberRelation.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(userMemberRelationList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + userMemberRelationList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + userMemberRelationList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public UserMemberRelation getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		UserMemberRelation userMemberRelation = null;

		if (id == null) {
			return userMemberRelation;
		}

		try {
			userMemberRelation = (UserMemberRelation) dao.get(UserMemberRelation.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return userMemberRelation;		
		}	
		  
    	   
		@Override
		public List<UserMemberRelation> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<UserMemberRelation> userMemberRelation = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<UserMemberRelation>();
		}

		try {
			userMemberRelation = (List<UserMemberRelation>) dao.getList(UserMemberRelation.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (userMemberRelation == null ? "null" : userMemberRelation.size()));
    
		return userMemberRelation;	
		}



	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getUserMemberRelationIdsByUidAndStatus(Long uid,Integer status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by uid,status,start,limit  : " + uid+" , "+status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserMemberRelationIdsByUidAndStatus", new Object[] { uid,status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,status,start,limit)  : " + uid+" , "+status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}
	
		
	@Override
	public List<Long> getUserMemberRelationIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getUserMemberRelationIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countUserMemberRelationIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getUserMemberRelationIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getUserMemberRelationIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}


	@Override
	public List<Long> getUserMemberRelationIdsByUid(Long uid, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
		if(log.isInfoEnabled()){
			log.info(" get ids by uid,start,limit  : " + uid+" , "+start+" , "+limit );
		}
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getUserMemberRelationIdsByUid", new Object[] { uid},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by uid,start,limit  : " + uid+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}



}

