package com.ptteng.academy.user.service.impl;

/**
 * Created by ${zhangfan} on 2017/10/1.
 */

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.Dao;
import com.google.gson.Gson;
import com.ptteng.academy.user.model.*;
import com.ptteng.academy.user.service.*;
import com.qding.common.pay.model.IndentInfo;
import com.qding.common.pay.service.IndentInfoService;
import com.qding.common.util.DataUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osoa.sca.annotations.Service;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

//引入academy-user-core中model和service
//import org.oasisopen.sca.annotation.Service;

/**
 * Created by lhwarthas on 16/3/16.
 */
@Service(IndentInfoService.class)
//@Component("IndentInfoService")
public class IndentInfoServiceImpl implements IndentInfoService {


//    @Autowired
//    private OrderSkuService orderSkuService;
//
//    @Resource(name = "fundService")
//    private FundService fundService;
//
//    @Resource(name = "userScoreService")
//    private UserScoreService userScoreService;

    @Resource(name = "userService")
    private UserService userService;

    //代替修真院官网中的accountService
    @Resource(name = "memberService")
    private MemberService memberService;

    @Autowired
    UserMemberRelationService userMemberRelationService;

//
//    @Resource(name = "servertService")
//    private ServertService servertService;

//    @Resource(name = "goodsService")
//    private GoodsService goodsService;

    //代替OrderService
    @Resource(name = "userOrderService")
    private UserOrderService userOrderService;
    @Autowired
    private UesrCourseRelationService uesrCourseRelationService;

    private Log indentLog = LogFactory.getLog("indent");

    @Autowired
    private Dao dao;

    @Override
    public String getIndentByIndentCode(String IndentCode) throws ServiceException, ServiceDaoException {


        IndentInfo indentInfo = new IndentInfo();


        indentLog.info("========++++++++++" + IndentCode);
        try {
//            Order order = orderService.getObjectById(Long.parseLong(IndentCode));
            UserOrder order = userOrderService.getOrderObjectByOrderId(IndentCode);
            indentLog.info(order);
//            if (86400000 < System.currentTimeMillis() - order.getCreateAt()) {
//                return "100";//订单超时
//            }
            BigDecimal price = order.getPrice();
            indentLog.info("get order : " + order.toString());
            indentInfo.setGoodsName("order_" + IndentCode);
            indentInfo.setCreateAt(order.getCreateAt());
            indentInfo.setTotalMoney(price.doubleValue());
            indentInfo.setPayManner(order.getPayType());
            indentInfo.setStatus(order.getStatus());
            indentInfo.setPayAt(order.getPayAt());
            indentInfo.setUserId(order.getUid());
            indentLog.info(indentInfo);

        } catch (Exception e) {
            indentLog.info("this is a error" + e);
            indentLog.error(e.getStackTrace());
        }
        Gson gson = new Gson();
        String indentInfoJson = gson.toJson(indentInfo);
        indentLog.info("indentInfoJson : " + indentInfoJson);
        return indentInfoJson;
    }

    //
    @Override
    public void noticeBack(String indentCode, int respCode, int payManner) throws ServiceException, ServiceDaoException {


        try {
            indentLog.info("noticeBack get indentCode : " + indentCode + " and respCode : " + respCode + " and payManner : "
                    + payManner);
            UserOrder order = userOrderService.getOrderObjectByOrderId(indentCode);
            indentLog.info("get order : " + order.toString());
            if (!Integer.valueOf(UserOrder.WAITFORPAY).equals(order.getStatus())) {
                indentLog.info(" indentinfo  service  status not  waitforpay 2  ");
                return;
            }
            Integer status = 0;
            Long targetId = order.getTargetId();
            Long uid = order.getUid();
            Boolean unlockStatus = true;
            User user = userService.getObjectById(uid);

            switch (respCode) {
                case UserOrder.PAY_SUCCESS:         //支付成功
                    status = UserOrder.COMPLETED;  //订单状态设为完成
                    indentLog.info("lesson order : " + order.getId() + " completed ");

                    switch (order.getBuyType()) {
                        case UserOrder.ORDER_LESSON: {

                            indentLog.info("==========解锁专题逻辑==========");
                            indentLog.info("order target id is " + order.getTargetId());
                            Long relationId = uesrCourseRelationService.getUesrCourseRelationIdByUidAndTypeAndTargetId(uid, 1L, order.getTargetId());
                            if (DataUtils.isNotNullOrEmpty(relationId)) {

                                UesrCourseRelation hasBoughtRelation = uesrCourseRelationService.getObjectById(relationId);
                                hasBoughtRelation.setCreateAt(System.currentTimeMillis());
                                uesrCourseRelationService.update(hasBoughtRelation);
                            } else {
                                indentLog.info("new userCourseRelation uid is: " + uid + " targetId is: " + targetId);

                                UesrCourseRelation uesrCourseRelation = new UesrCourseRelation();
                                uesrCourseRelation.setUid(uid);
                                uesrCourseRelation.setType((long) order.getBuyType());
                                uesrCourseRelation.setTargetId(order.getTargetId());
                                uesrCourseRelationService.insert(uesrCourseRelation);
                            }

                            break;
                        }

                        case UserOrder.ORDER_MEMBER: {

                            indentLog.info("==========购买会员逻辑==========");

                            indentLog.info(" pay noticeBack ,type is member ");
                            Member member = memberService.getObjectById(targetId);
                            Long now = System.currentTimeMillis();
                            Long endAt = 0L;
                            Long startAt = 0L;

                            //判断是开会员还是续费会员
                            List<Long> userMemberRelationIds = userMemberRelationService.getUserMemberRelationIdsByUidAndStatus(uid, User.IS_MEMBER, 0, Integer.MAX_VALUE);
                            if (CollectionUtils.isEmpty(userMemberRelationIds)) {
                                indentLog.info(" user " + uid + " is not a member ");

                                indentLog.info("==========开会员逻辑==========");

                                startAt = now;

                            } else {
                                List<UserMemberRelation> userMemberRelations = userMemberRelationService.getObjectsByIds(userMemberRelationIds);
                                for (UserMemberRelation userMemberRelation : userMemberRelations) {
                                    indentLog.info(" user member endAt is " + getDate(userMemberRelation.getEndAt()) + " now is " + getDate(now));
                                    if (userMemberRelation.getEndAt().longValue() >= endAt) {
                                        indentLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is more than " + endAt);
                                        endAt = userMemberRelation.getEndAt().longValue();
                                    } else {
                                        indentLog.info(" user member " + userMemberRelation.getId() + " end time " + userMemberRelation.getEndAt() + " is less than " + endAt);
                                    }
                                }
                                indentLog.info("final end at member time is : " + endAt);

                                startAt = endAt;

                            }

                            //给用户添加会员记录
                            UserMemberRelation userMemberRelation = new UserMemberRelation();
                            userMemberRelation.setUid(uid);
                            userMemberRelation.setName(member.getName());
                            userMemberRelation.setPrice(member.getPrice());
                            userMemberRelation.setPeriod(member.getPeriod());
                            userMemberRelation.setStatus(User.IS_MEMBER);
                            userMemberRelation.setStartAt(startAt);

                            Date startDate = new Date(startAt);
                            Date endDate = DateUtils.addMonths(startDate, member.getPeriod().intValue());

                            endAt = endDate.getTime();
                            userMemberRelation.setEndAt(endAt);
                            indentLog.info(" user " + uid + " member startAt = " + getDate(now) + " endAt = " + getDate(endAt));
                            Long userMemberRelationId = userMemberRelationService.insert(userMemberRelation);
                            indentLog.info(" user " + uid + " member id is = " + userMemberRelationId);


                            break;
                        }

                    }
                    break;

                case UserOrder.PAY_FAIL:         //支付失败
                    status = UserOrder.CLOSED; //订单状态设为关闭
                    indentLog.info("lesson order : " + order.getId() + " close ");

                    break;
            }

            if (UserOrder.PAY_SUCCESS == respCode) {
                indentLog.info("==========支付成功，记录推广统计信息==========");


            } else {
                indentLog.info("==========支付失败，不记录统计信息==========");
            }

            order.setStatus(status);
            order.setPayType(payManner);
            order.setUpdateAt(System.currentTimeMillis());
            order.setPayAt(System.currentTimeMillis());
            userOrderService.update(order);
            indentLog.info("update order over");


        } catch (Exception e) {
            indentLog.error(e.getMessage());
            indentLog.error(e.getStackTrace());

            e.printStackTrace(System.out);
            indentLog.error("error : ", e);
        }

    }


    public static String getDate(Long time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = "";

        if (null != time) {
            date = dateFormat.format(new Date(time));
        }
        return date;
    }


    @Override
    public Boolean setPayAt(String orderId, Long payAt) {
        return false;
    }

    public static void main(String[] args) {
        long a = System.currentTimeMillis();
        System.out.println(a);
        long aa = a + 60 * DateUtils.MILLIS_PER_DAY;
        System.out.println(" aa = " + aa);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        System.out.print(" bb = " + format.format(new Date(aa)));

    }


}