package com.ptteng.academy.user.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.academy.user.model.CooperatorOrder;
import com.ptteng.academy.user.model.CooperatorUserStatistics;
import com.ptteng.academy.user.service.CooperatorStatisticsService;
import com.ptteng.common.dao.util.SQLUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.osoa.sca.annotations.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

public class CooperatorStatisticsServiceImpl implements CooperatorStatisticsService {


    private JdbcTemplate jdbcTemplate;

    public JdbcTemplate getJdbcTemplate() {
        return jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public List<CooperatorUserStatistics> getCooperatorUserStatisticsByDynamicCondition(Map<String, Object> condition, Integer start, Integer size) {
        String sql = SQLUtil.convert2Sql(condition, start, size);
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<CooperatorUserStatistics>(CooperatorUserStatistics.class));
    }

    @Override
    public List<CooperatorOrder> getCooperatorOrdersByDynamicCondition(Map<String, Object> condition, Integer start, Integer size) {
        String sql = SQLUtil.convert2Sql(condition, start, size);
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<CooperatorOrder>(CooperatorOrder.class));
    }

    @Override
    public Integer getLessonOrderNumber(Long cooperatorLinkTime, Long startAt, Long endAt) {
        String sql = "SELECT COALESCE(SUM(user_order.buy_type = 1),0) " +
                "FROM " +
                " user_order " +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id " +
                "WHERE " +
                " user_openid_relation.type LIKE 'xinhuameiyu%' " +
                "AND user_order.pay_at >= ?  " +
                "AND user_order.pay_at < ? AND user_order.os = 2 ";
        return jdbcTemplate.queryForObject(sql, Integer.class, startAt, endAt);
    }

    @Override
    public Double getLessonOrderMoney(Long cooperatorLinkTime, Long startAt, Long endAt) {
        String sql = "SELECT\n" +
                "\tROUND(COALESCE(SUM(CASE WHEN user_order.buy_type = 1 THEN price END),0),2)\n" +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id\n" +
                "WHERE\n" +
                "\tuser_openid_relation.type LIKE 'xinhuameiyu%'\n" +
                "AND user_order.pay_at >= ? \n" +
                "AND user_order.pay_at < ? AND user_order.status = 3 AND user_order.os = 2 ";
        return jdbcTemplate.queryForObject(sql, Double.class, startAt, endAt);
    }

    @Override
    public Integer getMemberOrderNumber(Long cooperatorLinkTime, Long startAt, Long endAt) {
        String sql = "SELECT " +
                " COALESCE(SUM(user_order.buy_type = 6),0) " +
                "FROM " +
                " user_order " +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id " +
                "WHERE " +
                " user_openid_relation.type LIKE 'xinhuameiyu%' " +
                "AND user_order.pay_at >= ?  " +
                "AND user_order.pay_at < ?  AND user_order.os = 2  ";
        return jdbcTemplate.queryForObject(sql, Integer.class, startAt, endAt);
    }

    @Override
    public Double getMemberOrderMoney(Long cooperatorLinkTime, Long startAt, Long endAt) {
        String sql = "SELECT\n" +
                "\tROUND(COALESCE(SUM(CASE WHEN user_order.buy_type = 6 THEN price END),0),2)\n" +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id\n" +
                "WHERE\n" +
                "\tuser_openid_relation.type LIKE 'xinhuameiyu%'\n" +
                "AND user_order.pay_at >= ? \n" +
                "AND user_order.pay_at < ? AND user_order.os = 2  ";
        return jdbcTemplate.queryForObject(sql, Double.class, startAt, endAt);
    }

    @Override
    public List<CooperatorOrder> getMemberDateCooperatorOrder(Long dateStart, Long dateEnd, Long cooperatorLinkTime) {
        String sql = "SELECT " +
                " user_member_relation.name AS  order_name, " +
                " user_member_relation.price AS total_money, " +
                " user_openid_relation.openid AS  username, " +
                " user_member_relation.create_at AS  time " +
                "FROM " +
                " academy_user.user_member_relation " +
                "LEFT JOIN academy_user.user_openid_relation ON user_member_relation.uid = user_openid_relation.uid " +
                "WHERE " +
                " user_openid_relation.type LIKE 'xinhuameiyu%' " +
                "AND user_member_relation.create_at >= ?  " +
                "AND user_member_relation.create_at <=  ?  " +
                "AND user_member_relation.create_at > user_openid_relation.create_at   " +
                "AND user_openid_relation.create_at >= " + cooperatorLinkTime + "   " +
                "ORDER BY " +
                " user_member_relation.create_at DESC" +
                "";
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<CooperatorOrder>(CooperatorOrder.class), dateStart, dateEnd);
    }

    @Override
    public List<CooperatorOrder> getLessonDateCooperatorOrder(Long dateStart, Long dateEnd, Long cooperatorLinkTime) {
        String sql = "SELECT " +
                " uesr_course_relation.create_at AS time, " +
                " lesson.price AS total_money, " +
                " user_openid_relation.openid AS username, " +
                " lesson.lesson_name AS order_name " +
                "FROM " +
                " academy_user.uesr_course_relation " +
                "LEFT JOIN academy_course.lesson ON lesson.id = uesr_course_relation.target_id " +
                "LEFT JOIN academy_user.user_openid_relation ON user_openid_relation.uid = academy_user.uesr_course_relation.uid " +
                "WHERE " +
                " user_openid_relation.type LIKE 'xinhuameiyu%' " +
                "AND uesr_course_relation.create_at >= ?  " +
                "AND uesr_course_relation.create_at < ?   " +
                "AND uesr_course_relation.create_at > user_openid_relation.create_at   " +
                "AND user_openid_relation.create_at >= " + cooperatorLinkTime + " ";

        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<CooperatorOrder>(CooperatorOrder.class), dateStart, dateEnd);
    }

    @Override
    public List<CooperatorOrder> getDateCooperatorOrder(Long dateStart, Long dateEnd, Integer page, Integer size) {
        String sql = "SELECT\n" +
                "\tuser_openid_relation.openid AS username,\n" +
                "\tuser_order.price AS total_money,\n" +
                "\tuser_order.buy_type AS type,\n" +
                "\tuser_openid_relation.uid AS id,\n" +
                "\tCOALESCE(member.name,lesson.lesson_name) AS order_name,\n" +
                "\tuser_order.pay_at AS time\n" +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id\n" +
                "LEFT JOIN academy_course.lesson ON user_order.target_id = lesson.id\n" +
                "LEFT JOIN member ON user_order.target_id = member.id\n" +
                "WHERE\n" +
                "\tuser_order. STATUS = 3\n" +
                "AND user_openid_relation.type LIKE 'xinhuameiyu%' AND  user_order.pay_at >= ? AND user_order.pay_at < ? AND  user_order.os = 2  \n" +
                "ORDER BY user_order.pay_at DESC LIMIT ?,?";
        return jdbcTemplate.query(sql, new BeanPropertyRowMapper<CooperatorOrder>(CooperatorOrder.class), dateStart, dateEnd, page, size);
    }

    @Override
    public Integer countDateCooperatorOrder(Long dateStart, Long dateEnd) {
        String sql = "SELECT\n" +
                " COUNT(user_order.id) " +
                "FROM\n" +
                "\tuser_order\n" +
                "LEFT JOIN user_openid_relation ON user_openid_relation.uid = user_order.user_id\n" +
                "LEFT JOIN academy_course.lesson ON user_order.target_id = lesson.id\n" +
                "LEFT JOIN member ON user_order.target_id = member.id\n" +
                "WHERE\n" +
                "\tuser_order. STATUS = 3\n" +
                "AND user_openid_relation.type LIKE 'xinhuameiyu%' AND  user_order.pay_at >= ? AND user_order.pay_at < ? AND   user_order.os = 2 \n" +
                "ORDER BY user_order.pay_at DESC LIMIT ?,? ";
        return jdbcTemplate.queryForObject(sql, Integer.class, dateStart, dateEnd, 0, Integer.MAX_VALUE);
    }

}